package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.action.IcyAbstractAction;
import icy.file.FileUtil;
import icy.gui.component.button.IcyButton;
import icy.gui.dialog.OpenDialog;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.prefs.Preferences;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import plugins.tprovoost.Microscopy.MicroManager.tools.MMUtils;

/**
 * This class is the loading dialog used to select the configuration. Currently, this dialog is only
 * visible the first time the user launches the plugin, and when he hits the "Load Configuration"
 * button in the {@link MMMainFrame}.
 * 
 * @author Irsath Nguyen & Thomas Provoost
 */
public class LoadFrame extends JDialog
{
    private static final long serialVersionUID = 1195697437027678195L;
    // Preference keys for this package
    private static final String FILE = "cfgfile";
    private static final String NB_FILES = "nbfiles";
    private static final String X_POS = "xpos";
    private static final String Y_POS = "ypos";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DISP_RIGHT = "disp_right";
    private static final int DEFAULT_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 300;

    // Class variables
    private Preferences _prefs;
    String sysConfigFile;
    DefaultListModel _CFGFiles;
    File _actualfile = null;
    int _retval;
    private int _actual_file_nb_devices;
    private int _actual_file_nb_groups;
    private int _actual_file_nb_presets;
    boolean _isRightDisplayed = false;

    // ---------------
    // UI Variables
    // --------------
    private JPanel _panel_main;
    private JPanel _panel_buttons;

    // File choser panel
    private JPanel _panel_files;
    JList _list_files;
    private JScrollPane _scroll_files;

    // Device List Panel
    private JPanel _panel_devices;
    private JTextArea _list_devices;
    private JScrollPane _scroll_devices;

    // Config Panel
    private JPanel _panel_configs;
    private JTextArea _list_configs;
    private JScrollPane _scroll_configs;

    // Buttons
    IcyButton _btn_open;
    private IcyButton _btn_cancel;
    private IcyButton _btn_add;
    private IcyButton _btn_remove;
    IcyButton _btn_more;

    // resume windows
    private JPanel _panel_resume;
    private JTextArea _list_resume;
    private JPanel panelSouth;
    private JPanel panel;

    public LoadFrame()
    {
        super(Icy.getMainInterface().getMainFrame(), true);

        setTitle("Please choose your configuration file");
        _retval = -1;
        addWindowListener(new WindowAdapter()
        {
            @Override
            public void windowClosing(WindowEvent e)
            {
                _retval = 1;
                savePrefs();
            }
        });

        Preferences root = Preferences.userNodeForPackage(getClass());
        _prefs = root.node(root.absolutePath() + "/" + "CFGFiles");

        JLabel lbl_files = new JLabel("Files");
        lbl_files.setHorizontalAlignment(SwingConstants.CENTER);
        lbl_files.setFont(lbl_files.getFont().deriveFont(Font.BOLD, 12));

        JLabel lbl_devices = new JLabel("Devices");
        lbl_devices.setFont(lbl_files.getFont().deriveFont(Font.BOLD, 12));
        lbl_devices.setHorizontalAlignment(SwingConstants.CENTER);

        JLabel lbl_config_presets = new JLabel("Config / Main Presets");
        lbl_config_presets.setFont(lbl_files.getFont().deriveFont(Font.BOLD, 12));
        lbl_config_presets.setHorizontalAlignment(SwingConstants.CENTER);

        _CFGFiles = new DefaultListModel();
        _list_files = new JList(_CFGFiles);
        _list_files.addListSelectionListener(new ListSelectionListener()
        {
            @Override
            public void valueChanged(ListSelectionEvent e)
            {
                if (!_list_files.isSelectionEmpty())
                {
                    sysConfigFile = (String) _list_files.getSelectedValue();
                    _actualfile = new File(sysConfigFile);
                    try
                    {
                        loadFileAttribs();
                        _btn_open.setEnabled(true);
                    }
                    catch (IOException e1)
                    {
                        e1.printStackTrace();
                    }
                }
            }
        });
        _list_files.addMouseListener(new MouseAdapter()
        {
            @Override
            public void mousePressed(java.awt.event.MouseEvent mouseevent)
            {
                if ((mouseevent.getClickCount() >= 2) && _btn_open.isEnabled())
                    _btn_open.doClick();
            }
        });
        _list_files.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        _list_files.setLayoutOrientation(JList.VERTICAL);
        _list_files.setToolTipText("All files added. Select a file and click \"Open File\" to open it.");
        _scroll_files = new JScrollPane(_list_files);
        _panel_files = new JPanel();
        _panel_files.setLayout(new BorderLayout());
        _panel_files.add(lbl_files, BorderLayout.NORTH);
        _panel_files.add(_scroll_files);

        _list_resume = new JTextArea("Microscope :\nNb Devices :\nNb Groups : \nNb Presets : ");
        _list_resume.setEditable(false);
        _list_resume.setToolTipText("Basic information on the current file.");

        _list_devices = new JTextArea();
        _list_devices.setEditable(false);
        _list_devices.setToolTipText("Devices in the current file.");
        _scroll_devices = new JScrollPane(_list_devices);
        _panel_devices = new JPanel();
        _panel_devices.setLayout(new BorderLayout());
        _panel_devices.add(lbl_devices, BorderLayout.NORTH);
        _panel_devices.add(_scroll_devices);

        _list_configs = new JTextArea();
        _list_configs.setEditable(false);
        _list_configs.setToolTipText("Configurations and Presets for the current file.");
        _scroll_configs = new JScrollPane(_list_configs);
        _panel_configs = new JPanel();
        _panel_configs.setLayout(new BorderLayout());
        _panel_configs.add(lbl_config_presets, BorderLayout.NORTH);
        _panel_configs.add(_scroll_configs);

        _panel_main = new JPanel();

        loadPrefs();

        _panel_main.setLayout(new GridLayout(1, 3));
        _panel_main.add(_panel_files);
        _panel_main.add(_panel_devices);
        _panel_main.add(_panel_configs);

        JLabel _lbl_resume = new JLabel("Resume : ");
        _lbl_resume.setHorizontalAlignment(SwingConstants.CENTER);

        _panel_resume = new JPanel();
        _panel_resume.setLayout(new BoxLayout(_panel_resume, BoxLayout.Y_AXIS));
        _panel_resume.add(_lbl_resume);
        _panel_resume.add(_list_resume);

        getContentPane().add(_panel_main);

        panelSouth = new JPanel();
        getContentPane().add(panelSouth, BorderLayout.SOUTH);
        panelSouth.setLayout(new BorderLayout(0, 0));

        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        _panel_buttons = new JPanel();
        panelSouth.add(_panel_buttons);

        _btn_open = new IcyButton(new IcyAbstractAction("Open", new IcyIcon(ResourceUtil.ICON_OPEN),
                "Open currently selected file", KeyEvent.VK_ENTER)
        {
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean doAction(ActionEvent e)
            {
                _retval = 0;
                savePrefs();
                setVisible(false);
                return true;
            }
        });

        _btn_open.setEnabled(false);

        _btn_cancel = new IcyButton(new IcyAbstractAction("Cancel", new IcyIcon(ResourceUtil.ICON_DELETE),
                "Cancel and close Micro Manager", KeyEvent.VK_ESCAPE)
        {
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean doAction(ActionEvent e)
            {
                _retval = 1;
                dispose();
                return true;
            }
        });

        _btn_add = new IcyButton(new IcyAbstractAction("", new IcyIcon(ResourceUtil.ICON_PLUS),
                "Add a new file to the list.")
        {
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean doAction(ActionEvent e)
            {
                loadConfig();
                return true;
            }
        });

        _btn_remove = new IcyButton(new IcyAbstractAction("", new IcyIcon(ResourceUtil.ICON_MINUS),
                "Remove current file from the list.")
        {
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean doAction(ActionEvent e)
            {
                if (!_list_files.isSelectionEmpty())
                    _CFGFiles.remove(_list_files.getSelectedIndex());
                savePrefs();
                return true;
            }
        });

        _btn_more = new IcyButton(new IcyAbstractAction("", new IcyIcon((_isRightDisplayed) ? "br_prev" : "br_next"),
                "Expand / collapse details panel")
        {
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean doAction(ActionEvent e)
            {
                _isRightDisplayed = !_isRightDisplayed;

                if (_isRightDisplayed)
                    _btn_more.setIconName("br_prev");
                else
                    _btn_more.setIconName("br_next");

                updateGUI();
                return true;
            }
        });

        _panel_buttons.setLayout(new BoxLayout(_panel_buttons, BoxLayout.X_AXIS));
        _panel_buttons.add(Box.createHorizontalGlue());
        _panel_buttons.add(_btn_open);
        _panel_buttons.add(_btn_cancel);
        _panel_buttons.add(Box.createHorizontalStrut(12));
        _panel_buttons.add(_btn_add);
        _panel_buttons.add(_btn_remove);
        _panel_buttons.add(Box.createHorizontalStrut(12));
        _panel_buttons.add(_btn_more);

        updateGUI();
    }

    public int showDialog()
    {
        pack();
        ComponentUtil.center(this);
        setVisible(true);
        removeAll();
        updateGUI();
        return _retval;
    }

    public String getConfigFilePath()
    {
        return sysConfigFile;
    }

    void savePrefs()
    {
        _prefs.putInt(NB_FILES, _CFGFiles.getSize());
        for (int i = 0; i < _CFGFiles.getSize(); ++i)
            _prefs.put(FILE + i, _CFGFiles.getElementAt(i).toString());
        _prefs.putInt(X_POS, getX());
        _prefs.putInt(Y_POS, getY());
        _prefs.putInt(WIDTH, getWidth());
        _prefs.putInt(HEIGHT, getHeight());
        _prefs.putBoolean(DISP_RIGHT, _isRightDisplayed);
    }

    private void loadPrefs()
    {
        _CFGFiles.removeAllElements();
        for (int i = 0; i < _prefs.getInt(NB_FILES, 0); ++i)
            _CFGFiles.addElement(_prefs.get(FILE + i, "none"));

        if (_CFGFiles.isEmpty() && MMUtils.demoConfigFile != null)
            loadFile(MMUtils.demoConfigFile.getAbsolutePath());

        setLocation(_prefs.getInt(X_POS, Toolkit.getDefaultToolkit().getScreenSize().width / 2),
                _prefs.getInt(Y_POS, Toolkit.getDefaultToolkit().getScreenSize().height / 2));

        _isRightDisplayed = _prefs.getBoolean(DISP_RIGHT, false);
        int width = _prefs.getInt(WIDTH, DEFAULT_WIDTH) - (_isRightDisplayed ? 200 : 0);
        setSize(width, _prefs.getInt(HEIGHT, DEFAULT_HEIGHT));
    }

    void loadConfig()
    {
        String path = OpenDialog.chooseFile("Launch Configuration", FileUtil.getApplicationDirectory(), "config",
                ".cfg");

        if (path != null)
        {
            sysConfigFile = path;
            loadFile(sysConfigFile);
        }
    }

    private void loadFile(String path)
    {
        if (!_CFGFiles.contains(path) && FileUtil.exists(path))
            _CFGFiles.addElement(path);
        else
            _list_files.setSelectedValue(path, true);

        savePrefs();
        repaint();
    }

    void loadFileAttribs() throws IOException
    {
        _actual_file_nb_devices = 0;
        _actual_file_nb_groups = 0;
        _actual_file_nb_presets = 0;

        String slist_resume = "";
        String slist_devices = "";
        String slist_configs = "";

        BufferedReader in = new BufferedReader(new FileReader(_actualfile));
        if (_actualfile != null)
        {
            String actual_line = "";
            while ((actual_line = in.readLine()) != null)
            {
                if (actual_line.isEmpty())
                    continue;
                if (actual_line.charAt(0) == '#')
                {
                    if (actual_line.contains("Group:"))
                    {
                        slist_configs = slist_configs + actual_line.substring(9) + "\n";
                        ++_actual_file_nb_groups;
                    }
                    else if (actual_line.contains("Preset:"))
                    {
                        slist_configs = slist_configs + "   " + actual_line.substring(10) + "\n";
                        ++_actual_file_nb_presets;
                    }
                }
                else
                {
                    if (actual_line.startsWith("Device"))
                    {
                        actual_line = actual_line.substring(7);
                        int coma_index;
                        while ((coma_index = actual_line.indexOf(',')) != -1)
                            actual_line = actual_line.substring(coma_index + 1);
                        slist_devices = slist_devices + actual_line + "\n";
                        ++_actual_file_nb_devices;
                    }
                }
            }
        }
        in.close();
        _list_configs.getCaret().moveDot(0);
        slist_resume = slist_resume + "\nNb Devices : " + _actual_file_nb_devices;
        slist_resume = slist_resume + "\nNb Groups : " + _actual_file_nb_groups;
        slist_resume = slist_resume + "\nNb Presets : " + _actual_file_nb_presets;
        _list_devices.setText(slist_devices);
        _list_configs.setText(slist_configs);
        _list_resume.setText(slist_resume);
        _list_devices.setCaretPosition(0);
        _list_configs.setCaretPosition(0);
    }

    public void updateGUI()
    {
        _panel_main.removeAll();

        if (_isRightDisplayed)
        {
            _panel_main.setLayout(new GridLayout(1, 4));
            _panel_main.add(_panel_files);
            _panel_main.add(_panel_resume);
            _panel_main.add(_panel_devices);
            _panel_main.add(_panel_configs);
            Rectangle bounds = getBounds();
            setBounds(new Rectangle(bounds.x, bounds.y, bounds.width + 200, bounds.height));
        }
        else
        {
            _panel_main.setLayout(new GridLayout(1, 2));
            _panel_main.add(_panel_files);
            _panel_main.add(_panel_resume);
            Rectangle bounds = getBounds();
            if (bounds.width > 500)
                setBounds(new Rectangle(bounds.x, bounds.y, bounds.width - 200, bounds.height));
        }

        validate();
        repaint();
    }
}