/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.chol;

import org.ejml.alg.dense.decomposition.DecompositionInterface;
import org.ejml.data.DenseMatrix64F;

public class CholeskyDecompositionLDL
implements DecompositionInterface<DenseMatrix64F> {
    private int maxWidth;
    private int n;
    private DenseMatrix64F L;
    private double[] el;
    private double[] d;
    double[] vv;

    public void setExpectedMaxSize(int n, int n2) {
        if (n != n2) {
            throw new IllegalArgumentException("Can only decompose square matrices");
        }
        this.maxWidth = n;
        this.L = new DenseMatrix64F(this.maxWidth, this.maxWidth);
        this.el = this.L.data;
        this.vv = new double[this.maxWidth];
        this.d = new double[this.maxWidth];
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        int n;
        int n2;
        if (denseMatrix64F.numRows > this.maxWidth) {
            this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        } else if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new RuntimeException("Can only decompose square matrices");
        }
        this.n = denseMatrix64F.numRows;
        this.L.setReshape(denseMatrix64F);
        double d = 0.0;
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = n2; n < this.n; ++n) {
                double d2 = this.el[n2 * this.n + n];
                for (int i = 0; i < n2; ++i) {
                    d2 -= this.el[n2 * this.n + i] * this.el[n * this.n + i] * this.d[i];
                }
                if (n2 == n) {
                    if (d2 <= 0.0) {
                        return false;
                    }
                    this.d[n2] = d2;
                    d = 1.0 / d2;
                    this.el[n2 * this.n + n2] = 1.0;
                    continue;
                }
                this.el[n * this.n + n2] = d2 * d;
            }
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            for (n = n2 + 1; n < this.n; ++n) {
                this.el[n2 * this.n + n] = 0.0;
            }
        }
        return true;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    public double[] getD() {
        return this.d;
    }

    public DenseMatrix64F getL() {
        return this.L;
    }

    public double[] _getVV() {
        return this.vv;
    }
}

