/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util;

import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLDoubleBuffer;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.util.LinearAlgebraKernels;
import com.nativelibs4java.opencl.util.ReductionUtils;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinearAlgebraUtils {
    final LinearAlgebraKernels kernels;
    final CLQueue queue;
    ReductionUtils.Reductor<DoubleBuffer> addReductor;

    public LinearAlgebraUtils() throws IOException, CLBuildException {
        this(JavaCL.createBestContext().createDefaultQueue(new CLDevice.QueueProperties[0]));
    }

    public LinearAlgebraUtils(CLQueue queue) throws IOException, CLBuildException {
        this.queue = queue;
        this.kernels = new LinearAlgebraKernels(queue.getContext());
    }

    public CLContext getContext() {
        return this.getQueue().getContext();
    }

    public CLQueue getQueue() {
        return this.queue;
    }

    public synchronized CLEvent multiply(CLDoubleBuffer a, long aRows, long aColumns, CLDoubleBuffer b, long bRows, long bColumns, CLDoubleBuffer out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        long outRows = aRows;
        long outColumns = bColumns;
        return this.kernels.mulMat(this.queue, a, (int)aColumns, b, (int)bColumns, out, new int[]{(int)outRows, (int)outColumns}, null, eventsToWaitFor);
    }

    synchronized ReductionUtils.Reductor<DoubleBuffer> getAddReductor() {
        if (this.addReductor == null) {
            try {
                this.addReductor = ReductionUtils.createReductor(this.getContext(), ReductionUtils.Operation.Add, ReductionUtils.Type.Double, 1);
            }
            catch (CLBuildException ex) {
                Logger.getLogger(LinearAlgebraUtils.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException("Failed to create an addition reductor !", ex);
            }
        }
        return this.addReductor;
    }

    public synchronized CLEvent transpose(CLDoubleBuffer a, long aRows, long aColumns, CLDoubleBuffer out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        return this.kernels.transpose(this.queue, a, aRows, aColumns, out, new int[]{(int)aColumns, (int)aRows}, null, eventsToWaitFor);
    }
}

