/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import org.jdesktop.beans.AbstractBean;

public final class CapsLockSupport
extends AbstractBean
implements KeyEventDispatcher {
    private boolean useToolkit;
    private boolean capsLockeEnabled;
    private boolean updateViaKeyEvent;

    private CapsLockSupport() {
        try {
            this.capsLockeEnabled = Toolkit.getDefaultToolkit().getLockingKeyState(20);
            this.useToolkit = true;
            this.updateViaKeyEvent = false;
        }
        catch (UnsupportedOperationException e) {
            this.capsLockeEnabled = false;
            this.useToolkit = false;
            this.updateViaKeyEvent = true;
        }
    }

    public static CapsLockSupport getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean isInitialized() {
        return this.useToolkit || this.useToolkit ^ this.updateViaKeyEvent;
    }

    public boolean isCapsLockEnabled() {
        if (this.useToolkit) {
            try {
                return Toolkit.getDefaultToolkit().getLockingKeyState(20);
            }
            catch (UnsupportedOperationException shouldNeverHappen) {
                return this.capsLockeEnabled;
            }
        }
        return this.capsLockeEnabled;
    }

    void setCapsLockEnabled(boolean capsLockEnabled) {
        boolean oldValue = this.capsLockeEnabled;
        this.capsLockeEnabled = capsLockEnabled;
        this.firePropertyChange("capsLockEnabled", oldValue, this.capsLockeEnabled);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            int keyCode = e.getKeyCode();
            if (keyCode == 20) {
                if (!this.updateViaKeyEvent) {
                    if (this.useToolkit) {
                        try {
                            this.setCapsLockEnabled(Toolkit.getDefaultToolkit().getLockingKeyState(20));
                        }
                        catch (UnsupportedOperationException shouldNeverHappen) {
                            this.setCapsLockEnabled(!this.capsLockeEnabled);
                        }
                    } else {
                        this.setCapsLockEnabled(!this.capsLockeEnabled);
                    }
                }
            } else if (this.updateViaKeyEvent && Character.isLetter(keyCode)) {
                this.capsLockeEnabled = keyCode == e.getKeyChar() ? !e.isShiftDown() : e.isShiftDown();
                this.updateViaKeyEvent = false;
                this.firePropertyChange("initialized", false, true);
            }
        }
        return false;
    }

    private static class SingletonHolder {
        private static final CapsLockSupport INSTANCE = new CapsLockSupport();

        private SingletonHolder() {
        }

        static {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(INSTANCE);
        }
    }
}

