/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.raw.Body;
import net.phys2d.raw.collide.BoxBoxCollider;
import net.phys2d.raw.collide.BoxCircleCollider;
import net.phys2d.raw.collide.CircleCircleCollider;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.ColliderUnavailableException;
import net.phys2d.raw.collide.LineBoxCollider;
import net.phys2d.raw.collide.LineCircleCollider;
import net.phys2d.raw.collide.LineLineCollider;
import net.phys2d.raw.collide.LinePolygonCollider;
import net.phys2d.raw.collide.PolygonBoxCollider;
import net.phys2d.raw.collide.PolygonCircleCollider;
import net.phys2d.raw.collide.PolygonPolygonCollider;
import net.phys2d.raw.collide.SwapCollider;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.Line;
import net.phys2d.raw.shapes.Polygon;
import net.phys2d.raw.shapes.Shape;

public class ColliderFactory {
    public Collider createCollider(Body bodyA, Body bodyB) throws ColliderUnavailableException {
        Shape shapeA = bodyA.getShape();
        Shape shapeB = bodyB.getShape();
        if (shapeA instanceof Circle) {
            return this.createColliderFor((Circle)shapeA, shapeB);
        }
        if (shapeA instanceof Box) {
            return this.createColliderFor((Box)shapeA, shapeB);
        }
        if (shapeA instanceof Line) {
            return this.createColliderFor((Line)shapeA, shapeB);
        }
        if (shapeA instanceof Polygon) {
            return this.createColliderFor((Polygon)shapeA, shapeB);
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }

    public Collider createColliderFor(Circle shapeA, Shape shapeB) throws ColliderUnavailableException {
        if (shapeB instanceof Circle) {
            return new CircleCircleCollider();
        }
        if (shapeB instanceof Box) {
            return new SwapCollider(new BoxCircleCollider());
        }
        if (shapeB instanceof Line) {
            return new SwapCollider(new LineCircleCollider());
        }
        if (shapeB instanceof Polygon) {
            return new SwapCollider(new PolygonCircleCollider());
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }

    public Collider createColliderFor(Box shapeA, Shape shapeB) throws ColliderUnavailableException {
        if (shapeB instanceof Circle) {
            return new BoxCircleCollider();
        }
        if (shapeB instanceof Box) {
            return new BoxBoxCollider();
        }
        if (shapeB instanceof Line) {
            return new SwapCollider(new LineBoxCollider());
        }
        if (shapeB instanceof Polygon) {
            return new SwapCollider(new PolygonBoxCollider());
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }

    public Collider createColliderFor(Line shapeA, Shape shapeB) throws ColliderUnavailableException {
        if (shapeB instanceof Circle) {
            return new LineCircleCollider();
        }
        if (shapeB instanceof Box) {
            return new LineBoxCollider();
        }
        if (shapeB instanceof Line) {
            return new LineLineCollider();
        }
        if (shapeB instanceof Polygon) {
            return new LinePolygonCollider();
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }

    public Collider createColliderFor(Polygon shapeA, Shape shapeB) throws ColliderUnavailableException {
        if (shapeB instanceof Circle) {
            return new PolygonCircleCollider();
        }
        if (shapeB instanceof Box) {
            return new PolygonBoxCollider();
        }
        if (shapeB instanceof Line) {
            return new SwapCollider(new LinePolygonCollider());
        }
        if (shapeB instanceof Polygon) {
            return new PolygonPolygonCollider();
        }
        throw new ColliderUnavailableException(shapeA, shapeB);
    }
}

