/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.libmdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import mdbtools.libmdb.Data;
import mdbtools.libmdb.Holder;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbColumn;
import mdbtools.libmdb.MdbFormatConstants;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.MdbTableDef;
import mdbtools.libmdb.file;
import mdbtools.libmdb.macros;
import mdbtools.libmdb.mem;

public class Table {
    public static MdbTableDef mdb_read_table(MdbCatalogEntry entry) throws IOException {
        MdbTableDef table = null;
        MdbHandle mdb = entry.mdb;
        MdbFormatConstants fmt = mdb.fmt;
        table = mem.mdb_alloc_tabledef(entry);
        file.mdb_read_pg(mdb, entry.table_pg);
        int len = file.mdb_get_int16(mdb, 8);
        table.num_rows = file.mdb_get_int32(mdb, fmt.tab_num_rows_offset);
        table.num_cols = file.mdb_get_int16(mdb, fmt.tab_num_cols_offset);
        table.num_idxs = file.mdb_get_int32(mdb, fmt.tab_num_idxs_offset);
        table.num_real_idxs = file.mdb_get_int32(mdb, fmt.tab_num_ridxs_offset);
        byte rownum = mdb.pg_buf[fmt.tab_usage_map_offset];
        file.mdb_read_alt_pg(mdb, file.mdb_get_int24(mdb, fmt.tab_usage_map_offset + 1));
        file.mdb_swap_pgbuf(mdb);
        int row_start = file.mdb_get_int16(mdb, fmt.row_count_offset + 2 + rownum * 2);
        int row_end = Data.mdb_find_end_of_row(mdb, rownum);
        table.map_sz = row_end - row_start + 1;
        table.usage_map = new byte[table.map_sz];
        System.arraycopy(mdb.pg_buf, row_start, table.usage_map, 0, table.map_sz);
        file.mdb_swap_pgbuf(mdb);
        table.first_data_pg = file.mdb_get_int16(mdb, fmt.tab_first_dpg_offset);
        return table;
    }

    public static ArrayList mdb_read_columns(MdbTableDef table) throws IOException {
        MdbColumn pcol;
        int i;
        MdbHandle mdb = table.entry.mdb;
        MdbFormatConstants fmt = mdb.fmt;
        LinkedList<MdbColumn> slist = new LinkedList<MdbColumn>();
        Holder pm = new Holder();
        table.columns = new ArrayList();
        int cur_col = fmt.tab_cols_start_offset + table.num_real_idxs * fmt.tab_ridx_entry_size;
        for (i = 0; i < table.num_cols; ++i) {
            MdbColumn col = new MdbColumn();
            col.col_num = mdb.pg_buf[cur_col + fmt.col_num_offset];
            pm.i = cur_col;
            Table.read_pg_if(mdb, pm, 0);
            cur_col = pm.i;
            col.col_type = mdb.pg_buf[cur_col];
            if (col.col_type == 16) {
                col.col_prec = mdb.pg_buf[cur_col + 11];
                col.col_scale = mdb.pg_buf[cur_col + 12];
            }
            pm.i = cur_col;
            Table.read_pg_if(mdb, pm, 13);
            cur_col = pm.i;
            boolean bl = col.is_fixed = (mdb.pg_buf[cur_col + fmt.col_fixed_offset] & 1) != 0;
            if (col.col_type != 1) {
                pm.i = cur_col;
                Table.read_pg_if(mdb, pm, 17);
                cur_col = pm.i;
                byte low_byte = mdb.pg_buf[cur_col + fmt.col_size_offset];
                pm.i = cur_col;
                Table.read_pg_if(mdb, pm, 18);
                cur_col = pm.i;
                byte high_byte = mdb.pg_buf[cur_col + fmt.col_size_offset + 1];
                col.col_size += file.unsign(high_byte) * 256 + file.unsign(low_byte);
            } else {
                col.col_size = 0;
            }
            pcol = col;
            slist.add(pcol);
            cur_col += fmt.tab_col_entry_size;
        }
        Collections.sort(slist, new Comparator(){

            public int compare(Object o1, Object o2) {
                MdbColumn a = (MdbColumn)o1;
                MdbColumn b = (MdbColumn)o2;
                if (a.col_num > b.col_num) {
                    return 1;
                }
                if (a.col_num < b.col_num) {
                    return -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                throw new RuntimeException("equals is not implemented");
            }
        });
        int cur_name = cur_col;
        for (i = 0; i < table.num_cols; ++i) {
            int len;
            pcol = (MdbColumn)slist.get(i);
            pm.i = cur_col;
            Table.read_pg_if(mdb, pm, 0);
            cur_col = pm.i;
            int name_sz = mdb.pg_buf[cur_name];
            if (macros.IS_JET4(mdb)) {
                int j;
                len = (cur_name += 2) + name_sz > fmt.pg_size ? fmt.pg_size - cur_name : name_sz;
                char[] name = new char[31];
                int nameIndex = 0;
                for (j = 0; j < len; j += 2) {
                    name[nameIndex++] = (char)mdb.pg_buf[cur_name + j];
                }
                if (len < name_sz) {
                    file.mdb_read_pg(mdb, file.mdb_get_int32(mdb, 4));
                    cur_name = 8 - (fmt.pg_size - cur_name);
                    for (j = len; j < name_sz; ++j) {
                        if (j % 2 != 0) continue;
                        name[nameIndex++] = (char)file.unsign(mdb.pg_buf[cur_name + j]);
                    }
                }
                pcol.name = new String(name, 0, nameIndex);
                cur_name += name_sz;
                continue;
            }
            if (macros.IS_JET3(mdb)) {
                len = cur_name + name_sz > fmt.pg_size ? fmt.pg_size - cur_name : name_sz;
                pcol.name = len > 0 ? new String(mdb.pg_buf, cur_name + 1, len) : "";
                if (len < name_sz) {
                    file.mdb_read_pg(mdb, file.mdb_get_int32(mdb, 4));
                    cur_name = 8 - (fmt.pg_size - cur_name);
                    int strlen = name_sz - len;
                    if (cur_name < 0) {
                        cur_name = 0;
                    }
                    if (strlen < 0) {
                        strlen = 0;
                    }
                    if (strlen + cur_name >= mdb.pg_buf.length) {
                        strlen = mdb.pg_buf.length - cur_name;
                    }
                    pcol.name = pcol.name + new String(mdb.pg_buf, cur_name, strlen);
                }
                cur_name += name_sz + 1;
                continue;
            }
            throw new RuntimeException("Unknown MDB version");
        }
        for (i = 0; i < table.num_cols; ++i) {
            pcol = (MdbColumn)slist.get(i);
            table.columns.add(pcol);
        }
        table.index_start = cur_name;
        return table.columns;
    }

    private static int read_pg_if(MdbHandle mdb, Holder cur_pos, int offset) throws IOException {
        if (cur_pos.i + offset >= mdb.fmt.pg_size) {
            file.mdb_read_pg(mdb, file.mdb_get_int32(mdb, 4));
            cur_pos.i = 8 - (mdb.fmt.pg_size - cur_pos.i);
            return 1;
        }
        return 0;
    }
}

