/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.ResourceNamer;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.specification.XMLMockObjects;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.MapPair;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;

public class FakeReader
extends FormatReader {
    private static final long ANN_LONG_VALUE = 365L;
    private static final Double ANN_DOUBLE_VALUE = 0.111;
    private static final String ANNOTATION_PREFIX = "Annotation:";
    private static final String ANNOTATION_NAMESPACE = "fake-reader";
    private static final String ANN_TERM_VALUE = "Term:";
    private static final String ANN_TAG_VALUE = "Tag:";
    private static final Timestamp ANN_TIME_VALUE = new Timestamp("1970-01-01T00:00:00");
    private static final boolean ANN_BOOLEAN_VALUE = true;
    private static final String ANN_COMMENT_VALUE = "Comment:";
    private static final String ANN_XML_VALUE_START = "<dummyXml>";
    private static final String ANN_XML_VALUE_END = "</dummyXml>";
    public static final int BOX_SIZE = 10;
    public static final int DEFAULT_SIZE_X = 512;
    public static final int DEFAULT_SIZE_Y = 512;
    public static final int DEFAULT_SIZE_Z = 1;
    public static final int DEFAULT_SIZE_C = 1;
    public static final int DEFAULT_SIZE_T = 1;
    public static final int DEFAULT_PIXEL_TYPE = 1;
    public static final int DEFAULT_RGB_CHANNEL_COUNT = 1;
    public static final String DEFAULT_DIMENSION_ORDER = "XYZCT";
    private static final String TOKEN_SEPARATOR = "&";
    private static final long SEED = -889275714L;
    private Time exposureTime = null;
    private Length physicalSizeX;
    private Length physicalSizeY;
    private Length physicalSizeZ;
    private double scaleFactor = 1.0;
    private byte[][][] lut8 = null;
    private short[][][] lut16 = null;
    private int[][] indexToValue = null;
    private int[][] valueToIndex = null;
    private int ac = 0;
    private String iniFile;
    private List<String> fakeSeries = new ArrayList<String>();
    private OMEXMLMetadata omeXmlMetadata;
    private OMEXMLService omeXmlService;

    public FakeReader() {
        super("Simulated data", "fake");
        this.hasCompanionFiles = true;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.ac < 0 || this.lut8 == null ? (byte[][])null : this.lut8[this.ac];
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.ac < 0 || this.lut16 == null ? (short[][])null : this.lut16[this.ac];
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        long min;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int s = this.getSeries();
        int pixelType = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        boolean signed = FormatTools.isSigned(pixelType);
        boolean floating = FormatTools.isFloatingPoint(pixelType);
        int rgb = this.getRGBChannelCount();
        boolean indexed = this.isIndexed();
        boolean little = this.isLittleEndian();
        boolean interleaved = this.isInterleaved();
        int[] zct = this.getZCTCoords(no);
        int zIndex = zct[0];
        int cIndex = zct[1];
        int tIndex = zct[2];
        this.ac = cIndex;
        long l = min = signed ? (long)(-Math.pow(2.0, 8 * bpp - 1)) : 0L;
        if (floating) {
            min = 0L;
        }
        for (int cOffset = 0; cOffset < rgb; ++cOffset) {
            int channel = rgb * cIndex + cOffset;
            for (int row = 0; row < h; ++row) {
                int yy = y + row;
                for (int col = 0; col < w; ++col) {
                    int xx = x + col;
                    long pixel = min + (long)xx;
                    boolean specialPixel = false;
                    if (yy < 10) {
                        int grid = xx / 10;
                        specialPixel = true;
                        switch (grid) {
                            case 0: {
                                pixel = s;
                                break;
                            }
                            case 1: {
                                pixel = no;
                                break;
                            }
                            case 2: {
                                pixel = zIndex;
                                break;
                            }
                            case 3: {
                                pixel = channel;
                                break;
                            }
                            case 4: {
                                pixel = tIndex;
                                break;
                            }
                            default: {
                                specialPixel = false;
                            }
                        }
                    }
                    if (indexed) {
                        if (this.lut8 != null) {
                            pixel = this.valueToIndex[this.ac][(int)(pixel % 256L)];
                        }
                        if (this.lut16 != null) {
                            pixel = this.valueToIndex[this.ac][(int)(pixel % 65536L)];
                        }
                    }
                    switch (pixelType) {
                        case 6: {
                            float floatPixel = specialPixel ? (float)pixel : (float)(this.scaleFactor * (double)pixel);
                            pixel = Float.floatToIntBits(floatPixel);
                            break;
                        }
                        case 7: {
                            double doublePixel = specialPixel ? (double)pixel : this.scaleFactor * (double)pixel;
                            pixel = Double.doubleToLongBits(doublePixel);
                            break;
                        }
                        default: {
                            if (specialPixel) break;
                            pixel = (long)(this.scaleFactor * (double)pixel);
                        }
                    }
                    int index = interleaved ? w * rgb * row + rgb * col + cOffset : h * w * cOffset + w * row + col;
                    DataTools.unpackBytes(pixel, buf, index *= bpp, bpp, little);
                }
            }
        }
        return buf;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        if (new Location(id).isDirectory() && FakeReader.checkSuffix(id, "fake")) {
            this.fakeSeries.clear();
            return this.listFakeSeries(id).size() <= 1;
        }
        if (FakeReader.checkSuffix(id, "fake.ini")) {
            return !new Location(id).exists();
        }
        return !new Location(id + ".ini").exists();
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (FakeReader.checkSuffix(name, "fake.ini")) {
            return true;
        }
        this.fakeSeries.clear();
        if (name.endsWith(".fake") && this.listFakeSeries(name).size() > 0) {
            return true;
        }
        return super.isThisType(name, open);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        this.fakeSeries.clear();
        if (!noPixels) {
            files.addAll(this.listFakeSeries(this.currentId));
        }
        if (this.iniFile != null) {
            files.add(this.iniFile);
        }
        return files.toArray(new String[files.size()]);
    }

    private void findLogFiles() {
        this.iniFile = null;
        Location loc = new Location(this.getCurrentFile() + ".ini");
        if (loc.exists()) {
            this.iniFile = loc.getAbsolutePath();
        }
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        this.iniFile = null;
        super.close(fileOnly);
    }

    public OMEXMLMetadata getOmeXmlMetadata() {
        if (this.omeXmlMetadata == null) {
            try {
                this.omeXmlMetadata = this.getOmeXmlService().createOMEXMLMetadata();
            }
            catch (ServiceException exc) {
                LOGGER.error("Could not create OME-XML metadata", exc);
            }
        }
        return this.omeXmlMetadata;
    }

    public OMEXMLService getOmeXmlService() {
        if (this.omeXmlService == null) {
            try {
                this.omeXmlService = new ServiceFactory().getInstance(OMEXMLService.class);
            }
            catch (DependencyException exc) {
                LOGGER.error("Could not create OME-XML service", exc);
            }
        }
        return this.omeXmlService;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        block97: {
            int i;
            int num;
            int lutLength;
            int pixelType;
            int sizeC;
            block98: {
                boolean hasSPW;
                Location root;
                String name;
                if (!FakeReader.checkSuffix(id, "fake")) {
                    Location file2;
                    if (FakeReader.checkSuffix(id, "fake.ini")) {
                        id = id.substring(0, id.lastIndexOf("."));
                    }
                    if (!(file2 = new Location(id).getAbsoluteFile()).exists()) {
                        Location dir = file2.getParentFile();
                        String[] list = dir.list(true);
                        name = file2.getName();
                        name = name.substring(0, name.lastIndexOf("."));
                        for (String f : list) {
                            if (!FakeReader.checkSuffix(f, "fake") || !f.startsWith(name)) continue;
                            id = new Location(dir, f).getAbsolutePath();
                            break;
                        }
                    }
                }
                super.initFile(id);
                this.findLogFiles();
                String path = id;
                Location location = new Location(id);
                String[] tokens = null;
                if (location.exists() && (path = location.getAbsoluteFile().getName()).startsWith("Field") && (root = location.getAbsoluteFile().getParentFile()) != null && (root = root.getParentFile()) != null && (root = root.getParentFile()) != null && this.isSPWStructure((root = root.getParentFile()).getAbsolutePath())) {
                    tokens = this.extractTokensFromFakeSeries(root.getAbsolutePath());
                    this.currentId = root.getAbsolutePath();
                }
                if (location.isDirectory() && this.isSPWStructure(location.getAbsolutePath())) {
                    tokens = this.extractTokensFromFakeSeries(location.getAbsolutePath());
                } else if (tokens == null) {
                    String noExt = path.substring(0, path.lastIndexOf("."));
                    tokens = noExt.split(TOKEN_SEPARATOR);
                }
                name = null;
                int sizeX = 512;
                int sizeY = 512;
                int sizeZ = 1;
                sizeC = 1;
                int sizeT = 1;
                int thumbSizeX = 0;
                int thumbSizeY = 0;
                pixelType = 1;
                int bitsPerPixel = 0;
                int rgb = 1;
                String dimOrder = DEFAULT_DIMENSION_ORDER;
                boolean orderCertain = true;
                boolean little = true;
                boolean interleaved = false;
                boolean indexed = false;
                boolean falseColor = false;
                boolean metadataComplete = true;
                boolean thumbnail = false;
                int seriesCount = 1;
                lutLength = 3;
                String acquisitionDate = null;
                int screens = 1;
                int plates = 0;
                int plateRows = 0;
                int plateCols = 0;
                int fields = 0;
                int plateAcqs = 0;
                int annLong = 0;
                int annDouble = 0;
                int annComment = 0;
                int annBool = 0;
                int annTime = 0;
                int annTag = 0;
                int annTerm = 0;
                int annXml = 0;
                int annMap = 0;
                Integer defaultColor = null;
                ArrayList<Integer> color = new ArrayList<Integer>();
                if (this.iniFile != null) {
                    IniParser parser = new IniParser();
                    IniList list = parser.parseINI(new File(this.iniFile));
                    ArrayList<String> newTokens = new ArrayList<String>();
                    IniTable table = list.getTable("DEFAULT_HEADER");
                    if (table != null) {
                        for (Map.Entry entry : table.entrySet()) {
                            newTokens.add((String)entry.getKey() + "=" + (String)entry.getValue());
                        }
                    }
                    if ((table = list.getTable("GlobalMetadata")) != null) {
                        for (Map.Entry entry : table.entrySet()) {
                            this.addGlobalMeta((String)entry.getKey(), entry.getValue());
                        }
                    }
                    String[] newTokArr = newTokens.toArray(new String[0]);
                    String[] oldTokArr = tokens;
                    tokens = new String[newTokArr.length + oldTokArr.length];
                    System.arraycopy(oldTokArr, 0, tokens, 0, oldTokArr.length);
                    System.arraycopy(newTokArr, 0, tokens, oldTokArr.length, newTokArr.length);
                }
                for (String token : tokens) {
                    int intValue;
                    double doubleValue;
                    if (name == null) {
                        name = token;
                        continue;
                    }
                    int equals = token.indexOf("=");
                    if (equals < 0) {
                        LOGGER.warn("ignoring token: {}", (Object)token);
                        continue;
                    }
                    String key = token.substring(0, equals);
                    String value = token.substring(equals + 1);
                    boolean boolValue = value.equals("true");
                    try {
                        doubleValue = Double.parseDouble(value);
                    }
                    catch (NumberFormatException exc) {
                        doubleValue = Double.NaN;
                    }
                    int n = intValue = Double.isNaN(doubleValue) ? -1 : (int)doubleValue;
                    if (key.equals("sizeX")) {
                        sizeX = intValue;
                        continue;
                    }
                    if (key.equals("sizeY")) {
                        sizeY = intValue;
                        continue;
                    }
                    if (key.equals("sizeZ")) {
                        sizeZ = intValue;
                        continue;
                    }
                    if (key.equals("sizeC")) {
                        sizeC = intValue;
                        continue;
                    }
                    if (key.equals("sizeT")) {
                        sizeT = intValue;
                        continue;
                    }
                    if (key.equals("thumbSizeX")) {
                        thumbSizeX = intValue;
                        continue;
                    }
                    if (key.equals("thumbSizeY")) {
                        thumbSizeY = intValue;
                        continue;
                    }
                    if (key.equals("pixelType")) {
                        pixelType = FormatTools.pixelTypeFromString(value);
                        continue;
                    }
                    if (key.equals("bitsPerPixel")) {
                        bitsPerPixel = intValue;
                        continue;
                    }
                    if (key.equals("rgb")) {
                        rgb = intValue;
                        continue;
                    }
                    if (key.equals("dimOrder")) {
                        dimOrder = value.toUpperCase();
                        continue;
                    }
                    if (key.equals("orderCertain")) {
                        orderCertain = boolValue;
                        continue;
                    }
                    if (key.equals("little")) {
                        little = boolValue;
                        continue;
                    }
                    if (key.equals("interleaved")) {
                        interleaved = boolValue;
                        continue;
                    }
                    if (key.equals("indexed")) {
                        indexed = boolValue;
                        continue;
                    }
                    if (key.equals("falseColor")) {
                        falseColor = boolValue;
                        continue;
                    }
                    if (key.equals("metadataComplete")) {
                        metadataComplete = boolValue;
                        continue;
                    }
                    if (key.equals("thumbnail")) {
                        thumbnail = boolValue;
                        continue;
                    }
                    if (key.equals("series")) {
                        seriesCount = intValue;
                        continue;
                    }
                    if (key.equals("lutLength")) {
                        lutLength = intValue;
                        continue;
                    }
                    if (key.equals("scaleFactor")) {
                        this.scaleFactor = doubleValue;
                        continue;
                    }
                    if (key.equals("exposureTime")) {
                        this.exposureTime = new Time(Float.valueOf((float)doubleValue), UNITS.S);
                        continue;
                    }
                    if (key.equals("acquisitionDate")) {
                        acquisitionDate = value;
                        continue;
                    }
                    if (key.equals("screens")) {
                        screens = intValue;
                        continue;
                    }
                    if (key.equals("plates")) {
                        plates = intValue;
                        continue;
                    }
                    if (key.equals("plateRows")) {
                        plateRows = intValue;
                        continue;
                    }
                    if (key.equals("plateCols")) {
                        plateCols = intValue;
                        continue;
                    }
                    if (key.equals("fields")) {
                        fields = intValue;
                        continue;
                    }
                    if (key.equals("plateAcqs")) {
                        plateAcqs = intValue;
                        continue;
                    }
                    if (key.equals("annLong")) {
                        annLong = intValue;
                        continue;
                    }
                    if (key.equals("annDouble")) {
                        annDouble = intValue;
                        continue;
                    }
                    if (key.equals("annMap")) {
                        annMap = intValue;
                        continue;
                    }
                    if (key.equals("annComment")) {
                        annComment = intValue;
                        continue;
                    }
                    if (key.equals("annBool")) {
                        annBool = intValue;
                        continue;
                    }
                    if (key.equals("annTime")) {
                        annTime = intValue;
                        continue;
                    }
                    if (key.equals("annTag")) {
                        annTag = intValue;
                        continue;
                    }
                    if (key.equals("annTerm")) {
                        annTerm = intValue;
                        continue;
                    }
                    if (key.equals("annXml")) {
                        annXml = intValue;
                        continue;
                    }
                    if (key.equals("physicalSizeX")) {
                        this.physicalSizeX = this.parseLength(value, Pixels.getPhysicalSizeXUnitXsdDefault());
                        continue;
                    }
                    if (key.equals("physicalSizeY")) {
                        this.physicalSizeY = this.parseLength(value, Pixels.getPhysicalSizeYUnitXsdDefault());
                        continue;
                    }
                    if (key.equals("physicalSizeZ")) {
                        this.physicalSizeZ = this.parseLength(value, Pixels.getPhysicalSizeZUnitXsdDefault());
                        continue;
                    }
                    if (key.equals("color")) {
                        defaultColor = this.parseColor(value);
                        continue;
                    }
                    if (!key.startsWith("color_")) continue;
                    int index = Integer.parseInt(key.substring(key.indexOf("_") + 1));
                    while (index >= color.size()) {
                        color.add(null);
                    }
                    color.set(index, this.parseColor(value));
                }
                if (sizeX < 1) {
                    throw new FormatException("Invalid sizeX: " + sizeX);
                }
                if (sizeY < 1) {
                    throw new FormatException("Invalid sizeY: " + sizeY);
                }
                if (sizeZ < 1) {
                    throw new FormatException("Invalid sizeZ: " + sizeZ);
                }
                if (sizeC < 1) {
                    throw new FormatException("Invalid sizeC: " + sizeC);
                }
                if (sizeT < 1) {
                    throw new FormatException("Invalid sizeT: " + sizeT);
                }
                if (thumbSizeX < 0) {
                    throw new FormatException("Invalid thumbSizeX: " + thumbSizeX);
                }
                if (thumbSizeY < 0) {
                    throw new FormatException("Invalid thumbSizeY: " + thumbSizeY);
                }
                if (rgb < 1 || rgb > sizeC || sizeC % rgb != 0) {
                    throw new FormatException("Invalid sizeC/rgb combination: " + sizeC + "/" + rgb);
                }
                this.getDimensionOrder(dimOrder);
                if (falseColor && !indexed) {
                    throw new FormatException("False color images must be indexed");
                }
                if (seriesCount < 1) {
                    throw new FormatException("Invalid seriesCount: " + seriesCount);
                }
                if (lutLength < 1) {
                    throw new FormatException("Invalid lutLength: " + lutLength);
                }
                MetadataStore store = this.makeFilterMetadata();
                boolean bl = hasSPW = plates > 0 && plateRows > 0 && plateCols > 0 && fields > 0 && plateAcqs > 0;
                if (hasSPW) {
                    int imageCount;
                    if (screens < 0) {
                        screens = 0;
                    }
                    if ((imageCount = this.populateSPW(store, screens, plates, plateRows, plateCols, fields, plateAcqs)) > 0) {
                        seriesCount = imageCount;
                    } else {
                        hasSPW = false;
                    }
                }
                int effSizeC = sizeC / rgb;
                this.core.clear();
                for (int s = 0; s < seriesCount; ++s) {
                    CoreMetadata ms = new CoreMetadata();
                    this.core.add(ms);
                    ms.sizeX = sizeX;
                    ms.sizeY = sizeY;
                    ms.sizeZ = sizeZ;
                    ms.sizeC = sizeC;
                    ms.sizeT = sizeT;
                    ms.thumbSizeX = thumbSizeX;
                    ms.thumbSizeY = thumbSizeY;
                    ms.pixelType = pixelType;
                    ms.bitsPerPixel = bitsPerPixel;
                    ms.imageCount = sizeZ * effSizeC * sizeT;
                    ms.rgb = rgb > 1;
                    ms.dimensionOrder = dimOrder;
                    ms.orderCertain = orderCertain;
                    ms.littleEndian = little;
                    ms.interleaved = interleaved;
                    ms.indexed = indexed;
                    ms.falseColor = falseColor;
                    ms.metadataComplete = metadataComplete;
                    ms.thumbnail = thumbnail;
                }
                boolean planeInfo = this.exposureTime != null;
                int annotationCount = 0;
                int annotationDoubleCount = 0;
                int annotationLongCount = 0;
                int annotationBoolCount = 0;
                int annotationCommentCount = 0;
                int annotationTagCount = 0;
                int annotationTermCount = 0;
                int annotationTimeCount = 0;
                int annotationXmlCount = 0;
                int annotationMapCount = 0;
                int annotationRefCount = 0;
                MetadataTools.populatePixels(store, this, planeInfo);
                this.fillExposureTime(store);
                this.fillPhysicalSizes(store);
                for (int currentImageIndex = 0; currentImageIndex < seriesCount; ++currentImageIndex) {
                    String nextAnnotationID;
                    int currentAnnotation;
                    String imageName = currentImageIndex > 0 ? name + " " + (currentImageIndex + 1) : name;
                    store.setImageName(imageName, currentImageIndex);
                    if (acquisitionDate != null && DateTools.getTime(acquisitionDate, "yyyy-MM-dd_HH-mm-ss") != -1L) {
                        store.setImageAcquisitionDate(new Timestamp(DateTools.formatDate(acquisitionDate, "yyyy-MM-dd_HH-mm-ss")), currentImageIndex);
                    }
                    for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                        Color channel;
                        Color color2 = channel = defaultColor == null ? null : new Color(defaultColor);
                        if (c < color.size() && color.get(c) != null) {
                            channel = new Color((Integer)color.get(c));
                        }
                        if (channel == null) continue;
                        store.setChannelColor(channel, currentImageIndex, c);
                    }
                    annotationRefCount = 0;
                    for (currentAnnotation = 0; currentAnnotation < annLong; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setLongAnnotationID(nextAnnotationID, annotationLongCount);
                        store.setLongAnnotationNamespace(ANNOTATION_NAMESPACE, annotationLongCount);
                        store.setLongAnnotationValue(365L + (long)annotationCount, annotationLongCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationLongCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annDouble; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setDoubleAnnotationID(nextAnnotationID, annotationDoubleCount);
                        store.setDoubleAnnotationNamespace(ANNOTATION_NAMESPACE, annotationDoubleCount);
                        store.setDoubleAnnotationValue(ANN_DOUBLE_VALUE * (double)(annotationCount + 1), annotationDoubleCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationDoubleCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annMap; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setMapAnnotationID(nextAnnotationID, annotationMapCount);
                        store.setMapAnnotationNamespace(ANNOTATION_NAMESPACE, annotationMapCount);
                        ArrayList<MapPair> mapValue = new ArrayList<MapPair>();
                        for (int keyNum = 0; keyNum < 10; ++keyNum) {
                            mapValue.add(new MapPair("keyS" + currentImageIndex + "N" + keyNum, "val" + (keyNum + 1) * (annotationCount + 1)));
                        }
                        store.setMapAnnotationValue(mapValue, annotationMapCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationMapCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annComment; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setCommentAnnotationID(nextAnnotationID, annotationCommentCount);
                        store.setCommentAnnotationNamespace(ANNOTATION_NAMESPACE, annotationCommentCount);
                        store.setCommentAnnotationValue(ANN_COMMENT_VALUE + (annotationCount + 1), annotationCommentCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationCommentCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annBool; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setBooleanAnnotationID(nextAnnotationID, annotationBoolCount);
                        store.setBooleanAnnotationNamespace(ANNOTATION_NAMESPACE, annotationBoolCount);
                        store.setBooleanAnnotationValue(true, annotationBoolCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationBoolCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annTime; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setTimestampAnnotationID(nextAnnotationID, annotationTimeCount);
                        store.setTimestampAnnotationNamespace(ANNOTATION_NAMESPACE, annotationTimeCount);
                        store.setTimestampAnnotationValue(ANN_TIME_VALUE, annotationTimeCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationTimeCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annTag; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setTagAnnotationID(nextAnnotationID, annotationTagCount);
                        store.setTagAnnotationNamespace(ANNOTATION_NAMESPACE, annotationTagCount);
                        store.setTagAnnotationValue(ANN_TAG_VALUE + (annotationCount + 1), annotationTagCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationTagCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annTerm; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setTermAnnotationID(nextAnnotationID, annotationTermCount);
                        store.setTermAnnotationNamespace(ANNOTATION_NAMESPACE, annotationTermCount);
                        store.setTermAnnotationValue(ANN_TERM_VALUE + (annotationCount + 1), annotationTermCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationTermCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                    for (currentAnnotation = 0; currentAnnotation < annXml; ++currentAnnotation) {
                        nextAnnotationID = ANNOTATION_PREFIX + annotationCount;
                        store.setXMLAnnotationID(nextAnnotationID, annotationXmlCount);
                        store.setXMLAnnotationNamespace(ANNOTATION_NAMESPACE, annotationXmlCount);
                        store.setXMLAnnotationValue(ANN_XML_VALUE_START + (annotationCount + 1) + ANN_XML_VALUE_END, annotationXmlCount);
                        store.setImageAnnotationRef(nextAnnotationID, currentImageIndex, annotationRefCount);
                        ++annotationXmlCount;
                        ++annotationCount;
                        ++annotationRefCount;
                    }
                }
                if (!indexed) break block97;
                if (pixelType != 1) break block98;
                num = 256;
                this.createIndexMap(256);
                this.lut8 = new byte[sizeC][lutLength][256];
                for (int c = 0; c < sizeC; ++c) {
                    for (i = 0; i < lutLength; ++i) {
                        for (int index = 0; index < 256; ++index) {
                            this.lut8[c][i][index] = (byte)this.indexToValue[c][index];
                        }
                    }
                }
                break block97;
            }
            if (pixelType != 3) break block97;
            num = 65536;
            this.createIndexMap(65536);
            this.lut16 = new short[sizeC][lutLength][65536];
            for (int c = 0; c < sizeC; ++c) {
                for (i = 0; i < lutLength; ++i) {
                    for (int index = 0; index < 65536; ++index) {
                        this.lut16[c][i][index] = (short)this.indexToValue[c][index];
                    }
                }
            }
        }
    }

    private void fillPhysicalSizes(MetadataStore store) {
        if (this.physicalSizeX == null && this.physicalSizeY == null && this.physicalSizeZ == null) {
            return;
        }
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            store.setPixelsPhysicalSizeX(this.physicalSizeX, s);
            store.setPixelsPhysicalSizeY(this.physicalSizeY, s);
            store.setPixelsPhysicalSizeZ(this.physicalSizeZ, s);
        }
    }

    private void fillExposureTime(MetadataStore store) {
        if (this.exposureTime == null) {
            return;
        }
        int oldSeries = this.getSeries();
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            this.setSeries(s);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneExposureTime(this.exposureTime, s, i);
            }
        }
        this.setSeries(oldSeries);
    }

    private String[] extractTokensFromFakeSeries(String path) {
        ArrayList<String> tokens = new ArrayList<String>();
        int plates = 0;
        int plateAcqs = 0;
        int rows = 0;
        int cols = 0;
        int fields = 0;
        String currentPlate = "";
        String regExFileSeparator = File.separatorChar == '\\' ? "\\\\" : File.separator;
        for (String fakeImage : this.fakeSeries) {
            for (String pathToken : fakeImage.split(regExFileSeparator)) {
                if (!pathToken.startsWith("Plate") || pathToken.equals(currentPlate)) continue;
                currentPlate = pathToken;
                ++plates;
            }
        }
        for (String pathToken : this.fakeSeries.get(this.fakeSeries.size() - 1).split(regExFileSeparator)) {
            if (pathToken.startsWith("Run")) {
                plateAcqs = Integer.parseInt(pathToken.substring(pathToken.lastIndexOf("Run") + "Run".length(), pathToken.length())) + 1;
                continue;
            }
            if (pathToken.startsWith("Well")) {
                String wellId = pathToken.substring(pathToken.lastIndexOf("Well") + "Well".length(), pathToken.length());
                String[] elements = wellId.split("(?<=\\p{L})(?=\\d)");
                rows = ResourceNamer.alphabeticIndexCount(elements[0]);
                cols = Integer.parseInt(elements[1]) + 1;
                continue;
            }
            if (!pathToken.startsWith("Field")) continue;
            String fieldName = pathToken.substring(0, pathToken.lastIndexOf("."));
            fields = Integer.parseInt(fieldName.substring(fieldName.lastIndexOf("Field") + "Field".length(), fieldName.length())) + 1;
        }
        tokens.add(path);
        tokens.add("plates=" + plates);
        tokens.add("plateRows=" + rows);
        tokens.add("plateCols=" + cols);
        tokens.add("fields=" + fields);
        tokens.add("plateAcqs=" + plateAcqs);
        return tokens.toArray(new String[tokens.size()]);
    }

    private boolean isSPWStructure(String path) {
        this.fakeSeries.clear();
        return !this.listFakeSeries(path).get(0).equals(path);
    }

    private int populateSPW(MetadataStore store, int screens, int plates, int rows, int cols, int fields, int acqs) {
        XMLMockObjects xml = new XMLMockObjects();
        OME ome = null;
        ome = screens == 0 ? xml.createPopulatedPlate(plates, rows, cols, fields, acqs) : xml.createPopulatedScreen(screens, plates, rows, cols, fields, acqs);
        this.getOmeXmlMetadata().setRoot(new OMEXMLMetadataRoot(ome));
        this.getOmeXmlService().convertMetadata(this.omeXmlMetadata, store);
        this.domains = new String[]{"High-Content Screening (HCS)"};
        return ome.sizeOfImageList();
    }

    private void createIndexMap(int num) {
        int index;
        int c;
        int sizeC = ((CoreMetadata)this.core.get((int)0)).sizeC;
        this.indexToValue = new int[sizeC][num];
        for (c = 0; c < sizeC; ++c) {
            for (index = 0; index < num; ++index) {
                this.indexToValue[c][index] = index;
            }
            FakeReader.shuffle(c, this.indexToValue[c]);
        }
        this.valueToIndex = new int[sizeC][num];
        for (c = 0; c < sizeC; ++c) {
            index = 0;
            while (index < num) {
                int value = this.indexToValue[c][index];
                this.valueToIndex[c][value] = index++;
            }
        }
    }

    private List<String> listFakeSeries(String traversedDirectory) {
        File parent = new File(traversedDirectory);
        if (parent.isDirectory()) {
            Object[] children = parent.listFiles();
            Arrays.sort(children);
            if (children != null) {
                for (Object child : children) {
                    this.listFakeSeries(((File)child).getAbsolutePath());
                }
            }
        } else {
            String path = parent.getAbsolutePath();
            if (FakeReader.checkSuffix(path, "fake") || FakeReader.checkSuffix(path, "fake.ini")) {
                this.fakeSeries.add(path);
            }
        }
        return this.fakeSeries;
    }

    private static void shuffle(int c, int[] array) {
        Random r = new Random(-889275714L + (long)c);
        for (int i = array.length; i > 1; --i) {
            int j = r.nextInt(i);
            int tmp = array[j];
            array[j] = array[i - 1];
            array[i - 1] = tmp;
        }
    }

    private int parseColor(String value) {
        int base = 10;
        if (value.startsWith("0x") || value.startsWith("0X")) {
            value = value.substring(2);
            base = 16;
        }
        try {
            return (int)Long.parseLong(value, base);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private Length parseLength(String value, String defaultUnit) {
        Matcher m = Pattern.compile("\\s*([\\d.]+)\\s*([\\D\\S]*)\\s*").matcher(value);
        if (!m.matches()) {
            throw new RuntimeException(String.format("%s does not match a physical size!", value));
        }
        String number = m.group(1);
        String unit = m.group(2);
        if (unit == null || unit.trim().length() == 0) {
            unit = defaultUnit;
        }
        double d = Double.valueOf(number);
        Unit<Length> l = null;
        try {
            l = UnitsLengthEnumHandler.getBaseUnit(UnitsLength.fromString(unit));
        }
        catch (EnumerationException e) {
            throw new RuntimeException(String.format("%s does not match a length unit!", unit));
        }
        return new Length(d, l);
    }
}

