/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;

public class SparseRCMLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseLongMatrix1D[] elements;

    public SparseRCMLongMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseLongMatrix1D[rows];
        int i = 0;
        while (i < rows) {
            this.elements[i] = new SparseLongMatrix1D(columns);
            ++i;
        }
    }

    public SparseLongMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public long getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    @Override
    public void setQuick(int row, int column, long value) {
        this.elements[row].setQuick(column, value);
    }

    @Override
    public void trimToSize() {
        int r = 0;
        while (r < this.rows) {
            this.elements[r].trimToSize();
            ++r;
        }
    }

    @Override
    public SparseLongMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    @Override
    protected LongMatrix2D getContent() {
        return this;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new SparseRCMLongMatrix2D(rows, columns);
    }
}

