/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.LightSource;
import ome.xml.model.Map;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericExcitationSource
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericExcitationSource.class);
    private Map map;

    public GenericExcitationSource() {
    }

    public GenericExcitationSource(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public GenericExcitationSource(GenericExcitationSource orig) {
        super(orig);
        this.map = orig.map;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Map_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"GenericExcitationSource".equals(tagName)) {
            LOGGER.debug("Expecting node name of GenericExcitationSource got {}", (Object)tagName);
        }
        if ((Map_nodeList = GenericExcitationSource.getChildrenByTagName(element, "Map")).size() > 1) {
            throw new RuntimeException(String.format("Map node list size %d != 1", Map_nodeList.size()));
        }
        if (Map_nodeList.size() != 0) {
            this.setMap(new Map(Map_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element GenericExcitationSource_element) {
        if (GenericExcitationSource_element == null) {
            GenericExcitationSource_element = document.createElementNS(NAMESPACE, "GenericExcitationSource");
        }
        if (this.map != null) {
            GenericExcitationSource_element.appendChild(this.map.asXMLElement(document));
        }
        return super.asXMLElement(document, GenericExcitationSource_element);
    }
}

