/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import ucar.ma2.DataType;
import ucar.nc2.CDMNode;
import ucar.nc2.NetcdfFile;
import ucar.nc2.util.Indent;

@Immutable
public class EnumTypedef
extends CDMNode {
    private final Map<Integer, String> map;
    private ArrayList<String> enumStrings;
    private DataType basetype;

    public EnumTypedef(String name, Map<Integer, String> map) {
        this(name, map, DataType.ENUM4);
    }

    public EnumTypedef(String name, Map<Integer, String> map, DataType basetype) {
        super(name);
        assert (this.validateMap(map, basetype));
        this.map = map;
        this.setBaseType(basetype);
    }

    public List<String> getEnumStrings() {
        if (this.enumStrings != null) {
            this.enumStrings = new ArrayList<String>(this.map.values());
            Collections.sort(this.enumStrings);
        }
        return this.enumStrings;
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    public DataType getBaseType() {
        return this.basetype;
    }

    public void setBaseType(DataType basetype) {
        switch (basetype) {
            case ENUM1: 
            case ENUM2: 
            case ENUM4: {
                this.basetype = basetype;
                break;
            }
            default: {
                assert (false) : "Illegal Enum basetype";
                break;
            }
        }
    }

    public boolean validateMap(Map<Integer, String> map, DataType basetype) {
        if (map == null || basetype == null) {
            return false;
        }
        for (Integer I : map.keySet()) {
            int i = I;
            if (basetype == DataType.ENUM1 && (i < -128 || i > 127)) {
                return false;
            }
            if (basetype == DataType.ENUM2 && (i < Short.MIN_VALUE || i > Short.MAX_VALUE)) {
                return false;
            }
            if (basetype != DataType.ENUM2 || i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE) continue;
            return false;
        }
        return true;
    }

    public boolean inRange(int i) {
        if (this.basetype == DataType.ENUM1 && (i >= -128 || i <= 127)) {
            return true;
        }
        if (this.basetype == DataType.ENUM2 && (i >= Short.MIN_VALUE || i <= Short.MAX_VALUE)) {
            return true;
        }
        return this.basetype == DataType.ENUM2 && (i >= Integer.MIN_VALUE || i <= Integer.MAX_VALUE);
    }

    public String lookupEnumString(int e) {
        String result = this.map.get(e);
        return result == null ? "Unknown enum value=" + e : result;
    }

    public String writeCDL(boolean strict) {
        Formatter out = new Formatter();
        this.writeCDL(out, new Indent(2), strict);
        return out.toString();
    }

    protected void writeCDL(Formatter out, Indent indent, boolean strict) {
        String name = strict ? NetcdfFile.makeValidCDLName(this.getShortName()) : this.getShortName();
        out.format("%senum %s { ", indent, name);
        int count = 0;
        List<Object> keyset = Arrays.asList(this.map.keySet().toArray());
        for (Object key : keyset) {
            String s = this.map.get(key);
            if (0 < count++) {
                out.format(", ", new Object[0]);
            }
            if (strict) {
                out.format("%s = %s", NetcdfFile.makeValidCDLName(s), key);
                continue;
            }
            out.format("'%s' = %s", s, key);
        }
        out.format("};", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypedef that = (EnumTypedef)o;
        if (this.map != null ? !this.map.equals(that.map) : that.map != null) {
            return false;
        }
        String name = this.getShortName();
        String thatname = that.getShortName();
        return !(name != null ? !name.equals(thatname) : thatname != null);
    }

    public int hashCode() {
        if (CDMNode.OBJECTHASH) {
            return super.hashCode();
        }
        String name = this.getShortName();
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (this.map != null ? this.map.hashCode() : 0);
        return result;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("EnumTypedef %s: ", this.getShortName());
        for (int key : this.map.keySet()) {
            f.format("%d=%s,", key, this.map.get(key));
        }
        return f.toString();
    }
}

