/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tfloat;

import cern.colt.PersistentObject;
import cern.colt.buffer.tfloat.FloatBuffer3DConsumer;
import cern.colt.list.tfloat.FloatArrayList;

public class FloatBuffer3D
extends PersistentObject
implements FloatBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected FloatBuffer3DConsumer target;
    protected float[] xElements;
    protected float[] yElements;
    protected float[] zElements;
    protected FloatArrayList xList;
    protected FloatArrayList yList;
    protected FloatArrayList zList;
    protected int capacity;
    protected int size;

    public FloatBuffer3D(FloatBuffer3DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new float[capacity];
        this.yElements = new float[capacity];
        this.zElements = new float[capacity];
        this.xList = new FloatArrayList(this.xElements);
        this.yList = new FloatArrayList(this.yElements);
        this.zList = new FloatArrayList(this.zElements);
        this.size = 0;
    }

    public void add(float x, float y, float z) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size] = y;
        this.zElements[this.size++] = z;
    }

    @Override
    public void addAllOf(FloatArrayList xElements, FloatArrayList yElements, FloatArrayList zElements) {
        int listSize = xElements.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(xElements, yElements, zElements);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

