/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.gj;

import org.ejml.alg.dense.decomposition.SingularMatrixException;
import org.ejml.alg.dense.linsol.LinearSolverAbstract;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;

public class GaussJordan
extends LinearSolverAbstract {
    private int[] ipiv;
    private int[] indexRow;
    private int[] indexCol;

    public GaussJordan(int n) {
        this.ipiv = new int[n];
        this.indexRow = new int[n];
        this.indexCol = new int[n];
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        this._setA(denseMatrix64F);
        return true;
    }

    @Override
    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    public static void checkArgumentSquare(RowD1Matrix64F rowD1Matrix64F, String string) {
        if (rowD1Matrix64F.numCols != rowD1Matrix64F.numRows) {
            throw new IllegalArgumentException("'" + string + "' must be a square matrix.");
        }
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        int n;
        GaussJordan.checkArgumentSquare(denseMatrix64F, "A");
        if (denseMatrix64F != this.A) {
            denseMatrix64F.set(this.A);
        }
        int n2 = denseMatrix64F.numCols;
        for (n = 0; n < n2; ++n) {
            this.ipiv[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            double d = 0.0;
            int n4 = -1;
            int n5 = -1;
            for (int i = 0; i < n2; ++i) {
                if (this.ipiv[i] == 1) continue;
                for (int j = 0; j < n2; ++j) {
                    if (this.ipiv[j] != 0) continue;
                    double d2 = denseMatrix64F.unsafe_get(i, j);
                    if (d2 < 0.0) {
                        d2 = -d2;
                    }
                    if (!(d2 > d)) continue;
                    d = d2;
                    n4 = i;
                    n5 = j;
                }
            }
            if (n5 < 0) {
                throw new RuntimeException();
            }
            int n6 = n5;
            this.ipiv[n6] = this.ipiv[n6] + 1;
            if (n4 != n5) {
                GaussJordan.swapRow(denseMatrix64F, denseMatrix64F.numCols, n4, n5);
            }
            this.indexRow[n] = n4;
            this.indexCol[n] = n5;
            double d3 = denseMatrix64F.get(n5, n5);
            if (d3 == 0.0) {
                throw new SingularMatrixException();
            }
            denseMatrix64F.set(n5 * n2 + n5, 1.0);
            for (n3 = 0; n3 < n2; ++n3) {
                denseMatrix64F.div(n5 * n2 + n3, d3);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                if (n5 == n3) continue;
                double d4 = denseMatrix64F.get(n3, n5);
                denseMatrix64F.set(n3 * n2 + n5, 0.0);
                for (int i = 0; i < n2; ++i) {
                    denseMatrix64F.minus(n3 * n2 + i, d4 * denseMatrix64F.get(n5 * n2 + i));
                }
            }
        }
        GaussJordan.unscramble(n2, denseMatrix64F, this.indexRow, this.indexCol);
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        int n;
        GaussJordan.checkArgumentSquare(this.A, "A");
        if (this.A.getNumCols() != denseMatrix64F.getNumRows()) {
            throw new IllegalArgumentException("Dimensions of A and B are not compatible.");
        }
        denseMatrix64F2.set(denseMatrix64F);
        int n2 = this.A.numCols;
        for (n = 0; n < n2; ++n) {
            this.ipiv[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            int n3;
            double d = 0.0;
            int n4 = -1;
            int n5 = -1;
            for (int i = 0; i < n2; ++i) {
                if (this.ipiv[i] == 1) continue;
                for (int j = 0; j < n2; ++j) {
                    if (this.ipiv[j] != 0) continue;
                    double d2 = this.A.unsafe_get(i, j);
                    if (d2 < 0.0) {
                        d2 = -d2;
                    }
                    if (!(d2 > d)) continue;
                    d = d2;
                    n4 = i;
                    n5 = j;
                }
            }
            int n6 = n5;
            this.ipiv[n6] = this.ipiv[n6] + 1;
            if (n4 != n5) {
                GaussJordan.swapRow(this.A, this.A.numCols, n4, n5);
                GaussJordan.swapRow(denseMatrix64F2, denseMatrix64F2.numCols, n4, n5);
            }
            this.indexRow[n] = n4;
            this.indexCol[n] = n5;
            double d3 = this.A.get(n5, n5);
            if (d3 == 0.0) {
                throw new RuntimeException("Singular Matrix");
            }
            d3 = 1.0 / d3;
            this.A.unsafe_set(n5, n5, 1.0);
            for (n3 = 0; n3 < n2; ++n3) {
                this.A.times(n5 * n2 + n3, d3);
            }
            for (n3 = 0; n3 < denseMatrix64F2.numCols; ++n3) {
                denseMatrix64F2.times(n5 * denseMatrix64F2.numCols + n3, d3);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n7;
                if (n5 == n3) continue;
                double d4 = this.A.get(n3, n5);
                this.A.set(n3 * n2 + n5, 0.0);
                for (n7 = 0; n7 < n2; ++n7) {
                    this.A.minus(n3 * n2 + n7, d4 * this.A.get(n5 * n2 + n7));
                }
                for (n7 = 0; n7 < denseMatrix64F2.numCols; ++n7) {
                    denseMatrix64F2.minus(n3 * denseMatrix64F2.numCols + n7, d4 * denseMatrix64F2.get(n5 * denseMatrix64F2.numCols + n7));
                }
            }
        }
        GaussJordan.unscramble(n2, this.A, this.indexRow, this.indexCol);
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    private static void unscramble(int n, RowD1Matrix64F rowD1Matrix64F, int[] nArray, int[] nArray2) {
        for (int i = n - 1; i >= 0; --i) {
            if (nArray[i] == nArray2[i]) continue;
            for (int j = 0; j < n; ++j) {
                int n2 = j * n;
                int n3 = n2 + nArray[i];
                int n4 = n2 + nArray2[i];
                double d = rowD1Matrix64F.get(n3);
                rowD1Matrix64F.set(n3, rowD1Matrix64F.get(n4));
                rowD1Matrix64F.set(n4, d);
            }
        }
    }

    private static void swapRow(RowD1Matrix64F rowD1Matrix64F, int n, int n2, int n3) {
        int n4 = n2 * n;
        int n5 = n3 * n;
        int n6 = n4 + n;
        while (n4 < n6) {
            double d = rowD1Matrix64F.get(n5);
            rowD1Matrix64F.set(n5, rowD1Matrix64F.get(n4));
            rowD1Matrix64F.set(n4, d);
            ++n4;
            ++n5;
        }
    }
}

