package plugins.adufour.activemeshes.energy;

import java.util.concurrent.ExecutorService;

import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.activemeshes.mesh.Vertex;
import plugins.adufour.vars.lang.Var;

public class GradientTerm extends DataAttachmentTerm
{
	public GradientTerm(ExecutorService service, Var<Double> weight)
	{
		super(service, weight);
	}
	
	@Override
	public void registerMesh(Mesh mesh)
	{
		mesh.addModel(new Model(mesh)
		{
			@Override
			public void computeForces()
			{
				double w = weight.getValue();
				
				for (Vertex v : mesh.vertices)
				{
					if (v == null) continue;
					
					double x = v.position.x / imResolution.x;
					double y = v.position.y / imResolution.y;
					double z = v.position.z / imResolution.z;
					
					// check bounds only once
					if (x < sampler.minBounds.x + 1 || y < sampler.minBounds.y + 1 || z < sampler.minBounds.z + 1) continue;
					if (x >= sampler.maxBounds.x - 1 || y >= sampler.maxBounds.y - 1 || z >= sampler.maxBounds.z - 1) continue;
					
					double vVal = sampler.getPixelValue(x, y, z, false);
					double xVal = sampler.getPixelValue(x + 1, y, z, false);
					double yVal = sampler.getPixelValue(x, y + 1, z, false);
					double zVal = sampler.getPixelValue(x, y, z + 1, false);
					
					v.forces.x += w * (xVal - vVal);
					v.forces.y += w * (yVal - vVal);
					v.forces.z += w * (zVal - vVal);
				}
			}
			
			@Override
			public void removeMesh(Mesh mesh)
			{
				// nothing to do
			}
		});
	}
	
	@Override
	public void unregisterMesh(Mesh mesh)
	{
		
	}
	
	@Override
	public void unregisterMeshes()
	{
		
	}
	
}
