/*
 * Decompiled with CFR 0.152.
 */
package ome.units.unit;

import ome.units.quantity.Quantity;

public class Unit<Q extends Quantity> {
    private final String measurementSystem;
    private final String symbol;
    private final Double scaleFactor;
    private final Double offset;

    private Unit(String inSystem, String inSymbol, Double inScaleFactor, Double inOffset) {
        this.measurementSystem = inSystem;
        this.symbol = inSymbol;
        this.scaleFactor = inScaleFactor;
        this.offset = inOffset;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public Double getOffset() {
        return this.offset;
    }

    public Boolean isConvertible(Unit<Q> inUnit) {
        return this.measurementSystem.equals(inUnit.measurementSystem);
    }

    public Double convertValue(Number inValue, Unit<Q> inUnit) {
        if (!this.isConvertible(inUnit).booleanValue()) {
            throw new ArithmeticException("Incompatible units are not convertible [" + this.measurementSystem + "]->[" + inUnit.measurementSystem + "]");
        }
        Double theResult = (inValue.doubleValue() * this.scaleFactor + this.offset - inUnit.offset) / inUnit.scaleFactor;
        return theResult;
    }

    public Unit<Q> multiply(Integer scalar) {
        Double newScaleFactor = this.scaleFactor * (double)scalar.intValue();
        Double newOffset = this.offset * (double)scalar.intValue();
        return new Unit<Q>(this.measurementSystem, this.symbol, newScaleFactor, newOffset);
    }

    public Unit<Q> multiply(Double scalar) {
        Double newScaleFactor = this.scaleFactor * scalar;
        Double newOffset = this.offset * scalar;
        return new Unit<Q>(this.measurementSystem, this.symbol, newScaleFactor, newOffset);
    }

    public Unit<Q> divide(Integer scalar) {
        Double newScaleFactor = this.scaleFactor / (double)scalar.intValue();
        Double newOffset = this.offset / (double)scalar.intValue();
        return new Unit<Q>(this.measurementSystem, this.symbol, newScaleFactor, newOffset);
    }

    public Unit<Q> divide(Double scalar) {
        Double newScaleFactor = this.scaleFactor / scalar;
        Double newOffset = this.offset / scalar;
        return new Unit<Q>(this.measurementSystem, this.symbol, newScaleFactor, newOffset);
    }

    public Unit<Q> add(Integer scalar) {
        Double newOffset = this.offset + (double)scalar.intValue();
        return new Unit<Q>(this.measurementSystem, this.symbol, this.scaleFactor, newOffset);
    }

    public Unit<Q> add(Double scalar) {
        Double newOffset = this.offset + scalar;
        return new Unit<Q>(this.measurementSystem, this.symbol, this.scaleFactor, newOffset);
    }

    public Unit<Q> setSymbol(String inSymbol) {
        return new Unit<Q>(this.measurementSystem, inSymbol, this.scaleFactor, this.offset);
    }

    public Unit<Q> prefixSymbol(String prefix) {
        String newSymbol = prefix + this.symbol;
        return new Unit<Q>(this.measurementSystem, newSymbol, this.scaleFactor, this.offset);
    }

    public static <Q extends Quantity> Unit<Q> CreateBaseUnit(String inMeasurementSystem, String inSymbol) {
        return new Unit<Q>(inMeasurementSystem, inSymbol, 1.0, 0.0);
    }
}

