/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.function.tfloat.Float27Function;
import cern.colt.function.tfloat.Float9Function;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix2DProcedure;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3DProcedure;

public class FloatStencil {
    protected FloatStencil() {
    }

    public static int stencil27(FloatMatrix3D A, Float27Function function, int maxIterations, FloatMatrix3DProcedure hasConverged, int convergenceIterations) {
        FloatMatrix3D B = A.copy();
        if (convergenceIterations <= 1) {
            convergenceIterations = 2;
        }
        if (convergenceIterations % 2 != 0) {
            ++convergenceIterations;
        }
        int i = 0;
        while (i < maxIterations) {
            A.zAssign27Neighbors(B, function);
            B.zAssign27Neighbors(A, function);
            if ((i += 2) % convergenceIterations != 0 || hasConverged == null || !hasConverged.apply(A)) continue;
            return i;
        }
        return i;
    }

    public static int stencil9(FloatMatrix2D A, Float9Function function, int maxIterations, FloatMatrix2DProcedure hasConverged, int convergenceIterations) {
        FloatMatrix2D B = A.copy();
        if (convergenceIterations <= 1) {
            convergenceIterations = 2;
        }
        if (convergenceIterations % 2 != 0) {
            ++convergenceIterations;
        }
        int i = 0;
        while (i < maxIterations) {
            A.zAssign8Neighbors(B, function);
            B.zAssign8Neighbors(A, function);
            if ((i += 2) % convergenceIterations != 0 || hasConverged == null || !hasConverged.apply(A)) continue;
            return i;
        }
        return i;
    }
}

