/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tfloat.demo;

import edu.emory.mathcs.csparsej.tfloat.Scs_add;
import edu.emory.mathcs.csparsej.tfloat.Scs_chol;
import edu.emory.mathcs.csparsej.tfloat.Scs_cholsol;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_compress;
import edu.emory.mathcs.csparsej.tfloat.Scs_dmperm;
import edu.emory.mathcs.csparsej.tfloat.Scs_droptol;
import edu.emory.mathcs.csparsej.tfloat.Scs_dropzeros;
import edu.emory.mathcs.csparsej.tfloat.Scs_dupl;
import edu.emory.mathcs.csparsej.tfloat.Scs_fkeep;
import edu.emory.mathcs.csparsej.tfloat.Scs_gaxpy;
import edu.emory.mathcs.csparsej.tfloat.Scs_ifkeep;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_load;
import edu.emory.mathcs.csparsej.tfloat.Scs_lsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_ltsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_lusol;
import edu.emory.mathcs.csparsej.tfloat.Scs_multiply;
import edu.emory.mathcs.csparsej.tfloat.Scs_norm;
import edu.emory.mathcs.csparsej.tfloat.Scs_permute;
import edu.emory.mathcs.csparsej.tfloat.Scs_pinv;
import edu.emory.mathcs.csparsej.tfloat.Scs_pvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_qrsol;
import edu.emory.mathcs.csparsej.tfloat.Scs_schol;
import edu.emory.mathcs.csparsej.tfloat.Scs_transpose;
import edu.emory.mathcs.csparsej.tfloat.Scs_updown;
import edu.emory.mathcs.csparsej.tfloat.Scs_util;
import java.util.Random;

public class Scs_demo {
    private static int is_sym(Scs_common.Scs scs) {
        int n = scs.n;
        int n2 = scs.m;
        int[] nArray = scs.p;
        int[] nArray2 = scs.i;
        if (n2 != n) {
            return 0;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (nArray2[j] > i) {
                    bl = false;
                }
                if (nArray2[j] >= i) continue;
                bl2 = false;
            }
        }
        return bl ? 1 : (bl2 ? -1 : 0);
    }

    private static Scs_common.Scs make_sym(Scs_common.Scs scs) {
        Scs_common.Scs scs2 = Scs_transpose.cs_transpose(scs, true);
        Scs_fkeep.cs_fkeep(scs2, new Dropdiag(), null);
        Scs_common.Scs scs3 = Scs_add.cs_add(scs, scs2, 1.0f, 1.0f);
        return scs3;
    }

    private static void rhs(float[] fArray, float[] fArray2, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n2] = 1.0f + (float)n2 / (float)n;
        }
        for (n2 = 0; n2 < n; ++n2) {
            fArray[n2] = fArray2[n2];
        }
    }

    private static float norm(float[] fArray, int n) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f = Math.max(f, Math.abs(fArray[i]));
        }
        return f;
    }

    private static void print_resid(boolean bl, Scs_common.Scs scs, float[] fArray, float[] fArray2, float[] fArray3) {
        if (!bl) {
            System.out.print("    (failed)\n");
            return;
        }
        int n = scs.m;
        int n2 = scs.n;
        for (int i = 0; i < n; ++i) {
            fArray3[i] = -fArray2[i];
        }
        Scs_gaxpy.cs_gaxpy(scs, fArray, fArray3);
        System.out.print(String.format("resid: %8.2e\n", Float.valueOf(Scs_demo.norm(fArray3, n) / (n2 == 0 ? 1.0f : Scs_norm.cs_norm(scs) * Scs_demo.norm(fArray, n2) + Scs_demo.norm(fArray2, n)))));
    }

    private static float tic() {
        return System.nanoTime();
    }

    private static float toc(float f) {
        float f2 = Scs_demo.tic();
        return Math.max(0.0f, f2 - f) / 1000000.0f;
    }

    private static void print_order(int n) {
        switch (n) {
            case 0: {
                System.out.print("natural    ");
                break;
            }
            case 1: {
                System.out.print("amd(A+A')  ");
                break;
            }
            case 2: {
                System.out.print("amd(S'*S)  ");
                break;
            }
            case 3: {
                System.out.print("amd(A'*A)  ");
            }
        }
    }

    public static Sproblem get_problem(String string, boolean bl, float f) {
        int n;
        Scs_common.Scs scs;
        Sproblem sproblem = new Sproblem();
        Scs_common.Scs scs2 = Scs_load.cs_load(string, bl);
        sproblem.A = scs = Scs_compress.cs_compress(scs2);
        scs2 = null;
        Scs_dupl.cs_dupl(scs);
        sproblem.sym = n = Scs_demo.is_sym(scs);
        int n2 = scs.m;
        int n3 = scs.n;
        int n4 = Math.max(n2, n3);
        int n5 = scs.p[n3];
        Scs_dropzeros.cs_dropzeros(scs);
        int n6 = scs.p[n3];
        if (f > 0.0f) {
            Scs_droptol.cs_droptol(scs, f);
        }
        Scs_common.Scs scs3 = n != 0 ? Scs_demo.make_sym(scs) : scs;
        sproblem.C = scs3;
        if (scs3 == null) {
            return null;
        }
        System.out.print(String.format("\n--- Matrix: %d-by-%d, nnz: %d (sym: %d: nnz %d), norm: %8.2e\n", n2, n3, scs.p[n3], n, n != 0 ? scs3.p[n3] : 0, Float.valueOf(Scs_norm.cs_norm(scs3))));
        if (n5 != n6) {
            System.out.print(String.format("zero entries dropped: %d\n", n5 - n6));
        }
        if (n6 != scs.p[n3]) {
            System.out.print(String.format("tiny entries dropped: %d\n", n6 - scs.p[n3]));
        }
        sproblem.b = new float[n4];
        sproblem.x = new float[n4];
        sproblem.resid = new float[n4];
        return sproblem;
    }

    public static boolean demo2(Sproblem sproblem) {
        boolean bl;
        float f;
        int n;
        if (sproblem == null) {
            return false;
        }
        Scs_common.Scs scs = sproblem.A;
        Scs_common.Scs scs2 = sproblem.C;
        float[] fArray = sproblem.b;
        float[] fArray2 = sproblem.x;
        float[] fArray3 = sproblem.resid;
        int n2 = scs.m;
        int n3 = scs.n;
        float f2 = sproblem.sym != 0 ? 0.001f : 1.0f;
        Scs_common.Scsd scsd = Scs_dmperm.cs_dmperm(scs2, 1);
        if (scsd == null) {
            return false;
        }
        int n4 = scsd.nb;
        int[] nArray = scsd.r;
        int[] nArray2 = scsd.s;
        int[] nArray3 = scsd.rr;
        int n5 = nArray3[3];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (nArray[i + 1] != nArray[i] + 1 || nArray2[i + 1] != nArray2[i] + 1) continue;
            ++n6;
        }
        System.out.print(String.format("blocks: %d singletons: %d structural rank: %d\n", n4, n6, n5));
        scsd = null;
        for (n = 0; n <= 3; n += 3) {
            if (n == 0 && n2 > 1000) continue;
            System.out.print("QR   ");
            Scs_demo.print_order(n);
            Scs_demo.rhs(fArray2, fArray, n2);
            f = Scs_demo.tic();
            bl = Scs_qrsol.cs_qrsol(n, scs2, fArray2);
            System.out.print(String.format("time: %8.2f ms ", Float.valueOf(Scs_demo.toc(f))));
            Scs_demo.print_resid(bl, scs2, fArray2, fArray, fArray3);
        }
        if (n2 != n3 || n5 < n3) {
            return true;
        }
        for (n = 0; n <= 3; ++n) {
            if (n == 0 && n2 > 1000) continue;
            System.out.print("LU   ");
            Scs_demo.print_order(n);
            Scs_demo.rhs(fArray2, fArray, n2);
            f = Scs_demo.tic();
            bl = Scs_lusol.cs_lusol(n, scs2, fArray2, f2);
            System.out.print(String.format("time: %8.2f ms ", Float.valueOf(Scs_demo.toc(f))));
            Scs_demo.print_resid(bl, scs2, fArray2, fArray, fArray3);
        }
        if (sproblem.sym == 0) {
            return true;
        }
        for (n = 0; n <= 1; ++n) {
            if (n == 0 && n2 > 1000) continue;
            System.out.print("Chol ");
            Scs_demo.print_order(n);
            Scs_demo.rhs(fArray2, fArray, n2);
            f = Scs_demo.tic();
            bl = Scs_cholsol.cs_cholsol(n, scs2, fArray2);
            System.out.print(String.format("time: %8.2f ms ", Float.valueOf(Scs_demo.toc(f))));
            Scs_demo.print_resid(bl, scs2, fArray2, fArray, fArray3);
        }
        return true;
    }

    public static boolean demo3(Sproblem sproblem) {
        int n;
        Scs_common.Scs scs = null;
        Scs_common.Scs scs2 = null;
        int[] nArray = null;
        float[] fArray = null;
        Scs_common.Scss scss = null;
        Scs_common.Scsn scsn = null;
        if (sproblem == null || sproblem.sym == 0 || sproblem.A.n == 0) {
            return false;
        }
        Scs_common.Scs scs3 = sproblem.A;
        Scs_common.Scs scs4 = sproblem.C;
        float[] fArray2 = sproblem.b;
        float[] fArray3 = sproblem.x;
        float[] fArray4 = sproblem.resid;
        int n2 = scs3.n;
        if (sproblem.sym == 0 || n2 == 0) {
            return true;
        }
        Scs_demo.rhs(fArray3, fArray2, n2);
        System.out.print("\nchol then update/downdate ");
        Scs_demo.print_order(1);
        fArray = new float[n2];
        float f = Scs_demo.tic();
        scss = Scs_schol.cs_schol(1, scs4);
        System.out.print(String.format("\nsymbolic chol time %8.2f ms\n", Float.valueOf(Scs_demo.toc(f))));
        f = Scs_demo.tic();
        scsn = Scs_chol.cs_chol(scs4, scss);
        System.out.print(String.format("numeric  chol time %8.2f ms\n", Float.valueOf(Scs_demo.toc(f))));
        if (scss == null || scsn == null) {
            return false;
        }
        f = Scs_demo.tic();
        Scs_ipvec.cs_ipvec(scss.pinv, fArray2, fArray, n2);
        Scs_lsolve.cs_lsolve(scsn.L, fArray);
        Scs_ltsolve.cs_ltsolve(scsn.L, fArray);
        Scs_pvec.cs_pvec(scss.pinv, fArray, fArray3, n2);
        System.out.print(String.format("solve    chol time %8.2f ms\n", Float.valueOf(Scs_demo.toc(f))));
        System.out.println("original: ");
        Scs_demo.print_resid(true, scs4, fArray3, fArray2, fArray4);
        int n3 = n2 / 2;
        scs = Scs_util.cs_spalloc(n2, 1, n2, true, false);
        int[] nArray2 = scsn.L.p;
        int[] nArray3 = scsn.L.i;
        float[] fArray5 = scsn.L.x;
        int[] nArray4 = scs.p;
        int[] nArray5 = scs.i;
        float[] fArray6 = scs.x;
        nArray4[0] = 0;
        nArray4[1] = nArray2[n3 + 1] - n;
        float f2 = fArray5[n];
        Random random = new Random(1L);
        for (n = nArray2[n3]; n < nArray2[n3 + 1]; ++n) {
            int n4 = n - nArray2[n3];
            nArray5[n4] = nArray3[n];
            fArray6[n4] = f2 * random.nextFloat();
        }
        f = Scs_demo.tic();
        boolean bl = Scs_updown.cs_updown(scsn.L, 1, scs, scss.parent);
        float f3 = Scs_demo.toc(f);
        System.out.print(String.format("update:   time: %8.2f ms\n", Float.valueOf(f3)));
        if (!bl) {
            return false;
        }
        f = Scs_demo.tic();
        Scs_ipvec.cs_ipvec(scss.pinv, fArray2, fArray, n2);
        Scs_lsolve.cs_lsolve(scsn.L, fArray);
        Scs_ltsolve.cs_ltsolve(scsn.L, fArray);
        Scs_pvec.cs_pvec(scss.pinv, fArray, fArray3, n2);
        f = Scs_demo.toc(f);
        nArray = Scs_pinv.cs_pinv(scss.pinv, n2);
        Scs_common.Scs scs5 = Scs_permute.cs_permute(scs, nArray, null, true);
        Scs_common.Scs scs6 = Scs_transpose.cs_transpose(scs5, true);
        Scs_common.Scs scs7 = Scs_multiply.cs_multiply(scs5, scs6);
        scs6 = null;
        scs5 = null;
        scs2 = Scs_add.cs_add(scs4, scs7, 1.0f, 1.0f);
        scs7 = null;
        if (scs2 == null || nArray == null) {
            return false;
        }
        System.out.print(String.format("update:   time: %8.2f ms(incl solve) ", Float.valueOf(f3 + f)));
        Scs_demo.print_resid(true, scs2, fArray3, fArray2, fArray4);
        scsn = null;
        f = Scs_demo.tic();
        scsn = Scs_chol.cs_chol(scs2, scss);
        if (scsn == null) {
            return false;
        }
        Scs_ipvec.cs_ipvec(scss.pinv, fArray2, fArray, n2);
        Scs_lsolve.cs_lsolve(scsn.L, fArray);
        Scs_ltsolve.cs_ltsolve(scsn.L, fArray);
        Scs_pvec.cs_pvec(scss.pinv, fArray, fArray3, n2);
        f = Scs_demo.toc(f);
        System.out.print(String.format("rechol:   time: %8.2f ms(incl solve) ", Float.valueOf(f)));
        Scs_demo.print_resid(true, scs2, fArray3, fArray2, fArray4);
        f = Scs_demo.tic();
        bl = Scs_updown.cs_updown(scsn.L, -1, scs, scss.parent);
        f3 = Scs_demo.toc(f);
        if (!bl) {
            return false;
        }
        System.out.print(String.format("downdate: time: %8.2f\n", Float.valueOf(f3)));
        f = Scs_demo.tic();
        Scs_ipvec.cs_ipvec(scss.pinv, fArray2, fArray, n2);
        Scs_lsolve.cs_lsolve(scsn.L, fArray);
        Scs_ltsolve.cs_ltsolve(scsn.L, fArray);
        Scs_pvec.cs_pvec(scss.pinv, fArray, fArray3, n2);
        f = Scs_demo.toc(f);
        System.out.print(String.format("downdate: time: %8.2f ms(incl solve) ", Float.valueOf(f3 + f)));
        Scs_demo.print_resid(true, scs4, fArray3, fArray2, fArray4);
        return true;
    }

    private static class Dropdiag
    implements Scs_ifkeep {
        private Dropdiag() {
        }

        public boolean fkeep(int n, int n2, float f, Object object) {
            return n != n2;
        }
    }

    public static class Sproblem {
        public Scs_common.Scs A;
        public Scs_common.Scs C;
        public int sym;
        public float[] x;
        public float[] b;
        public float[] resid;
    }
}

