/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.EjmlParameters;
import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.decomposition.qr.BlockMatrix64HouseholderQR;
import org.ejml.alg.dense.decomposition.BaseDecompositionBlock64;
import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class QRDecompositionBlock64
extends BaseDecompositionBlock64
implements QRDecomposition<DenseMatrix64F> {
    public QRDecompositionBlock64() {
        super(new BlockMatrix64HouseholderQR(), EjmlParameters.BLOCK_WIDTH);
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        int n = Math.min(this.Ablock.numRows, this.Ablock.numCols);
        if (denseMatrix64F == null) {
            if (bl) {
                denseMatrix64F = new DenseMatrix64F(this.Ablock.numRows, n);
                CommonOps.setIdentity(denseMatrix64F);
            } else {
                denseMatrix64F = new DenseMatrix64F(this.Ablock.numRows, this.Ablock.numRows);
                CommonOps.setIdentity(denseMatrix64F);
            }
        }
        BlockMatrix64F blockMatrix64F = new BlockMatrix64F();
        blockMatrix64F.numRows = denseMatrix64F.numRows;
        blockMatrix64F.numCols = denseMatrix64F.numCols;
        blockMatrix64F.blockLength = this.blockLength;
        blockMatrix64F.data = denseMatrix64F.data;
        ((BlockMatrix64HouseholderQR)this.alg).getQ(blockMatrix64F, bl);
        this.convertBlockToRow(denseMatrix64F.numRows, denseMatrix64F.numCols, this.Ablock.blockLength, denseMatrix64F.data);
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getR(DenseMatrix64F denseMatrix64F, boolean bl) {
        BlockMatrix64F blockMatrix64F = ((BlockMatrix64HouseholderQR)this.alg).getR((BlockMatrix64F)null, bl);
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(blockMatrix64F.numRows, blockMatrix64F.numCols);
        }
        BlockMatrixOps.convert(blockMatrix64F, denseMatrix64F);
        return denseMatrix64F;
    }
}

