/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class Empirical
extends AbstractContinousDoubleDistribution {
    private static final long serialVersionUID = 1L;
    protected double[] cdf;
    protected int interpolationType;
    public static final int LINEAR_INTERPOLATION = 0;
    public static final int NO_INTERPOLATION = 1;

    public Empirical(double[] pdf, int interpolationType, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(pdf, interpolationType);
    }

    public double cdf(int k) {
        if (k < 0) {
            return 0.0;
        }
        if (k >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[k];
    }

    @Override
    public Object clone() {
        Empirical copy = (Empirical)super.clone();
        if (this.cdf != null) {
            copy.cdf = (double[])this.cdf.clone();
        }
        return copy;
    }

    @Override
    public double nextDouble() {
        double rand = this.randomGenerator.raw();
        if (this.cdf == null) {
            return rand;
        }
        int nBins = this.cdf.length - 1;
        int nbelow = 0;
        int nabove = nBins;
        while (nabove > nbelow + 1) {
            int middle = nabove + nbelow + 1 >> 1;
            if (rand >= this.cdf[middle]) {
                nbelow = middle;
                continue;
            }
            nabove = middle;
        }
        if (this.interpolationType == 1) {
            return (double)nbelow / (double)nBins;
        }
        if (this.interpolationType == 0) {
            double binMeasure = this.cdf[nabove] - this.cdf[nbelow];
            if (binMeasure == 0.0) {
                return ((double)nbelow + 0.5) / (double)nBins;
            }
            double binFraction = (rand - this.cdf[nbelow]) / binMeasure;
            return ((double)nbelow + binFraction) / (double)nBins;
        }
        throw new InternalError();
    }

    public double pdf(double x) {
        throw new RuntimeException("not implemented");
    }

    public double pdf(int k) {
        if (k < 0 || k >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[k - 1] - this.cdf[k];
    }

    public void setState(double[] pdf, int interpolationType) {
        if (interpolationType != 0 && interpolationType != 1) {
            throw new IllegalArgumentException("Illegal Interpolation Type");
        }
        this.interpolationType = interpolationType;
        if (pdf == null || pdf.length == 0) {
            this.cdf = null;
            return;
        }
        int nBins = pdf.length;
        this.cdf = new double[nBins + 1];
        this.cdf[0] = 0.0;
        int ptn = 0;
        while (ptn < nBins) {
            double prob = pdf[ptn];
            if (prob < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[ptn + 1] = this.cdf[ptn] + prob;
            ++ptn;
        }
        if (this.cdf[nBins] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        ptn = 0;
        while (ptn < nBins + 1) {
            int n = ptn++;
            this.cdf[n] = this.cdf[n] / this.cdf[nBins];
        }
    }

    public String toString() {
        String interpolation = null;
        if (this.interpolationType == 1) {
            interpolation = "NO_INTERPOLATION";
        }
        if (this.interpolationType == 0) {
            interpolation = "LINEAR_INTERPOLATION";
        }
        return String.valueOf(this.getClass().getName()) + "(" + (this.cdf != null ? this.cdf.length : 0) + "," + interpolation + ")";
    }

    private int xnBins() {
        return this.cdf.length - 1;
    }
}

