/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PlotCanvas;
import ij.gui.PlotMaker;
import ij.gui.PlotObject;
import ij.gui.PlotWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plot
implements Cloneable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int TOP_LEFT = 144;
    public static final int TOP_RIGHT = 160;
    public static final int BOTTOM_LEFT = 176;
    public static final int BOTTOM_RIGHT = 192;
    public static final int AUTO_POSITION = 128;
    private static final int LEGEND_POSITION_MASK = 240;
    public static final int LEGEND_BOTTOM_UP = 256;
    public static final int LEGEND_TRANSPARENT = 512;
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int DOT = 6;
    public static final int LINE = 2;
    public static final int CONNECTED_CIRCLES = 7;
    public static final int X_NUMBERS = 1;
    public static final int Y_NUMBERS = 2;
    public static final int X_TICKS = 4;
    public static final int Y_TICKS = 8;
    public static final int X_GRID = 16;
    public static final int Y_GRID = 32;
    public static final int X_FORCE2GRID = 64;
    public static final int Y_FORCE2GRID = 128;
    public static final int X_MINOR_TICKS = 256;
    public static final int Y_MINOR_TICKS = 512;
    public static final int X_LOG_NUMBERS = 1024;
    public static final int Y_LOG_NUMBERS = 2048;
    public static final int X_LOG_TICKS = 4096;
    public static final int Y_LOG_TICKS = 8192;
    public static final int DEFAULT_FLAGS = 12339;
    public static final int X_RANGE = 1;
    public static final int Y_RANGE = 2;
    public static final int COPY_SIZE = 16;
    public static final int COPY_LABELS = 32;
    public static final int COPY_LEGEND = 64;
    public static final int LEFT_MARGIN = 60;
    public static final int RIGHT_MARGIN = 20;
    public static final int TOP_MARGIN = 13;
    public static final int BOTTOM_MARGIN = 42;
    public static final int MIN_FRAMEWIDTH = 160;
    public static final int MIN_FRAMEHEIGHT = 90;
    public static final String PROPERTY_KEY = "thePlot";
    private static final int MIN_X_GRIDSPACING = 45;
    private static final int MIN_Y_GRIDSPACING = 30;
    private final double MIN_LOG_RATIO = 3.0;
    private static final int LEGEND_PADDING = 4;
    private static final int LEGEND_LINELENGTH = 20;
    private static final int USUALLY_ENLARGE = 1;
    private static final int ALWAYS_ENLARGE = 2;
    private static final double RELATIVE_ARROWHEAD_SIZE = 0.2;
    private static final int MIN_ARROWHEAD_LENGTH = 3;
    private static final int MAX_ARROWHEAD_LENGTH = 20;
    static final int ZOOM_AS_PREVIOUS = -20202020;
    Rectangle frame = null;
    float scale = 1.0f;
    int leftMargin = 60;
    int rightMargin = 20;
    int topMargin = 13;
    int bottomMargin = 42;
    int frameWidth;
    int frameHeight;
    double xMin = Double.NaN;
    double xMax;
    double yMin;
    double yMax;
    double[] currentMinMax = new double[]{Double.NaN, 0.0, Double.NaN, 0.0};
    double[] defaultMinMax = new double[]{Double.NaN, 0.0, Double.NaN, 0.0};
    double[] savedMinMax = new double[]{Double.NaN, 0.0, Double.NaN, 0.0};
    int[] enlargeRange;
    boolean logXAxis;
    boolean logYAxis;
    Font defaultFont = new Font("Helvetica", 0, PlotWindow.fontSize);
    Font currentFont;
    Font xLabelFont;
    Font yLabelFont;
    String xLabel;
    String yLabel;
    int templateFlags = 112;
    private double xScale;
    private double yScale;
    private int xBasePxl;
    private int yBasePxl;
    private double previousXZoom = Double.NaN;
    private double previousYZoom = Double.NaN;
    private int maxIntervals = 12;
    private int tickLength = 7;
    private int minorTickLength = 3;
    private Color gridColor = new Color(0xC0C0C0);
    private Color frameColor = Color.black;
    private int flags;
    private ImageProcessor ip;
    private ImagePlus imp;
    private boolean frozen;
    private String title;
    private boolean invertedLut;
    private boolean isColor;
    private boolean plotDrawn;
    private boolean antialiasedText = true;
    int plotWidth = PlotWindow.plotWidth;
    int plotHeight = PlotWindow.plotHeight;
    PlotMaker plotMaker;
    Vector<PlotObject> allPlotObjects = new Vector();
    PlotObject legend;
    private Color currentColor;
    private Color currentColor2;
    float currentLineWidth;
    float frameLineWidth;
    private int currentJustification = 0;
    private boolean ignoreForce2Grid;
    static final int MIN_SCIENTIFIC_DIGITS = 4;
    static final double MIN_FLOAT_PRECISION = 1.0E-5;

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, Plot.getDefaultFlags());
    }

    public Plot(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, xValues != null ? Tools.toFloat(xValues) : null, yValues != null ? Tools.toFloat(yValues) : null, Plot.getDefaultFlags());
    }

    public Plot(String dummy, String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        this(title, xLabel, yLabel, xValues, yValues, Plot.getDefaultFlags());
    }

    public Plot(String title, String xLabel, String yLabel) {
        this(title, xLabel, yLabel, (float[])null, (float[])null, Plot.getDefaultFlags());
    }

    public Plot(String title, String xLabel, String yLabel, int flags) {
        this(title, xLabel, yLabel, (float[])null, (float[])null, flags);
    }

    public Plot(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, int flags) {
        this.title = title;
        this.flags = flags;
        this.setXYLabels(xLabel, yLabel);
        if (yValues != null && yValues.length > 0) {
            this.addPoints(xValues, yValues, null, 2, null);
            this.allPlotObjects.get((int)0).flags = 1;
        }
    }

    public Plot(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, int flags) {
        this(title, xLabel, yLabel, xValues != null ? Tools.toFloat(xValues) : null, yValues != null ? Tools.toFloat(yValues) : null, flags);
    }

    public String getTitle() {
        return this.imp == null ? this.title : this.imp.getTitle();
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.defaultMinMax[0] = xMin;
        this.defaultMinMax[1] = xMax;
        this.defaultMinMax[2] = yMin;
        this.defaultMinMax[3] = yMax;
        this.enlargeRange = null;
        this.ignoreForce2Grid = true;
        if (this.plotDrawn) {
            this.setLimitsToDefaults(true);
        }
    }

    public double[] getLimits() {
        return new double[]{this.xMin, this.xMax, this.yMin, this.yMax};
    }

    public void setSize(int width, int height) {
        if (this.ip != null && width == this.ip.getWidth() && height == this.ip.getHeight()) {
            return;
        }
        Dimension minSize = this.getMinimumSize();
        this.plotWidth = Math.max(width, minSize.width) - (this.leftMargin + this.rightMargin);
        this.plotHeight = Math.max(height, minSize.height) - (this.topMargin + this.bottomMargin);
        this.scale = 1.0f;
        this.ip = null;
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public Dimension getSize() {
        if (this.ip == null) {
            this.getBlankProcessor();
        }
        return new Dimension(this.ip.getWidth(), this.ip.getHeight());
    }

    public void setFrameSize(int width, int height) {
        this.plotWidth = width;
        this.plotHeight = height;
        this.ip = null;
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(160 + this.leftMargin + this.rightMargin, 90 + this.topMargin + this.bottomMargin);
    }

    public void useTemplate(Plot plot) {
        this.useTemplate(plot, this.templateFlags);
    }

    public void useTemplate(Plot plot, int templateFlags) {
        if (plot == null) {
            return;
        }
        this.flags = plot.flags;
        this.defaultFont = plot.defaultFont;
        this.currentFont = plot.currentFont;
        this.xLabelFont = plot.xLabelFont;
        this.yLabelFont = plot.yLabelFont;
        this.currentLineWidth = plot.currentLineWidth;
        this.frameLineWidth = plot.frameLineWidth;
        this.currentColor = plot.currentColor;
        this.frameColor = plot.frameColor;
        if ((templateFlags & 0x20) != 0) {
            this.xLabel = plot.xLabel;
            this.yLabel = plot.yLabel;
        }
        if ((templateFlags & 0x40) != 0) {
            // empty if block
        }
        for (int i = 0; i < this.currentMinMax.length; ++i) {
            if ((templateFlags >> i / 2 & 1) == 0) continue;
            this.currentMinMax[i] = plot.currentMinMax[i];
            if (this.plotDrawn) continue;
            this.defaultMinMax[i] = plot.currentMinMax[i];
        }
        if ((templateFlags & 0x40) != 0) {
            if (plot.legend != null) {
                this.legend = plot.legend.clone();
            }
            int plotPObjectIndex = 0;
            int plotPObjectNumber = plot.allPlotObjects.size();
            for (PlotObject plotObject : this.allPlotObjects) {
                if (plotObject.type != 0) continue;
                while (plotPObjectIndex < plotPObjectNumber && plot.allPlotObjects.get((int)plotPObjectIndex).type != 0) {
                    ++plotPObjectIndex;
                }
                if (plotPObjectIndex >= plotPObjectNumber) break;
                plotObject.label = plot.allPlotObjects.get((int)plotPObjectIndex).label;
            }
        }
        this.setFrameSize(plot.plotWidth, plot.plotHeight);
        this.templateFlags = templateFlags;
    }

    public void setScale(float scale) {
        this.scale = scale;
        if (scale > 20.0f) {
            scale = 20.0f;
        }
        if (scale < 0.7f) {
            scale = 0.7f;
        }
        this.plotDrawn = false;
    }

    public void setXYLabels(String xLabel, String yLabel) {
        this.xLabel = xLabel != null && xLabel.length() > 0 ? xLabel : "";
        this.yLabel = yLabel != null && yLabel.length() > 0 ? yLabel : "";
    }

    public void setMaxIntervals(int intervals) {
        this.maxIntervals = intervals;
    }

    public void setTickLength(int tickLength) {
    }

    public void setMinorTickLength(int minorTickLength) {
    }

    public void setFormatFlags(int flags) {
        int unchangedFlags = 3264;
        this.flags = this.flags & unchangedFlags | (flags &= ~unchangedFlags);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setAxisXLog(boolean axisXLog) {
        this.flags = axisXLog ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
    }

    public void setAxisYLog(boolean axisYLog) {
        this.flags = axisYLog ? this.flags | 0x800 : this.flags & 0xFFFFF7FF;
    }

    public void setXTicks(boolean xTicks) {
        this.flags = xTicks ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public void setYTicks(boolean yTicks) {
        this.flags = yTicks ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public void setXMinorTicks(boolean xMinorTicks) {
        int n = this.flags = xMinorTicks ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
        if (xMinorTicks && !this.hasFlag(16)) {
            this.flags |= 4;
        }
    }

    public void setYMinorTicks(boolean yMinorTicks) {
        int n = this.flags = yMinorTicks ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
        if (yMinorTicks && !this.hasFlag(32)) {
            this.flags |= 8;
        }
    }

    public void setAxes(boolean xLog, boolean yLog, boolean xTicks, boolean yTicks, boolean xMinorTicks, boolean yMinorTicks, int tickLenght, int minorTickLenght) {
        this.setAxisXLog(xLog);
        this.setAxisYLog(yLog);
        this.setXMinorTicks(xMinorTicks);
        this.setYMinorTicks(yMinorTicks);
        this.setXTicks(xTicks);
        this.setYTicks(yTicks);
        this.setTickLength(tickLenght);
        this.setMinorTickLength(minorTickLenght);
    }

    public void setLogScaleX() {
        this.setAxisXLog(true);
    }

    public void setLogScaleY() {
        this.setAxisYLog(true);
    }

    public static int getDefaultFlags() {
        int defaultFlags = 0;
        if (!PlotWindow.noGridLines) {
            defaultFlags |= 0x3033;
        }
        if (!PlotWindow.noTicks) {
            defaultFlags |= 0x330F;
        }
        return defaultFlags;
    }

    public void addPoints(float[] xValues, float[] yValues, float[] yErrorBars, int shape, String label) {
        if (xValues == null || xValues.length == 0) {
            xValues = new float[yValues.length];
            for (int i = 0; i < yValues.length; ++i) {
                xValues[i] = i;
            }
        }
        this.allPlotObjects.add(new PlotObject(xValues, yValues, yErrorBars, shape, this.currentLineWidth, this.currentColor, this.currentColor2, label));
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.addPoints(x, y, null, shape, null);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addPoints(String dummy, float[] x, float[] y, int shape) {
        this.addPoints(x, y, shape);
    }

    public void add(String shape, double[] x, double[] y) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), null, Plot.toShape(shape), null);
    }

    public static int toShape(String str) {
        str = str.toLowerCase(Locale.US);
        int shape = 0;
        if (str.contains("curve") || str.contains("line")) {
            shape = 2;
        }
        if (str.contains("connected")) {
            shape = 7;
        } else if (str.contains("box")) {
            shape = 3;
        } else if (str.contains("triangle")) {
            shape = 4;
        } else if (str.contains("cross")) {
            shape = 5;
        } else if (str.contains("dot")) {
            shape = 6;
        } else if (str.contains("xerror")) {
            shape = -2;
        } else if (str.contains("error")) {
            shape = -1;
        } else if (str.contains("x")) {
            shape = 1;
        }
        return shape;
    }

    public void addPoints(ArrayList x, ArrayList y, int shape) {
        this.addPoints(this.getDoubleFromArrayList(x), this.getDoubleFromArrayList(y), shape);
    }

    public void addPoints(double[] x, double[] y, double[] errorBars, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), Tools.toFloat(errorBars), shape, null);
    }

    public void addPoints(ArrayList x, ArrayList y, ArrayList z, int shape) {
        this.addPoints(this.getDoubleFromArrayList(x), this.getDoubleFromArrayList(y), this.getDoubleFromArrayList(z), shape);
    }

    public double[] getDoubleFromArrayList(ArrayList list) {
        double[] targ = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            targ[i] = (Double)list.get(i);
        }
        return targ;
    }

    public void drawVectors(double[] x1, double[] y1, double[] x2, double[] y2) {
        this.allPlotObjects.add(new PlotObject(Tools.toFloat(x1), Tools.toFloat(y1), Tools.toFloat(x2), Tools.toFloat(y2), this.currentLineWidth, this.currentColor));
    }

    public static double calculateDistance(int x1, int y1, int x2, int y2) {
        return Math.sqrt((double)(x2 - x1) * (double)(x2 - x1) + (double)(y2 - y1) * (double)(y2 - y1));
    }

    public void drawVectors(ArrayList x1, ArrayList y1, ArrayList x2, ArrayList y2) {
        this.drawVectors(this.getDoubleFromArrayList(x1), this.getDoubleFromArrayList(y1), this.getDoubleFromArrayList(x2), this.getDoubleFromArrayList(y2));
    }

    public void addErrorBars(float[] errorBars) {
        PlotObject mainObject = this.getLastCurveObject();
        if (mainObject == null) {
            throw new RuntimeException("Plot can't add y error bars without data");
        }
        mainObject.yEValues = errorBars;
    }

    public void addErrorBars(double[] errorBars) {
        this.addErrorBars(Tools.toFloat(errorBars));
    }

    public void addErrorBars(String dummy, float[] errorBars) {
        this.addErrorBars(errorBars);
    }

    public void addHorizontalErrorBars(double[] xErrorBars) {
        PlotObject mainObject = this.getLastCurveObject();
        if (mainObject == null) {
            throw new RuntimeException("Plot can't add x error bars without data");
        }
        mainObject.xEValues = Tools.toFloat(xErrorBars);
    }

    public void addLabel(double x, double y, String label) {
        this.allPlotObjects.add(new PlotObject(label, x, y, this.currentJustification, this.currentFont, this.currentColor, 6));
    }

    public void addText(String label, double x, double y) {
        this.allPlotObjects.add(new PlotObject(label, x, y, this.currentJustification, this.currentFont, this.currentColor, 5));
    }

    public void addLegend(String labels) {
        this.addLegend(labels, null);
    }

    public void addLegend(String labels, String options) {
        int flags = 128;
        if (options != null) {
            if ((options = options.toLowerCase()).contains("top-left")) {
                flags |= 0x90;
            } else if (options.contains("top-right")) {
                flags |= 0xA0;
            } else if (options.contains("bottom-left")) {
                flags |= 0xB0;
            } else if (options.contains("bottom-right")) {
                flags |= 0xC0;
            }
            if (options.contains("bottom-to-top")) {
                flags |= 0x100;
            }
            if (options.contains("transparent")) {
                flags |= 0x200;
            }
        }
        this.setLegend(labels, flags);
    }

    public void setLegend(String labels, int flags) {
        this.legend = new PlotObject(labels, this.currentLineWidth == 0.0f ? 1.0f : this.currentLineWidth, this.currentFont == null ? this.defaultFont : this.currentFont, this.currentColor == null ? Color.black : this.currentColor, flags);
        if (this.plotDrawn) {
            this.updateImage();
        }
    }

    public void setJustification(int justification) {
        this.currentJustification = justification;
    }

    public void setColor(Color c) {
        this.currentColor = c;
        if (c.getRed() != c.getGreen() || c.getGreen() != c.getBlue()) {
            this.isColor = true;
        }
        this.currentColor2 = null;
    }

    public void setColor(String color) {
        this.setColor(Colors.getColor(color, Color.black));
    }

    public void setColor(Color c, Color c2) {
        this.currentColor = c;
        this.currentColor2 = c2;
        if (c.getRed() != c.getGreen() || c.getGreen() != c.getBlue() || c2 != null && (c2.getRed() != c2.getGreen() || c2.getGreen() != c2.getBlue())) {
            this.isColor = true;
        }
    }

    public void setColor(String c1, String c2) {
        this.setColor(Colors.getColor(c1, Color.black), Colors.getColor(c2, Color.black));
    }

    public void setLineWidth(int lineWidth) {
        this.currentLineWidth = lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.currentLineWidth = lineWidth;
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.allPlotObjects.add(new PlotObject(x1, y1, x2, y2, this.currentLineWidth, 0, this.currentColor, 2));
    }

    public void drawNormalizedLine(double x1, double y1, double x2, double y2) {
        this.allPlotObjects.add(new PlotObject(x1, y1, x2, y2, this.currentLineWidth, 0, this.currentColor, 3));
    }

    public void drawDottedLine(double x1, double y1, double x2, double y2, int step) {
        this.allPlotObjects.add(new PlotObject(x1, y1, x2, y2, this.currentLineWidth, step, this.currentColor, 4));
    }

    public void setFont(Font font) {
        this.currentFont = font;
    }

    public void setFont(int style, float size) {
        Font previousFont;
        if (size < 9.0f) {
            size = 9.0f;
        }
        if (size > 24.0f) {
            size = 24.0f;
        }
        Font font = previousFont = this.currentFont == null ? this.defaultFont : this.currentFont;
        if (style < 0) {
            style = previousFont.getStyle();
        }
        this.setFont(previousFont.deriveFont(size));
    }

    public void setAxisLabelFont(int style, float size) {
        Font usualFont;
        if (size < 9.0f) {
            size = 9.0f;
        }
        if (size > 33.0f) {
            size = 33.0f;
        }
        Font font = usualFont = this.currentFont == null ? this.defaultFont : this.currentFont;
        if (this.xLabelFont == null) {
            this.xLabelFont = usualFont;
        }
        if (this.yLabelFont == null) {
            this.yLabelFont = usualFont;
        }
        this.setXLabelFont(this.xLabelFont.deriveFont(style < 0 ? this.xLabelFont.getStyle() : style, size));
        this.setYLabelFont(this.xLabelFont.deriveFont(style < 0 ? this.yLabelFont.getStyle() : style, size));
    }

    public void setXLabelFont(Font font) {
        this.xLabelFont = font;
    }

    public void setYLabelFont(Font font) {
        this.yLabelFont = font;
    }

    public void setAntialiasedText(boolean antialiasedText) {
        this.antialiasedText = antialiasedText;
    }

    public void changeFont(Font font) {
        this.setFont(font);
    }

    public float[] getXValues() {
        PlotObject p = this.getMainCurveObject();
        return p == null ? null : p.xValues;
    }

    public float[] getYValues() {
        PlotObject p = this.getMainCurveObject();
        return p == null ? null : p.yValues;
    }

    public void setLimitsToDefaults(boolean updateImg) {
        this.saveMinMax();
        System.arraycopy(this.defaultMinMax, 0, this.currentMinMax, 0, this.defaultMinMax.length);
        if (this.plotDrawn && updateImg) {
            this.updateImage();
        }
    }

    public void setLimitsToFit(boolean updateImg) {
        this.saveMinMax();
        this.currentMinMax = this.getMinAndMax(true, 255);
        if (Double.isNaN(this.defaultMinMax[0])) {
            System.arraycopy(this.currentMinMax, 0, this.defaultMinMax, 0, this.currentMinMax.length);
        }
        if (this.plotDrawn && updateImg) {
            this.updateImage();
        }
    }

    public void setPreviousMinMax() {
        if (Double.isNaN(this.savedMinMax[0])) {
            return;
        }
        double[] swap = new double[this.currentMinMax.length];
        System.arraycopy(this.currentMinMax, 0, swap, 0, this.currentMinMax.length);
        System.arraycopy(this.savedMinMax, 0, this.currentMinMax, 0, this.currentMinMax.length);
        System.arraycopy(swap, 0, this.savedMinMax, 0, this.currentMinMax.length);
        this.updateImage();
    }

    public ImageProcessor getProcessor() {
        this.draw();
        return this.ip;
    }

    public ImagePlus getImagePlus() {
        if (this.plotDrawn) {
            this.updateImage();
        } else {
            this.draw();
        }
        if (this.imp != null) {
            if (this.imp.getProcessor() != this.ip) {
                this.imp.setProcessor(this.ip);
            }
            return this.imp;
        }
        ImagePlus imp = new ImagePlus(this.title, this.ip);
        imp.setIgnoreGlobalCalibration(true);
        Calibration cal = imp.getCalibration();
        this.adjustCalibration(cal);
        if (this.imp == null) {
            this.imp = imp;
        }
        imp.setProperty(PROPERTY_KEY, this);
        return imp;
    }

    public void setImagePlus(ImagePlus imp) {
        if (this.imp != null) {
            this.imp.setProperty(PROPERTY_KEY, null);
        }
        this.imp = imp;
        if (imp != null) {
            imp.setIgnoreGlobalCalibration(true);
            this.adjustCalibration(imp.getCalibration());
            imp.setProperty(PROPERTY_KEY, this);
        }
    }

    public void adjustCalibration(Calibration cal) {
        if (this.xMin == this.xMax) {
            this.xScale = 1000000.0;
        }
        if (this.yMin == this.yMax) {
            this.yScale = 1000000.0;
        }
        cal.xOrigin = (double)this.xBasePxl - this.xMin * this.xScale;
        cal.pixelWidth = 1.0 / Math.abs(this.xScale);
        cal.yOrigin = (double)this.yBasePxl + this.yMin * this.yScale;
        cal.pixelHeight = 1.0 / Math.abs(this.yScale);
        cal.setInvertY(this.yScale >= 0.0);
        if (this.xMin == this.xMax) {
            this.xScale = Double.POSITIVE_INFINITY;
        }
        if (this.yMin == this.yMax) {
            this.yScale = Double.POSITIVE_INFINITY;
        }
    }

    public PlotWindow show() {
        ImageWindow win;
        if (IJ.macroRunning() && IJ.getInstance() == null || Interpreter.isBatchMode()) {
            this.imp = this.getImagePlus();
            WindowManager.setTempCurrentImage(this.imp);
            if (this.getMainCurveObject() != null) {
                this.imp.setProperty("XValues", this.getXValues());
                this.imp.setProperty("YValues", this.getYValues());
            }
            Interpreter.addBatchModeImage(this.imp);
            return null;
        }
        if (this.imp != null && (win = this.imp.getWindow()) instanceof PlotWindow && win.isVisible()) {
            this.updateImage();
            return (PlotWindow)win;
        }
        PlotWindow pw = new PlotWindow(this);
        if (this.imp == null) {
            this.imp.setProperty(PROPERTY_KEY, null);
        }
        this.imp = pw.getImagePlus();
        this.imp.setProperty(PROPERTY_KEY, this);
        if (IJ.isMacro() && this.imp != null) {
            IJ.selectWindow(this.imp.getID());
        }
        return pw;
    }

    public void draw() {
        if (this.plotDrawn) {
            return;
        }
        this.getInitialMinAndMax();
        this.getBlankProcessor();
        this.drawContents(this.ip);
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        if (!frozen) {
            ImageCanvas ic;
            if (this.imp != null && this.ip != null && (ic = this.imp.getCanvas()) instanceof PlotCanvas) {
                ((PlotCanvas)ic).resetMagnification();
            }
            this.updateImage();
            ImageWindow win = this.imp.getWindow();
            if (win != null) {
                win.updateImage(this.imp);
            }
        }
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void updateImage() {
        if (!this.plotDrawn || this.frozen) {
            return;
        }
        this.getBlankProcessor();
        this.drawContents(this.ip);
        if (this.imp == null) {
            return;
        }
        this.adjustCalibration(this.imp.getCalibration());
        this.imp.updateAndDraw();
    }

    public Rectangle getDrawingFrame() {
        if (this.frame == null) {
            this.getBlankProcessor();
        }
        return new Rectangle(this.frame.x, this.frame.y, this.frameWidth, this.frameHeight);
    }

    public ImagePlus makeHighResolution(String title, float scale, boolean antialiasedText, boolean showIt) {
        Plot hiresPlot = null;
        try {
            hiresPlot = (Plot)this.clone();
        }
        catch (Exception e) {
            return null;
        }
        hiresPlot.ip = null;
        hiresPlot.imp = null;
        if (!this.plotDrawn) {
            hiresPlot.getInitialMinAndMax();
        }
        hiresPlot.setScale(scale);
        hiresPlot.setAntialiasedText(antialiasedText);
        hiresPlot.defaultMinMax = (double[])this.currentMinMax.clone();
        ImageProcessor hiresIp = hiresPlot.getProcessor();
        if (title == null || title.length() == 0) {
            title = this.getTitle() + "_HiRes";
        }
        title = WindowManager.makeUniqueName(title);
        ImagePlus hiresImp = new ImagePlus(title, hiresIp);
        Calibration cal = hiresImp.getCalibration();
        hiresPlot.adjustCalibration(cal);
        if (showIt) {
            hiresImp.setIgnoreGlobalCalibration(true);
            hiresImp.show();
        }
        hiresPlot.dispose();
        return hiresImp;
    }

    public void dispose() {
        if (this.imp != null) {
            this.imp.setProperty(PROPERTY_KEY, null);
        }
        this.imp = null;
        this.ip = null;
    }

    public double descaleX(int x) {
        if (this.xMin == this.xMax) {
            return this.xMin;
        }
        double xv = (double)(x - this.xBasePxl) / this.xScale + this.xMin;
        if (this.logXAxis) {
            xv = Math.pow(10.0, xv);
        }
        return xv;
    }

    public double descaleY(int y) {
        if (this.yMin == this.yMax) {
            return this.yMin;
        }
        double yv = (double)(this.yBasePxl - y) / this.yScale + this.yMin;
        if (this.logYAxis) {
            yv = Math.pow(10.0, yv);
        }
        return yv;
    }

    public double scaleXtoPxl(double x) {
        if (this.xMin == this.xMax) {
            if (x == this.xMin) {
                return this.xBasePxl;
            }
            return x > this.xMin ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (this.logXAxis) {
            return (double)this.xBasePxl + (Math.log10(x) - this.xMin) * this.xScale;
        }
        return (double)this.xBasePxl + (x - this.xMin) * this.xScale;
    }

    public double scaleYtoPxl(double y) {
        if (this.yMin == this.yMax) {
            if (y == this.xMin) {
                return this.yBasePxl;
            }
            return y > this.yMin ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (this.logYAxis) {
            return (double)this.yBasePxl - (Math.log10(y) - this.yMin) * this.yScale;
        }
        return (double)this.yBasePxl - (y - this.yMin) * this.yScale;
    }

    private int scaleX(double x) {
        if (this.xMin == this.xMax) {
            if (x == this.xMin) {
                return this.xBasePxl;
            }
            return x > this.xMin ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        if (this.logXAxis) {
            return this.xBasePxl + (int)Math.round((Math.log10(x) - this.xMin) * this.xScale);
        }
        return this.xBasePxl + (int)Math.round((x - this.xMin) * this.xScale);
    }

    private int scaleY(double y) {
        if (this.yMin == this.yMax) {
            if (y == this.yMin) {
                return this.yBasePxl;
            }
            return y > this.yMin ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        }
        if (this.logYAxis) {
            return this.yBasePxl - (int)Math.round((Math.log10(y) - this.yMin) * this.yScale);
        }
        return this.yBasePxl - (int)Math.round((y - this.yMin) * this.yScale);
    }

    private int scaleXWithOverflow(double x) {
        if (!this.logXAxis || x > 0.0) {
            return this.scaleX(x);
        }
        return this.xScale > 0.0 ? -1 : this.ip.getWidth();
    }

    private int scaleYWithOverflow(double y) {
        if (!this.logYAxis || y > 0.0) {
            return this.scaleY(y);
        }
        return this.yScale > 0.0 ? this.ip.getHeight() : -1;
    }

    int sc(float length) {
        int pixels = (int)((double)(length * this.scale) + 0.5);
        if (pixels < 1) {
            pixels = 1;
        }
        return pixels;
    }

    Font scFont(Font font) {
        float size = font.getSize2D();
        return this.scale == 1.0f ? font : font.deriveFont(size * this.scale);
    }

    void drawContents(ImageProcessor ip) {
        this.makeRangeGetSteps();
        ip.setColor(Color.black);
        ip.setLineWidth(this.sc(1.0f));
        float lineWidth = 1.0f;
        Color color = Color.black;
        Font font = this.defaultFont;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.hasFlag(1)) continue;
            if (plotObject.lineWidth > 0.0f) {
                lineWidth = plotObject.lineWidth;
            } else {
                plotObject.lineWidth = lineWidth;
            }
            if (plotObject.color != null) {
                color = plotObject.color;
            } else {
                plotObject.color = color;
            }
            if (plotObject.font != null) {
                font = plotObject.font;
            } else {
                plotObject.font = font;
            }
            this.drawPlotObject(plotObject, ip);
        }
        if (this.allPlotObjects.size() > 0 && this.allPlotObjects.get(0).hasFlag(1)) {
            PlotObject mainPlotObject = this.allPlotObjects.get(0);
            if (mainPlotObject.lineWidth == 0.0f) {
                mainPlotObject.lineWidth = this.currentLineWidth == 0.0f ? 1.0f : this.currentLineWidth;
            }
            lineWidth = mainPlotObject.lineWidth;
            if (mainPlotObject.color == null) {
                mainPlotObject.color = this.currentColor == null ? Color.black : this.currentColor;
            }
            this.drawPlotObject(mainPlotObject, ip);
        } else if (this.currentLineWidth > 0.0f) {
            lineWidth = this.currentLineWidth;
        }
        this.frameLineWidth = lineWidth;
        if (this.frameLineWidth == 0.0f) {
            this.frameLineWidth = 1.0f;
        }
        if (this.frameLineWidth > 3.0f) {
            this.frameLineWidth = 3.0f;
        }
        ip.setLineWidth(this.sc(this.frameLineWidth));
        ip.setColor(this.frameColor);
        int x2 = this.frame.x + this.frame.width - 1;
        int y2 = this.frame.y + this.frame.height - 1;
        ip.moveTo(this.frame.x, this.frame.y);
        ip.lineTo(x2, this.frame.y);
        ip.lineTo(x2, y2);
        ip.lineTo(this.frame.x, y2);
        ip.lineTo(this.frame.x, this.frame.y);
        if (this.legend != null && (this.legend.flags & 0xF0) != 0) {
            this.drawPlotObject(this.legend, ip);
        }
        this.plotDrawn = true;
    }

    ImageProcessor getBlankProcessor() {
        float marginScale = 0.2f + 0.8f * (this.currentFont == null ? this.defaultFont : this.currentFont).getSize2D() / 12.0f;
        if (marginScale < 0.7f) {
            marginScale = 0.7f;
        }
        if (marginScale > 2.0f) {
            marginScale = 2.0f;
        }
        this.leftMargin = this.sc(60.0f * marginScale);
        this.rightMargin = this.sc(20.0f * marginScale);
        this.topMargin = this.sc(13.0f * marginScale);
        this.bottomMargin = this.sc(42.0f * marginScale);
        this.frameWidth = this.sc(this.plotWidth);
        this.frameHeight = this.sc(this.plotHeight);
        int width = this.frameWidth + this.leftMargin + this.rightMargin;
        int height = this.frameHeight + this.topMargin + this.bottomMargin;
        if (this.ip == null || width != this.ip.getWidth() || height != this.ip.getHeight() || this.isColor && this.ip instanceof ByteProcessor) {
            if (this.isColor) {
                this.ip = new ColorProcessor(width, height);
            } else {
                this.ip = new ByteProcessor(width, height);
                boolean bl = this.invertedLut = Prefs.useInvertingLut && !Interpreter.isBatchMode() && IJ.getInstance() != null;
                if (this.invertedLut) {
                    this.ip.invertLut();
                }
            }
            if (this.imp != null) {
                this.imp.setProcessor(this.ip);
            }
        }
        if (this.ip instanceof ColorProcessor) {
            Arrays.fill((int[])this.ip.getPixels(), 0xFFFFFF);
        } else {
            Arrays.fill((byte[])this.ip.getPixels(), this.invertedLut ? (byte)0 : -1);
        }
        this.ip.setColor(Color.black);
        this.ip.setFont(this.scFont(this.defaultFont));
        this.ip.setLineWidth(this.sc(1.0f));
        this.ip.setAntialiasedText(this.antialiasedText);
        this.frame = new Rectangle(this.leftMargin, this.topMargin, this.frameWidth + 1, this.frameHeight + 1);
        return this.ip;
    }

    double[] makeRangeGetSteps() {
        double[] steps = new double[2];
        this.logXAxis = this.hasFlag(1024);
        this.logYAxis = this.hasFlag(2048);
        for (int i = 0; i < this.currentMinMax.length; i += 2) {
            double rangeRatio;
            boolean logAxis = this.hasFlag(i == 0 ? 1024 : 2048);
            double range = this.currentMinMax[i + 1] - this.currentMinMax[i];
            double mid = 0.5 * (this.currentMinMax[i + 1] + this.currentMinMax[i]);
            double relativeRange = Math.abs(range / mid);
            if (!logAxis) {
                relativeRange = Math.min(relativeRange, Math.abs(range / (this.defaultMinMax[i + 1] - this.defaultMinMax[i])));
            }
            if (range != 0.0 && relativeRange < 1.0E-4) {
                this.currentMinMax[i + 1] = mid + 0.5 * range * 1.0E-4 / relativeRange;
                this.currentMinMax[i] = mid - 0.5 * range * 1.0E-4 / relativeRange;
            }
            if (!(!logAxis || ((rangeRatio = this.currentMinMax[i + 1] / this.currentMinMax[i]) > 3.0 || 1.0 / rangeRatio > 3.0) && this.currentMinMax[i] > (double)1.4E-44f && this.currentMinMax[i + 1] > (double)1.4E-44f)) {
                logAxis = false;
            }
            if (logAxis) {
                this.currentMinMax[i] = Math.log10(this.currentMinMax[i]);
                this.currentMinMax[i + 1] = Math.log10(this.currentMinMax[i + 1]);
            }
            if (i == 0 && !this.simpleXAxis() || i == 2 && !this.simpleYAxis()) {
                boolean force2grid;
                int minGridspacing = i == 0 ? 45 : 30;
                int frameSize = i == 0 ? this.frameWidth : this.frameHeight;
                double step = Math.abs((this.currentMinMax[i + 1] - this.currentMinMax[i]) * Math.max(1.0 / (double)this.maxIntervals, (double)((float)this.sc(minGridspacing) / (float)frameSize) + 0.06));
                step = this.niceNumber(step);
                if (logAxis && step < 1.0) {
                    step = 1.0;
                }
                steps[i / 2] = step;
                boolean bl = force2grid = this.hasFlag(i == 0 ? 64 : 128) && !this.ignoreForce2Grid;
                if (force2grid) {
                    int i1 = (int)Math.floor(Math.min(this.currentMinMax[i], this.currentMinMax[i + 1]) / step + 1.0E-10);
                    int i2 = (int)Math.ceil(Math.max(this.currentMinMax[i], this.currentMinMax[i + 1]) / step - 1.0E-10);
                    if (this.currentMinMax[i + 1] > this.currentMinMax[i]) {
                        this.currentMinMax[i] = (double)i1 * step;
                        this.currentMinMax[i + 1] = (double)i2 * step;
                    } else {
                        this.currentMinMax[i] = (double)i2 * step;
                        this.currentMinMax[i + 1] = (double)i1 * step;
                    }
                } else if (this.enlargeRange != null) {
                    range = this.currentMinMax[i + 1] - this.currentMinMax[i];
                    double tmpMin = this.currentMinMax[i] - 0.015 * range;
                    if (this.enlargeRange[i] == 1) {
                        this.currentMinMax[i] = tmpMin * this.currentMinMax[i] <= 0.0 ? 0.0 : tmpMin;
                    } else if (this.enlargeRange[i] == 2) {
                        this.currentMinMax[i] = tmpMin;
                    }
                    double tmpMax = this.currentMinMax[i + 1] + 0.015 * range;
                    if (this.enlargeRange[i + 1] == 1) {
                        this.currentMinMax[i + 1] = tmpMax * this.currentMinMax[i + 1] <= 0.0 ? 0.0 : tmpMax;
                    } else if (this.enlargeRange[i + 1] == 2) {
                        this.currentMinMax[i + 1] = tmpMax;
                    }
                }
            }
            if (i == 0) {
                this.xMin = this.currentMinMax[i];
                this.xMax = this.currentMinMax[i + 1];
                this.logXAxis = logAxis;
            } else {
                this.yMin = this.currentMinMax[i];
                this.yMax = this.currentMinMax[i + 1];
                this.logYAxis = logAxis;
            }
            if (!logAxis) continue;
            this.currentMinMax[i] = Math.pow(10.0, this.currentMinMax[i]);
            this.currentMinMax[i + 1] = Math.pow(10.0, this.currentMinMax[i + 1]);
        }
        this.enlargeRange = null;
        this.ignoreForce2Grid = false;
        this.xBasePxl = this.leftMargin;
        this.yBasePxl = this.topMargin + this.frameHeight;
        this.xScale = (double)this.frameWidth / (this.xMax - this.xMin);
        if (this.xMax - this.xMin == 0.0) {
            this.xBasePxl += this.sc(10.0f);
        }
        this.yScale = (double)this.frameHeight / (this.yMax - this.yMin);
        if (this.yMax - this.yMin == 0.0) {
            this.yBasePxl -= this.sc(10.0f);
        }
        this.drawAxesTicksGridNumbers(steps);
        return steps;
    }

    void getInitialMinAndMax() {
        int axisFlags = 0;
        if (Double.isNaN(this.defaultMinMax[0])) {
            axisFlags |= 1;
        }
        if (Double.isNaN(this.defaultMinMax[2])) {
            axisFlags |= 2;
        }
        if (axisFlags != 0) {
            this.defaultMinMax = this.getMinAndMax(false, axisFlags);
        }
        this.setLimitsToDefaults(false);
    }

    double[] getMinAndMax(boolean allObjects, int axisFlags) {
        double[] allMinMax = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        for (int i = 0; i < allMinMax.length; ++i) {
            if ((axisFlags >> i / 2 & 1) != 0) continue;
            allMinMax[i] = this.defaultMinMax[i];
        }
        this.enlargeRange = new int[allMinMax.length];
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 0 && plotObject.type != 1) continue;
            this.getMinAndMax(allMinMax, this.enlargeRange, plotObject, axisFlags);
            if (allObjects) continue;
            break;
        }
        return allMinMax;
    }

    void getMinAndMax(double[] allMinAndMax, int[] enlargeRange, PlotObject plotObject, int axisFlags) {
        if (plotObject.type == 0) {
            int suggestedEnlarge;
            if ((axisFlags & 1) != 0) {
                suggestedEnlarge = 0;
                if (plotObject.shape == 6 || plotObject.yEValues != null) {
                    suggestedEnlarge = 2;
                } else if (plotObject.shape != 2) {
                    suggestedEnlarge = 1;
                }
                this.getMinAndMax(allMinAndMax, enlargeRange, suggestedEnlarge, 0, plotObject.xValues, plotObject.xEValues);
            }
            if ((axisFlags & 2) != 0) {
                suggestedEnlarge = 0;
                if (plotObject.shape == 6 || plotObject.xEValues != null) {
                    suggestedEnlarge = 2;
                } else if (plotObject.shape != 2) {
                    suggestedEnlarge = 1;
                }
                this.getMinAndMax(allMinAndMax, enlargeRange, suggestedEnlarge, 2, plotObject.yValues, plotObject.yEValues);
            }
        } else if (plotObject.type == 1) {
            if ((axisFlags & 1) != 0) {
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 0, plotObject.xValues, null);
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 0, plotObject.xEValues, null);
            }
            if ((axisFlags & 2) != 0) {
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 2, plotObject.yValues, null);
                this.getMinAndMax(allMinAndMax, enlargeRange, 2, 2, plotObject.yEValues, null);
            }
        }
    }

    void getMinAndMax(double[] allMinAndMax, int[] enlargeRange, int suggestedEnlarge, int axisIndex, float[] data, float[] errorBars) {
        int nMinEqual = 0;
        int nMaxEqual = 0;
        for (int i = 0; i < data.length; ++i) {
            double v1 = data[i];
            double v2 = data[i];
            if (errorBars != null && i < errorBars.length) {
                v1 -= (double)errorBars[i];
                v2 += (double)errorBars[i];
            }
            if (v1 < allMinAndMax[axisIndex]) {
                allMinAndMax[axisIndex] = v1;
                nMinEqual = 1;
                enlargeRange[axisIndex] = suggestedEnlarge;
                if (suggestedEnlarge == 0 && i > 0 && i < data.length - 1) {
                    enlargeRange[axisIndex] = 1;
                }
            } else if (v1 == allMinAndMax[axisIndex]) {
                ++nMinEqual;
            }
            if (v2 > allMinAndMax[axisIndex + 1]) {
                allMinAndMax[axisIndex + 1] = v2;
                nMaxEqual = 1;
                enlargeRange[axisIndex + 1] = suggestedEnlarge;
                if (suggestedEnlarge != 0 || i <= 0 || i >= data.length - 1) continue;
                enlargeRange[axisIndex + 1] = 1;
                continue;
            }
            if (v2 != allMinAndMax[axisIndex + 1]) continue;
            ++nMaxEqual;
        }
        if (enlargeRange[axisIndex] == 0 && nMinEqual > 2 && nMinEqual * 10 > data.length) {
            enlargeRange[axisIndex] = 1;
        }
        if (enlargeRange[axisIndex + 1] == 0 && nMaxEqual > 2 && nMaxEqual * 10 > data.length) {
            enlargeRange[axisIndex + 1] = 1;
        }
        if (nMinEqual == data.length) {
            enlargeRange[axisIndex] = 2;
        }
        if (nMaxEqual == data.length) {
            enlargeRange[axisIndex + 1] = 2;
        }
        if (nMinEqual > 0 && enlargeRange[axisIndex] < suggestedEnlarge) {
            enlargeRange[axisIndex] = suggestedEnlarge;
        }
        if (nMaxEqual > 0 && enlargeRange[axisIndex + 1] < suggestedEnlarge) {
            enlargeRange[axisIndex + 1] = suggestedEnlarge;
        }
    }

    void saveMinMax() {
        System.arraycopy(this.currentMinMax, 0, this.savedMinMax, 0, this.currentMinMax.length);
    }

    void zoomToRect(Rectangle r) {
        this.saveMinMax();
        this.currentMinMax[0] = this.descaleX(r.x);
        this.currentMinMax[1] = this.descaleX(r.x + r.width);
        this.currentMinMax[2] = this.descaleY(r.y + r.height);
        this.currentMinMax[3] = this.descaleY(r.y);
        this.updateImage();
    }

    void zoomOnRangeArrow(int arrowIndex) {
        boolean logAxis;
        int axisIndex = arrowIndex / 4 * 2;
        double min = axisIndex == 0 ? this.xMin : this.yMin;
        double max = axisIndex == 0 ? this.xMax : this.yMax;
        double range = max - min;
        boolean isMin = arrowIndex % 4 < 2;
        boolean shrinkRange = arrowIndex % 4 == 1 || arrowIndex % 4 == 2;
        double factor = Math.sqrt(2.0);
        if (shrinkRange) {
            factor = 1.0 / factor;
        }
        if (isMin) {
            min = max - range * factor;
        } else {
            max = min + range * factor;
        }
        boolean bl = logAxis = axisIndex == 0 ? this.logXAxis : this.logYAxis;
        if (logAxis) {
            min = Math.pow(10.0, min);
            max = Math.pow(10.0, max);
        }
        this.currentMinMax[axisIndex] = min;
        this.currentMinMax[axisIndex + 1] = max;
        this.updateImage();
    }

    void zoom(int x, int y, double zoomFactor) {
        boolean zoomY;
        boolean zoomAsPrevious;
        boolean zoomIn = zoomFactor > 1.0;
        boolean bl = zoomAsPrevious = x == -20202020 && (!Double.isNaN(this.previousXZoom) || !Double.isNaN(this.previousYZoom));
        if (!zoomAsPrevious) {
            this.previousXZoom = Double.NaN;
            this.previousYZoom = Double.NaN;
            this.saveMinMax();
        }
        boolean cursorLeft = x >= 0 && x < this.leftMargin - 1;
        boolean cursorBottom = y > this.topMargin + this.frameHeight + 1;
        boolean zoomX = !cursorLeft && !zoomAsPrevious || !Double.isNaN(this.previousXZoom) && zoomAsPrevious;
        boolean bl2 = zoomY = cursorLeft || !cursorBottom || !Double.isNaN(this.previousYZoom) && zoomAsPrevious;
        if (cursorLeft && cursorBottom) {
            x = -1;
        }
        for (int axisIndex = 0; axisIndex < this.currentMinMax.length; axisIndex += 2) {
            if (axisIndex == 0 && !zoomX || axisIndex == 2 && !zoomY) continue;
            boolean logAxis = axisIndex == 0 ? this.logXAxis : this.logYAxis;
            double min = axisIndex == 0 ? this.xMin : this.yMin;
            double max = axisIndex == 0 ? this.xMax : this.yMax;
            double mid = 0.5 * (min + max);
            if (zoomAsPrevious) {
                double d = mid = axisIndex == 0 ? this.previousXZoom : this.previousYZoom;
                if (logAxis) {
                    mid = Math.log10(mid);
                }
            }
            double span = max - min;
            if (x >= 0) {
                double d = mid = axisIndex == 0 ? this.descaleX(x) : this.descaleY(y);
                if (logAxis) {
                    mid = Math.log10(mid);
                }
            }
            if (axisIndex == 0) {
                this.previousXZoom = logAxis ? Math.pow(10.0, mid) : mid;
            } else {
                this.previousYZoom = logAxis ? Math.pow(10.0, mid) : mid;
            }
            double newHalfSpan = 0.5 * span / zoomFactor;
            this.currentMinMax[axisIndex] = mid - newHalfSpan;
            this.currentMinMax[axisIndex + 1] = mid + newHalfSpan;
            if (!logAxis) continue;
            this.currentMinMax[axisIndex] = Math.pow(10.0, this.currentMinMax[axisIndex]);
            this.currentMinMax[axisIndex + 1] = Math.pow(10.0, this.currentMinMax[axisIndex + 1]);
        }
        this.updateImage();
    }

    void scroll(int dx, int dy) {
        if (this.logXAxis) {
            this.currentMinMax[0] = this.currentMinMax[0] / Math.pow(10.0, (double)dx / this.xScale);
            this.currentMinMax[1] = this.currentMinMax[1] / Math.pow(10.0, (double)dx / this.xScale);
        } else {
            this.currentMinMax[0] = this.currentMinMax[0] - (double)dx / this.xScale;
            this.currentMinMax[1] = this.currentMinMax[1] - (double)dx / this.xScale;
        }
        if (this.logYAxis) {
            this.currentMinMax[2] = this.currentMinMax[2] * Math.pow(10.0, (double)dy / this.yScale);
            this.currentMinMax[3] = this.currentMinMax[3] * Math.pow(10.0, (double)dy / this.yScale);
        } else {
            this.currentMinMax[2] = this.currentMinMax[2] + (double)dy / this.yScale;
            this.currentMinMax[3] = this.currentMinMax[3] + (double)dy / this.yScale;
        }
        this.updateImage();
    }

    private boolean simpleXAxis() {
        return !this.hasFlag(4373);
    }

    private boolean simpleYAxis() {
        return !this.hasFlag(8746);
    }

    void drawAxesTicksGridNumbers(double[] steps) {
        int i;
        Font scFont = this.scFont(this.currentFont == null ? this.defaultFont : this.currentFont);
        Font scFontMedium = scFont.deriveFont(scFont.getSize2D() * 10.0f / 12.0f);
        Font scFontSmall = scFont.deriveFont(scFont.getSize2D() * 9.0f / 12.0f);
        int extraWidth = scFont.getSize() / 3;
        this.ip.setFont(scFont);
        FontMetrics fm = this.ip.getFontMetrics();
        int fontAscent = fm.getAscent();
        this.ip.setJustification(0);
        int yOfXAxisNumbers = this.topMargin + this.frameHeight + fm.getHeight() * 5 / 4 + this.sc(3.0f);
        if (this.hasFlag(1 | (this.logXAxis ? 260 : 4096) + 16)) {
            Font baseFont = scFont;
            boolean majorTicks = this.logXAxis ? this.hasFlag(4096) : this.hasFlag(4);
            boolean minorTicks = this.hasFlag(256);
            double step = steps[0];
            int i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
            int i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
            int digits = Plot.getDigits(this.xMin, this.xMax, step, 7);
            int y1 = this.topMargin;
            int y2 = this.topMargin + this.frameHeight;
            if (this.xMin == this.xMax) {
                if (this.hasFlag(1)) {
                    String s = IJ.d2s(this.xMin, Plot.getDigits(this.xMin, 0.001 * this.xMin, 5));
                    int y = this.yBasePxl;
                    this.ip.drawString(s, this.xBasePxl - this.ip.getStringWidth(s) / 2, yOfXAxisNumbers);
                }
            } else {
                boolean haveMinorLogNumbers;
                int w2;
                int w1;
                int wMax;
                if (this.hasFlag(1) && (double)(wMax = Math.max(w1 = this.ip.getStringWidth(IJ.d2s(this.currentMinMax[0], this.logXAxis ? -1 : digits)), w2 = this.ip.getStringWidth(IJ.d2s(this.currentMinMax[1], this.logXAxis ? -1 : digits)))) > Math.abs(step * this.xScale) - (double)this.sc(8.0f)) {
                    baseFont = scFontMedium;
                    this.ip.setFont(baseFont);
                }
                for (int i3 = 0; i3 <= i2 - i1; ++i3) {
                    double v = (double)(i3 + i1) * step;
                    int x = (int)Math.round((v - this.xMin) * this.xScale) + this.leftMargin;
                    if (this.hasFlag(16)) {
                        this.ip.setColor(this.gridColor);
                        this.ip.drawLine(x, y1, x, y2);
                        this.ip.setColor(Color.black);
                    }
                    if (majorTicks) {
                        this.ip.drawLine(x, y1, x, y1 + this.sc(this.tickLength));
                        this.ip.drawLine(x, y2, x, y2 - this.sc(this.tickLength));
                    }
                    if (!this.hasFlag(1)) continue;
                    if (this.logXAxis || digits < 0) {
                        this.drawExpString(this.logXAxis ? Math.pow(10.0, v) : v, this.logXAxis ? -1 : -digits, x, yOfXAxisNumbers - fontAscent / 2, 1, fontAscent, baseFont, scFontSmall);
                        continue;
                    }
                    String s = IJ.d2s(v, digits);
                    this.ip.drawString(s, x - this.ip.getStringWidth(s) / 2, yOfXAxisNumbers);
                }
                boolean bl = haveMinorLogNumbers = i2 - i1 < 2;
                if (minorTicks && (!this.logXAxis || step > 1.1)) {
                    step = this.niceNumber(step * 0.19);
                    if (this.logXAxis && step < 1.0) {
                        step = 1.0;
                    }
                    i1 = (int)Math.ceil(Math.min(this.xMin, this.xMax) / step - 1.0E-10);
                    i2 = (int)Math.floor(Math.max(this.xMin, this.xMax) / step + 1.0E-10);
                    for (int i4 = i1; i4 <= i2; ++i4) {
                        double v = (double)i4 * step;
                        int x = (int)Math.round((v - this.xMin) * this.xScale) + this.leftMargin;
                        this.ip.drawLine(x, y1, x, y1 + this.sc(this.minorTickLength));
                        this.ip.drawLine(x, y2, x, y2 - this.sc(this.minorTickLength));
                    }
                } else if (this.logXAxis && majorTicks && Math.abs(this.xScale) > (double)this.sc(45.0f)) {
                    int minorNumberLimit = haveMinorLogNumbers ? (int)(0.12 * Math.abs(this.xScale) / (double)(fm.charWidth('0') + this.sc(2.0f))) : 0;
                    i1 = (int)Math.floor(Math.min(this.xMin, this.xMax) - 1.0E-10);
                    i2 = (int)Math.ceil(Math.max(this.xMin, this.xMax) + 1.0E-10);
                    for (i = i1; i <= i2; ++i) {
                        for (int m = 2; m < 10; ++m) {
                            double v = (double)i + Math.log10(m);
                            if (!(v > Math.min(this.xMin, this.xMax)) || !(v < Math.max(this.xMin, this.xMax))) continue;
                            int x = (int)Math.round((v - this.xMin) * this.xScale) + this.leftMargin;
                            this.ip.drawLine(x, y1, x, y1 + this.sc(this.minorTickLength));
                            this.ip.drawLine(x, y2, x, y2 - this.sc(this.minorTickLength));
                            if (m > minorNumberLimit) continue;
                            this.drawExpString(Math.pow(10.0, v), 0, x, yOfXAxisNumbers - fontAscent / 2, 1, fontAscent, baseFont, scFontSmall);
                        }
                    }
                }
            }
        }
        int maxNumWidth = 0;
        if (this.hasFlag(2 | (this.logYAxis ? 520 : 8192) + 32)) {
            boolean haveMinorLogNumbers;
            int w;
            int y;
            this.ip.setFont(scFont);
            this.ip.setJustification(2);
            Font baseFont = scFont;
            boolean majorTicks = this.logYAxis ? this.hasFlag(8192) : this.hasFlag(8);
            boolean minorTicks = this.logYAxis ? this.hasFlag(8192) : this.hasFlag(512);
            double step = steps[1];
            int i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
            int i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
            int digits = Plot.getDigits(this.yMin, this.yMax, step, 5);
            int x1 = this.leftMargin;
            int x2 = this.leftMargin + this.frameWidth;
            if (this.yMin == this.yMax) {
                if (this.hasFlag(2)) {
                    String s = IJ.d2s(this.yMin, Plot.getDigits(this.yMin, 0.001 * this.yMin, 5));
                    maxNumWidth = this.ip.getStringWidth(s);
                    int y2 = this.yBasePxl;
                    this.ip.drawString(s, this.leftMargin - 1, y2 + fontAscent / 2 + this.sc(1.0f));
                }
            } else {
                int w1 = this.ip.getStringWidth(IJ.d2s(this.currentMinMax[2], this.logYAxis ? -1 : digits));
                int w2 = this.ip.getStringWidth(IJ.d2s(this.currentMinMax[3], this.logYAxis ? -1 : digits));
                int wMax = Math.max(w1, w2);
                if (this.hasFlag(2) && wMax > this.leftMargin - this.sc(2.0f) - extraWidth - (this.yLabel.length() > 0 ? fm.getHeight() : 0)) {
                    baseFont = scFontMedium;
                    this.ip.setFont(baseFont);
                }
                for (int i5 = i1; i5 <= i2; ++i5) {
                    double v = step == 0.0 ? this.yMin : (double)i5 * step;
                    y = this.topMargin + this.frameHeight - (int)Math.round((v - this.yMin) * this.yScale);
                    if (this.hasFlag(32)) {
                        this.ip.setColor(this.gridColor);
                        this.ip.drawLine(x1, y, x2, y);
                        this.ip.setColor(Color.black);
                    }
                    if (majorTicks) {
                        this.ip.drawLine(x1, y, x1 + this.sc(this.tickLength), y);
                        this.ip.drawLine(x2, y, x2 - this.sc(this.tickLength), y);
                    }
                    if (!this.hasFlag(2)) continue;
                    w = 0;
                    if (this.logYAxis || digits < 0) {
                        w = this.drawExpString(this.logYAxis ? Math.pow(10.0, v) : v, this.logYAxis ? -1 : -digits, this.leftMargin, y, 2, fontAscent, baseFont, scFontSmall);
                    } else {
                        String s = IJ.d2s(v, digits);
                        w = this.ip.getStringWidth(s);
                        this.ip.drawString(s, this.leftMargin - 1, y + fontAscent * 2 / 3 + 1);
                    }
                    if (w <= maxNumWidth) continue;
                    maxNumWidth = w;
                }
            }
            boolean bl = haveMinorLogNumbers = i2 - i1 < 2;
            if (minorTicks && (!this.logYAxis || step > 1.1)) {
                step = this.niceNumber(step * 0.19);
                if (this.logYAxis && step < 1.0) {
                    step = 1.0;
                }
                i1 = (int)Math.ceil(Math.min(this.yMin, this.yMax) / step - 1.0E-10);
                i2 = (int)Math.floor(Math.max(this.yMin, this.yMax) / step + 1.0E-10);
                for (i = i1; i <= i2; ++i) {
                    double v = (double)i * step;
                    int y3 = this.topMargin + this.frameHeight - (int)Math.round((v - this.yMin) * this.yScale);
                    this.ip.drawLine(x1, y3, x1 + this.sc(this.minorTickLength), y3);
                    this.ip.drawLine(x2, y3, x2 - this.sc(this.minorTickLength), y3);
                }
            }
            if (this.logYAxis && majorTicks && Math.abs(this.yScale) > (double)this.sc(45.0f)) {
                int minorNumberLimit = haveMinorLogNumbers ? (int)(0.4 * Math.abs(this.yScale) / (double)fm.getHeight()) : 0;
                i1 = (int)Math.floor(Math.min(this.yMin, this.yMax) - 1.0E-10);
                i2 = (int)Math.ceil(Math.max(this.yMin, this.yMax) + 1.0E-10);
                for (int i6 = i1; i6 <= i2; ++i6) {
                    for (int m = 2; m < 10; ++m) {
                        double v = (double)i6 + Math.log10(m);
                        if (!(v > Math.min(this.yMin, this.yMax)) || !(v < Math.max(this.yMin, this.yMax))) continue;
                        y = this.topMargin + this.frameHeight - (int)Math.round((v - this.yMin) * this.yScale);
                        this.ip.drawLine(x1, y, x1 + this.sc(this.minorTickLength), y);
                        this.ip.drawLine(x2, y, x2 - this.sc(this.minorTickLength), y);
                        if (m > minorNumberLimit || (w = this.drawExpString(Math.pow(10.0, v), 0, this.leftMargin - this.sc(1.0f), y, 2, fontAscent, baseFont, scFontSmall)) <= maxNumWidth) continue;
                        maxNumWidth = w;
                    }
                }
            }
        }
        this.ip.setFont(scFont);
        this.ip.setJustification(0);
        String xLabelToDraw = this.xLabel;
        String yLabelToDraw = this.yLabel;
        if (this.simpleYAxis()) {
            int digits = Plot.getDigits(this.yMin, this.yMax, 0.001 * (this.yMax - this.yMin), 6);
            String s = IJ.d2s(this.yMax, digits);
            int sw = this.ip.getStringWidth(s);
            if (sw + this.sc(4.0f) > this.leftMargin) {
                this.ip.drawString(s, this.sc(4.0f), this.topMargin - this.sc(4.0f));
            } else {
                this.ip.drawString(s, this.leftMargin - this.ip.getStringWidth(s) - this.sc(4.0f), this.topMargin + 10);
            }
            s = IJ.d2s(this.yMin, digits);
            sw = this.ip.getStringWidth(s);
            if (sw + 4 > this.leftMargin) {
                this.ip.drawString(s, this.sc(4.0f), this.topMargin + this.frame.height);
            } else {
                this.ip.drawString(s, this.leftMargin - this.ip.getStringWidth(s) - this.sc(4.0f), this.topMargin + this.frame.height);
            }
            if (this.logYAxis) {
                yLabelToDraw = yLabelToDraw + " (LOG)";
            }
        }
        int y = yOfXAxisNumbers;
        if (this.simpleXAxis()) {
            int digits = Plot.getDigits(this.xMin, this.xMax, 0.001 * (this.xMax - this.xMin), 7);
            this.ip.drawString(IJ.d2s(this.xMin, digits), this.leftMargin, y);
            String s = IJ.d2s(this.xMax, digits);
            this.ip.drawString(s, this.leftMargin + this.frame.width - this.ip.getStringWidth(s) + 6, y);
            y -= fm.getHeight();
            if (this.logXAxis) {
                xLabelToDraw = xLabelToDraw + " (LOG)";
            }
        } else {
            y += this.sc(1.0f);
        }
        this.ip.setFont(this.xLabelFont == null ? scFont : this.scFont(this.xLabelFont));
        this.ip.drawString(xLabelToDraw, this.leftMargin + (this.frame.width - this.ip.getStringWidth(this.xLabel)) / 2, y + this.ip.getFontMetrics().getHeight());
        if (this.yLabel.length() > 0) {
            int xOfYLabel = this.leftMargin - maxNumWidth - extraWidth - this.sc(4.0f);
            if (xOfYLabel < 0) {
                xOfYLabel = 0;
            }
            this.drawYLabel(yLabelToDraw, xOfYLabel, this.topMargin, this.frame.height, this.yLabelFont == null ? scFont : this.scFont(this.yLabelFont));
        }
    }

    double niceNumber(double v) {
        double base = Math.pow(10.0, Math.floor(Math.log10(v) - 1.0E-6));
        if (v > 5.0000001 * base) {
            return 10.0 * base;
        }
        if (v > 2.0000001 * base) {
            return 5.0 * base;
        }
        return 2.0 * base;
    }

    int drawExpString(double value, int digits, int x, int y, int justification, int fontAscent, Font baseFont, Font smallFont) {
        int ePos;
        String base = "10";
        String exponent = null;
        String s = IJ.d2s(value, digits <= 0 ? -1 : -digits);
        if (Tools.parseDouble(s) == 0.0) {
            s = "0";
        }
        if ((ePos = s.indexOf(69)) < 0) {
            base = s;
        } else {
            if (digits >= 0) {
                base = s.substring(0, ePos);
                if (digits == 0) {
                    base = Integer.toString((int)Math.round(Tools.parseDouble(base)));
                }
                base = base + "\u00b710";
            }
            exponent = s.substring(ePos + 1);
        }
        this.ip.setJustification(2);
        int width = this.ip.getStringWidth(base);
        if (exponent != null) {
            this.ip.setFont(smallFont);
            int wExponent = this.ip.getStringWidth(exponent);
            width += wExponent;
            if (justification == 1) {
                x += width / 2;
            }
            this.ip.drawString(exponent, x, y + fontAscent * 3 / 10);
            x -= wExponent;
            this.ip.setFont(baseFont);
        }
        this.ip.drawString(base, x, y + fontAscent * 7 / 10);
        return width;
    }

    static int getDigits(double n, double resolution, int maxDigits) {
        if (n == (double)Math.round(n) && Math.abs(n) < Math.pow(10.0, maxDigits - 1) - 1.0) {
            return 0;
        }
        return Plot.getDigits2(n, resolution, maxDigits);
    }

    static int getDigits(double n1, double n2, double resolution, int maxDigits) {
        if (n1 == 0.0 && n2 == 0.0) {
            return 0;
        }
        return Plot.getDigits2(Math.max(Math.abs(n1), Math.abs(n2)), resolution, maxDigits);
    }

    static int getDigits2(double n, double resolution, int maxDigits) {
        int log10ofN = (int)Math.floor(Math.log10(Math.abs(n)) + 1.0E-7);
        int digits = resolution != 0.0 ? -((int)Math.floor(Math.log10(Math.abs(resolution)) + 1.0E-7)) : Math.max(0, -log10ofN + maxDigits - 2);
        int sciDigits = -Math.max(log10ofN + digits, 1);
        if (digits < -2 && log10ofN >= maxDigits) {
            digits = sciDigits;
        } else if (digits < 0) {
            digits = 0;
        } else if (digits > maxDigits - 1 && log10ofN < -2) {
            digits = sciDigits;
        }
        return digits;
    }

    static boolean isInteger(double n) {
        return n == (double)Math.round(n);
    }

    private void drawPlotObject(PlotObject plotObject, ImageProcessor ip) {
        ip.setColor(plotObject.color);
        ip.setLineWidth(this.sc(plotObject.lineWidth));
        int type = plotObject.type;
        switch (type) {
            case 0: {
                ip.setClipRect(this.frame);
                if (plotObject.yEValues != null) {
                    this.drawVerticalErrorBars(plotObject.xValues, plotObject.yValues, plotObject.yEValues);
                }
                if (plotObject.xEValues != null) {
                    this.drawHorizontalErrorBars(plotObject.xValues, plotObject.yValues, plotObject.xEValues);
                }
                boolean drawMarker = plotObject.hasMarker();
                boolean drawLine = plotObject.hasCurve();
                if (plotObject.shape == 7) {
                    ip.setColor(plotObject.color2 == null ? Color.black : plotObject.color2);
                }
                if (drawLine) {
                    this.drawFloatPolyline(ip, plotObject.xValues, plotObject.yValues, Math.min(plotObject.xValues.length, plotObject.yValues.length));
                }
                if (drawMarker) {
                    int i;
                    int markSize = plotObject.getMarkerSize();
                    if (plotObject.hasFilledMarker()) {
                        ip.setColor(plotObject.color2);
                        ip.setLineWidth(1);
                        for (i = 0; i < Math.min(plotObject.xValues.length, plotObject.yValues.length); ++i) {
                            if (this.logXAxis && !(plotObject.xValues[i] > 0.0f) || this.logYAxis && !(plotObject.yValues[i] > 0.0f)) continue;
                            this.fillShape(plotObject.shape, this.scaleX(plotObject.xValues[i]), this.scaleY(plotObject.yValues[i]), markSize);
                        }
                        ip.setLineWidth(this.sc(plotObject.lineWidth));
                    }
                    ip.setColor(plotObject.color);
                    for (i = 0; i < Math.min(plotObject.xValues.length, plotObject.yValues.length); ++i) {
                        if (this.logXAxis && !(plotObject.xValues[i] > 0.0f) || this.logYAxis && !(plotObject.yValues[i] > 0.0f)) continue;
                        this.drawShape(plotObject.shape, this.scaleX(plotObject.xValues[i]), this.scaleY(plotObject.yValues[i]), markSize);
                    }
                }
                ip.setClipRect(null);
                break;
            }
            case 1: {
                ip.setClipRect(this.frame);
                for (int i = 0; i < plotObject.xValues.length; ++i) {
                    int xt1 = this.scaleX(plotObject.xValues[i]);
                    int yt1 = this.scaleY(plotObject.yValues[i]);
                    int xt2 = this.scaleX(plotObject.xEValues[i]);
                    int yt2 = this.scaleY(plotObject.yEValues[i]);
                    double dist = Plot.calculateDistance(xt1, yt1, xt2, yt2);
                    if (xt1 == xt2 && yt1 == yt2) {
                        ip.drawDot(xt1, yt1);
                        continue;
                    }
                    if (dist < (double)this.sc(4.5f)) {
                        ip.drawLine(xt1, yt1, xt2, yt2);
                        continue;
                    }
                    int arrowHeadLength = (int)(dist * 0.2 + 0.5);
                    if (arrowHeadLength > this.sc(20.0f)) {
                        arrowHeadLength = this.sc(20.0f);
                    }
                    if (arrowHeadLength < this.sc(3.0f)) {
                        arrowHeadLength = this.sc(3.0f);
                    }
                    this.drawArrow(xt1, yt1, xt2, yt2, arrowHeadLength);
                }
                ip.setClipRect(null);
                break;
            }
            case 2: {
                ip.setClipRect(this.frame);
                ip.drawLine(this.scaleX(plotObject.x), this.scaleY(plotObject.y), this.scaleX(plotObject.xEnd), this.scaleY(plotObject.yEnd));
                ip.setClipRect(null);
                break;
            }
            case 3: {
                ip.setClipRect(this.frame);
                int ix1 = this.leftMargin + (int)(plotObject.x * (double)this.frameWidth);
                int iy1 = this.topMargin + (int)(plotObject.y * (double)this.frameHeight);
                int ix2 = this.leftMargin + (int)(plotObject.xEnd * (double)this.frameWidth);
                int iy2 = this.topMargin + (int)(plotObject.yEnd * (double)this.frameHeight);
                ip.drawLine(ix1, iy1, ix2, iy2);
                ip.setClipRect(null);
                break;
            }
            case 4: {
                ip.setClipRect(this.frame);
                int ix1 = this.scaleX(plotObject.x);
                int iy1 = this.scaleY(plotObject.y);
                int ix2 = this.scaleX(plotObject.xEnd);
                int iy2 = this.scaleY(plotObject.yEnd);
                double length = Plot.calculateDistance(ix1, ix2, iy1, iy2) + 0.1;
                int n = (int)(length / (double)plotObject.step);
                for (int i = 0; i <= n; ++i) {
                    ip.drawDot(ix1 + (int)Math.round((double)(ix2 - ix1) * (double)i / (double)n), iy1 + (int)Math.round((double)(iy2 - iy1) * (double)i / (double)n));
                }
                ip.setClipRect(null);
                break;
            }
            case 5: 
            case 6: {
                ip.setJustification(plotObject.justification);
                if (plotObject.font != null) {
                    ip.setFont(this.scFont(plotObject.font));
                }
                int xt = type == 5 ? this.scaleX(plotObject.x) : this.leftMargin + (int)(plotObject.x * (double)this.frameWidth);
                int yt = type == 5 ? this.scaleY(plotObject.y) : this.topMargin + (int)(plotObject.y * (double)this.frameHeight);
                ip.drawString(plotObject.label, xt, yt);
                break;
            }
            case 7: {
                this.drawLegend(plotObject, ip);
            }
        }
    }

    void drawShape(int shape, int x, int y, int size) {
        int xbase = x - this.sc(size / 2);
        int ybase = y - this.sc(size / 2);
        int xend = x + this.sc(size / 2);
        int yend = y + this.sc(size / 2);
        switch (shape) {
            case 1: {
                this.ip.drawLine(xbase, ybase, xend, yend);
                this.ip.drawLine(xend, ybase, xbase, yend);
                break;
            }
            case 3: {
                this.ip.drawLine(xbase, ybase, xend, ybase);
                this.ip.drawLine(xend, ybase, xend, yend);
                this.ip.drawLine(xend, yend, xbase, yend);
                this.ip.drawLine(xbase, yend, xbase, ybase);
                break;
            }
            case 4: {
                this.ip.drawLine(x, ybase - this.sc(1.0f), xend + this.sc(1.0f), yend);
                this.ip.drawLine(x, ybase - this.sc(1.0f), xbase - this.sc(1.0f), yend);
                this.ip.drawLine(xend + this.sc(1.0f), yend, xbase - this.sc(1.0f), yend);
                break;
            }
            case 5: {
                this.ip.drawLine(xbase, y, xend, y);
                this.ip.drawLine(x, ybase, x, yend);
                break;
            }
            case 6: {
                this.ip.drawDot(x, y);
                break;
            }
            default: {
                if ((double)this.sc(size) < 5.01) {
                    this.ip.drawLine(x - 1, y - 2, x + 1, y - 2);
                    this.ip.drawLine(x - 1, y + 2, x + 1, y + 2);
                    this.ip.drawLine(x + 2, y + 1, x + 2, y - 1);
                    this.ip.drawLine(x - 2, y + 1, x - 2, y - 1);
                    break;
                }
                int r = this.sc(0.5f * (float)size - 0.5f);
                this.ip.drawOval(x - r, y - r, 2 * r, 2 * r);
            }
        }
    }

    void fillShape(int shape, int x0, int y0, int size) {
        int r = this.sc(size / 2) - 1;
        switch (shape) {
            case 3: {
                int widthOrHeight = 2 * this.sc(size / 2);
                for (int dy = -r; dy <= r; ++dy) {
                    for (int dx = -r; dx <= r; ++dx) {
                        this.ip.drawDot(x0 + dx, y0 + dy);
                    }
                }
                break;
            }
            case 4: {
                int ybase = y0 - r - this.sc(1.0f);
                int yend = y0 + r;
                double halfWidth = this.sc(size / 2) + this.sc(1.0f) - 1;
                double hwStep = halfWidth / (double)(yend - ybase + 1);
                int y = yend;
                while (y >= ybase) {
                    int dx = (int)Math.round(halfWidth);
                    for (int x = x0 - dx; x <= x0 + dx; ++x) {
                        this.ip.drawDot(x, y);
                    }
                    --y;
                    halfWidth -= hwStep;
                }
                break;
            }
            case 0: {
                int rsquare = (r + 1) * (r + 1);
                for (int dy = -r; dy <= r; ++dy) {
                    for (int dx = -r; dx <= r; ++dx) {
                        if (dx * dx + dy * dy > rsquare) continue;
                        this.ip.drawDot(x0 + dx, y0 + dy);
                    }
                }
                break;
            }
        }
    }

    public void drawArrow(int x1, int y1, int x2, int y2, double size) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double ra = Math.sqrt(dx * dx + dy * dy);
        int x3 = (int)Math.round((double)x2 - (dx /= ra) * size);
        int y3 = (int)Math.round((double)y2 - (dy /= ra) * size);
        double r = 0.3 * size;
        int x4 = (int)Math.round((double)x3 + dy * r);
        int y4 = (int)Math.round((double)y3 - dx * r);
        int x5 = (int)Math.round((double)x3 - dy * r);
        int y5 = (int)Math.round((double)y3 + dx * r);
        this.ip.moveTo(x1, y1);
        this.ip.lineTo(x2, y2);
        this.ip.moveTo(x4, y4);
        this.ip.lineTo(x2, y2);
        this.ip.lineTo(x5, y5);
    }

    private void drawVerticalErrorBars(float[] x, float[] y, float[] e) {
        int nPoints = Math.min(Math.min(x.length, y.length), e.length);
        for (int i = 0; i < nPoints; ++i) {
            if (Float.isNaN(x[i]) || Float.isNaN(y[i]) || this.logXAxis && !(x[i] > 0.0f)) continue;
            int x0 = this.scaleX(x[i]);
            int yPlus = this.scaleYWithOverflow(y[i] + e[i]);
            int yMinus = this.scaleYWithOverflow(y[i] - e[i]);
            this.ip.moveTo(x0, yMinus);
            this.ip.lineTo(x0, yPlus);
        }
    }

    private void drawHorizontalErrorBars(float[] x, float[] y, float[] e) {
        int nPoints = Math.min(Math.min(x.length, y.length), e.length);
        float[] xpoints = new float[2];
        float[] ypoints = new float[2];
        for (int i = 0; i < nPoints; ++i) {
            if (Float.isNaN(x[i]) || Float.isNaN(y[i]) || this.logXAxis && !(y[i] > 0.0f)) continue;
            int y0 = this.scaleY(y[i]);
            int xPlus = this.scaleXWithOverflow(x[i] + e[i]);
            int xMinus = this.scaleXWithOverflow(x[i] - e[i]);
            this.ip.moveTo(xMinus, y0);
            this.ip.lineTo(xPlus, y0);
        }
    }

    void drawFloatPolyline(ImageProcessor ip, float[] x, float[] y, int n) {
        if (x == null || x.length == 0) {
            return;
        }
        int x2 = this.scaleX(x[0]);
        int y2 = this.scaleY(y[0]);
        boolean isNaN2 = Float.isNaN(x[0]) || Float.isNaN(y[0]) || this.logXAxis && x[0] <= 0.0f || this.logYAxis && y[0] <= 0.0f;
        for (int i = 1; i < n; ++i) {
            int x1 = x2;
            int y1 = y2;
            boolean isNaN1 = isNaN2;
            x2 = this.scaleX(x[i]);
            y2 = this.scaleY(y[i]);
            boolean bl = isNaN2 = Float.isNaN(x[i]) || Float.isNaN(y[i]) || this.logXAxis && x[i] <= 0.0f || this.logYAxis && y[i] <= 0.0f;
            if (isNaN1 || isNaN1) continue;
            ip.drawLine(x1, y1, x2, y2);
        }
    }

    void drawYLabel(String yLabel, int xRight, int yFrameTop, int frameHeight, Font scaledFont) {
        if (yLabel.equals("")) {
            return;
        }
        this.ip.setFont(scaledFont);
        FontMetrics fm = this.ip.getFontMetrics();
        int w = this.ip.getStringWidth(yLabel) + this.sc(5.0f);
        int h = fm.getHeight() + this.sc(1.0f);
        ImageProcessor label = new ByteProcessor(w, h);
        label.setAntialiasedText(this.antialiasedText);
        if (this.invertedLut) {
            label.invertLut();
        }
        ((ImageProcessor)label).setColor(Color.white);
        label.fill();
        ((ImageProcessor)label).setColor(Color.black);
        label.setFont(scaledFont);
        label.drawString(yLabel, 0, h);
        label = label.rotateLeft();
        int y2 = yFrameTop + (frameHeight - this.ip.getStringWidth(yLabel)) / 2;
        if (y2 < yFrameTop) {
            y2 = yFrameTop;
        }
        int x2 = Math.max(xRight - h, 0);
        this.ip.insert(label, x2, y2);
    }

    void drawLegend(PlotObject legendObject, ImageProcessor ip) {
        int y;
        ip.setFont(this.scFont(legendObject.font));
        String[] labels = null;
        if (legendObject.label != null) {
            labels = legendObject.label.split("[\t\n]");
        }
        int n = 0;
        int nLabels = 0;
        int maxStringWidth = 0;
        float maxLineThickness = 0.0f;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 0) continue;
            if (labels != null && n < labels.length && labels[n].length() > 0) {
                plotObject.label = labels[n];
            }
            if (plotObject.label != null) {
                ++nLabels;
                int w = ip.getStringWidth(plotObject.label);
                if (w > maxStringWidth) {
                    maxStringWidth = w;
                }
                if (plotObject.lineWidth > maxLineThickness) {
                    maxLineThickness = plotObject.lineWidth;
                }
            }
            ++n;
        }
        if (nLabels == 0) {
            return;
        }
        if (this.antialiasedText && this.scale > 1.0f) {
            maxStringWidth = (int)((1.0 + 0.004 * (double)this.scale) * (double)maxStringWidth);
        }
        int frameThickness = this.sc(legendObject.lineWidth > 0.0f ? legendObject.lineWidth : 1.0f);
        FontMetrics fm = ip.getFontMetrics();
        ip.setJustification(0);
        int lineHeight = fm.getHeight();
        int height = nLabels * lineHeight + 2 * this.sc(4.0f);
        int width = maxStringWidth + this.sc(32.0f + maxLineThickness);
        int positionCode = legendObject.flags & 0xF0;
        if (positionCode == 128) {
            positionCode = this.autoLegendPosition(width, height, frameThickness);
        }
        Rectangle rect = this.legendRect(positionCode, width, height, frameThickness);
        int x0 = rect.x;
        int y0 = rect.y;
        ip.setColor(Color.white);
        ip.setLineWidth(1);
        if (!legendObject.hasFlag(512)) {
            ip.setRoi(x0, y0, width, height);
            ip.fill();
        } else if (this.hasFlag(48)) {
            int grid = ip instanceof ColorProcessor ? this.gridColor.getRGB() & 0xFFFFFF : ip.getBestIndex(this.gridColor);
            for (y = y0; y < y0 + height; ++y) {
                for (int x = x0; x < x0 + width; ++x) {
                    if ((ip.getPixel(x, y) & 0xFFFFFF) != grid) continue;
                    ip.drawDot(x, y);
                }
            }
        }
        ip.setLineWidth(frameThickness);
        ip.setColor(legendObject.color);
        ip.drawRect(x0 - frameThickness / 2, y0 - frameThickness / 2, width + frameThickness, height);
        boolean bottomUp = legendObject.hasFlag(256);
        y = y0 + frameThickness / 2 + this.sc(4.0f) + lineHeight / 2;
        if (bottomUp) {
            y += (nLabels - 1) * lineHeight;
        }
        int xText = x0 + frameThickness / 2 + this.sc(28.0f + maxLineThickness);
        int xMarker = x0 + frameThickness / 2 + this.sc(4.0f + 0.5f * (20.0f + maxLineThickness));
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 0 || plotObject.label == null) continue;
            if (plotObject.hasFilledMarker()) {
                ip.setColor(plotObject.color2);
                this.fillShape(plotObject.shape, xMarker, y, plotObject.getMarkerSize());
            }
            int lineWidth = this.sc(plotObject.lineWidth);
            ip.setLineWidth(lineWidth);
            if (plotObject.hasMarker()) {
                ip.setColor(plotObject.color);
                this.drawShape(plotObject.shape, xMarker, y, plotObject.getMarkerSize());
            }
            if (plotObject.hasCurve()) {
                Color c = plotObject.shape == 7 ? (plotObject.color2 == null ? Color.black : plotObject.color2) : plotObject.color;
                ip.setColor(c);
                ip.drawLine(x0 + frameThickness / 2 + this.sc(4.0f) + lineWidth, y, xText - this.sc(4.0f) - lineWidth, y);
            }
            ip.setColor(plotObject.color);
            ip.setLineWidth(frameThickness);
            ip.drawString(plotObject.label, xText, y + lineHeight / 2);
            y += bottomUp ? -lineHeight : lineHeight;
        }
    }

    Rectangle legendRect(int positionCode, int width, int height, int frameThickness) {
        int y0;
        boolean leftPosition = positionCode == 144 || positionCode == 176;
        boolean topPosition = positionCode == 144 || positionCode == 160;
        int x0 = leftPosition ? this.leftMargin + this.sc(8.0f) + frameThickness / 2 : this.leftMargin + this.frameWidth - width - this.sc(8.0f) - frameThickness / 2;
        int n = y0 = topPosition ? this.topMargin + this.sc(4.0f) + frameThickness / 2 : this.topMargin + this.frameHeight - height - this.sc(4.0f) + frameThickness / 2;
        if (this.hasFlag(8)) {
            x0 += (leftPosition ? 1 : -1) * this.sc(this.tickLength - 4);
        }
        if (this.hasFlag(4)) {
            y0 += (topPosition ? 1 : -1) * this.sc(this.tickLength - 2);
        }
        return new Rectangle(x0, y0, width, height);
    }

    int autoLegendPosition(int width, int height, int frameThickness) {
        int background = this.ip instanceof ColorProcessor ? 0xFFFFFF : (this.ip.isInvertedLut() ? 0 : 255);
        int grid = this.ip instanceof ColorProcessor ? this.gridColor.getRGB() & 0xFFFFFF : this.ip.getBestIndex(this.gridColor);
        int bestPosition = 0;
        int minCoveredPixels = Integer.MAX_VALUE;
        for (int positionCode : new int[]{144, 160, 192, 176}) {
            Rectangle rect = this.legendRect(positionCode, width, height, frameThickness);
            int coveredPixels = 0;
            for (int y = rect.y - frameThickness / 2; y <= rect.y + rect.height + frameThickness / 2; ++y) {
                for (int x = rect.x - frameThickness / 2; x <= rect.x + rect.width + frameThickness / 2; ++x) {
                    int pixel = this.ip.getPixel(x, y) & 0xFFFFFF;
                    if (pixel == background || pixel == grid) continue;
                    ++coveredPixels;
                }
            }
            if (coveredPixels >= minCoveredPixels) continue;
            minCoveredPixels = coveredPixels;
            bestPosition = positionCode;
        }
        return bestPosition;
    }

    String getCoordinates(int x, int y) {
        PlotObject p;
        if (this.frame == null) {
            return "";
        }
        String text = "";
        if (!this.frame.contains(x, y)) {
            return text;
        }
        double xv = this.descaleX(x);
        double yv = this.descaleY(y);
        boolean yIsValue = false;
        if (!this.hasMultiplePlots() && (p = this.getMainCurveObject()) != null) {
            double bestDx = Double.MAX_VALUE;
            double xBest = 0.0;
            double yBest = 0.0;
            for (int i = 0; i < Math.min(p.xValues.length, p.yValues.length); ++i) {
                double xp = p.xValues[i];
                if (!(Math.abs(xp - xv) < bestDx)) continue;
                bestDx = Math.abs(xp - xv);
                xBest = xp;
                yBest = p.yValues[i];
            }
            if (this.xScale != 0.0 && bestDx * this.xScale < 50.0) {
                xv = xBest;
                yv = yBest;
                yIsValue = true;
            } else {
                xv = Double.NaN;
            }
        }
        if (!Double.isNaN(xv)) {
            text = "X=" + IJ.d2s(xv, Plot.getDigits(xv, 0.001 * (this.xMax - this.xMin), 6)) + ", Y";
            if (yIsValue) {
                text = text + "(X)";
            }
            text = text + "=" + IJ.d2s(yv, Plot.getDigits(yv, 0.001 * (this.yMax - this.yMin), 6));
        }
        return text;
    }

    private PlotObject getMainCurveObject() {
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 0) continue;
            return plotObject;
        }
        return null;
    }

    private PlotObject getLastCurveObject() {
        for (int i = this.allPlotObjects.size() - 1; i >= 0; --i) {
            if (this.allPlotObjects.get((int)i).type != 0) continue;
            return this.allPlotObjects.get(i);
        }
        return null;
    }

    private boolean hasMultiplePlots() {
        int nPlots = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type == 1) {
                return true;
            }
            if (plotObject.type != 0 || ++nPlots <= 1) continue;
            return true;
        }
        return nPlots > 1;
    }

    public void setPlotMaker(PlotMaker plotMaker) {
        this.plotMaker = plotMaker;
    }

    PlotMaker getPlotMaker() {
        return this.plotMaker;
    }

    String getDataLabels() {
        String labels = "";
        boolean first = true;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type != 0) continue;
            if (first) {
                first = false;
            } else {
                labels = labels + '\n';
            }
            if (plotObject.label == null) continue;
            labels = labels + plotObject.label;
        }
        return labels;
    }

    public ResultsTable getResultsTable(boolean writeFirstXColumn) {
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(false);
        int nDataSets = 0;
        int tableLength = 0;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.xValues == null) continue;
            ++nDataSets;
            tableLength = Math.max(tableLength, plotObject.xValues.length);
        }
        if (nDataSets == 0) {
            return null;
        }
        ArrayList<String> headings = new ArrayList<String>(2 * nDataSets);
        ArrayList<float[]> data = new ArrayList<float[]>(2 * nDataSets);
        int dataSetNumber = 0;
        int arrowsNumber = 0;
        PlotObject firstXYobject = null;
        for (PlotObject plotObject : this.allPlotObjects) {
            if (plotObject.type == 0) {
                boolean sameX = firstXYobject != null && Arrays.equals(firstXYobject.xValues, plotObject.xValues);
                boolean sameXY = sameX && Arrays.equals(firstXYobject.yValues, plotObject.yValues);
                boolean writeX = firstXYobject == null && writeFirstXColumn || !sameX;
                this.addToLists(headings, data, plotObject, dataSetNumber, writeX, !sameXY, nDataSets > 1);
                if (firstXYobject == null) {
                    firstXYobject = plotObject;
                }
                ++dataSetNumber;
                continue;
            }
            if (plotObject.type != 1) continue;
            this.addToLists(headings, data, plotObject, arrowsNumber, true, true, nDataSets > 1);
            ++arrowsNumber;
        }
        int nColumns = headings.size();
        for (int line = 0; line < tableLength; ++line) {
            for (int col = 0; col < nColumns; ++col) {
                String heading = (String)headings.get(col);
                float[] values = (float[])data.get(col);
                if (line < values.length) {
                    rt.setValue(heading, line, (double)values[line]);
                    continue;
                }
                rt.setValue(heading, line, "");
            }
        }
        nColumns = rt.getLastColumn() + 1;
        for (int i = 0; i < nColumns; ++i) {
            rt.setDecimalPlaces(i, Plot.getPrecision(rt.getColumn(i)));
        }
        return rt;
    }

    void addToLists(ArrayList<String> headings, ArrayList<float[]> data, PlotObject plotObject, int dataSetNumber, boolean writeX, boolean writeY, boolean multipleSets) {
        String label;
        if (writeX) {
            String string = label = plotObject.type == 1 ? "XStart" : "X";
            if (multipleSets) {
                label = label + dataSetNumber;
            }
            headings.add(label);
            data.add(plotObject.xValues);
        }
        if (writeY) {
            String string = label = plotObject.type == 1 ? "YStart" : "Y";
            if (multipleSets) {
                label = label + dataSetNumber;
            }
            headings.add(label);
            data.add(plotObject.yValues);
        }
        if (plotObject.xEValues != null) {
            String string = label = plotObject.type == 1 ? "XEnd" : "XERR";
            if (multipleSets) {
                label = label + dataSetNumber;
            }
            headings.add(label);
            data.add(plotObject.xEValues);
        }
        if (plotObject.yEValues != null) {
            String string = label = plotObject.type == 1 ? "YEnd" : "ERR";
            if (multipleSets) {
                label = label + dataSetNumber;
            }
            headings.add(label);
            data.add(plotObject.yEValues);
        }
    }

    static int getPrecision(float[] values) {
        int digits;
        boolean scientificNotation;
        int setDigits = Analyzer.getPrecision();
        int measurements = Analyzer.getMeasurements();
        boolean bl = scientificNotation = (measurements & 0x200000) != 0;
        if (scientificNotation) {
            if (setDigits < 4) {
                setDigits = 4;
            }
            return -setDigits;
        }
        boolean allInteger = true;
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < values.length; ++i) {
            if ((float)((int)values[i]) == values[i] || Float.isNaN(values[i])) continue;
            allInteger = false;
            if (values[i] < min) {
                min = values[i];
            }
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        if (allInteger) {
            return 0;
        }
        int n = digits = max - min > 0.0f ? Plot.getDigits(min, max, 1.0E-5 * (double)(max - min), 15) : Plot.getDigits(max, 1.0E-5 * (double)Math.abs(max), 15);
        if (setDigits > Math.abs(digits)) {
            digits = setDigits * (digits < 0 ? -1 : 1);
        }
        return digits;
    }

    boolean hasFlag(int what) {
        return (this.flags & what) != 0;
    }
}

