/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.rc;

import com.ibm.media.codec.audio.rc.RateConversionTables;

public final class RateConversion {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1998.";
    public static final int RATE_CONVERSION_OK = -1;
    public static final int RATE_CONVERSION_NOT_SUPPORTED = -2;
    public static final int RATE_CONVERSION_NOT_INITIALIZED = -3;
    public static final int RATE_CONVERSION_ILLEGAL_PARAMETER = -4;
    public static final int RATE_CONVERSION_RECOMMENDED_INPUT_SIZE = 1056;
    public static final int RATE_CONVERSION_MAX_SUPPORTED_CHANNELS = 2;
    public static final int RATE_CONVERSION_MAX_OUTPUT_FACTOR = 5;
    public static final int RATE_CONVERSION_BIG_ENDIAN_FORMAT = 0;
    public static final int RATE_CONVERSION_LITTLE_ENDIAN_FORMAT = 1;
    public static final int RATE_CONVERSION_BYTE_FORMAT = 2;
    private static final boolean USE_REMOVE_DC = false;
    private boolean useMuLaw = false;
    private static final int MAX_RATE_IN = 11;
    private static final int UNROLLING_ORDER = 4;
    private static final int CORRECTION_FRAME_SIZE = 441;
    private static final int CONV_ERROR = -1;
    private static final int CONV_11to2 = 1;
    private static final int CONV_11to4 = 2;
    private static final int CONV_11to8 = 3;
    private static final int CONV_6to1 = 4;
    private static final int CONV_4to1 = 5;
    private static final int CONV_2to1 = 6;
    private static final int MAX_MEM_SIZE = 792;
    private static final float DCFACT = 0.9921875f;
    private static final float SHRT_MIN = -32767.0f;
    private static final float SHRT_MAX = 32767.0f;
    private static final float FRACTION_DELTA = 0.0022727272f;
    private static final float FRACTION_DELIMITER = 1.0011364f;
    private int bias;
    private int signMask;
    private int filterHistoryLength;
    private int decimFlag;
    private int numberOfInputChannels;
    private int numberOfOutputChannels;
    private boolean channels2To1 = false;
    private boolean channels1To2 = false;
    private boolean channels2To2 = false;
    private int rateIn;
    private int rateOut;
    private int[] index = new int[2];
    private int inputRemainedSamples;
    private int maxInputLength;
    private int paddingLength;
    private int maxDrainedSamples;
    private int pcmType;
    private int inputSampleSize;
    private float[] poly;
    private float[] x1;
    private float[] x2;
    private float[] y1;
    private float[] y2;
    private boolean needInputCorrection;
    private boolean isDrained;
    private boolean isRateConversionInited;
    private int delay;
    private float lastInputSample1;
    private float lastInputSample2;
    private float frac;
    private float prev_fsample1;
    private float prev_fsample2;
    private float fractionDelta = 0.0022727272f;
    private float fractionDelimiter;
    private int precisionCountDelimiter = 1;
    private int precisionCount;

    public int init(int maxInputBufferSize, int rateInput, int rateOutput, int inputChannels, int outputChannels, int pcmType, boolean signed, boolean useMuLaw) {
        int filterLength;
        this.useMuLaw = useMuLaw;
        this.inputSampleSize = 2;
        if (0 != pcmType && 1 != pcmType && 2 != pcmType) {
            return -4;
        }
        if (signed) {
            this.bias = 0;
            this.signMask = -1;
        } else {
            this.bias = 32768;
            this.signMask = 65535;
        }
        if (2 == pcmType) {
            this.inputSampleSize = 1;
        }
        this.pcmType = pcmType;
        this.maxInputLength = maxInputBufferSize / (this.inputSampleSize * inputChannels);
        this.numberOfInputChannels = inputChannels;
        this.numberOfOutputChannels = outputChannels;
        this.channels2To1 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1;
        this.channels1To2 = this.numberOfInputChannels == 1 && this.numberOfOutputChannels == 2;
        this.channels2To2 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 2;
        this.needInputCorrection = false;
        this.delay = 0;
        this.decimFlag = -1;
        if (rateInput == 44100 && rateOutput == 8000) {
            this.decimFlag = 1;
            this.rateIn = 11;
            this.rateOut = 2;
            this.needInputCorrection = true;
        } else if (rateInput == 22050 && rateOutput == 8000) {
            this.decimFlag = 2;
            this.rateIn = 11;
            this.rateOut = 4;
            this.needInputCorrection = true;
        } else if (rateInput == 11025 && rateOutput == 8000) {
            this.decimFlag = 3;
            this.rateIn = 11;
            this.rateOut = 8;
            this.needInputCorrection = true;
        } else if (rateInput == 48000 && rateOutput == 8000) {
            this.decimFlag = 4;
            this.rateIn = 6;
            this.rateOut = 1;
            this.needInputCorrection = false;
        } else if (rateInput == 32000 && rateOutput == 8000) {
            this.decimFlag = 5;
            this.rateIn = 4;
            this.rateOut = 1;
            this.needInputCorrection = false;
        } else if (rateInput == 16000 && rateOutput == 8000) {
            this.decimFlag = 6;
            this.rateIn = 2;
            this.rateOut = 1;
            this.needInputCorrection = false;
        } else if (rateInput == 11127 && rateOutput == 8000) {
            this.decimFlag = 3;
            this.rateIn = 11;
            this.rateOut = 8;
            this.needInputCorrection = true;
            this.fractionDelta = 0.011545454f;
            this.precisionCountDelimiter = 127;
        } else if (rateInput == 22254 && rateOutput == 8000) {
            this.decimFlag = 2;
            this.rateIn = 11;
            this.rateOut = 4;
            this.needInputCorrection = true;
            this.fractionDelta = 0.011545454f;
            this.precisionCountDelimiter = 127;
        } else if (rateInput == 22255 && rateOutput == 8000) {
            this.decimFlag = 2;
            this.rateIn = 11;
            this.rateOut = 4;
            this.needInputCorrection = true;
            this.fractionDelta = 0.011590909f;
            this.precisionCountDelimiter = 255;
        } else {
            this.close();
            return -2;
        }
        switch (this.decimFlag) {
            case 3: {
                this.filterHistoryLength = 25;
                this.delay = 9;
                filterLength = 200;
                break;
            }
            case 2: {
                this.filterHistoryLength = 50;
                this.delay = 9;
                filterLength = 200;
                break;
            }
            case 1: {
                this.filterHistoryLength = 100;
                this.delay = 9;
                filterLength = 200;
                break;
            }
            case 4: {
                this.filterHistoryLength = 128;
                this.delay = 11;
                filterLength = 128;
                break;
            }
            case 5: {
                this.filterHistoryLength = 128;
                this.delay = 16;
                filterLength = 128;
                break;
            }
            case 6: {
                this.filterHistoryLength = 64;
                this.delay = 16;
                filterLength = 64;
                break;
            }
            default: {
                this.close();
                return -2;
            }
        }
        this.poly = new float[filterLength];
        this.x1 = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
        this.y1 = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
        if (this.channels2To2) {
            this.x2 = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
            this.y2 = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
        }
        float gain = 1.0f;
        switch (this.decimFlag) {
            case 1: {
                gain = 2.0f;
                int i2 = 0;
                while (i2 < 2) {
                    int j2 = 0;
                    while (j2 < 100) {
                        this.poly[i2 * 100 + j2] = RateConversionTables.filter11[i2 + j2 * 2] * gain;
                        ++j2;
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                gain = 4.0f;
                int i2 = 0;
                while (i2 < 4) {
                    int j2 = 0;
                    while (j2 < 50) {
                        this.poly[i2 * 50 + j2] = RateConversionTables.filter11[i2 + j2 * 4] * gain;
                        ++j2;
                    }
                    ++i2;
                }
                break;
            }
            case 3: {
                gain = 8.0f;
                int i2 = 0;
                while (i2 < 8) {
                    int j2 = 0;
                    while (j2 < 25) {
                        this.poly[i2 * 25 + j2] = RateConversionTables.filter11[i2 + j2 * 8] * gain;
                        ++j2;
                    }
                    ++i2;
                }
                break;
            }
            case 4: {
                int i2 = 0;
                while (i2 < 128) {
                    this.poly[i2] = RateConversionTables.filter6[i2];
                    ++i2;
                }
                break;
            }
            case 5: {
                int i2 = 0;
                while (i2 < 128) {
                    this.poly[i2] = RateConversionTables.filter4[i2];
                    ++i2;
                }
                break;
            }
            case 6: {
                int i2 = 0;
                while (i2 < 64) {
                    this.poly[i2] = RateConversionTables.filter2[i2];
                    ++i2;
                }
                break;
            }
        }
        this.paddingLength = this.filterHistoryLength / 2;
        this.maxDrainedSamples = (int)((float)((this.paddingLength + 4 * this.rateIn * 2) * this.rateOut) / (float)this.rateIn);
        this.isRateConversionInited = true;
        this.fractionDelimiter = 1.0f + this.fractionDelta / 2.0f;
        this.reset();
        return -1;
    }

    public int reset() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        this.inputRemainedSamples = 0;
        this.isDrained = false;
        this.frac = 1.0f;
        this.precisionCount = this.precisionCountDelimiter - 1;
        this.prev_fsample1 = 0.0f;
        this.prev_fsample2 = 0.0f;
        int i2 = 0;
        while (i2 < this.filterHistoryLength) {
            this.x1[i2] = 0.0f;
            ++i2;
        }
        this.index[0] = 0;
        if (this.channels2To2) {
            i2 = 0;
            while (i2 < this.filterHistoryLength) {
                this.x2[i2] = 0.0f;
                ++i2;
            }
            this.index[1] = 0;
        }
        this.lastInputSample1 = 0.0f;
        this.lastInputSample2 = 0.0f;
        return -1;
    }

    public void close() {
        this.isRateConversionInited = false;
        this.x1 = null;
        this.x2 = null;
        this.y1 = null;
        this.y2 = null;
        this.poly = null;
    }

    public int getDelay() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int outputDelayLength = this.delay;
        if (!this.useMuLaw) {
            outputDelayLength *= 2;
        }
        return outputDelayLength;
    }

    public int process(byte[] inputData, int inputDataOffset, int inputDataLength, byte[] output, int outputDataOffset) {
        if (!this.isRateConversionInited) {
            return -3;
        }
        if (!this.isDrained && inputDataLength > this.maxInputLength * this.inputSampleSize * this.numberOfInputChannels) {
            this.enlargeBufferAllocation(inputDataLength);
        }
        if (0 == inputDataLength) {
            return 0;
        }
        int inputOffset = this.inputRemainedSamples + this.filterHistoryLength;
        inputDataLength = this.extractInput(inputData, inputDataOffset, inputDataLength, inputOffset);
        int inputLength = inputDataLength + this.inputRemainedSamples;
        int inputBlocks = inputLength / (4 * this.rateIn);
        this.inputRemainedSamples = inputLength - inputBlocks * (4 * this.rateIn);
        inputOffset = this.inputRemainedSamples + this.filterHistoryLength;
        if ((inputLength -= this.inputRemainedSamples) == 0) {
            return 0;
        }
        int outputLength = inputLength / this.rateIn * this.rateOut;
        int numberOfChannels = 1;
        if (this.channels2To2) {
            numberOfChannels = 2;
        }
        int i2 = 0;
        while (i2 < numberOfChannels) {
            float[] y;
            float[] x;
            if (i2 > 0) {
                x = this.x2;
                y = this.y2;
            } else {
                x = this.x1;
                y = this.y1;
            }
            switch (this.decimFlag) {
                case 3: {
                    this.index[i2] = this.downsampleMtoL(x, y, this.index[i2], this.poly, 25, 8, 11, (outputLength >> 5) * 11, outputLength >> 2);
                    break;
                }
                case 2: {
                    this.index[i2] = this.downsampleMtoL(x, y, this.index[i2], this.poly, 50, 4, 11, (outputLength >> 4) * 11, outputLength >> 2);
                    break;
                }
                case 1: {
                    this.index[i2] = this.downsampleMtoL(x, y, this.index[i2], this.poly, 100, 2, 11, (outputLength >> 3) * 11, outputLength >> 2);
                    break;
                }
                case 4: {
                    this.downsampleM(x, y, this.poly, 128, 6, outputLength);
                    break;
                }
                case 5: {
                    this.downsampleM(x, y, this.poly, 128, 4, outputLength);
                    break;
                }
                case 6: {
                    this.downsampleM(x, y, this.poly, 64, 2, outputLength);
                }
            }
            int j2 = 0;
            while (j2 < inputOffset) {
                x[j2] = x[j2 + inputLength];
                ++j2;
            }
            ++i2;
        }
        if (!this.useMuLaw) {
            if (this.numberOfOutputChannels == 1) {
                this.Fl2Byte(this.y1, outputLength, output, outputDataOffset);
                return 2 * outputLength;
            }
            if (this.channels1To2) {
                this.y2 = this.y1;
            }
            this.Fl2ByteStereo(this.y1, this.y2, outputLength, output, outputDataOffset);
            return 4 * outputLength;
        }
        this.convertToMuLaw(this.y1, outputLength, output, outputDataOffset);
        return outputLength;
    }

    public int drain(byte[] output, int outputOffset) {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int inputSamples = (this.paddingLength + 4 * this.rateIn) * this.numberOfInputChannels * this.inputSampleSize;
        this.isDrained = true;
        int actualOutputSamples = (int)((float)((this.paddingLength + this.inputRemainedSamples) * this.rateOut) / (float)this.rateIn);
        if (!this.useMuLaw) {
            actualOutputSamples *= 2;
        }
        int numberOfOutputSamples = this.process(null, 0, inputSamples, output, outputOffset);
        this.isDrained = false;
        if (actualOutputSamples < numberOfOutputSamples) {
            numberOfOutputSamples = actualOutputSamples;
        }
        return numberOfOutputSamples;
    }

    public int getMaxOutputLength() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int outputLength = (this.maxInputLength + this.rateIn * 4) * this.rateOut / this.rateIn;
        if (!this.useMuLaw) {
            outputLength *= 2;
        }
        return outputLength;
    }

    public int getMaxOutputLength(int inputLength) {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int inputSamples = inputLength / (this.inputSampleSize * this.numberOfInputChannels);
        int outputLength = (inputSamples + this.rateIn * 4) * this.rateOut / this.rateIn;
        if (!this.useMuLaw) {
            outputLength *= 2;
        }
        return outputLength *= this.numberOfOutputChannels;
    }

    public int getDrainMaxLength() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int drainMaxLength = this.maxDrainedSamples;
        if (!this.useMuLaw) {
            drainMaxLength *= 2;
        }
        return drainMaxLength;
    }

    private void convertToMuLaw(float[] inBuffer, int Len, byte[] outBuffer, int indexOut) {
        int i2 = 0;
        while (i2 < Len) {
            int signBit;
            float inSample = inBuffer[i2];
            if (inSample < -32767.0f) {
                inSample = -32767.0f;
            } else if (inSample > 32767.0f) {
                inSample = 32767.0f;
            }
            int sample = (int)inSample;
            if (sample >= 0) {
                signBit = 128;
            } else {
                sample = -sample;
                signBit = 0;
            }
            sample = 132 + sample >> 3;
            outBuffer[indexOut++] = sample < 32 ? (byte)(signBit | 0x70 | 31 - (sample >> 0)) : (sample < 64 ? (byte)(signBit | 0x60 | 31 - (sample >> 1)) : (sample < 128 ? (byte)(signBit | 0x50 | 31 - (sample >> 2)) : (sample < 256 ? (byte)(signBit | 0x40 | 31 - (sample >> 3)) : (sample < 512 ? (byte)(signBit | 0x30 | 31 - (sample >> 4)) : (sample < 1024 ? (byte)(signBit | 0x20 | 31 - (sample >> 5)) : (sample < 2048 ? (byte)(signBit | 0x10 | 31 - (sample >> 6)) : (sample < 4096 ? (byte)(signBit | 0 | 31 - (sample >> 7)) : (byte)(signBit | 0 | 0))))))));
            ++i2;
        }
    }

    private final void Fl2Byte(float[] inBuffer, int Len, byte[] outBuffer, int indexOut) {
        int j2 = 0;
        int i2 = 0;
        while (i2 < Len) {
            float sample = inBuffer[i2];
            if (sample < -32767.0f) {
                sample = -32767.0f;
            } else if (sample > 32767.0f) {
                sample = 32767.0f;
            }
            int TempInt = (int)sample;
            outBuffer[indexOut + j2] = (byte)(TempInt & 0xFF);
            outBuffer[indexOut + j2 + 1] = (byte)(TempInt >> 8);
            j2 += 2;
            ++i2;
        }
    }

    private final void Fl2ByteStereo(float[] inBuffer1, float[] inBuffer2, int Len, byte[] outBuffer, int indexOut) {
        int j2 = 0;
        int i2 = 0;
        while (i2 < Len) {
            float sample = inBuffer1[i2];
            if (sample < -32767.0f) {
                sample = -32767.0f;
            } else if (sample > 32767.0f) {
                sample = 32767.0f;
            }
            int TempInt = (int)sample;
            outBuffer[indexOut + j2] = (byte)(TempInt & 0xFF);
            outBuffer[indexOut + j2 + 1] = (byte)(TempInt >> 8);
            sample = inBuffer2[i2];
            if (sample < -32767.0f) {
                sample = -32767.0f;
            } else if (sample > 32767.0f) {
                sample = 32767.0f;
            }
            TempInt = (int)sample;
            outBuffer[indexOut + j2 + 2] = (byte)(TempInt & 0xFF);
            outBuffer[indexOut + j2 + 3] = (byte)(TempInt >> 8);
            j2 += 4;
            ++i2;
        }
    }

    private int extractInput(byte[] input, int inputOffset, int inputLength, int internalBufferOffset) {
        int msbOffset;
        int lsbOffset;
        int internalBufferIndex = internalBufferOffset;
        float fsample1 = 0.0f;
        float fsample2 = 0.0f;
        int sample1 = 0;
        int sample2 = 0;
        boolean inputSample = false;
        if (this.isDrained) {
            int length = inputLength / (this.numberOfInputChannels * this.inputSampleSize);
            int i2 = 0;
            while (i2 < length) {
                this.x1[internalBufferIndex + i2] = 0.0f;
                ++i2;
            }
            if (this.channels2To2) {
                i2 = 0;
                while (i2 < length) {
                    this.x2[internalBufferIndex + i2] = 0.0f;
                    ++i2;
                }
            }
            return length;
        }
        if (this.pcmType == 1) {
            lsbOffset = -1;
            msbOffset = 1;
        } else {
            lsbOffset = 1;
            msbOffset = 0;
        }
        int i2 = inputOffset + msbOffset;
        while (i2 < inputLength + inputOffset) {
            if (1 == this.inputSampleSize) {
                sample1 = input[i2++] << 8;
                if (this.numberOfInputChannels == 2) {
                    sample2 = input[i2++] << 8;
                }
            } else {
                sample1 = (input[i2] << 8) + (0xFF & input[i2 + lsbOffset]);
                i2 += 2;
                if (this.numberOfInputChannels == 2) {
                    sample2 = (input[i2] << 8) + (0xFF & input[i2 + lsbOffset]);
                    i2 += 2;
                }
            }
            if (this.channels2To1) {
                sample1 = (sample1 & this.signMask) + (sample2 & this.signMask) >> 1;
            }
            fsample1 = (short)(sample1 + this.bias);
            if (this.channels2To2) {
                fsample2 = (short)(sample2 + this.bias);
            }
            if (this.channels1To2) {
                fsample2 = fsample1;
            }
            if (this.needInputCorrection) {
                if (this.frac > this.fractionDelimiter) {
                    ++this.precisionCount;
                    if (this.precisionCount == this.precisionCountDelimiter) {
                        this.precisionCount = 0;
                        this.frac = this.fractionDelta;
                    } else {
                        this.frac -= 1.0f;
                    }
                    this.prev_fsample1 = fsample1;
                    this.prev_fsample2 = fsample2;
                    continue;
                }
                this.x1[internalBufferIndex] = this.prev_fsample1 * (1.0f - this.frac) + this.frac * fsample1;
                this.prev_fsample1 = fsample1;
                if (this.channels2To2) {
                    this.x2[internalBufferIndex] = this.prev_fsample2 * (1.0f - this.frac) + this.frac * fsample2;
                    this.prev_fsample2 = fsample2;
                }
                this.frac += this.fractionDelta;
            } else {
                this.x1[internalBufferIndex] = fsample1;
                if (this.channels2To2) {
                    this.x2[internalBufferIndex] = fsample2;
                }
            }
            ++internalBufferIndex;
        }
        return internalBufferIndex - internalBufferOffset;
    }

    private float remove_dc(float[] input, int inputOffset, float previous_sample, int length) {
        return 0.0f;
    }

    private int downsampleMtoL(float[] x, float[] y, int index, float[] poly, int poly_length, int interpolation_factor, int decimation_factor, int input_block_size, int output_block_size) {
        int m2 = 0;
        int n2 = 0;
        while (n2 < output_block_size) {
            float sum3 = 0.0f;
            float sum2 = 0.0f;
            float sum1 = 0.0f;
            float sum0 = 0.0f;
            int offset = index * poly_length;
            int j2 = 0;
            while (j2 < poly_length) {
                float polySample = poly[offset + j2];
                sum0 += polySample * x[j2 + m2];
                sum1 += polySample * x[j2 + m2 + 1 * input_block_size];
                sum2 += polySample * x[j2 + m2 + 2 * input_block_size];
                sum3 += polySample * x[j2 + m2 + 3 * input_block_size];
                ++j2;
            }
            y[n2 + 1 * output_block_size] = sum1;
            y[n2 + 2 * output_block_size] = sum2;
            y[n2 + 3 * output_block_size] = sum3;
            y[n2] = sum0;
            while (index < decimation_factor) {
                index += interpolation_factor;
                ++m2;
            }
            index -= decimation_factor;
            ++n2;
        }
        return index;
    }

    void downsampleM(float[] x, float[] y, float[] filter, int filter_length, int decimation_factor, int output_length) {
        int filt_length = filter_length / 2;
        int offset_inc = decimation_factor * 4;
        int sym_offset = filter_length - 1;
        int offset1 = 0;
        int n2 = 0;
        while (n2 < output_length) {
            float sum3 = 0.0f;
            float sum2 = 0.0f;
            float sum1 = 0.0f;
            float sum0 = 0.0f;
            int offset2 = offset1 + decimation_factor;
            int offset3 = offset2 + decimation_factor;
            int offset4 = offset3 + decimation_factor;
            int i2 = 0;
            while (i2 < filt_length) {
                float filterSample = filter[i2];
                sum0 += filterSample * (x[offset1 + i2] + x[offset1 + sym_offset - i2]);
                sum1 += filterSample * (x[offset2 + i2] + x[offset2 + sym_offset - i2]);
                sum2 += filterSample * (x[offset3 + i2] + x[offset3 + sym_offset - i2]);
                sum3 += filterSample * (x[offset4 + i2] + x[offset4 + sym_offset - i2]);
                ++i2;
            }
            y[n2++] = sum0;
            y[n2++] = sum1;
            y[n2++] = sum2;
            y[n2++] = sum3;
            offset1 += offset_inc;
        }
    }

    private void enlargeBufferAllocation(int length) {
        this.maxInputLength = length / (this.inputSampleSize * this.numberOfInputChannels);
        float[] inputBuffer = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
        float[] outputBuffer = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
        int i2 = 0;
        while (i2 < this.x1.length) {
            inputBuffer[i2] = this.x1[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.y1.length) {
            outputBuffer[i2] = this.y1[i2];
            ++i2;
        }
        this.x1 = inputBuffer;
        this.y1 = outputBuffer;
        if (this.channels2To2) {
            inputBuffer = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
            outputBuffer = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
            i2 = 0;
            while (i2 < this.x2.length) {
                inputBuffer[i2] = this.x2[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.y2.length) {
                outputBuffer[i2] = this.y2[i2];
                ++i2;
            }
            this.x2 = inputBuffer;
            this.y2 = outputBuffer;
        }
    }
}

