/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io;

import com.sun.j3d.utils.scenegraph.io.NamedObjectException;
import com.sun.j3d.utils.scenegraph.io.UnsupportedUniverseException;
import com.sun.j3d.utils.scenegraph.io.retained.RandomAccessFileControl;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.SceneGraphObject;

public class SceneGraphFileWriter {
    private RandomAccessFileControl fileControl = new RandomAccessFileControl();
    private File file;

    public SceneGraphFileWriter(File file, SimpleUniverse simpleUniverse, boolean bl, String string, Serializable serializable) throws IOException, UnsupportedUniverseException {
        this.file = file;
        file.createNewFile();
        if (!file.canWrite()) {
            throw new IOException("Can not Write to File");
        }
        this.fileControl.createFile(file, simpleUniverse, bl, string, serializable);
    }

    public void writeBranchGraph(BranchGroup branchGroup) throws IOException {
        this.writeBranchGraph(branchGroup, null);
    }

    public void writeBranchGraph(BranchGroup branchGroup, Serializable serializable) throws IOException {
        this.fileControl.writeBranchGraph(branchGroup, serializable);
    }

    public void addObjectName(String string, SceneGraphObject sceneGraphObject) throws NamedObjectException {
        this.fileControl.addNamedObject(string, sceneGraphObject);
    }

    public void close() throws IOException {
        this.fileControl.close();
    }
}

