/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.ImageLayout;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PlotCanvas;
import ij.gui.PlotDialog;
import ij.gui.PlotMaker;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.RoiListener;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ItemListener,
ClipboardOwner,
ImageListener,
RoiListener,
Runnable {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static boolean listValues;
    public static boolean interpolate;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final int FONT_SIZE = 12;
    public static int plotWidth;
    public static int plotHeight;
    public static int fontSize;
    public static boolean noGridLines;
    public static boolean noTicks;
    private static final String PREFS_WIDTH = "pp.width";
    private static final String PREFS_HEIGHT = "pp.height";
    private static final String PREFS_FONT_SIZE = "pp.fontsize";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private static final int NO_TICKS = 32;
    private static String moreButtonLabel;
    private Button list;
    private Button save;
    private Button more;
    private Button live;
    private PopupMenu popupMenu;
    private MenuItem[] menuItems;
    private Label coordinates;
    private static String defaultDirectory;
    private static int options;
    private int defaultDigits = -1;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    boolean layoutDone;
    private String blankLabel = "                       ";
    private PlotMaker plotMaker;
    private ImagePlus srcImp;
    private Thread bgThread;
    private boolean doUpdate;
    private Roi[] rangeArrowRois;
    private boolean rangeArrowsVisible;
    private int activeRangeArrow = -1;
    private static int COPY;
    private static int COPY_ALL;
    private static int SET_RANGE;
    private static int PREV_RANGE;
    private static int RESET_RANGE;
    private static int FIT_RANGE;
    private static int ZOOM_SELECTION;
    private static int AXIS_OPTIONS;
    private static int LEGEND;
    private static int RESET_PLOT;
    private static int FREEZE;
    private static int HI_RESOLUTION;
    private static int PROFILE_PLOT_OPTIONS;
    private static int[] DISABLED_WHEN_FROZEN;

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(PlotWindow.createImage(title, xLabel, yLabel, xValues, yValues));
        this.plot = staticPlot;
        ((PlotCanvas)this.getCanvas()).setPlot(this.plot);
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
    }

    PlotWindow(Plot plot) {
        super(plot.getImagePlus());
        ((PlotCanvas)this.getCanvas()).setPlot(plot);
        this.plot = plot;
        this.draw();
    }

    static ImagePlus createImage(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        staticPlot = new Plot(title, xLabel, yLabel, xValues, yValues);
        return new ImagePlus(title, staticPlot.getBlankProcessor());
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.plot.setLimits(xMin, xMax, yMin, yMax);
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.plot.addPoints(x, y, shape);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addErrorBars(float[] errorBars) {
        this.plot.addErrorBars(errorBars);
    }

    public void addLabel(double x, double y, String label) {
        this.plot.addLabel(x, y, label);
    }

    public void setColor(Color c) {
        this.plot.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.plot.setLineWidth(lineWidth);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel bottomPanel = new Panel();
        int hgap = IJ.isMacOSX() ? 1 : 5;
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        bottomPanel.add(this.list);
        bottomPanel.setLayout(new FlowLayout(2, hgap, 0));
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        bottomPanel.add(this.save);
        this.more = new Button(moreButtonLabel);
        this.more.addActionListener(this);
        bottomPanel.add(this.more);
        if (this.plot != null && this.plot.getPlotMaker() != null) {
            this.live = new Button("Live");
            this.live.addActionListener(this);
            bottomPanel.add(this.live);
        }
        this.coordinates = new Label(this.blankLabel);
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        this.coordinates.setBackground(new Color(220, 220, 220));
        bottomPanel.add(this.coordinates);
        this.add(bottomPanel);
        this.more.add(this.getPopupMenu());
        this.plot.draw();
        LayoutManager lm = this.getLayout();
        if (lm instanceof ImageLayout) {
            ((ImageLayout)lm).ignoreNonImageWidths(true);
        }
        this.pack();
        ImageProcessor ip = this.plot.getProcessor();
        if (ip instanceof ColorProcessor && this.imp.getProcessor() instanceof ByteProcessor) {
            this.imp.setProcessor(null, ip);
        } else {
            this.imp.updateAndDraw();
        }
        this.layoutDone = true;
        if (listValues) {
            this.showList();
        } else {
            this.ic.requestFocus();
        }
    }

    public void dispose() {
        this.plot.dispose();
        this.plot = null;
        this.plotMaker = null;
        this.srcImp = null;
        super.dispose();
    }

    void updateMinimumSize() {
        if (this.plot == null) {
            return;
        }
        Dimension d1 = this.getExtraSize();
        Dimension d2 = this.plot.getMinimumSize();
        this.setMinimumSize(new Dimension(d1.width + d2.width, d1.height + d2.height));
    }

    PopupMenu getPopupMenu() {
        this.popupMenu = new PopupMenu();
        this.menuItems = new MenuItem[13];
        this.menuItems[PlotWindow.COPY] = this.addPopupItem(this.popupMenu, "Copy 1st Data Set");
        this.menuItems[PlotWindow.COPY_ALL] = this.addPopupItem(this.popupMenu, "Copy All Data");
        this.popupMenu.addSeparator();
        this.menuItems[PlotWindow.SET_RANGE] = this.addPopupItem(this.popupMenu, "Set Range...");
        this.menuItems[PlotWindow.PREV_RANGE] = this.addPopupItem(this.popupMenu, "Previous Range");
        this.menuItems[PlotWindow.RESET_RANGE] = this.addPopupItem(this.popupMenu, "Reset Range");
        this.menuItems[PlotWindow.FIT_RANGE] = this.addPopupItem(this.popupMenu, "Set Range to Fit All");
        this.menuItems[PlotWindow.ZOOM_SELECTION] = this.addPopupItem(this.popupMenu, "Zoom to Selection");
        this.popupMenu.addSeparator();
        this.menuItems[PlotWindow.AXIS_OPTIONS] = this.addPopupItem(this.popupMenu, "Axis Options...");
        this.menuItems[PlotWindow.LEGEND] = this.addPopupItem(this.popupMenu, "Legend...");
        this.menuItems[PlotWindow.RESET_PLOT] = this.addPopupItem(this.popupMenu, "Reset Format");
        this.menuItems[PlotWindow.FREEZE] = this.addPopupItem(this.popupMenu, "Freeze Plot", true);
        this.menuItems[PlotWindow.HI_RESOLUTION] = this.addPopupItem(this.popupMenu, "High-Resolution Plot...");
        this.popupMenu.addSeparator();
        this.menuItems[PlotWindow.PROFILE_PLOT_OPTIONS] = this.addPopupItem(this.popupMenu, "Profile & Plot Options...");
        return this.popupMenu;
    }

    MenuItem addPopupItem(PopupMenu popupMenu, String s) {
        return this.addPopupItem(popupMenu, s, false);
    }

    MenuItem addPopupItem(PopupMenu popupMenu, String s, boolean isCheckboxItem) {
        MenuItem mi = null;
        if (isCheckboxItem) {
            mi = new CheckboxMenuItem(s);
            ((CheckboxMenuItem)mi).addItemListener(this);
        } else {
            mi = new MenuItem(s);
            mi.addActionListener(this);
        }
        popupMenu.add(mi);
        return mi;
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.live) {
            this.toggleLiveProfiling();
        } else if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else if (b == this.more) {
            boolean frozen = this.plot.isFrozen();
            ((CheckboxMenuItem)this.menuItems[FREEZE]).setState(frozen);
            for (int i : DISABLED_WHEN_FROZEN) {
                this.menuItems[i].setEnabled(!frozen);
            }
            this.popupMenu.show((Component)b, 1, 1);
        } else if (b == this.menuItems[COPY]) {
            this.copyToClipboard(false);
        } else if (b == this.menuItems[COPY_ALL]) {
            this.copyToClipboard(true);
        } else if (b == this.menuItems[ZOOM_SELECTION]) {
            if (this.imp != null && this.imp.getRoi() != null && this.imp.getRoi().isArea()) {
                this.plot.zoomToRect(this.imp.getRoi().getBounds());
            }
        } else if (b == this.menuItems[SET_RANGE]) {
            new PlotDialog(this.plot, 0).showDialog(this);
        } else if (b == this.menuItems[PREV_RANGE]) {
            this.plot.setPreviousMinMax();
        } else if (b == this.menuItems[RESET_RANGE]) {
            this.plot.setLimitsToDefaults(true);
        } else if (b == this.menuItems[FIT_RANGE]) {
            this.plot.setLimitsToFit(true);
        } else if (b == this.menuItems[AXIS_OPTIONS]) {
            new PlotDialog(this.plot, 1).showDialog(this);
        } else if (b == this.menuItems[LEGEND]) {
            new PlotDialog(this.plot, 2).showDialog(this);
        } else if (b == this.menuItems[RESET_PLOT]) {
            this.plot.setFont(0, Prefs.getInt(PREFS_FONT_SIZE, 12));
            this.plot.setAxisLabelFont(0, Prefs.getInt(PREFS_FONT_SIZE, 12));
            this.plot.setFormatFlags(Plot.getDefaultFlags());
            this.plot.setFrameSize(plotWidth, plotHeight);
        } else if (b == this.menuItems[HI_RESOLUTION]) {
            new PlotDialog(this.plot, 3).showDialog(this);
        } else if (b == this.menuItems[PROFILE_PLOT_OPTIONS]) {
            IJ.doCommand("Profile Plot Options...");
        }
        this.ic.requestFocus();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.menuItems[FREEZE]) {
            boolean frozen = ((CheckboxMenuItem)this.menuItems[FREEZE]).getState();
            this.plot.setFrozen(frozen);
        }
    }

    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.plot == null) {
            return;
        }
        if (this.coordinates != null) {
            String coords = this.plot.getCoordinates(x, y) + this.blankLabel;
            this.coordinates.setText(coords.substring(0, this.blankLabel.length()));
        }
        if (x < this.plot.leftMargin || y > this.plot.topMargin + this.plot.frameHeight) {
            int i;
            if (!this.rangeArrowsVisible && !this.plot.isFrozen()) {
                this.showRangeArrows();
            }
            if (this.activeRangeArrow >= 0 && !this.rangeArrowRois[this.activeRangeArrow].contains(x, y)) {
                this.rangeArrowRois[this.activeRangeArrow].setFillColor(Color.GRAY);
                this.ic.repaint();
                this.activeRangeArrow = -1;
            }
            if (this.activeRangeArrow < 0 && (i = this.getRangeArrowIndex(x, y)) >= 0) {
                this.rangeArrowRois[i].setFillColor(Color.RED);
                this.activeRangeArrow = i;
                this.ic.repaint();
            }
        } else if (this.rangeArrowsVisible) {
            this.hideRangeArrows();
        }
    }

    void mouseExited(MouseEvent e) {
        if (this.rangeArrowsVisible) {
            this.hideRangeArrows();
        }
    }

    public synchronized void mouseWheelMoved(MouseWheelEvent e) {
        boolean ctrl;
        if (this.plot.isFrozen() || !(this.ic instanceof PlotCanvas)) {
            super.mouseWheelMoved(e);
            return;
        }
        int rotation = e.getWheelRotation();
        int amount = e.getScrollAmount();
        boolean bl = ctrl = (e.getModifiers() & 2) != 0;
        if (amount < 1) {
            amount = 1;
        }
        if (rotation == 0) {
            return;
        }
        if (ctrl || IJ.shiftKeyDown()) {
            double zoomFactor = rotation < 0 ? Math.pow(2.0, 0.2) : Math.pow(0.5, 0.2);
            Point loc = this.ic.getCursorLoc();
            int x = this.ic.screenX(loc.x);
            int y = this.ic.screenY(loc.y);
            ((PlotCanvas)this.ic).zoom(x, y, zoomFactor);
        } else if (IJ.spaceBarDown()) {
            this.plot.scroll(rotation * amount * Math.max(this.ic.imageWidth / 50, 1), 0);
        } else {
            this.plot.scroll(0, rotation * amount * Math.max(this.ic.imageHeight / 50, 1));
        }
    }

    void showRangeArrows() {
        if (this.imp == null) {
            return;
        }
        this.hideRangeArrows();
        this.rangeArrowRois = new Roi[8];
        int i = 0;
        int height = this.imp.getHeight();
        int arrowH = this.plot.topMargin < 14 ? 6 : 8;
        float[] yP = new float[]{height - arrowH / 2, height - 3 * arrowH / 2, (float)(height - 5 * arrowH / 2) - 0.1f};
        for (float x : new float[]{this.plot.leftMargin, this.plot.leftMargin + this.plot.frameWidth}) {
            float[] x0 = new float[]{x - (float)(arrowH / 2), x - (float)(3 * arrowH / 2) - 0.1f, x - (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(x0, yP, 3, 2);
            float[] x1 = new float[]{x + (float)(arrowH / 2), x + (float)(3 * arrowH / 2) + 0.1f, x + (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(x1, yP, 3, 2);
        }
        float[] xP = new float[]{(float)(arrowH / 2) - 0.1f, 3 * arrowH / 2, (float)(5 * arrowH / 2) + 0.1f};
        for (float y : new float[]{this.plot.topMargin + this.plot.frameHeight, this.plot.topMargin}) {
            float[] y0 = new float[]{y + (float)(arrowH / 2), y + (float)(3 * arrowH / 2) + 0.1f, y + (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(xP, y0, 3, 2);
            float[] y1 = new float[]{y - (float)(arrowH / 2), y - (float)(3 * arrowH / 2) - 0.1f, y - (float)(arrowH / 2)};
            this.rangeArrowRois[i++] = new PolygonRoi(xP, y1, 3, 2);
        }
        Overlay ovly = this.imp.getOverlay();
        if (ovly == null) {
            ovly = new Overlay();
        }
        for (Roi roi : this.rangeArrowRois) {
            roi.setFillColor(Color.GRAY);
            ovly.add(roi);
        }
        this.imp.setOverlay(ovly);
        this.ic.repaint();
        this.rangeArrowsVisible = true;
    }

    void hideRangeArrows() {
        if (this.imp == null || this.rangeArrowRois == null) {
            return;
        }
        Overlay ovly = this.imp.getOverlay();
        if (ovly == null) {
            return;
        }
        for (Roi roi : this.rangeArrowRois) {
            ovly.remove(roi);
        }
        this.ic.repaint();
        this.rangeArrowsVisible = false;
        this.activeRangeArrow = -1;
    }

    int getRangeArrowIndex(int x, int y) {
        if (!this.rangeArrowsVisible) {
            return -1;
        }
        for (int i = 0; i < this.rangeArrowRois.length; ++i) {
            if (!this.rangeArrowRois[i].getBounds().contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    void showList() {
        ResultsTable rt = this.plot.getResultsTable(saveXValues);
        rt.show("Plot Values");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public ResultsTable getResultsTable() {
        return this.plot.getResultsTable(saveXValues);
    }

    private String getValuesAsString() {
        ResultsTable rt = this.getResultsTable();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rt.size(); ++i) {
            sb.append(rt.getRowAsString(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    void saveAsText() {
        if (this.plot.getXValues() == null) {
            IJ.error("Plot has no data");
            return;
        }
        SaveDialog sd = new SaveDialog("Save as Text", "Values", Prefs.defaultResultsExtension());
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        ResultsTable rt = this.getResultsTable();
        try {
            rt.saveAs(directory + name);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard(boolean writeAllColumns) {
        float[] xValues = this.plot.getXValues();
        float[] yValues = this.plot.getYValues();
        if (xValues == null) {
            return;
        }
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        CharArrayWriter aw = new CharArrayWriter(10 * xValues.length);
        PrintWriter pw = new PrintWriter(aw);
        if (writeAllColumns) {
            ResultsTable rt = this.plot.getResultsTable(true);
            if (!Prefs.dontSaveHeaders) {
                String headings = rt.getColumnHeadings();
                pw.println(headings);
            }
            for (int i = 0; i < rt.size(); ++i) {
                pw.println(rt.getRowAsString(i));
            }
        } else {
            int xdigits = 0;
            if (saveXValues) {
                xdigits = Plot.getPrecision(xValues);
            }
            int ydigits = Plot.getPrecision(yValues);
            for (int i = 0; i < Math.min(xValues.length, yValues.length); ++i) {
                if (saveXValues) {
                    pw.println(IJ.d2s(xValues[i], xdigits) + "\t" + IJ.d2s(yValues[i], ydigits));
                    continue;
                }
                pw.println(IJ.d2s(yValues[i], ydigits));
            }
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public float[] getXValues() {
        return this.plot.getXValues();
    }

    public float[] getYValues() {
        return this.plot.getYValues();
    }

    public void drawPlot(Plot plot) {
        this.plot = plot;
        if (this.imp != null) {
            if (this.ic instanceof PlotCanvas) {
                ((PlotCanvas)this.ic).setPlot(plot);
            }
            this.imp.setProcessor(null, plot.getProcessor());
            plot.setImagePlus(this.imp);
        }
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PREFS_WIDTH, Integer.toString(plotWidth));
            prefs.put(PREFS_HEIGHT, Integer.toString(plotHeight));
            prefs.put(PREFS_FONT_SIZE, Integer.toString(fontSize));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose && !listValues) {
            options |= 2;
        }
        if (listValues) {
            options |= 4;
        }
        if (!interpolate) {
            options |= 8;
        }
        if (noGridLines) {
            options |= 0x10;
        }
        if (noTicks) {
            options |= 0x20;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    private void toggleLiveProfiling() {
        boolean liveMode;
        boolean bl = liveMode = this.live.getForeground() == Color.red;
        if (liveMode) {
            this.removeListeners();
        } else {
            this.enableLiveProfiling();
        }
    }

    private void enableLiveProfiling() {
        if (this.plotMaker == null) {
            PlotMaker plotMaker = this.plotMaker = this.plot != null ? this.plot.getPlotMaker() : null;
        }
        if (this.plotMaker != null && this.bgThread == null) {
            this.srcImp = this.plotMaker.getSourceImage();
            if (this.srcImp == null) {
                return;
            }
            this.bgThread = new Thread((Runnable)this, "Live Profiler");
            this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
            this.bgThread.start();
            this.imageUpdated(this.srcImp);
        }
        this.createListeners();
        if (this.srcImp != null) {
            this.imageUpdated(this.srcImp);
        }
    }

    public synchronized void roiModified(ImagePlus img, int id) {
        if (IJ.debugMode) {
            IJ.log("PlotWindow.roiModified: " + img + "  " + id);
        }
        if (img == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    public void imageOpened(ImagePlus imp) {
    }

    public synchronized void imageUpdated(ImagePlus imp) {
        if (imp == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    public void imageClosed(ImagePlus imp) {
        if (imp == this.srcImp || imp == this.imp) {
            if (this.bgThread != null) {
                this.bgThread.interrupt();
            }
            this.bgThread = null;
            this.removeListeners();
            this.srcImp = null;
            this.plotMaker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            IJ.wait(50);
            Plot plot = this.plotMaker.getPlot();
            if (this.doUpdate && plot != null) {
                plot.useTemplate(this.plot, this.plot.templateFlags);
                plot.setPlotMaker(this.plotMaker);
                this.plot = plot;
                ((PlotCanvas)this.ic).setPlot(plot);
                ImageProcessor ip = plot.getProcessor();
                if (ip != null && this.imp != null) {
                    this.imp.setProcessor(null, ip);
                    plot.setImagePlus(this.imp);
                }
            }
            PlotWindow plotWindow = this;
            synchronized (plotWindow) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    private void createListeners() {
        if (IJ.debugMode) {
            IJ.log("PlotWindow.createListeners");
        }
        if (this.srcImp == null) {
            return;
        }
        ImagePlus.addImageListener(this);
        Roi.addRoiListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 1, font.getSize()));
        this.live.setForeground(Color.red);
    }

    private void removeListeners() {
        if (IJ.debugMode) {
            IJ.log("PlotWindow.removeListeners");
        }
        if (this.srcImp == null) {
            return;
        }
        ImagePlus.removeImageListener(this);
        Roi.removeRoiListener(this);
        Font font = this.live.getFont();
        this.live.setFont(new Font(font.getName(), 0, font.getSize()));
        this.live.setForeground(Color.black);
    }

    public Plot getPlot() {
        return this.plot;
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        fontSize = 12;
        moreButtonLabel = "More \u00bb";
        defaultDirectory = null;
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PREFS_WIDTH, 450);
        plotHeight = Prefs.getInt(PREFS_HEIGHT, 200);
        fontSize = Prefs.getInt(PREFS_FONT_SIZE, 12);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
        noTicks = (options & 0x20) != 0;
        COPY = 0;
        COPY_ALL = 1;
        SET_RANGE = 2;
        PREV_RANGE = 3;
        RESET_RANGE = 4;
        FIT_RANGE = 5;
        ZOOM_SELECTION = 6;
        AXIS_OPTIONS = 7;
        LEGEND = 8;
        RESET_PLOT = 9;
        FREEZE = 10;
        HI_RESOLUTION = 11;
        PROFILE_PLOT_OPTIONS = 12;
        DISABLED_WHEN_FROZEN = new int[]{SET_RANGE, PREV_RANGE, RESET_RANGE, FIT_RANGE, ZOOM_SELECTION, AXIS_OPTIONS, LEGEND, RESET_PLOT};
    }
}

