/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigObject;
import java.awt.Window;
import javax.media.j3d.Canvas3D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;

class ConfigScreen
extends ConfigObject {
    int frameBufferNumber;
    double physicalScreenWidth = 0.0;
    double physicalScreenHeight = 0.0;
    Matrix4d trackerBaseToImagePlate = null;
    Matrix4d headTrackerToLeftImagePlate = null;
    Matrix4d headTrackerToRightImagePlate = null;
    int monoscopicViewPolicy = 2;
    boolean fullScreen = false;
    boolean noBorderFullScreen = false;
    int windowWidthInPixels = 512;
    int windowHeightInPixels = 512;
    int windowX = 0;
    int windowY = 0;
    JFrame j3dJFrame;
    Window j3dWindow;
    JPanel j3dJPanel;
    Canvas3D j3dCanvas;

    ConfigScreen() {
    }

    protected void setProperty(ConfigCommand configCommand) {
        String string = null;
        Object object = null;
        String string2 = null;
        if (configCommand.argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(configCommand.argv[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a property name");
        }
        string = (String)configCommand.argv[2];
        object = configCommand.argv[3];
        if (string.equals("PhysicalScreenWidth")) {
            if (!(object instanceof Double)) {
                this.syntaxError("Value for PhysicalScreenWidth must be a number");
            }
            this.physicalScreenWidth = (Double)object;
        } else if (string.equals("PhysicalScreenHeight")) {
            if (!(object instanceof Double)) {
                this.syntaxError("Value for PhysicalScreenHeight must be a number");
            }
            this.physicalScreenHeight = (Double)object;
        } else if (string.equals("TrackerBaseToImagePlate")) {
            if (!(object instanceof Matrix4d)) {
                this.syntaxError("Value for TrackerBaseToImagePlate must be a 4x3 or 4x4 matrix");
            }
            this.trackerBaseToImagePlate = (Matrix4d)object;
        } else if (string.equals("HeadTrackerToLeftImagePlate")) {
            if (!(object instanceof Matrix4d)) {
                this.syntaxError("Value for HeadTrackerToLeftImagePlate must be a 4x3 or 4x4 matrix");
            }
            this.headTrackerToLeftImagePlate = (Matrix4d)object;
        } else if (string.equals("HeadTrackerToRightImagePlate")) {
            if (!(object instanceof Matrix4d)) {
                this.syntaxError("Value for HeadTrackerToRightImagePlate must be a 4x3 or 4x4 matrix");
            }
            this.headTrackerToRightImagePlate = (Matrix4d)object;
        } else if (string.equals("MonoscopicViewPolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("Value for MonoscopicViewPolicy must be a name");
            }
            if ((string2 = (String)object).equals("LEFT_EYE_VIEW")) {
                this.monoscopicViewPolicy = 0;
            } else if (string2.equals("RIGHT_EYE_VIEW")) {
                this.monoscopicViewPolicy = 1;
            } else if (string2.equals("CYCLOPEAN_EYE_VIEW")) {
                this.monoscopicViewPolicy = 2;
            } else {
                this.syntaxError("Invalid value for MonoscopicViewPolicy \"" + string2 + "\"");
            }
        } else if (string.equals("WindowPosition")) {
            if (!(object instanceof Point2d)) {
                this.syntaxError("WindowPosition must be a Point2d");
            }
            Point2d point2d = (Point2d)object;
            this.windowX = (int)point2d.x;
            this.windowY = (int)point2d.y;
        } else if (string.equals("WindowSize")) {
            if (object instanceof Point2d) {
                this.fullScreen = false;
                this.noBorderFullScreen = false;
                Point2d point2d = (Point2d)object;
                this.windowWidthInPixels = (int)point2d.x;
                this.windowHeightInPixels = (int)point2d.y;
            } else if (object instanceof String) {
                String string3 = (String)object;
                if (string3.equals("FullScreen")) {
                    this.fullScreen = true;
                    this.noBorderFullScreen = false;
                } else if (string3.equals("NoBorderFullScreen")) {
                    this.fullScreen = false;
                    this.noBorderFullScreen = true;
                } else {
                    this.syntaxError("Value for WindowSize must be one of\n\"FullScreen\" \"NoBorderFullScreen\" or Point2d");
                }
            } else {
                this.syntaxError("Invalid WindowSize value: " + object + "\nValue for WindowSize " + "must be one of\n" + "\"FullScreen\" " + "\"NoBorderFullScreen\" or Point2d");
            }
        } else {
            this.syntaxError("Unknown " + configCommand.commandName + " \"" + string + "\"");
        }
    }

    protected void initialize(ConfigCommand configCommand) {
        if (configCommand.argc != 3) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!(configCommand.argv[2] instanceof Double)) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a GraphicsDevice index");
        }
        this.frameBufferNumber = ((Double)configCommand.argv[2]).intValue();
    }
}

