package plugins.adufour.activemeshes.producers;

import javax.vecmath.Vector3d;

import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.activemeshes.mesh.Vertex;

/**
 * Abstract class defining utilities to build mesh objects
 * 
 * @author Alexandre Dufour
 * 
 */
public abstract class MeshProducer implements Runnable
{
	protected final Mesh	mesh;
	
	private boolean			produced	= false;
	
	protected MeshProducer(Mesh mesh)
	{
		this.mesh = mesh;
	}
	
	/**
	 * Gets the mesh built by this producer. If the mesh is not yet built, the build method is
	 * called first and the final mesh is returned
	 * 
	 * @return
	 */
	public final Mesh getMesh()
	{
		return getMesh(null);
	}
	
	/**
	 * Gets the mesh built by this producer, and adds to it a 3D translation vector (in case the
	 * mesh must be placed somewhere). If the mesh is not yet built, the build method is called
	 * first and the final mesh is returned
	 * 
	 * @return
	 */
	public final Mesh getMesh(Vector3d offset)
	{
		if (!produced)
		{
			run();
			
			// apply the offset
			if (offset != null)
			{
				for (Vertex v : mesh.vertices)
				{
					if (v == null) continue;
					v.position.add(offset);
				}
			}
			
			mesh.updateMassCenter();
			
			produced = true;
		}
		return mesh;
	}
}
