package plugins.adufour.activemeshes.energy;

import java.util.concurrent.ExecutorService;

import javax.vecmath.Vector3d;

import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.activemeshes.mesh.Vertex;
import plugins.adufour.vars.lang.Var;

public class CurvatureRegularizationTerm extends EnergyTerm
{
    private final boolean resolutionIndependent;
    
    /**
     * @deprecated use {@link #CurvatureRegularizationTerm(ExecutorService, Var, boolean)} instead
     * @param service
     * @param weight
     */
    public CurvatureRegularizationTerm(ExecutorService service, Var<Double> weight)
    {
        this(service, weight, false);
    }
    
    public CurvatureRegularizationTerm(ExecutorService service, Var<Double> weight, boolean resolutionIndependent)
    {
        super(service, weight);
        this.resolutionIndependent = resolutionIndependent;
    }
    
    @Override
    public void registerMesh(Mesh mesh)
    {
        mesh.addModel(new Model(mesh)
        {
            @Override
            public void computeForces()
            {
                Vector3d internalForce = new Vector3d();
                double w = weight.getValue();
                if (resolutionIndependent) w /= mesh.getResolution();
                
                if (w == 0.0) return;
                
                for (Vertex v : mesh.vertices)
                {
                    if (v == null) continue;
                    
                    internalForce.scale(-v.neighbors.size(), v.position);
                    
                    for (Integer nn : v.neighbors)
                        internalForce.add(mesh.vertices.get(nn).position);
                    
                    internalForce.scale(w);
                    
                    v.forces.add(internalForce);
                }
            }
            
            @Override
            public void removeMesh(Mesh mesh)
            {
                // nothing to do (meshes are not stored here)
            }
        });
    }
    
    @Override
    public void unregisterMesh(Mesh mesh)
    {
        
    }
    
    @Override
    public void unregisterMeshes()
    {
        
    }
}
