/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.util;

import com.nativelibs4java.util.EnumValue;
import com.nativelibs4java.util.ValuedEnum;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class EnumValues {
    private static final Map<Class<? extends Enum<?>>, Cache<?>> caches = new HashMap();

    private static synchronized <E extends Enum<?>> Cache<E> getCache(Class<E> enumClass) {
        Cache<Object> cache = caches.get(enumClass);
        if (cache == null) {
            cache = new Cache<E>(enumClass);
            caches.put(enumClass, cache);
        }
        return cache;
    }

    public static <E extends Enum<E>> E getEnum(long value, Class<E> enumClass) {
        return (E)((Enum)EnumValues.getCache(enumClass).enumsByValue.get(value));
    }

    public static <E extends Enum<E>> EnumSet<E> getEnumSet(long value, Class<E> enumClass) {
        EnumSet set = EnumSet.noneOf(enumClass);
        for (Map.Entry pair : EnumValues.getCache(enumClass).enumsByValue.entrySet()) {
            long ev = pair.getKey();
            if ((ev & value) != ev) continue;
            set.add(pair.getValue());
        }
        return set;
    }

    public static <E extends Enum<?>> long getValue(E enumItem) {
        return EnumValues.getCache(enumItem.getDeclaringClass()).valuesByEnum.get(enumItem);
    }

    public static <E extends Enum<E>> long getValue(EnumSet<E> set) {
        long v = 0L;
        for (Enum e : set) {
            v |= EnumValues.getValue(e);
        }
        return v;
    }

    private static class Cache<E extends Enum<?>> {
        final Map<Long, E> enumsByValue = new LinkedHashMap<Long, E>();
        final Map<E, Long> valuesByEnum = new LinkedHashMap<E, Long>();

        public Cache(Class<E> enumClass) {
            if (ValuedEnum.class.isAssignableFrom(enumClass)) {
                for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                    long value = ((ValuedEnum)((Object)e)).value();
                    this.enumsByValue.put(value, e);
                    this.valuesByEnum.put(e, value);
                }
            } else {
                for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                    EnumValue ev = null;
                    try {
                        ev = enumClass.getField(e.name()).getAnnotation(EnumValue.class);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    if (ev == null) {
                        throw new IllegalArgumentException("Enum value is not annotated with the " + EnumValue.class.getName() + " annotation : " + e);
                    }
                    long value = ev.value();
                    this.enumsByValue.put(value, e);
                    this.valuesByEnum.put(e, value);
                }
            }
        }
    }
}

