/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import ome.units.UNITS;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetamorphReader.class);
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd HH:mm:ss";
    public static final String LONG_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss";
    public static final String[] ND_SUFFIX = new String[]{"nd"};
    public static final String[] STK_SUFFIX = new String[]{"stk", "tif", "tiff"};
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private double[] wave;
    private String binning;
    private double zoom;
    private double stepSize;
    private Double exposureTime;
    private Vector<String> waveNames;
    private Vector<String> stageNames;
    private long[] internalStamps;
    private double[] zDistances;
    private Length[] stageX;
    private Length[] stageY;
    private double zStart;
    private Double sizeX = null;
    private Double sizeY = null;
    private double tempZ;
    private boolean validZ;
    private Double gain;
    private int mmPlanes;
    private MetamorphReader[][] stkReaders;
    private String[][] stks;
    private String ndFilename;
    private boolean canLookForND = true;
    private boolean[] firstSeriesChannels;
    private boolean bizarreMultichannelAcquisition = false;
    private int openFiles = 0;
    private boolean hasStagePositions = false;
    private boolean hasChipOffsets = false;
    private boolean hasAbsoluteZ = false;
    private boolean hasAbsoluteZValid = false;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd", "tif", "tiff"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "One or more .stk or .tif/.tiff files plus an optional .nd file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location location = new Location(name);
        if (!location.exists()) {
            return false;
        }
        if (MetamorphReader.checkSuffix(name, "nd")) {
            return true;
        }
        if (open) {
            location = location.getAbsoluteFile();
            Location parent = location.getParentFile();
            String baseName = location.getName();
            while (baseName.indexOf("_") >= 0) {
                baseName = baseName.substring(0, baseName.lastIndexOf("_"));
                if (MetamorphReader.checkSuffix(name, this.suffixes) && (new Location(parent, baseName + ".nd").exists() || new Location(parent, baseName + ".ND").exists())) {
                    return true;
                }
                if (!MetamorphReader.checkSuffix(name, this.suffixes) || !new Location(parent, baseName + ".htd").exists() && !new Location(parent, baseName + ".HTD").exists()) continue;
                return false;
            }
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        boolean validSoftware = software != null && software.trim().toLowerCase().startsWith("metamorph");
        return validSoftware || ifd.containsKey(33628) && ifd.containsKey(33630) && ifd.containsKey(33631);
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return !MetamorphReader.checkSuffix(id, ND_SUFFIX);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        String[] files;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        for (String file2 : files = l.getParentFile().list()) {
            if (!MetamorphReader.checkSuffix(file2, ND_SUFFIX) || !l.getName().startsWith(file2.substring(0, file2.lastIndexOf(".")))) continue;
            return 0;
        }
        return 2;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (!noPixels && this.stks == null) {
            return new String[]{this.currentId};
        }
        if (this.stks == null) {
            return new String[0];
        }
        Vector<String> v = new Vector<String>();
        if (this.ndFilename != null) {
            v.add(this.ndFilename);
        }
        if (!noPixels) {
            for (String stk : this.stks[this.getSeries()]) {
                if (stk == null || !new Location(stk).exists()) continue;
                v.add(stk);
            }
        }
        return v.toArray(new String[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        String file2;
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        int[] coords = FormatTools.getZCTCoords(this, no % this.getSizeZ());
        int ndx = no / this.getSizeZ();
        if (this.bizarreMultichannelAcquisition) {
            int[] pos = this.getZCTCoords(no);
            ndx = this.getIndex(pos[0], 0, pos[2]) / this.getSizeZ();
        }
        if (this.stks[this.getSeries()].length == 1) {
            ndx = 0;
        }
        if ((file2 = this.stks[this.getSeries()][ndx]) == null) {
            return buf;
        }
        this.stkReaders[this.getSeries()][ndx].setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.MINIMUM));
        int plane = this.stks[this.getSeries()].length == 1 ? no : coords[0];
        try {
            if (!file2.equals(this.stkReaders[this.getSeries()][ndx].getCurrentFile())) {
                ++this.openFiles;
            }
            this.stkReaders[this.getSeries()][ndx].setId(file2);
            if (this.bizarreMultichannelAcquisition) {
                int realX = this.getZCTCoords(no)[1] == 0 ? x : x + this.getSizeX();
                this.stkReaders[this.getSeries()][ndx].openBytes(plane, buf, realX, y, w, h);
            } else {
                this.stkReaders[this.getSeries()][ndx].openBytes(plane, buf, x, y, w, h);
            }
        }
        finally {
            int count = this.stkReaders[this.getSeries()][ndx].getImageCount();
            if (plane == count - 1 || this.openFiles > 128) {
                this.stkReaders[this.getSeries()][ndx].close();
                --this.openFiles;
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.stkReaders != null) {
            for (MetamorphReader[] s : this.stkReaders) {
                if (s == null) continue;
                for (MetamorphReader reader : s) {
                    if (reader == null) continue;
                    reader.close(fileOnly);
                }
            }
        }
        if (!fileOnly) {
            this.imageCreationDate = null;
            this.imageName = null;
            this.emWavelength = null;
            this.stks = null;
            this.mmPlanes = 0;
            this.ndFilename = null;
            this.wave = null;
            this.binning = null;
            this.stepSize = 0.0;
            this.zoom = 0.0;
            this.exposureTime = null;
            this.stageNames = null;
            this.waveNames = null;
            this.internalStamps = null;
            this.zDistances = null;
            this.stageY = null;
            this.stageX = null;
            this.firstSeriesChannels = null;
            this.sizeY = null;
            this.sizeX = null;
            this.tempZ = 0.0;
            this.validZ = false;
            this.stkReaders = null;
            this.gain = null;
            this.bizarreMultichannelAcquisition = false;
            this.openFiles = 0;
            this.hasStagePositions = false;
            this.hasChipOffsets = false;
            this.hasAbsoluteZ = false;
            this.hasAbsoluteZValid = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            String[] dirList;
            LOGGER.info("Initializing " + id);
            String stkFile = id.substring(0, id.lastIndexOf("."));
            if (stkFile.indexOf(File.separator) != -1) {
                stkFile = stkFile.substring(stkFile.lastIndexOf(File.separator) + 1);
            }
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            LOGGER.info("Looking for STK file in {}", (Object)parent.getAbsolutePath());
            for (String f : dirList = parent.list(true)) {
                int underscore = f.indexOf("_");
                if (underscore < 0) {
                    underscore = f.indexOf(".");
                }
                if (underscore < 0) {
                    underscore = f.length();
                }
                String prefix = f.substring(0, underscore);
                if (!f.equals(stkFile) && !stkFile.startsWith(prefix) || !MetamorphReader.checkSuffix(f, STK_SUFFIX)) continue;
                stkFile = new Location(parent.getAbsolutePath(), f).getAbsolutePath();
                break;
            }
            if (!MetamorphReader.checkSuffix(stkFile, STK_SUFFIX)) {
                throw new FormatException("STK file not found in " + parent.getAbsolutePath() + ".");
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (MetamorphReader.checkSuffix(id, ND_SUFFIX)) {
            ndfile = new Location(id);
        } else if (this.canLookForND && this.isGroupFiles()) {
            Location stk = new Location(id).getAbsoluteFile();
            String stkName = stk.getName();
            String stkPrefix = stkName;
            if (stkPrefix.indexOf("_") >= 0) {
                stkPrefix = stkPrefix.substring(0, stkPrefix.indexOf("_") + 1);
            }
            Location parent = stk.getParentFile();
            String[] list = parent.list(true);
            int matchingChars = 0;
            for (String f : list) {
                if (!MetamorphReader.checkSuffix(f, ND_SUFFIX)) continue;
                String prefix = f.substring(0, f.lastIndexOf("."));
                if (prefix.indexOf("_") >= 0) {
                    prefix = prefix.substring(0, prefix.indexOf("_") + 1);
                }
                if (!stkName.startsWith(prefix) && !prefix.equals(stkPrefix)) continue;
                int charCount = 0;
                for (int i = 0; i < f.length() && i < stkName.length() && f.charAt(i) == stkName.charAt(i); ++i) {
                    ++charCount;
                }
                if (charCount <= matchingChars && (charCount != matchingChars || f.charAt(charCount) != '.')) continue;
                ndfile = new Location(parent, f).getAbsoluteFile();
                matchingChars = charCount;
            }
        }
        String creationTime = null;
        if (ndfile != null && ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            void var20_64;
            int stagesCount;
            void var20_62;
            int zc = this.getSizeZ();
            int cc = this.getSizeC();
            int tc = this.getSizeT();
            int nstages = 0;
            String z = null;
            String c = null;
            String t = null;
            Vector<Boolean> hasZ = new Vector<Boolean>();
            this.waveNames = new Vector();
            this.stageNames = new Vector();
            boolean useWaveNames = true;
            this.ndFilename = ndfile.getAbsolutePath();
            String[] lines = DataTools.readFile(this.ndFilename).split("\n");
            boolean globalDoZ = true;
            boolean doTimelapse = false;
            StringBuilder currentValue = new StringBuilder();
            String key = "";
            String[] arr$ = lines;
            int len$ = arr$.length;
            boolean bl = false;
            while (var20_62 < len$) {
                String line = arr$[var20_62];
                int comma = line.indexOf(",");
                if (comma <= 0) {
                    currentValue.append("\n");
                    currentValue.append(line);
                } else {
                    String value = currentValue.toString();
                    this.addGlobalMeta(key, value);
                    if (key.equals("NZSteps")) {
                        z = value;
                    } else if (key.equals("DoTimelapse")) {
                        doTimelapse = Boolean.parseBoolean(value);
                    } else if (key.equals("NWavelengths")) {
                        c = value;
                    } else if (key.equals("NTimePoints")) {
                        t = value;
                    } else if (key.startsWith("WaveDoZ")) {
                        hasZ.add(new Boolean(value.toLowerCase()));
                    } else if (key.startsWith("WaveName")) {
                        String waveName = value.substring(1, value.length() - 1);
                        if (waveName.equals("Both lasers") || waveName.startsWith("DUAL")) {
                            this.bizarreMultichannelAcquisition = true;
                        }
                        this.waveNames.add(waveName);
                    } else if (key.startsWith("Stage")) {
                        this.stageNames.add(value);
                    } else if (key.startsWith("StartTime")) {
                        creationTime = value;
                    } else if (key.equals("ZStepSize")) {
                        value = value.replace(',', '.');
                        this.stepSize = Double.parseDouble(value);
                    } else if (key.equals("NStagePositions")) {
                        nstages = Integer.parseInt(value);
                    } else if (key.equals("WaveInFileName")) {
                        useWaveNames = Boolean.parseBoolean(value);
                    } else if (key.equals("DoZSeries")) {
                        globalDoZ = new Boolean(value.toLowerCase());
                    }
                    key = line.substring(1, comma - 1).trim();
                    currentValue.delete(0, currentValue.length());
                    currentValue.append(line.substring(comma + 1).trim());
                }
                ++var20_62;
            }
            if (!globalDoZ) {
                for (int i = 0; i < hasZ.size(); ++i) {
                    hasZ.set(i, false);
                }
            }
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            } else if (!doTimelapse) {
                tc = 1;
            }
            if (cc == 0) {
                cc = 1;
            }
            if (cc == 1 && this.bizarreMultichannelAcquisition) {
                cc = 2;
            }
            if (tc == 0) {
                tc = 1;
            }
            int numFiles = cc * tc;
            if (nstages > 0) {
                numFiles *= nstages;
            }
            int n = stagesCount = nstages == 0 ? 1 : nstages;
            this.firstSeriesChannels = new boolean[cc];
            Arrays.fill(this.firstSeriesChannels, true);
            boolean differentZs = false;
            for (int i = 0; i < cc; ++i) {
                boolean hasZ2;
                boolean hasZ1 = i < hasZ.size() && (Boolean)hasZ.get(i) != false;
                boolean bl2 = hasZ2 = i != 0 && i - 1 < hasZ.size() && (Boolean)hasZ.get(i - 1) != false;
                if (i <= 0 || hasZ1 == hasZ2 || !globalDoZ) continue;
                if (!differentZs) {
                    var20_64 *= 2;
                }
                differentZs = true;
            }
            int channelsInFirstSeries = cc;
            if (differentZs) {
                channelsInFirstSeries = 0;
                for (int i = 0; i < cc; ++i) {
                    if (!((Boolean)hasZ.get(0)).booleanValue() && i == 0 || ((Boolean)hasZ.get(0)).booleanValue() && ((Boolean)hasZ.get(i)).booleanValue()) {
                        ++channelsInFirstSeries;
                        continue;
                    }
                    this.firstSeriesChannels[i] = false;
                }
            }
            this.stks = new String[var20_64][];
            if (var20_64 == true) {
                this.stks[0] = new String[numFiles];
            } else if (differentZs) {
                for (int i = 0; i < stagesCount; ++i) {
                    this.stks[i * 2] = new String[channelsInFirstSeries * tc];
                    this.stks[i * 2 + 1] = new String[(cc - channelsInFirstSeries) * tc];
                }
            } else {
                for (int i = 0; i < this.stks.length; ++i) {
                    this.stks[i] = new String[numFiles / this.stks.length];
                }
            }
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            boolean anyZ = hasZ.contains(Boolean.TRUE);
            int[] pt = new int[var20_64];
            for (int i = 0; i < tc; ++i) {
                for (int s = 0; s < stagesCount; ++s) {
                    for (int j = 0; j < cc; ++j) {
                        boolean validZ = j >= hasZ.size() || (Boolean)hasZ.get(j) != false;
                        int seriesNdx = s * (var20_64 / stagesCount);
                        if (!((var20_64 == true || validZ && (hasZ.size() <= 0 || ((Boolean)hasZ.get(0)).booleanValue())) && (nstages != 0 || (validZ || cc <= 1) && var20_64 <= true) || !anyZ || j <= 0 || seriesNdx >= var20_64 - true || validZ && ((Boolean)hasZ.get(0)).booleanValue())) {
                            ++seriesNdx;
                        }
                        if (seriesNdx >= this.stks.length || seriesNdx >= pt.length || pt[seriesNdx] >= this.stks[seriesNdx].length) continue;
                        this.stks[seriesNdx][pt[seriesNdx]] = prefix;
                        if (j < this.waveNames.size() && this.waveNames.get(j) != null) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n2 = pt[seriesNdx];
                            stringArray[n2] = stringArray[n2] + "_w" + (j + 1);
                            if (useWaveNames) {
                                String waveName = this.waveNames.get(j);
                                waveName = waveName.replace('_', '-');
                                waveName = waveName.replace('/', '-');
                                waveName = waveName.replace('\\', '-');
                                waveName = waveName.replace('(', '-');
                                waveName = waveName.replace(')', '-');
                                String[] stringArray2 = this.stks[seriesNdx];
                                int n3 = pt[seriesNdx];
                                stringArray2[n3] = stringArray2[n3] + waveName;
                            }
                        }
                        if (nstages > 0) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n4 = pt[seriesNdx];
                            stringArray[n4] = stringArray[n4] + "_s" + (s + 1);
                        }
                        if (tc > 1 || doTimelapse) {
                            String[] stringArray = this.stks[seriesNdx];
                            int n5 = pt[seriesNdx];
                            stringArray[n5] = stringArray[n5] + "_t" + (i + 1) + ".STK";
                        } else {
                            String[] stringArray = this.stks[seriesNdx];
                            int n6 = pt[seriesNdx];
                            stringArray[n6] = stringArray[n6] + ".STK";
                        }
                        int n7 = seriesNdx;
                        pt[n7] = pt[n7] + 1;
                    }
                }
            }
            ndfile = ndfile.getAbsoluteFile();
            for (int s = 0; s < this.stks.length; ++s) {
                for (int f = 0; f < this.stks[s].length; ++f) {
                    Location l = new Location(ndfile.getParent(), this.stks[s][f]);
                    this.stks[s][f] = this.getRealSTKFile(l);
                }
            }
            String file2 = this.locateFirstValidFile();
            if (file2 == null) {
                throw new FormatException("Unable to locate at least one valid STK file!");
            }
            RandomAccessInputStream s = new RandomAccessInputStream(file2, 16);
            TiffParser tp = new TiffParser(s);
            IFD ifd = tp.getFirstIFD();
            CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
            s.close();
            ms0.sizeX = (int)ifd.getImageWidth();
            ms0.sizeY = (int)ifd.getImageLength();
            if (this.bizarreMultichannelAcquisition) {
                ms0.sizeX /= 2;
            }
            ms0.sizeZ = hasZ.size() > 0 && (Boolean)hasZ.get(0) == false ? 1 : zc;
            ms0.sizeC = cc;
            ms0.sizeT = tc;
            ms0.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms0.dimensionOrder = "XYZCT";
            if (this.stks != null && this.stks.length > 1) {
                ArrayList<CoreMetadata> newCore = new ArrayList<CoreMetadata>();
                for (int i = 0; i < this.stks.length; ++i) {
                    CoreMetadata ms = new CoreMetadata();
                    newCore.add(ms);
                    ms.sizeX = this.getSizeX();
                    ms.sizeY = this.getSizeY();
                    ms.sizeZ = this.getSizeZ();
                    ms.sizeC = this.getSizeC();
                    ms.sizeT = this.getSizeT();
                    ms.pixelType = this.getPixelType();
                    ms.imageCount = this.getImageCount();
                    ms.dimensionOrder = this.getDimensionOrder();
                    ms.rgb = this.isRGB();
                    ms.littleEndian = this.isLittleEndian();
                    ms.interleaved = this.isInterleaved();
                    ms.orderCertain = true;
                }
                if (this.stks.length > nstages) {
                    for (int j = 0; j < stagesCount; ++j) {
                        int idx = j * 2 + 1;
                        CoreMetadata midx = (CoreMetadata)newCore.get(idx);
                        CoreMetadata pmidx = (CoreMetadata)newCore.get(j * 2);
                        pmidx.sizeC = this.stks[j * 2].length / this.getSizeT();
                        midx.sizeC = this.stks[idx].length / midx.sizeT;
                        midx.sizeZ = hasZ.size() > 1 && (Boolean)hasZ.get(1) != false && ((CoreMetadata)this.core.get((int)0)).sizeZ == 1 ? zc : 1;
                        pmidx.imageCount = pmidx.sizeC * pmidx.sizeT * pmidx.sizeZ;
                        midx.imageCount = midx.sizeC * midx.sizeT * midx.sizeZ;
                    }
                }
                this.core = newCore;
            }
        }
        if (this.stks == null) {
            this.stkReaders = new MetamorphReader[1][1];
            this.stkReaders[0][0] = new MetamorphReader();
            this.stkReaders[0][0].setCanLookForND(false);
        } else {
            this.stkReaders = new MetamorphReader[this.stks.length][];
            for (int i = 0; i < this.stks.length; ++i) {
                this.stkReaders[i] = new MetamorphReader[this.stks[i].length];
                for (int j = 0; j < this.stkReaders[i].length; ++j) {
                    this.stkReaders[i][j] = new MetamorphReader();
                    this.stkReaders[i][j].setCanLookForND(false);
                    if (j <= 0) continue;
                    this.stkReaders[i][j].setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.MINIMUM));
                }
            }
        }
        Vector<String> timestamps = null;
        MetamorphHandler handler = null;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            String date;
            String comment;
            this.setSeries(i);
            handler = new MetamorphHandler(this.getSeriesMetadata());
            String instrumentID = MetadataTools.createLSID("Instrument", i);
            store.setInstrumentID(instrumentID, i);
            store.setImageInstrumentRef(instrumentID, i);
            if (i == 0) {
                store.setDetectorID(detectorID, 0, 0);
                store.setDetectorType(this.getDetectorType("Other"), 0, 0);
            }
            if ((comment = this.getFirstComment(i)) != null && comment.startsWith("<MetaData>")) {
                try {
                    XMLTools.parseXML(XMLTools.sanitizeXML(comment), (DefaultHandler)handler);
                }
                catch (IOException hasZ) {
                    // empty catch block
                }
            }
            if (creationTime != null && (date = DateTools.formatDate(creationTime, SHORT_DATE_FORMAT, ".")) != null) {
                store.setImageAcquisitionDate(new Timestamp(date), 0);
            }
            store.setImageName(this.makeImageName(i).trim(), i);
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            store.setImageDescription("", i);
            store.setImagingEnvironmentTemperature(new Temperature(handler.getTemperature(), UNITS.DEGREEC), i);
            if (this.sizeX == null) {
                this.sizeX = handler.getPixelSizeX();
            }
            if (this.sizeY == null) {
                this.sizeY = handler.getPixelSizeY();
            }
            Length physicalSizeX = FormatTools.getPhysicalSizeX(this.sizeX);
            Length physicalSizeY = FormatTools.getPhysicalSizeY(this.sizeY);
            if (physicalSizeX != null) {
                store.setPixelsPhysicalSizeX(physicalSizeX, i);
            }
            if (physicalSizeY != null) {
                store.setPixelsPhysicalSizeY(physicalSizeY, i);
            }
            if (this.zDistances != null) {
                this.stepSize = this.zDistances[0];
            } else {
                Vector<Object> zPositions = new Vector();
                Vector<Double> uniqueZ = new Vector<Double>();
                for (IFD ifd : this.ifds) {
                    MetamorphHandler zPlaneHandler = new MetamorphHandler();
                    String zComment = ifd.getComment();
                    if (zComment != null && zComment.startsWith("<MetaData>")) {
                        try {
                            XMLTools.parseXML(XMLTools.sanitizeXML(zComment), (DefaultHandler)zPlaneHandler);
                        }
                        catch (IOException stagesCount) {
                            // empty catch block
                        }
                    }
                    zPositions = zPlaneHandler.getZPositions();
                    for (Double d : zPositions) {
                        if (uniqueZ.contains(d)) continue;
                        uniqueZ.add(d);
                    }
                }
                if (uniqueZ.size() > 1 && uniqueZ.size() == this.getSizeZ()) {
                    BigDecimal lastZ = BigDecimal.valueOf((Double)uniqueZ.get(uniqueZ.size() - 1));
                    BigDecimal firstZ = BigDecimal.valueOf((Double)uniqueZ.get(0));
                    BigDecimal zRange = lastZ.subtract(firstZ).abs();
                    BigDecimal zSize = BigDecimal.valueOf((double)(this.getSizeZ() - 1));
                    this.stepSize = zRange.divide(zSize).doubleValue();
                }
            }
            Length physicalSizeZ = FormatTools.getPhysicalSizeZ(this.stepSize);
            if (physicalSizeZ != null) {
                store.setPixelsPhysicalSizeZ(physicalSizeZ, i);
            }
            String objectiveID = MetadataTools.createLSID("Objective", i, 0);
            store.setObjectiveID(objectiveID, i, 0);
            if (handler.getLensNA() != 0.0) {
                store.setObjectiveLensNA(handler.getLensNA(), i, 0);
            }
            store.setObjectiveSettingsID(objectiveID, i);
            int waveIndex = 0;
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (this.firstSeriesChannels == null || this.stageNames != null && this.stageNames.size() == this.getSeriesCount()) {
                    waveIndex = c;
                } else if (this.firstSeriesChannels != null) {
                    int s = i % 2;
                    while (this.firstSeriesChannels[waveIndex] == (s == 1) && waveIndex < this.firstSeriesChannels.length) {
                        ++waveIndex;
                    }
                }
                if (this.waveNames != null && waveIndex < this.waveNames.size()) {
                    store.setChannelName(this.waveNames.get(waveIndex).trim(), i, c);
                }
                if (handler.getBinning() != null) {
                    this.binning = handler.getBinning();
                }
                if (this.binning != null) {
                    store.setDetectorSettingsBinning(this.getBinning(this.binning), i, c);
                }
                if (handler.getReadOutRate() != 0.0) {
                    store.setDetectorSettingsReadOutRate(new Frequency(handler.getReadOutRate(), UNITS.HZ), i, c);
                }
                if (this.gain == null) {
                    this.gain = handler.getGain();
                }
                if (this.gain != null) {
                    store.setDetectorSettingsGain(this.gain, i, c);
                }
                store.setDetectorSettingsID(detectorID, i, c);
                if (this.wave != null && waveIndex < this.wave.length) {
                    Length wavelength = FormatTools.getWavelength(this.wave[waveIndex]);
                    if ((int)this.wave[waveIndex] >= 1) {
                        String lightSourceID = MetadataTools.createLSID("LightSource", i, c);
                        store.setLaserID(lightSourceID, i, c);
                        store.setChannelLightSourceSettingsID(lightSourceID, i, c);
                        store.setLaserType(this.getLaserType("Other"), i, c);
                        store.setLaserLaserMedium(this.getLaserMedium("Other"), i, c);
                        if (wavelength != null) {
                            store.setChannelLightSourceSettingsWavelength(wavelength, i, c);
                        }
                    }
                }
                ++waveIndex;
            }
            timestamps = handler.getTimestamps();
            for (int t = 0; t < timestamps.size(); ++t) {
                String date2 = DateTools.convertDate(DateTools.getTime(timestamps.get(t), SHORT_DATE_FORMAT, "."), 0, "yyyyMMdd HH:mm:ss.SSS");
                this.addSeriesMetaList("timestamp", date2);
            }
            long startDate = 0L;
            if (timestamps.size() > 0) {
                startDate = DateTools.getTime(timestamps.get(0), SHORT_DATE_FORMAT, ".");
            }
            Length positionX = handler.getStagePositionX();
            Length positionY = handler.getStagePositionY();
            Vector<Double> vector = handler.getExposures();
            if (vector.size() == 0) {
                for (int p = 0; p < this.getImageCount(); ++p) {
                    vector.add(this.exposureTime);
                }
            } else if (vector.size() == 1 && vector.size() < this.getSizeC()) {
                for (int c = 1; c < this.getSizeC(); ++c) {
                    MetamorphHandler channelHandler = new MetamorphHandler();
                    String channelComment = this.getComment(i, c);
                    if (channelComment != null && channelComment.startsWith("<MetaData>")) {
                        try {
                            XMLTools.parseXML(XMLTools.sanitizeXML(channelComment), (DefaultHandler)channelHandler);
                        }
                        catch (IOException anyZ) {
                            // empty catch block
                        }
                    }
                    Vector<Double> channelExpTime = channelHandler.getExposures();
                    vector.add(channelExpTime.get(0));
                }
            }
            int lastFile = -1;
            ArrayList lastIFDs = null;
            IFD lastIFD = null;
            Object lastOffsets = null;
            double distance = this.zStart;
            TiffParser tp = null;
            RandomAccessInputStream stream = null;
            for (int p = 0; p < this.getImageCount(); ++p) {
                int[] coords = this.getZCTCoords(p);
                Double deltaT = 0.0;
                Double expTime = this.exposureTime;
                Double xmlZPosition = null;
                int fileIndex = this.getIndex(0, 0, coords[2]) / this.getSizeZ();
                if (fileIndex >= 0) {
                    String file3;
                    String string = file3 = this.stks == null ? this.currentId : this.stks[i][fileIndex];
                    if (file3 != null && fileIndex != lastFile) {
                        if (stream != null) {
                            stream.close();
                        }
                        stream = new RandomAccessInputStream(file3, 16);
                        tp = new TiffParser(stream);
                        tp.checkHeader();
                        IFDList f = tp.getIFDs();
                        if (f.size() > 0) {
                            lastFile = fileIndex;
                            lastIFDs = f;
                        } else {
                            file3 = null;
                            this.stks[i][fileIndex] = null;
                        }
                    }
                    if (file3 != null) {
                        lastIFD = (IFD)lastIFDs.get(p % lastIFDs.size());
                        Object commentEntry = lastIFD.get(270);
                        if (commentEntry != null) {
                            if (commentEntry instanceof String) {
                                comment = (String)commentEntry;
                            } else if (commentEntry instanceof TiffIFDEntry) {
                                comment = tp.getIFDValue((TiffIFDEntry)commentEntry).toString();
                            }
                        }
                        if (comment != null) {
                            comment = comment.trim();
                        }
                        if (comment != null && comment.startsWith("<MetaData>")) {
                            String[] lines = comment.split("\n");
                            timestamps = new Vector();
                            for (String line : lines) {
                                if (!(line = line.trim()).startsWith("<prop")) continue;
                                int firstQuote = line.indexOf("\"") + 1;
                                int lastQuote = line.lastIndexOf("\"");
                                String key = line.substring(firstQuote, line.indexOf("\"", firstQuote));
                                String value = line.substring(line.lastIndexOf("\"", lastQuote - 1) + 1, lastQuote);
                                if (key.equals("z-position")) {
                                    xmlZPosition = new Double(value);
                                    continue;
                                }
                                if (!key.equals("acquisition-time-local")) continue;
                                timestamps.add(value);
                            }
                        }
                    }
                }
                int index = 0;
                if (timestamps.size() > 0) {
                    if (coords[2] < timestamps.size()) {
                        index = coords[2];
                    }
                    String stamp = timestamps.get(index);
                    long ms = DateTools.getTime(stamp, SHORT_DATE_FORMAT, ".");
                    deltaT = new Double((double)(ms - startDate) / 1000.0);
                } else if (this.internalStamps != null && p < this.internalStamps.length) {
                    long delta = this.internalStamps[p] - this.internalStamps[0];
                    deltaT = new Double((double)delta / 1000.0);
                    if (coords[2] < vector.size()) {
                        index = coords[2];
                    }
                }
                if (index == 0 && p > 0 && vector.size() > 0) {
                    index = coords[1] % vector.size();
                }
                if (index < vector.size()) {
                    expTime = vector.get(index);
                }
                if (deltaT != null) {
                    store.setPlaneDeltaT(new Time(deltaT, UNITS.S), i, p);
                }
                if (expTime != null) {
                    store.setPlaneExposureTime(new Time(expTime, UNITS.S), i, p);
                }
                if (this.stageX != null && p < this.stageX.length) {
                    store.setPlanePositionX(this.stageX[p], i, p);
                } else if (positionX != null) {
                    store.setPlanePositionX(positionX, i, p);
                }
                if (this.stageY != null && p < this.stageY.length) {
                    store.setPlanePositionY(this.stageY[p], i, p);
                } else if (positionY != null) {
                    store.setPlanePositionY(positionY, i, p);
                }
                if (this.zDistances != null && p < this.zDistances.length) {
                    if (p > 0) {
                        distance = this.zDistances[p] != 0.0 ? (distance += this.zDistances[p]) : (distance += this.zDistances[0]);
                    }
                    Length zPos = new Length(distance, UNITS.REFERENCEFRAME);
                    store.setPlanePositionZ(zPos, i, p);
                    continue;
                }
                if (xmlZPosition == null) continue;
                Length zPos = new Length(xmlZPosition, UNITS.REFERENCEFRAME);
                store.setPlanePositionZ(zPos, i, p);
            }
            if (stream == null) continue;
            stream.close();
        }
        this.setSeries(0);
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        String filename;
        super.initStandardMetadata();
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.sizeZ = 1;
        ms0.sizeT = 0;
        int rgbChannels = this.getSizeC();
        TiffIFDEntry uic1tagEntry = null;
        TiffIFDEntry uic2tagEntry = null;
        TiffIFDEntry uic4tagEntry = null;
        try {
            uic1tagEntry = this.tiffParser.getFirstIFDEntry(33628);
            uic2tagEntry = this.tiffParser.getFirstIFDEntry(33629);
            uic4tagEntry = this.tiffParser.getFirstIFDEntry(33631);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Unknown tag", exc);
        }
        try {
            if (uic4tagEntry != null) {
                this.mmPlanes = uic4tagEntry.getValueCount();
            }
            if (this.mmPlanes == 0) {
                this.mmPlanes = this.ifds.size();
            }
            if (uic2tagEntry != null) {
                this.parseUIC2Tags(uic2tagEntry.getValueOffset());
            }
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                if (uic4tagEntry != null) {
                    this.parseUIC4Tags(uic4tagEntry.getValueOffset());
                }
                if (uic1tagEntry != null) {
                    this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
                }
            }
            this.in.seek(uic4tagEntry.getValueOffset());
        }
        catch (NullPointerException exc) {
            LOGGER.debug("", exc);
        }
        catch (IOException exc) {
            LOGGER.debug("Failed to parse proprietary tags", exc);
        }
        try {
            PhotoInterp check;
            TiffRational[] tiffRationalArray;
            IFD firstIFD = (IFD)this.ifds.get(0);
            long[] uic2 = firstIFD.getIFDLongArray(33629);
            if (uic2 == null) {
                throw new FormatException("Invalid Metamorph file. Tag 33629 not found.");
            }
            ms0.imageCount = uic2.length;
            Object entry = firstIFD.getIFDValue(33630);
            if (entry instanceof TiffRational[]) {
                tiffRationalArray = (TiffRational[])entry;
            } else {
                TiffRational[] tiffRationalArray2 = new TiffRational[1];
                tiffRationalArray = tiffRationalArray2;
                tiffRationalArray2[0] = (TiffRational)entry;
            }
            TiffRational[] uic3 = tiffRationalArray;
            this.wave = new double[uic3.length];
            Vector<Double> uniqueWavelengths = new Vector<Double>();
            for (int i = 0; i < uic3.length; ++i) {
                this.wave[i] = uic3[i].doubleValue();
                this.addSeriesMeta("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.wave[i]);
                Double v = new Double(this.wave[i]);
                if (uniqueWavelengths.contains(v)) continue;
                uniqueWavelengths.add(v);
            }
            if (this.getSizeC() == 1) {
                ms0.sizeC = uniqueWavelengths.size();
                if (this.getSizeC() < this.getImageCount() && this.getSizeC() > this.getImageCount() - this.getSizeC() && this.getImageCount() % this.getSizeC() != 0) {
                    ms0.sizeC = this.getImageCount();
                }
            }
            IFDList tempIFDs = new IFDList();
            long[] oldOffsets = firstIFD.getStripOffsets();
            long[] stripByteCounts = firstIFD.getStripByteCounts();
            int rowsPerStrip = (int)firstIFD.getRowsPerStrip()[0];
            int stripsPerImage = this.getSizeY() / rowsPerStrip;
            if (stripsPerImage * rowsPerStrip != this.getSizeY()) {
                ++stripsPerImage;
            }
            if ((check = firstIFD.getPhotometricInterpretation()) == PhotoInterp.RGB_PALETTE) {
                firstIFD.putIFDValue(262, PhotoInterp.BLACK_IS_ZERO);
            }
            this.emWavelength = firstIFD.getIFDLongArray(33630);
            for (int i = 0; i < this.getImageCount(); ++i) {
                IFD temp = new IFD(firstIFD);
                long[] newOffsets = new long[stripsPerImage];
                if (stripsPerImage * (i + 1) <= oldOffsets.length) {
                    System.arraycopy(oldOffsets, stripsPerImage * i, newOffsets, 0, stripsPerImage);
                } else {
                    System.arraycopy(oldOffsets, 0, newOffsets, 0, stripsPerImage);
                    long image = stripByteCounts[0] / (long)rowsPerStrip * (long)this.getSizeY();
                    int q = 0;
                    while (q < stripsPerImage) {
                        int n = q++;
                        newOffsets[n] = newOffsets[n] + (long)i * image;
                    }
                }
                temp.putIFDValue(273, newOffsets);
                long[] newByteCounts = new long[stripsPerImage];
                if (stripsPerImage * i < stripByteCounts.length) {
                    System.arraycopy(stripByteCounts, stripsPerImage * i, newByteCounts, 0, stripsPerImage);
                } else {
                    Arrays.fill(newByteCounts, stripByteCounts[0]);
                }
                temp.putIFDValue(279, newByteCounts);
                tempIFDs.add(temp);
            }
            this.ifds = tempIFDs;
        }
        catch (IllegalArgumentException exc) {
            LOGGER.debug("Unknown tag", exc);
        }
        catch (NullPointerException exc) {
            LOGGER.debug("", exc);
        }
        catch (FormatException exc) {
            LOGGER.debug("Failed to build list of IFDs", exc);
        }
        String descr = ((IFD)this.ifds.get(0)).getComment();
        if (descr != null) {
            String line;
            String[] lines = descr.split("\n");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; !(i >= lines.length || (line = lines[i].trim()).startsWith("<") && line.endsWith(">")); ++i) {
                int space;
                int colon = line.indexOf(":");
                if (colon < 0) {
                    if (line.length() <= 0) continue;
                    sb.append(line);
                    sb.append("  ");
                    continue;
                }
                String descrValue = null;
                if (i == 0) {
                    int dot = line.lastIndexOf(".", colon);
                    if (dot >= 0) {
                        descrValue = line.substring(0, dot + 1);
                    }
                    line = line.substring(dot + 1);
                    colon -= dot + 1;
                }
                if (descrValue != null) {
                    sb.append(descrValue);
                    if (!descrValue.endsWith(".")) {
                        sb.append(".");
                    }
                    sb.append("  ");
                }
                String key = line.substring(0, colon);
                String value = line.substring(colon + 1).trim();
                this.addSeriesMeta(key, value);
                if (key.equals("Exposure")) {
                    if (value.indexOf("=") != -1) {
                        value = value.substring(value.indexOf("=") + 1).trim();
                    }
                    if (value.indexOf(" ") != -1) {
                        value = value.substring(0, value.indexOf(" "));
                    }
                    try {
                        value = value.replace(',', '.');
                        double exposure = Double.parseDouble(value);
                        this.exposureTime = new Double(exposure / 1000.0);
                    }
                    catch (NumberFormatException exposure) {}
                    continue;
                }
                if (key.equals("Bit Depth")) {
                    if (value.indexOf("-") != -1) {
                        value = value.substring(0, value.indexOf("-"));
                    }
                    try {
                        ms0.bitsPerPixel = Integer.parseInt(value);
                    }
                    catch (NumberFormatException exposure) {}
                    continue;
                }
                if (!key.equals("Gain") || (space = value.indexOf(" ")) == -1) continue;
                int nextSpace = value.indexOf(" ", space + 1);
                if (nextSpace < 0) {
                    nextSpace = value.length();
                }
                try {
                    this.gain = new Double(value.substring(space, nextSpace));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            descr = sb.toString().trim();
            if (descr.equals("")) {
                this.metadata.remove("Comment");
            } else {
                this.addSeriesMeta("Comment", descr);
            }
        }
        ms0.sizeT = this.getImageCount() / (this.getSizeZ() * (this.getSizeC() / rgbChannels));
        if (this.getSizeT() * this.getSizeZ() * (this.getSizeC() / rgbChannels) != this.getImageCount()) {
            ms0.sizeT = 1;
            ms0.sizeZ = this.getImageCount() / (this.getSizeC() / rgbChannels);
        }
        if ((filename = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1)).indexOf("_t") != -1 && this.getSizeT() > 1) {
            int z = this.getSizeZ();
            ms0.sizeZ = this.getSizeT();
            ms0.sizeT = z;
        }
        if (this.getSizeZ() == 0) {
            ms0.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            ms0.sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC()) != this.getImageCount()) {
            ms0.sizeZ = this.getImageCount();
            ms0.sizeT = 1;
            if (!this.isRGB()) {
                ms0.sizeC = 1;
            }
        }
    }

    private String getRealSTKFile(Location l) {
        if (l.exists()) {
            return l.getAbsolutePath();
        }
        String name = l.getName();
        String parent = l.getParent();
        if (name.indexOf("_") > 0) {
            Location p;
            String prefix = name.substring(0, name.indexOf("_"));
            String suffix = name.substring(name.indexOf("_"));
            String basePrefix = new Location(this.currentId).getName();
            int end = basePrefix.indexOf("_");
            if (end < 0) {
                end = basePrefix.indexOf(".");
            }
            if (!(basePrefix = basePrefix.substring(0, end)).equals(prefix) && (p = new Location(parent, name = basePrefix + suffix)).exists()) {
                return p.getAbsolutePath();
            }
        }
        if (name.indexOf("%") != -1 && !(l = new Location(parent, name = name.replaceAll("%", "-"))).exists() && !(l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".TIF")).exists()) {
            l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".tif");
            return l.exists() ? l.getAbsolutePath() : null;
        }
        if (!l.exists()) {
            int index = name.lastIndexOf(".");
            if (index < 0) {
                index = name.length();
            }
            if (!(l = new Location(parent, name = name.substring(0, index) + ".TIF")).exists() && !(l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".tif")).exists()) {
                l = new Location(parent, name = name.substring(0, name.lastIndexOf(".")) + ".stk");
                return l.exists() ? l.getAbsolutePath() : null;
            }
        }
        return l.getAbsolutePath();
    }

    private String getFirstComment(int i) throws IOException {
        return this.getComment(i, 0);
    }

    private String getComment(int i, int no) throws IOException {
        if (this.stks != null && this.stks[i][no] != null) {
            RandomAccessInputStream stream = new RandomAccessInputStream(this.stks[i][no], 16);
            TiffParser tp = new TiffParser(stream);
            String comment = tp.getComment();
            stream.close();
            return comment;
        }
        return ((IFD)this.ifds.get(0)).getComment();
    }

    private String makeImageName(int i) {
        String name = "";
        if (this.stageNames != null && this.stageNames.size() > 0) {
            int stagePosition = i / (this.getSeriesCount() / this.stageNames.size());
            name = name + "Stage" + (stagePosition + 1) + " " + this.stageNames.get(stagePosition);
        }
        if (this.firstSeriesChannels != null && (this.stageNames == null || this.stageNames.size() == 0 || this.stageNames.size() != this.getSeriesCount())) {
            if (name.length() > 0) {
                name = name + "; ";
            }
            for (int c = 0; c < this.firstSeriesChannels.length; ++c) {
                if (this.firstSeriesChannels[c] != (i % 2 == 0) || c >= this.waveNames.size()) continue;
                name = name + this.waveNames.get(c) + "/";
            }
            if (name.length() > 0) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        this.zDistances = new double[this.mmPlanes];
        this.internalStamps = new long[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            if (this.in.getFilePointer() + 8L > this.in.length()) break;
            this.zDistances[i] = this.readRational(this.in).doubleValue();
            this.addSeriesMeta("zDistance[" + iAsString + "]", this.zDistances[i]);
            if (this.zDistances[i] != 0.0) {
                ++((CoreMetadata)this.core.get((int)0)).sizeZ;
            }
            String cDate = MetamorphReader.decodeDate(this.in.readInt());
            String cTime = MetamorphReader.decodeTime(this.in.readInt());
            this.internalStamps[i] = DateTools.getTime(cDate + " " + cTime, LONG_DATE_FORMAT, ":");
            this.addSeriesMeta("creationDate[" + iAsString + "]", cDate);
            this.addSeriesMeta("creationTime[" + iAsString + "]", cTime);
            this.in.skip(8L);
        }
        if (this.getSizeZ() == 0) {
            ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        if (this.in.getFilePointer() + 2L >= this.in.length()) {
            return;
        }
        this.tempZ = 0.0;
        this.validZ = false;
        short id = this.in.readShort();
        while (id != 0) {
            switch (id) {
                case 28: {
                    this.readStagePositions();
                    this.hasStagePositions = true;
                    break;
                }
                case 29: {
                    this.readRationals(new String[]{"cameraXChipOffset", "cameraYChipOffset"});
                    this.hasChipOffsets = true;
                    break;
                }
                case 37: {
                    this.readStageLabels();
                    break;
                }
                case 40: {
                    this.readRationals(new String[]{"UIC4 absoluteZ"});
                    this.hasAbsoluteZ = true;
                    break;
                }
                case 41: {
                    this.readAbsoluteZValid();
                    this.hasAbsoluteZValid = true;
                    break;
                }
                case 46: {
                    this.in.skipBytes(this.mmPlanes * 8);
                    break;
                }
                default: {
                    this.in.skipBytes(4);
                }
            }
            id = this.in.readShort();
        }
        this.in.seek(saveLoc);
        if (this.validZ) {
            this.zStart = this.tempZ;
        }
    }

    private void readStagePositions() throws IOException {
        this.stageX = new Length[this.mmPlanes];
        this.stageY = new Length[this.mmPlanes];
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            Double posX = this.readRational(this.in).doubleValue();
            Double posY = this.readRational(this.in).doubleValue();
            this.stageX[i] = new Length(posX, UNITS.REFERENCEFRAME);
            this.stageY[i] = new Length(posY, UNITS.REFERENCEFRAME);
            this.addSeriesMeta("stageX[" + pos + "]", posX);
            this.addSeriesMeta("stageY[" + pos + "]", posY);
            this.addGlobalMeta("X position for position #" + (this.getSeries() + 1), posX);
            this.addGlobalMeta("Y position for position #" + (this.getSeries() + 1), posY);
        }
    }

    private void readRationals(String[] labels) throws IOException {
        HashSet<Double> uniqueZ = new HashSet<Double>();
        for (int i = 0; i < this.mmPlanes; ++i) {
            String pos = MetamorphReader.intFormatMax(i, this.mmPlanes);
            for (int q = 0; q < labels.length; ++q) {
                double v = this.readRational(this.in).doubleValue();
                if (labels[q].endsWith("absoluteZ")) {
                    if (i == 0) {
                        this.tempZ = v;
                    }
                    uniqueZ.add(v);
                }
                this.addSeriesMeta(labels[q] + "[" + pos + "]", v);
            }
        }
        if (uniqueZ.size() == this.mmPlanes) {
            ((CoreMetadata)this.core.get((int)0)).sizeZ = this.mmPlanes;
        }
    }

    void readStageLabels() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            this.addSeriesMeta("stageLabel[" + iAsString + "]", this.in.readString(strlen));
        }
    }

    void readAbsoluteZValid() throws IOException {
        for (int i = 0; i < this.mmPlanes; ++i) {
            int valid = this.in.readInt();
            this.addSeriesMeta("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", valid);
            if (i != 0) continue;
            this.validZ = valid == 1;
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        this.tempZ = 0.0;
        this.validZ = false;
        for (int i = 0; i < uic1count && this.in.getFilePointer() < this.in.length(); ++i) {
            int currentID = this.in.readInt();
            long valOrOffset = (long)this.in.readInt() & 0xFFFFFFFFL;
            long lastOffset = this.in.getFilePointer();
            String key = this.getKey(currentID);
            Object value = String.valueOf(valOrOffset);
            boolean skipKey = false;
            block0 : switch (currentID) {
                case 3: {
                    value = valOrOffset != 0L ? "on" : "off";
                    break;
                }
                case 4: 
                case 5: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 38: 
                case 39: {
                    value = this.readRational(this.in, valOrOffset);
                    break;
                }
                case 6: 
                case 25: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    if ((long)num + this.in.getFilePointer() >= this.in.length()) {
                        num = (int)(this.in.length() - this.in.getFilePointer() - 1L);
                    }
                    if (num < 0) break;
                    value = this.in.readString(num);
                    break;
                }
                case 7: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    if (num < 0) break;
                    this.imageName = this.in.readString(num);
                    value = this.imageName;
                    break;
                }
                case 8: {
                    if (valOrOffset == 1L) {
                        value = "inside";
                        break;
                    }
                    if (valOrOffset == 2L) {
                        value = "outside";
                        break;
                    }
                    value = "off";
                    break;
                }
                case 17: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.imageCreationDate = thedate + " " + thetime;
                    value = this.imageCreationDate;
                    break;
                }
                case 16: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    value = thedate + " " + thetime;
                    break;
                }
                case 26: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    switch (standardLUT) {
                        case 0: {
                            value = "monochrome";
                            break block0;
                        }
                        case 1: {
                            value = "pseudocolor";
                            break block0;
                        }
                        case 2: {
                            value = "Red";
                            break block0;
                        }
                        case 3: {
                            value = "Green";
                            break block0;
                        }
                        case 4: {
                            value = "Blue";
                            break block0;
                        }
                        case 5: {
                            value = "user-defined";
                            break block0;
                        }
                    }
                    value = "monochrome";
                    break;
                }
                case 28: {
                    if (valOrOffset >= this.in.length()) break;
                    if (!this.hasStagePositions) {
                        this.in.seek(valOrOffset);
                        this.readStagePositions();
                    }
                    skipKey = true;
                    break;
                }
                case 29: {
                    if (valOrOffset >= this.in.length()) break;
                    if (!this.hasChipOffsets) {
                        this.in.seek(valOrOffset);
                        this.readRationals(new String[]{"cameraXChipOffset", "cameraYChipOffset"});
                    }
                    skipKey = true;
                    break;
                }
                case 34: {
                    value = String.valueOf(this.in.readInt());
                    break;
                }
                case 42: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    value = String.valueOf(this.in.readInt());
                    break;
                }
                case 46: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.binning = xBin + "x" + yBin;
                    value = this.binning;
                    break;
                }
                case 40: {
                    if (valOrOffset == 0L || valOrOffset >= this.in.length()) break;
                    if (!this.hasAbsoluteZ) {
                        this.in.seek(valOrOffset);
                        this.readRationals(new String[]{"UIC1 absoluteZ"});
                    }
                    skipKey = true;
                    break;
                }
                case 41: {
                    if (valOrOffset != 0L && valOrOffset < this.in.length()) {
                        if (!this.hasAbsoluteZValid) {
                            this.in.seek(valOrOffset);
                            this.readAbsoluteZValid();
                        }
                        skipKey = true;
                        break;
                    }
                    if (valOrOffset != 0L || this.getSizeZ() >= this.mmPlanes) break;
                    ((CoreMetadata)this.core.get((int)0)).sizeZ = 1;
                    break;
                }
                case 49: {
                    if (valOrOffset >= this.in.length()) break;
                    this.in.seek(valOrOffset);
                    this.readPlaneData();
                    skipKey = true;
                }
            }
            if (!skipKey) {
                this.addSeriesMeta(key, value);
            }
            this.in.seek(lastOffset);
            if ("Zoom".equals(key) && value != null) {
                this.zoom = Double.parseDouble(value.toString());
            }
            if ("XCalibration".equals(key) && value != null) {
                this.sizeX = value instanceof TiffRational ? Double.valueOf(((TiffRational)value).doubleValue()) : new Double(value.toString());
            }
            if (!"YCalibration".equals(key) || value == null) continue;
            this.sizeY = value instanceof TiffRational ? Double.valueOf(((TiffRational)value).doubleValue()) : new Double(value.toString());
        }
        this.in.seek(saveLoc);
        if (this.validZ) {
            this.zStart = this.tempZ;
        }
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return MetamorphReader.intFormat(day, 2) + "/" + MetamorphReader.intFormat(month, 2) + "/" + year;
    }

    public static String decodeTime(int millis) {
        DateTime tm = new DateTime((long)millis, DateTimeZone.UTC);
        String hours = MetamorphReader.intFormat(tm.getHourOfDay(), 2);
        String minutes = MetamorphReader.intFormat(tm.getMinuteOfHour(), 2);
        String seconds = MetamorphReader.intFormat(tm.getSecondOfMinute(), 2);
        String ms = MetamorphReader.intFormat(tm.getMillisOfSecond(), 3);
        return hours + ":" + minutes + ":" + seconds + ":" + ms;
    }

    public static String intFormat(int myint, int digits) {
        return String.format("%0" + digits + "d", myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, String.valueOf(maxint).length());
    }

    private String locateFirstValidFile() {
        for (int q = 0; q < this.stks.length; ++q) {
            for (int f = 0; f < this.stks.length; ++f) {
                if (this.stks[q][f] == null) continue;
                return this.stks[q][f];
            }
        }
        return null;
    }

    private TiffRational readRational(RandomAccessInputStream s) throws IOException {
        return this.readRational(s, s.getFilePointer());
    }

    private TiffRational readRational(RandomAccessInputStream s, long offset) throws IOException {
        if (offset >= s.length() - 8L) {
            return null;
        }
        s.seek(offset);
        int num = s.readInt();
        int denom = s.readInt();
        return new TiffRational(num, denom);
    }

    private void setCanLookForND(boolean v) {
        FormatTools.assertId(this.currentId, false, 1);
        this.canLookForND = v;
    }

    private void readPlaneData() throws IOException {
        this.in.skipBytes(4);
        int keyLength = this.in.read();
        String key = this.in.readString(keyLength);
        this.in.skipBytes(4);
        int type = this.in.read();
        int index = 0;
        switch (type) {
            case 1: {
                while (this.getGlobalMeta("Channel #" + index + " " + key) != null) {
                    ++index;
                }
                this.addGlobalMeta("Channel #" + index + " " + key, this.readRational(this.in).doubleValue());
                break;
            }
            case 2: {
                int valueLength = this.in.read();
                String value = this.in.readString(valueLength);
                if (valueLength == 0) {
                    this.in.skipBytes(4);
                    valueLength = this.in.read();
                    value = this.in.readString(valueLength);
                }
                while (this.getGlobalMeta("Channel #" + index + " " + key) != null) {
                    ++index;
                }
                this.addGlobalMeta("Channel #" + index + " " + key, value);
                if (!key.equals("_IllumSetting_")) break;
                if (this.waveNames == null) {
                    this.waveNames = new Vector();
                }
                this.waveNames.add(value);
            }
        }
    }

    private String getKey(int id) {
        switch (id) {
            case 0: {
                return "AutoScale";
            }
            case 1: {
                return "MinScale";
            }
            case 2: {
                return "MaxScale";
            }
            case 3: {
                return "Spatial Calibration";
            }
            case 4: {
                return "XCalibration";
            }
            case 5: {
                return "YCalibration";
            }
            case 6: {
                return "CalibrationUnits";
            }
            case 7: {
                return "Name";
            }
            case 8: {
                return "ThreshState";
            }
            case 9: {
                return "ThreshStateRed";
            }
            case 11: {
                return "ThreshStateGreen";
            }
            case 12: {
                return "ThreshStateBlue";
            }
            case 13: {
                return "ThreshStateLo";
            }
            case 14: {
                return "ThreshStateHi";
            }
            case 15: {
                return "Zoom";
            }
            case 16: {
                return "DateTime";
            }
            case 17: {
                return "LastSavedTime";
            }
            case 18: {
                return "currentBuffer";
            }
            case 19: {
                return "grayFit";
            }
            case 20: {
                return "grayPointCount";
            }
            case 21: {
                return "grayX";
            }
            case 22: {
                return "grayY";
            }
            case 23: {
                return "grayMin";
            }
            case 24: {
                return "grayMax";
            }
            case 25: {
                return "grayUnitName";
            }
            case 26: {
                return "StandardLUT";
            }
            case 27: {
                return "Wavelength";
            }
            case 28: {
                return "StagePosition";
            }
            case 29: {
                return "CameraChipOffset";
            }
            case 30: {
                return "OverlayMask";
            }
            case 31: {
                return "OverlayCompress";
            }
            case 32: {
                return "Overlay";
            }
            case 33: {
                return "SpecialOverlayMask";
            }
            case 34: {
                return "SpecialOverlayCompress";
            }
            case 35: {
                return "SpecialOverlay";
            }
            case 36: {
                return "ImageProperty";
            }
            case 38: {
                return "AutoScaleLoInfo";
            }
            case 39: {
                return "AutoScaleHiInfo";
            }
            case 40: {
                return "AbsoluteZ";
            }
            case 41: {
                return "AbsoluteZValid";
            }
            case 42: {
                return "Gamma";
            }
            case 43: {
                return "GammaRed";
            }
            case 44: {
                return "GammaGreen";
            }
            case 45: {
                return "GammaBlue";
            }
            case 46: {
                return "CameraBin";
            }
            case 47: {
                return "NewLUT";
            }
            case 48: {
                return "ImagePropertyEx";
            }
            case 49: {
                return "PlaneProperty";
            }
            case 50: {
                return "UserLutTable";
            }
            case 51: {
                return "RedAutoScaleInfo";
            }
            case 52: {
                return "RedAutoScaleLoInfo";
            }
            case 53: {
                return "RedAutoScaleHiInfo";
            }
            case 54: {
                return "RedMinScaleInfo";
            }
            case 55: {
                return "RedMaxScaleInfo";
            }
            case 56: {
                return "GreenAutoScaleInfo";
            }
            case 57: {
                return "GreenAutoScaleLoInfo";
            }
            case 58: {
                return "GreenAutoScaleHiInfo";
            }
            case 59: {
                return "GreenMinScaleInfo";
            }
            case 60: {
                return "GreenMaxScaleInfo";
            }
            case 61: {
                return "BlueAutoScaleInfo";
            }
            case 62: {
                return "BlueAutoScaleLoInfo";
            }
            case 63: {
                return "BlueAutoScaleHiInfo";
            }
            case 64: {
                return "BlueMinScaleInfo";
            }
            case 65: {
                return "BlueMaxScaleInfo";
            }
            case 66: {
                return "OverlayPlaneColor";
            }
        }
        return null;
    }
}

