/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.Prefs;
import loci.formats.ClassList;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.in.ND2Reader;
import loci.formats.in.PictReader;
import loci.formats.in.QTReader;
import loci.formats.in.SDTReader;
import loci.formats.in.TiffDelegateReader;

public final class LociPrefs {
    public static final String PREF_READER_ENABLED = "bioformats.enabled";
    public static final String PREF_READER_WINDOWLESS = "bioformats.windowless";
    public static final String PREF_ND2_NIKON = "bioformats.nd2.nikon";
    public static final String PREF_PICT_QTJAVA = "bioformats.pict.qtjava";
    public static final String PREF_QT_QTJAVA = "bioformats.qt.qtjava";
    public static final String PREF_SDT_INTENSITY = "bioformats.sdt.intensity";
    public static final String PREF_TIFF_IMAGEIO = "bioformats.tiff.imageio";

    private LociPrefs() {
    }

    public static ImageReader makeImageReader() {
        ClassList<IFormatReader> defaultClasses = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] c = defaultClasses.getClasses();
        ClassList<IFormatReader> enabledClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (int i = 0; i < c.length; ++i) {
            boolean on = LociPrefs.isReaderEnabled(c[i]);
            if (!on) continue;
            enabledClasses.addClass(c[i]);
        }
        ImageReader reader = new ImageReader(enabledClasses);
        boolean nd2Nikon = LociPrefs.isND2Nikon();
        boolean pictQTJava = LociPrefs.isPictQTJava();
        boolean qtQTJava = LociPrefs.isQTQTJava();
        boolean sdtIntensity = LociPrefs.isSDTIntensity();
        boolean tiffImageIO = LociPrefs.isTiffImageIO();
        IFormatReader[] r = reader.getReaders();
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof ND2Reader) {
                ND2Reader nd2 = (ND2Reader)r[i];
                nd2.setLegacy(nd2Nikon);
                continue;
            }
            if (r[i] instanceof PictReader) {
                PictReader pict = (PictReader)r[i];
                pict.setLegacy(pictQTJava);
                continue;
            }
            if (r[i] instanceof QTReader) {
                QTReader qt = (QTReader)r[i];
                qt.setLegacy(qtQTJava);
                continue;
            }
            if (r[i] instanceof SDTReader) {
                SDTReader sdt = (SDTReader)r[i];
                sdt.setIntensity(sdtIntensity);
                continue;
            }
            if (!(r[i] instanceof TiffDelegateReader)) continue;
            TiffDelegateReader tiff = (TiffDelegateReader)r[i];
            tiff.setLegacy(tiffImageIO);
        }
        return reader;
    }

    public static boolean isWindowless(IFormatReader r) {
        return LociPrefs.getPref(PREF_READER_WINDOWLESS, r.getClass(), false);
    }

    public static boolean isReaderEnabled(Class<? extends IFormatReader> c) {
        return LociPrefs.getPref(PREF_READER_ENABLED, c, true);
    }

    public static boolean isND2Nikon() {
        return Prefs.get((String)PREF_ND2_NIKON, (boolean)false);
    }

    public static boolean isPictQTJava() {
        return Prefs.get((String)PREF_PICT_QTJAVA, (boolean)false);
    }

    public static boolean isQTQTJava() {
        return Prefs.get((String)PREF_QT_QTJAVA, (boolean)false);
    }

    public static boolean isSDTIntensity() {
        return Prefs.get((String)PREF_SDT_INTENSITY, (boolean)false);
    }

    public static boolean isTiffImageIO() {
        return Prefs.get((String)PREF_TIFF_IMAGEIO, (boolean)false);
    }

    private static boolean getPref(String pref, Class<? extends IFormatReader> c, boolean defaultValue) {
        String n = c.getName();
        String readerName = n.substring(n.lastIndexOf(".") + 1, n.length() - 6);
        String key = pref + "." + readerName;
        return Prefs.get((String)key, (boolean)defaultValue);
    }
}

