/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.Roi;
import ij.plugin.RoiRotator;
import ij.plugin.tool.PlugInTool;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RoiRotationTool
extends PlugInTool {
    ImageCanvas ic = null;
    int startX = 0;
    int startY = 0;
    Roi roi;
    Roi newRoi;
    int centerX;
    int centerY;
    int xNew;
    int yNew;
    int dx1;
    int dy1;
    int dx2;
    int dy2;
    double l;
    double l1;
    double l2;
    double dx;
    double dy;
    double phi;
    double phi1;
    double phi2;
    boolean isImageRoi;
    Rectangle bounds;
    ImagePlus imp2;
    static final int UPDOWNROTATION = 0;
    static final int CIRCULARROTATION = 1;
    int defaultRotationMode = 1;

    public void mousePressed(ImagePlus imp, MouseEvent e) {
        if (imp == null) {
            return;
        }
        this.imp2 = imp;
        this.ic = imp.getCanvas();
        if (this.ic == null) {
            return;
        }
        this.roi = imp.getRoi();
        if (this.roi == null) {
            IJ.beep();
            IJ.showStatus("No selection");
            return;
        }
        this.startX = this.ic.offScreenX(e.getX());
        this.startY = this.ic.offScreenY(e.getY());
        if (this.defaultRotationMode == 0) {
            this.centerX = imp.getWidth() / 2;
            this.centerY = imp.getHeight() / 2;
        } else {
            Rectangle bounds = this.roi.getBounds();
            this.centerX = bounds.x + bounds.width / 2;
            this.centerY = bounds.y + bounds.height / 2;
        }
    }

    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        if (imp == null || this.ic == null) {
            return;
        }
        this.roi = imp.getRoi();
        if (this.roi == null) {
            return;
        }
        this.isImageRoi = this.roi instanceof ImageRoi;
        if (this.isImageRoi) {
            ((ImageRoi)this.roi).setZeroTransparent(true);
        }
        if (e.isAltDown() || e.isShiftDown()) {
            this.moveRoi(e.getX(), e.getY());
        } else {
            this.rotateRoi(e.getX(), e.getY());
        }
    }

    public void showOptionsDialog() {
        IJ.log("PlugInTool MouseRoiRotator Peter Haub dipsystems.de 10'2015");
    }

    public String getToolName() {
        return "Selection Rotator (press alt key to move)";
    }

    public String getToolIcon() {
        return "C037D06D15D16D24D25D26D27D28D29D2aD33D34D35D36D37D3bD3cD42D43D44D45D46D47D48D4cD4dDb1Db2Db6Db7Db8Db9DbaDbbDbcDc2Dc3Dc7Dc8Dc9DcaDcbDd4Dd5Dd6Dd7Dd8Dd9DdaDe8De9Df8CabcD05D14D17D18D19D1aD23D2bD2cD32D3dD41D51D52D53D54D55D56D57D58Da6Da7Da8Da9DaaDabDacDadDbdDc1DccDd2Dd3DdbDe4De5De6De7DeaDf9";
    }

    void rotateRoi(int sx, int sy) {
        this.xNew = this.ic.offScreenX(sx);
        this.yNew = this.ic.offScreenY(sy);
        this.dx1 = this.centerX - this.xNew;
        this.dy1 = this.centerY - this.yNew;
        this.dx2 = this.centerX - this.startX;
        this.dy2 = this.centerY - this.startY;
        if (this.defaultRotationMode == 0) {
            this.l1 = Math.sqrt(this.dx1 * this.dx1 + this.dy1 * this.dy1);
            this.l2 = Math.sqrt(this.dx2 * this.dx2 + this.dy2 * this.dy2);
            this.l = (this.l1 + this.l2) / 2.0;
            this.dy = this.yNew - this.startY;
            if (this.l == 0.0 || this.dy == 0.0) {
                return;
            }
            this.phi = Math.atan2(this.dy, this.l);
        } else {
            this.phi1 = Math.atan2(this.dy1, this.dx1);
            this.phi2 = Math.atan2(this.dy2, this.dx2);
            this.phi = this.phi1 - this.phi2;
            if (this.phi == 0.0 || this.phi == Double.NaN) {
                return;
            }
        }
        this.startX = this.xNew;
        this.startY = this.yNew;
        this.newRoi = RoiRotator.rotate(this.roi, this.phi * 180.0 / Math.PI);
        if (this.isImageRoi) {
            this.imp2.draw();
        } else {
            this.imp2.setRoi(this.newRoi);
        }
    }

    void moveRoi(int sx, int sy) {
        this.xNew = this.ic.offScreenX(sx);
        this.yNew = this.ic.offScreenY(sy);
        this.dx1 = this.xNew - this.startX;
        this.dy1 = this.yNew - this.startY;
        if (this.dx1 == 0 && this.dy2 == 0) {
            return;
        }
        this.startX = this.xNew;
        this.startY = this.yNew;
        this.dx = this.roi.getXBase() + (double)this.dx1;
        this.dy = this.roi.getYBase() + (double)this.dy1;
        this.roi.setLocation(this.dx, this.dy);
        this.imp2.draw();
    }
}

