/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BinaryOnly;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plate;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reference;
import ome.xml.model.Rights;
import ome.xml.model.Screen;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OME
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(OME.class);
    private String uuid;
    private String creator;
    private Rights rights;
    private List<Project> projects = new ArrayList<Project>();
    private List<Dataset> datasets = new ArrayList<Dataset>();
    private List<Experiment> experiments = new ArrayList<Experiment>();
    private List<Plate> plates = new ArrayList<Plate>();
    private List<Screen> screens = new ArrayList<Screen>();
    private List<Experimenter> experimenters = new ArrayList<Experimenter>();
    private List<ExperimenterGroup> experimenterGroups = new ArrayList<ExperimenterGroup>();
    private List<Instrument> instruments = new ArrayList<Instrument>();
    private List<Image> images = new ArrayList<Image>();
    private StructuredAnnotations structuredAnnotations;
    private List<ROI> roIs = new ArrayList<ROI>();
    private BinaryOnly binaryOnly;

    public OME() {
    }

    public OME(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public OME(OME orig) {
        this.uuid = orig.uuid;
        this.creator = orig.creator;
        this.rights = orig.rights;
        this.projects = orig.projects;
        this.datasets = orig.datasets;
        this.experiments = orig.experiments;
        this.plates = orig.plates;
        this.screens = orig.screens;
        this.experimenters = orig.experimenters;
        this.experimenterGroups = orig.experimenterGroups;
        this.instruments = orig.instruments;
        this.images = orig.images;
        this.structuredAnnotations = orig.structuredAnnotations;
        this.roIs = orig.roIs;
        this.binaryOnly = orig.binaryOnly;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Rights_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"OME".equals(tagName)) {
            LOGGER.debug("Expecting node name of OME got {}", (Object)tagName);
        }
        if (element.hasAttribute("UUID")) {
            this.setUUID(String.valueOf(element.getAttribute("UUID")));
        }
        if (element.hasAttribute("Creator")) {
            this.setCreator(String.valueOf(element.getAttribute("Creator")));
        }
        if ((Rights_nodeList = OME.getChildrenByTagName(element, "Rights")).size() > 1) {
            throw new RuntimeException(String.format("Rights node list size %d != 1", Rights_nodeList.size()));
        }
        if (Rights_nodeList.size() != 0) {
            this.setRights(new Rights(Rights_nodeList.get(0), model));
        }
        List<Element> Project_nodeList = OME.getChildrenByTagName(element, "Project");
        for (Element Project_element : Project_nodeList) {
            this.addProject(new Project(Project_element, model));
        }
        List<Element> Dataset_nodeList = OME.getChildrenByTagName(element, "Dataset");
        for (Element Dataset_element : Dataset_nodeList) {
            this.addDataset(new Dataset(Dataset_element, model));
        }
        List<Element> Experiment_nodeList = OME.getChildrenByTagName(element, "Experiment");
        for (Element Experiment_element : Experiment_nodeList) {
            this.addExperiment(new Experiment(Experiment_element, model));
        }
        List<Element> Plate_nodeList = OME.getChildrenByTagName(element, "Plate");
        for (Element Plate_element : Plate_nodeList) {
            this.addPlate(new Plate(Plate_element, model));
        }
        List<Element> Screen_nodeList = OME.getChildrenByTagName(element, "Screen");
        for (Element Screen_element : Screen_nodeList) {
            this.addScreen(new Screen(Screen_element, model));
        }
        List<Element> Experimenter_nodeList = OME.getChildrenByTagName(element, "Experimenter");
        for (Element Experimenter_element : Experimenter_nodeList) {
            this.addExperimenter(new Experimenter(Experimenter_element, model));
        }
        List<Element> ExperimenterGroup_nodeList = OME.getChildrenByTagName(element, "ExperimenterGroup");
        for (Element ExperimenterGroup_element : ExperimenterGroup_nodeList) {
            this.addExperimenterGroup(new ExperimenterGroup(ExperimenterGroup_element, model));
        }
        List<Element> Instrument_nodeList = OME.getChildrenByTagName(element, "Instrument");
        for (Element Instrument_element : Instrument_nodeList) {
            this.addInstrument(new Instrument(Instrument_element, model));
        }
        List<Element> Image_nodeList = OME.getChildrenByTagName(element, "Image");
        for (Element Image_element : Image_nodeList) {
            this.addImage(new Image(Image_element, model));
        }
        List<Element> StructuredAnnotations_nodeList = OME.getChildrenByTagName(element, "StructuredAnnotations");
        if (StructuredAnnotations_nodeList.size() > 1) {
            throw new RuntimeException(String.format("StructuredAnnotations node list size %d != 1", StructuredAnnotations_nodeList.size()));
        }
        if (StructuredAnnotations_nodeList.size() != 0) {
            this.setStructuredAnnotations(new StructuredAnnotations(StructuredAnnotations_nodeList.get(0), model));
        }
        List<Element> ROI_nodeList = OME.getChildrenByTagName(element, "ROI");
        for (Element ROI_element : ROI_nodeList) {
            this.addROI(new ROI(ROI_element, model));
        }
        List<Element> BinaryOnly_nodeList = OME.getChildrenByTagName(element, "BinaryOnly");
        if (BinaryOnly_nodeList.size() > 1) {
            throw new RuntimeException(String.format("BinaryOnly node list size %d != 1", BinaryOnly_nodeList.size()));
        }
        if (BinaryOnly_nodeList.size() != 0) {
            this.setBinaryOnly(new BinaryOnly(BinaryOnly_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Rights getRights() {
        return this.rights;
    }

    public void setRights(Rights rights) {
        this.rights = rights;
    }

    public int sizeOfProjectList() {
        return this.projects.size();
    }

    public List<Project> copyProjectList() {
        return new ArrayList<Project>(this.projects);
    }

    public Project getProject(int index) {
        return this.projects.get(index);
    }

    public Project setProject(int index, Project project) {
        return this.projects.set(index, project);
    }

    public void addProject(Project project) {
        this.projects.add(project);
    }

    public void removeProject(Project project) {
        this.projects.remove(project);
    }

    public int sizeOfDatasetList() {
        return this.datasets.size();
    }

    public List<Dataset> copyDatasetList() {
        return new ArrayList<Dataset>(this.datasets);
    }

    public Dataset getDataset(int index) {
        return this.datasets.get(index);
    }

    public Dataset setDataset(int index, Dataset dataset) {
        return this.datasets.set(index, dataset);
    }

    public void addDataset(Dataset dataset) {
        this.datasets.add(dataset);
    }

    public void removeDataset(Dataset dataset) {
        this.datasets.remove(dataset);
    }

    public int sizeOfExperimentList() {
        return this.experiments.size();
    }

    public List<Experiment> copyExperimentList() {
        return new ArrayList<Experiment>(this.experiments);
    }

    public Experiment getExperiment(int index) {
        return this.experiments.get(index);
    }

    public Experiment setExperiment(int index, Experiment experiment) {
        return this.experiments.set(index, experiment);
    }

    public void addExperiment(Experiment experiment) {
        this.experiments.add(experiment);
    }

    public void removeExperiment(Experiment experiment) {
        this.experiments.remove(experiment);
    }

    public int sizeOfPlateList() {
        return this.plates.size();
    }

    public List<Plate> copyPlateList() {
        return new ArrayList<Plate>(this.plates);
    }

    public Plate getPlate(int index) {
        return this.plates.get(index);
    }

    public Plate setPlate(int index, Plate plate) {
        return this.plates.set(index, plate);
    }

    public void addPlate(Plate plate) {
        this.plates.add(plate);
    }

    public void removePlate(Plate plate) {
        this.plates.remove(plate);
    }

    public int sizeOfScreenList() {
        return this.screens.size();
    }

    public List<Screen> copyScreenList() {
        return new ArrayList<Screen>(this.screens);
    }

    public Screen getScreen(int index) {
        return this.screens.get(index);
    }

    public Screen setScreen(int index, Screen screen) {
        return this.screens.set(index, screen);
    }

    public void addScreen(Screen screen) {
        this.screens.add(screen);
    }

    public void removeScreen(Screen screen) {
        this.screens.remove(screen);
    }

    public int sizeOfExperimenterList() {
        return this.experimenters.size();
    }

    public List<Experimenter> copyExperimenterList() {
        return new ArrayList<Experimenter>(this.experimenters);
    }

    public Experimenter getExperimenter(int index) {
        return this.experimenters.get(index);
    }

    public Experimenter setExperimenter(int index, Experimenter experimenter) {
        return this.experimenters.set(index, experimenter);
    }

    public void addExperimenter(Experimenter experimenter) {
        this.experimenters.add(experimenter);
    }

    public void removeExperimenter(Experimenter experimenter) {
        this.experimenters.remove(experimenter);
    }

    public int sizeOfExperimenterGroupList() {
        return this.experimenterGroups.size();
    }

    public List<ExperimenterGroup> copyExperimenterGroupList() {
        return new ArrayList<ExperimenterGroup>(this.experimenterGroups);
    }

    public ExperimenterGroup getExperimenterGroup(int index) {
        return this.experimenterGroups.get(index);
    }

    public ExperimenterGroup setExperimenterGroup(int index, ExperimenterGroup experimenterGroup) {
        return this.experimenterGroups.set(index, experimenterGroup);
    }

    public void addExperimenterGroup(ExperimenterGroup experimenterGroup) {
        this.experimenterGroups.add(experimenterGroup);
    }

    public void removeExperimenterGroup(ExperimenterGroup experimenterGroup) {
        this.experimenterGroups.remove(experimenterGroup);
    }

    public int sizeOfInstrumentList() {
        return this.instruments.size();
    }

    public List<Instrument> copyInstrumentList() {
        return new ArrayList<Instrument>(this.instruments);
    }

    public Instrument getInstrument(int index) {
        return this.instruments.get(index);
    }

    public Instrument setInstrument(int index, Instrument instrument) {
        return this.instruments.set(index, instrument);
    }

    public void addInstrument(Instrument instrument) {
        this.instruments.add(instrument);
    }

    public void removeInstrument(Instrument instrument) {
        this.instruments.remove(instrument);
    }

    public int sizeOfImageList() {
        return this.images.size();
    }

    public List<Image> copyImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getImage(int index) {
        return this.images.get(index);
    }

    public Image setImage(int index, Image image) {
        return this.images.set(index, image);
    }

    public void addImage(Image image) {
        this.images.add(image);
    }

    public void removeImage(Image image) {
        this.images.remove(image);
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations) {
        this.structuredAnnotations = structuredAnnotations;
    }

    public int sizeOfROIList() {
        return this.roIs.size();
    }

    public List<ROI> copyROIList() {
        return new ArrayList<ROI>(this.roIs);
    }

    public ROI getROI(int index) {
        return this.roIs.get(index);
    }

    public ROI setROI(int index, ROI roi) {
        return this.roIs.set(index, roi);
    }

    public void addROI(ROI roi) {
        this.roIs.add(roi);
    }

    public void removeROI(ROI roi) {
        this.roIs.remove(roi);
    }

    public BinaryOnly getBinaryOnly() {
        return this.binaryOnly;
    }

    public void setBinaryOnly(BinaryOnly binaryOnly) {
        this.binaryOnly = binaryOnly;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element OME_element) {
        if (OME_element == null) {
            OME_element = document.createElementNS(NAMESPACE, "OME");
        }
        if (this.uuid != null) {
            OME_element.setAttribute("UUID", this.uuid.toString());
        }
        if (this.creator != null) {
            OME_element.setAttribute("Creator", this.creator.toString());
        }
        if (this.rights != null) {
            OME_element.appendChild(this.rights.asXMLElement(document));
        }
        if (this.projects != null) {
            for (Project projects_value : this.projects) {
                OME_element.appendChild(projects_value.asXMLElement(document));
            }
        }
        if (this.datasets != null) {
            for (Dataset datasets_value : this.datasets) {
                OME_element.appendChild(datasets_value.asXMLElement(document));
            }
        }
        if (this.experiments != null) {
            for (Experiment experiments_value : this.experiments) {
                OME_element.appendChild(experiments_value.asXMLElement(document));
            }
        }
        if (this.plates != null) {
            for (Plate plates_value : this.plates) {
                OME_element.appendChild(plates_value.asXMLElement(document));
            }
        }
        if (this.screens != null) {
            for (Screen screens_value : this.screens) {
                OME_element.appendChild(screens_value.asXMLElement(document));
            }
        }
        if (this.experimenters != null) {
            for (Experimenter experimenters_value : this.experimenters) {
                OME_element.appendChild(experimenters_value.asXMLElement(document));
            }
        }
        if (this.experimenterGroups != null) {
            for (ExperimenterGroup experimenterGroups_value : this.experimenterGroups) {
                OME_element.appendChild(experimenterGroups_value.asXMLElement(document));
            }
        }
        if (this.instruments != null) {
            for (Instrument instruments_value : this.instruments) {
                OME_element.appendChild(instruments_value.asXMLElement(document));
            }
        }
        if (this.images != null) {
            for (Image images_value : this.images) {
                OME_element.appendChild(images_value.asXMLElement(document));
            }
        }
        if (this.structuredAnnotations != null) {
            OME_element.appendChild(this.structuredAnnotations.asXMLElement(document));
        }
        if (this.roIs != null) {
            for (ROI roIs_value : this.roIs) {
                OME_element.appendChild(roIs_value.asXMLElement(document));
            }
        }
        if (this.binaryOnly != null) {
            OME_element.appendChild(this.binaryOnly.asXMLElement(document));
        }
        return super.asXMLElement(document, OME_element);
    }
}

