/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;

public class OnDemandLongArray {
    private transient RandomAccessInputStream stream;
    private int size;
    private long start;

    public OnDemandLongArray(RandomAccessInputStream in) throws IOException {
        this.stream = in;
        this.start = this.stream.getFilePointer();
    }

    public void setSize(int size) {
        this.size = size;
    }

    public RandomAccessInputStream getStream() {
        return this.stream;
    }

    public void setStream(RandomAccessInputStream in) {
        this.stream = in;
    }

    public long get(int index) throws IOException {
        long fp = this.stream.getFilePointer();
        this.stream.seek(this.start + (long)(index * 8));
        long value = this.stream.readLong();
        this.stream.seek(fp);
        return value;
    }

    public long size() {
        return this.size;
    }

    public long[] toArray() throws IOException {
        long fp = this.stream.getFilePointer();
        this.stream.seek(this.start);
        byte[] rawBytes = new byte[this.size * 8];
        this.stream.readFully(rawBytes);
        this.stream.seek(fp);
        return (long[])DataTools.makeDataArray(rawBytes, 8, false, this.stream.isLittleEndian());
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
        this.size = 0;
        this.start = 0L;
    }
}

