package plugins.tprovoost.Microscopy.CalibratorManager;

import icy.gui.frame.IcyFrame;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.system.thread.ThreadUtil;

import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;

import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

/**
 * A plugin which show in a tabbed pane all calibration plugin created by extending
 * {@link CalibratorPlugin}
 * 
 * @author Irsath Nguyen
 */
public final class CalibratorManagerPlugin extends MicroscopePlugin
{
    static IcyFrame frame;

    @Override
    public void start()
    {
        if (frame == null)
        {
            ThreadUtil.invokeNow(new Runnable()
            {
                @Override
                public void run()
                {
                    final JTabbedPane container = new JTabbedPane(SwingConstants.TOP);

                    ThreadUtil.bgRun(new Runnable()
                    {
                        @Override
                        public void run()
                        {
                            for (PluginDescriptor d : PluginLoader.getPlugins(CalibratorPlugin.class))
                            {
                                final CalibratorPlugin c = ((CalibratorPlugin) PluginLauncher.start(d));
                                c.initializePluginData(MicroManager.getCore());
                                ThreadUtil.invokeNow(new Runnable()
                                {
                                    @Override
                                    public void run()
                                    {
                                        container.add(c.getJTabbedPaneTitle(), c.getJTabbedPaneContent());
                                    }
                                });
                            }
                        }
                    });

                    frame = new IcyFrame("Calibrator Manager", true, true, true, true)
                    {
                        @Override
                        public void onClosed()
                        {
                            super.onClosed();
                            frame = null;
                        }
                    };

                    frame.add(container);
                    frame.addToDesktopPane();
                    frame.setVisible(true);
                }
            });
        }

        frame.toFront();
    }

    @Override
    public void shutdown()
    {
        super.shutdown();
        
        if (frame != null)
            frame.dispose();
        frame = null;
    }
}
