/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import loci.formats.UpgradeChecker;
import loci.plugins.BF;

public class Updater
implements PlugIn {
    private static final String TRUNK = "Trunk build";
    private static final String DAILY = "Daily build";
    private static final String STABLE = "Stable build (5.1.5)";
    public boolean canceled;
    private String urlPath;

    public void run(String arg) {
        if (Updater.isFiji()) {
            IJ.showMessage((String)"Please use 'Help > Update Fiji' to update.");
            return;
        }
        GenericDialog upgradeDialog = new GenericDialog("Update Bio-Formats Plugins");
        String[] options = new String[]{TRUNK, DAILY, STABLE};
        upgradeDialog.addChoice("Release", options, options[0]);
        upgradeDialog.showDialog();
        if (upgradeDialog.wasCanceled()) {
            this.canceled = true;
            return;
        }
        String release = upgradeDialog.getNextChoice();
        if (release.equals(TRUNK)) {
            this.urlPath = "http://ci.openmicroscopy.org/job/BIOFORMATS-5.1-latest/lastSuccessfulBuild/artifact/artifacts/";
        } else if (release.equals(DAILY)) {
            this.urlPath = "http://ci.openmicroscopy.org/job/BIOFORMATS-5.1-daily/lastSuccessfulBuild/artifact/artifacts/";
        } else if (release.equals(STABLE)) {
            this.urlPath = "http://downloads.openmicroscopy.org/bio-formats/5.1.5/artifacts/";
        }
        this.urlPath = this.urlPath + "bioformats_package.jar";
        Updater.install(this.urlPath);
    }

    public static boolean isFiji() {
        String title;
        ImageJ ij = IJ.getInstance();
        if (ij != null && (title = ij.getTitle()) != null) {
            return title.indexOf("Fiji") >= 0;
        }
        return false;
    }

    public static void install(String urlPath) {
        String pluginsDirectory;
        String jarPath = pluginsDirectory = IJ.getDirectory((String)"plugins");
        if (!Updater.isFiji()) {
            jarPath = jarPath + "bioformats_package.jar";
        }
        BF.status(false, "Downloading...");
        boolean success = false;
        if (Updater.isFiji()) {
            return;
        }
        success = new UpgradeChecker().install(urlPath, jarPath);
        BF.status(false, "");
        if (!success) {
            IJ.showMessage((String)"An error occurred while downloading the Bio-Formats plugins");
        } else {
            IJ.showMessage((String)"The Bio-Formats plugins have been downloaded.\nPlease restart ImageJ to complete the upgrade process.");
        }
    }

    private static String find(String dir, String filename) {
        String[] list;
        File dirFile = new File(dir);
        for (String f : list = dirFile.list()) {
            File nextFile = new File(dirFile, f);
            if (nextFile.isDirectory()) {
                String result = Updater.find(nextFile.getAbsolutePath(), filename);
                if (result == null) continue;
                return result;
            }
            int dot = filename.indexOf(".");
            if (!f.startsWith(filename.substring(0, dot)) || !f.endsWith(filename.substring(dot))) continue;
            return nextFile.getAbsolutePath();
        }
        return null;
    }
}

