/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;

public class HyBRDoubleIterationMonitor
extends AbstractDoubleIterationMonitor {
    protected HyBRStoppingCondition stoppingCondition;
    protected int maxIter;
    protected double dtol;
    protected double initR;
    protected double regularizationParameter;

    public HyBRDoubleIterationMonitor() {
        this.maxIter = 100;
        this.dtol = 100000.0;
        this.stoppingCondition = HyBRStoppingCondition.PERFORMED_MAX_NUMBER_OF_ITERATIONS;
    }

    public HyBRDoubleIterationMonitor(int maxIter, double dtol) {
        this.maxIter = maxIter;
        this.dtol = dtol;
        this.stoppingCondition = HyBRStoppingCondition.PERFORMED_MAX_NUMBER_OF_ITERATIONS;
    }

    @Override
    public boolean converged(double r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(r, x, this.iter);
        }
        this.residual = r;
        return this.convergedI(r, x);
    }

    @Override
    public boolean converged(double r) throws IterativeSolverDoubleNotConvergedException {
        if (!this.isFirst()) {
            this.reporter.monitor(r, this.iter);
        }
        this.residual = r;
        return this.convergedI(r);
    }

    @Override
    protected boolean convergedI(double r) throws IterativeSolverDoubleNotConvergedException {
        if (this.isFirst()) {
            this.initR = r;
        }
        if (this.initR != -1.0 && r > this.dtol * this.initR) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter + 1) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(r)) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    @Override
    protected boolean convergedI(double r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        return this.convergedI(r);
    }

    @Override
    public int getMaxIterations() {
        return this.maxIter;
    }

    @Override
    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public void setDivergenceTolerance(double dtol) {
        this.dtol = dtol;
    }

    public double getDivergenceTolerance() {
        return this.dtol;
    }

    public double getRegularizationParameter() {
        return this.regularizationParameter;
    }

    public void setRegularizationParameter(double regularizationParameter) {
        this.regularizationParameter = regularizationParameter;
    }

    public void setStoppingCondition(HyBRStoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public HyBRStoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    @Override
    public int iterations() {
        return Math.min(this.iter, this.maxIter);
    }

    protected static enum HyBRStoppingCondition {
        FLAT_GCV_CURVE,
        MIN_OF_GCV_CURVE_WITHIN_WINDOW_OF_4_ITERATIONS,
        PERFORMED_MAX_NUMBER_OF_ITERATIONS;

    }
}

