package plugins.adufour.activemeshes.mesh;

import java.util.ArrayList;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Vertex
{
	public final Point3d			position;
	
	public final ArrayList<Integer>	neighbors;
	
	public final Vector3d			forces;
	
	public final Vector3d			normal;
	
	public double					distanceToCenter	= 0;
	
	public Vertex(Vertex v)
	{
		this(v.position, v.neighbors);
	}
	
	public Vertex(Point3d position)
	{
		this(position, 0);
	}
	
	public Vertex(Point3d position, int nbNeighbors)
	{
		this.position = new Point3d(position);
		if (Double.isNaN(position.x))
		{
			System.out.println("new vertex is NaN");
		}
		this.neighbors = new ArrayList<Integer>(nbNeighbors);
		this.forces = new Vector3d();
		this.normal = new Vector3d();
	}
	
	public Vertex(Point3d position, ArrayList<Integer> neighbors)
	{
		this(position, neighbors.size());
		for (Integer i : neighbors)
			this.neighbors.add(new Integer(i));
	}
	
	public String toString()
	{
		return "Vertex {" + position.x + "," + position.y + "," + position.z + "}, " + neighbors.size() + " neighbors";
	}
}
