    package plugins.adufour.activemeshes.producers;

import java.io.File;

import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.roi.mesh.Vertex3D;
import plugins.adufour.roi.mesh.polygon.Polygon3D;
import plugins.adufour.roi.mesh.polygon.ROI3DPolygonalMesh;

public class VTKMeshReader extends MeshProducer
{
	private final File	vtkFile;
	
	public VTKMeshReader(File vtkFile, boolean useVTK)
	{
		super(new Mesh(0, 0, 0, useVTK));
		this.vtkFile = vtkFile;
	}
	
	@Override
	public void run()
	{
		try
		{
		    ROI3DPolygonalMesh m = new ROI3DPolygonalMesh();
		    m.loadFromVTK(vtkFile);
		    
		    for(Vertex3D v : m.getVertices())
		        mesh.topology.addVertex(v.position);
		    
		    for(Polygon3D face : m.getCells())
		        mesh.topology.addFace(face.vertexIndices[0], face.vertexIndices[1], face.vertexIndices[2]);
		    
//			FileInputStream fis = new FileInputStream(vtkFile);
//			BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
//			
//			@SuppressWarnings("unused")
//			String header = reader.readLine();
//			@SuppressWarnings("unused")
//			String description = reader.readLine();
//			@SuppressWarnings("unused")
//			String encoding = reader.readLine();
//			@SuppressWarnings("unused")
//			String dataType = reader.readLine();
//			
//			int nbPts = Integer.parseInt(reader.readLine().split(" ")[1]);
//			//mesh.vertices.ensureCapacity(nbPts);
//			
//			for (int i = 0; i < nbPts; i++)
//			{
//				String[] vertex = reader.readLine().split(" ");
//				mesh.topology.addVertex(new Point3d(Double.parseDouble(vertex[0]), Double.parseDouble(vertex[1]), Double.parseDouble(vertex[2])));
//			}
//			
//			int nbFaces = Integer.parseInt(reader.readLine().split(" ")[1]);
//			//mesh.faces.ensureCapacity(nbFaces);
//			
//			//double resolution = 0;
//			
//			for (int i = 0; i < nbFaces; i++)
//			{
//				String[] face = reader.readLine().split(" ");
//				int v1 = Integer.parseInt(face[1]);
//				int v2 = Integer.parseInt(face[2]);
//				int v3 = Integer.parseInt(face[3]);
//				mesh.topology.addFace(v1, v2, v3);
//				
//				//resolution += mesh.vertices.get(v1).position.distance(mesh.vertices.get(v2).position);
//				//resolution += mesh.vertices.get(v1).position.distance(mesh.vertices.get(v3).position);
//			}
//			
//			//resolution /= nbFaces * 2;
//			//mesh.topology.setResolution(resolution);

		    
		    
			mesh.topology.endUpdate();
		}
		catch (Exception e)
		{
			throw new MeshProducerException("Error reading mesh from VTK file", e);
		}
	}
}
