/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdcomplex;

import cern.jet.math.tdouble.DoubleConstants;

public class DComplex
extends DoubleConstants {
    public static final double abs(double[] x) {
        double absX = Math.abs(x[0]);
        double absY = Math.abs(x[1]);
        if (absX == 0.0 && absY == 0.0) {
            return 0.0;
        }
        if (absX >= absY) {
            double d = x[1] / x[0];
            return absX * Math.sqrt(1.0 + d * d);
        }
        double d = x[0] / x[1];
        return absY * Math.sqrt(1.0 + d * d);
    }

    public static final double abs(double re, double im) {
        double absX = Math.abs(re);
        double absY = Math.abs(im);
        if (absX == 0.0 && absY == 0.0) {
            return 0.0;
        }
        if (absX >= absY) {
            double d = im / re;
            return absX * Math.sqrt(1.0 + d * d);
        }
        double d = re / im;
        return absY * Math.sqrt(1.0 + d * d);
    }

    public static final double[] acos(double[] x) {
        double[] z = new double[2];
        double re = 1.0 - (x[0] * x[0] - x[1] * x[1]);
        double im = -(x[0] * x[1] + x[1] * x[0]);
        z[0] = re;
        z[1] = im;
        z = DComplex.sqrt(z);
        re = -z[1];
        im = z[0];
        z[0] = x[0] + re;
        z[1] = x[1] + im;
        re = Math.log(DComplex.abs(z));
        z[0] = im = Math.atan2(z[1], z[0]);
        z[1] = -re;
        return z;
    }

    public static final double arg(double[] x) {
        return Math.atan2(x[1], x[0]);
    }

    public static final double arg(double re, double im) {
        return Math.atan2(im, re);
    }

    public static final double[] asin(double[] x) {
        double[] z = new double[2];
        double re = 1.0 - (x[0] * x[0] - x[1] * x[1]);
        double im = -(x[0] * x[1] + x[1] * x[0]);
        z[0] = re;
        z[1] = im;
        z = DComplex.sqrt(z);
        re = -z[1];
        im = z[0];
        z[0] = z[0] + re;
        z[1] = z[1] + im;
        re = Math.log(DComplex.abs(z));
        z[0] = im = Math.atan2(z[1], z[0]);
        z[1] = -re;
        return z;
    }

    public static final double[] atan(double[] x) {
        double[] z = new double[]{-x[0], 1.0 - x[1]};
        double re = x[0];
        double im = 1.0 + x[1];
        z = DComplex.div(z, re, im);
        re = Math.log(DComplex.abs(z));
        im = Math.atan2(z[1], z[0]);
        z[0] = 0.5 * im;
        z[1] = -0.5 * re;
        return z;
    }

    public static final double[] conj(double[] x) {
        double[] z = new double[]{x[0], -x[1]};
        return z;
    }

    public static final double[] cos(double[] x) {
        double[] z = new double[2];
        double iz_re = -x[1];
        double iz_im = x[0];
        double scalar = Math.exp(iz_re);
        double re1 = scalar * Math.cos(iz_im);
        double im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double re2 = scalar * Math.cos(-iz_im);
        double im2 = scalar * Math.sin(-iz_im);
        z[0] = 0.5 * (re1 += re2);
        z[1] = 0.5 * (im1 += im2);
        return z;
    }

    public static final double[] div(double[] x, double re, double im) {
        double[] z = new double[2];
        if (Math.abs(re) >= Math.abs(im)) {
            double scalar = 1.0 / (re + im * (im / re));
            z[0] = scalar * (x[0] + x[1] * (im / re));
            z[1] = scalar * (x[1] - x[0] * (im / re));
        } else {
            double scalar = 1.0 / (re * (re / im) + im);
            z[0] = scalar * (x[0] * (re / im) + x[1]);
            z[1] = scalar * (x[1] * (re / im) - x[0]);
        }
        return z;
    }

    public static final double[] div(double[] x, double[] y) {
        return DComplex.div(x, y[0], y[1]);
    }

    public static final double equals(double[] x, double[] y, double tol) {
        if (DComplex.abs(x[0] - y[0], x[1] - y[1]) <= Math.abs(tol)) {
            return 1.0;
        }
        return 0.0;
    }

    public static final boolean isEqual(double[] x, double[] y, double tol) {
        return DComplex.abs(x[0] - y[0], x[1] - y[1]) <= Math.abs(tol);
    }

    public static final double[] exp(double[] x) {
        double[] z = new double[2];
        double scalar = Math.exp(x[0]);
        z[0] = scalar * Math.cos(x[1]);
        z[1] = scalar * Math.sin(x[1]);
        return z;
    }

    public static final double[] inv(double[] x) {
        double[] z = new double[2];
        if (x[1] != 0.0) {
            if (Math.abs(x[0]) >= Math.abs(x[1])) {
                double scalar;
                z[0] = scalar = 1.0 / (x[0] + x[1] * (x[1] / x[0]));
                z[1] = scalar * (-x[1] / x[0]);
            } else {
                double scalar = 1.0 / (x[0] * (x[0] / x[1]) + x[1]);
                z[0] = scalar * (x[0] / x[1]);
                z[1] = -scalar;
            }
        } else {
            z[0] = 1.0 / x[0];
            z[1] = 0.0;
        }
        return z;
    }

    public static final double[] log(double[] x) {
        double[] z = new double[]{Math.log(DComplex.abs(x)), DComplex.arg(x)};
        return z;
    }

    public static final double[] minus(double[] x, double[] y) {
        double[] z = new double[]{x[0] - y[0], x[1] - y[1]};
        return z;
    }

    public static final double[] minusAbs(double[] x, double[] y) {
        double[] z = new double[]{Math.abs(x[0] - y[0]), Math.abs(x[1] - y[1])};
        return z;
    }

    public static final double[] mult(double[] x, double y) {
        double[] z = new double[]{x[0] * y, x[1] * y};
        return z;
    }

    public static final double[] mult(double[] x, double[] y) {
        double[] z = new double[]{x[0] * y[0] - x[1] * y[1], x[1] * y[0] + x[0] * y[1]};
        return z;
    }

    public static final double[] neg(double[] x) {
        double[] z = new double[]{-x[0], -x[1]};
        return z;
    }

    public static final double[] plus(double[] x, double[] y) {
        double[] z = new double[]{x[0] + y[0], x[1] + y[1]};
        return z;
    }

    public static final double[] pow(double[] x, double y) {
        double[] z = new double[2];
        double re = y * Math.log(DComplex.abs(x));
        double im = y * DComplex.arg(x);
        double scalar = Math.exp(re);
        z[0] = scalar * Math.cos(im);
        z[1] = scalar * Math.sin(im);
        return z;
    }

    public static final double[] pow(double x, double[] y) {
        double[] z = new double[2];
        double re = Math.log(Math.abs(x));
        double im = Math.atan2(0.0, x);
        double re2 = re * y[0] - im * y[1];
        double im2 = re * y[1] + im * y[0];
        double scalar = Math.exp(re2);
        z[0] = scalar * Math.cos(im2);
        z[1] = scalar * Math.sin(im2);
        return z;
    }

    public static final double[] pow(double[] x, double[] y) {
        double[] z = new double[2];
        double re = Math.log(DComplex.abs(x));
        double im = DComplex.arg(x);
        double re2 = re * y[0] - im * y[1];
        double im2 = re * y[1] + im * y[0];
        double scalar = Math.exp(re2);
        z[0] = scalar * Math.cos(im2);
        z[1] = scalar * Math.sin(im2);
        return z;
    }

    public static final double[] sin(double[] x) {
        double[] z = new double[2];
        double iz_re = -x[1];
        double iz_im = x[0];
        double scalar = Math.exp(iz_re);
        double re1 = scalar * Math.cos(iz_im);
        double im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double re2 = scalar * Math.cos(-iz_im);
        double im2 = scalar * Math.sin(-iz_im);
        z[0] = 0.5 * (im1 -= im2);
        z[1] = -0.5 * (re1 -= re2);
        return z;
    }

    public static final double[] sqrt(double[] x) {
        double[] z = new double[2];
        double absx = DComplex.abs(x);
        if (absx > 0.0) {
            if (x[0] > 0.0) {
                double tmp;
                z[0] = tmp = Math.sqrt(0.5 * (absx + x[0]));
                z[1] = 0.5 * (x[1] / tmp);
            } else {
                double tmp = Math.sqrt(0.5 * (absx - x[0]));
                if (x[1] < 0.0) {
                    tmp = -tmp;
                }
                z[0] = 0.5 * (x[1] / tmp);
                z[1] = tmp;
            }
        } else {
            z[0] = 0.0;
            z[1] = 0.0;
        }
        return z;
    }

    public static final double[] square(double[] x) {
        return DComplex.mult(x, x);
    }

    public static final double[] tan(double[] x) {
        double[] z = new double[2];
        double iz_re = -x[1];
        double iz_im = x[0];
        double scalar = Math.exp(iz_re);
        double re1 = scalar * Math.cos(iz_im);
        double im1 = scalar * Math.sin(iz_im);
        scalar = Math.exp(-iz_re);
        double re2 = scalar * Math.cos(-iz_im);
        double im2 = scalar * Math.sin(-iz_im);
        double re3 = re1 - re2;
        double im3 = im1 - im2;
        z[0] = 0.5 * im3;
        z[1] = -0.5 * re3;
        re3 = re1 + re2;
        im3 = im1 + im2;
        double cs_re = 0.5 * re3;
        double cs_im = 0.5 * im3;
        z = DComplex.div(z, cs_re, cs_im);
        return z;
    }

    protected DComplex() {
    }
}

