/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig.watched;

import java.util.Random;
import org.ejml.UtilEjml;
import org.ejml.alg.dense.decomposition.eig.EigenvalueSmall;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.MatrixFeatures;

public class WatchedDoubleStepQREigen {
    private Random rand = new Random(9026L);
    private int N;
    DenseMatrix64F A;
    private DenseMatrix64F u;
    private double gamma;
    private DenseMatrix64F _temp;
    int[] numStepsFind;
    int steps;
    Complex64F[] eigenvalues;
    int numEigen;
    private EigenvalueSmall valueSmall = new EigenvalueSmall();
    private double[] temp = new double[9];
    private boolean printHumps = false;
    boolean checkHessenberg = false;
    private boolean checkOrthogonal = false;
    private boolean checkUncountable = false;
    private boolean useStandardEq = false;
    private boolean useCareful2x2 = true;
    private boolean normalize = true;
    int lastExceptional;
    int numExceptional;
    int exceptionalThreshold = 20;
    int maxIterations = this.exceptionalThreshold * 20;
    public boolean createR = true;
    public DenseMatrix64F Q;

    public void incrementSteps() {
        ++this.steps;
    }

    public void setQ(DenseMatrix64F denseMatrix64F) {
        this.Q = denseMatrix64F;
    }

    private void addEigenvalue(double d) {
        this.numStepsFind[this.numEigen] = this.steps;
        this.eigenvalues[this.numEigen].set(d, 0.0);
        ++this.numEigen;
        this.steps = 0;
        this.lastExceptional = 0;
    }

    private void addEigenvalue(double d, double d2) {
        this.numStepsFind[this.numEigen] = this.steps;
        this.eigenvalues[this.numEigen].set(d, d2);
        ++this.numEigen;
        this.steps = 0;
        this.lastExceptional = 0;
    }

    public void setChecks(boolean bl, boolean bl2, boolean bl3) {
        this.checkHessenberg = bl;
        this.checkOrthogonal = bl2;
        this.checkUncountable = bl3;
    }

    public boolean isZero(int n, int n2) {
        double d;
        double d2;
        double d3 = Math.abs(this.A.get(n, n2));
        return d3 <= 0.5 * UtilEjml.EPS * ((d2 = Math.abs(this.A.get(n - 1, n2))) + (d = Math.abs(this.A.get(n, n2 + 1))));
    }

    public void setup(DenseMatrix64F denseMatrix64F) {
        int n;
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new RuntimeException("Must be square");
        }
        if (this.N != denseMatrix64F.numRows) {
            this.N = denseMatrix64F.numRows;
            this.A = denseMatrix64F.copy();
            this.u = new DenseMatrix64F(denseMatrix64F.numRows, 1);
            this._temp = new DenseMatrix64F(denseMatrix64F.numRows, 1);
            this.numStepsFind = new int[denseMatrix64F.numRows];
        } else {
            this.A.set(denseMatrix64F);
            UtilEjml.memset(this.numStepsFind, 0, this.numStepsFind.length);
        }
        for (n = 2; n < this.N; ++n) {
            for (int i = 0; i < n - 1; ++i) {
                this.A.set(n, i, 0.0);
            }
        }
        this.eigenvalues = new Complex64F[denseMatrix64F.numRows];
        for (n = 0; n < this.eigenvalues.length; ++n) {
            this.eigenvalues[n] = new Complex64F();
        }
        this.numEigen = 0;
        this.lastExceptional = 0;
        this.numExceptional = 0;
        this.steps = 0;
    }

    public void exceptionalShift(int n, int n2) {
        double d;
        if (this.printHumps) {
            System.out.println("Performing exceptional implicit double step");
        }
        if ((d = Math.abs(this.A.get(n2, n2))) == 0.0) {
            d = 1.0;
        }
        ++this.numExceptional;
        double d2 = 1.0 - Math.pow(0.1, this.numExceptional);
        d *= d2 + 2.0 * (1.0 - d2) * (this.rand.nextDouble() - 0.5);
        if (this.rand.nextBoolean()) {
            d = -d;
        }
        this.performImplicitSingleStep(n, n2, d);
        this.lastExceptional = this.steps;
    }

    public void implicitDoubleStep(int n, int n2) {
        double d;
        double d2;
        double d3;
        if (this.printHumps) {
            System.out.println("Performing implicit double step");
        }
        double d4 = this.A.get(n2 - 1, n2 - 1);
        double d5 = this.A.get(n2 - 1, n2);
        double d6 = this.A.get(n2, n2 - 1);
        double d7 = this.A.get(n2, n2);
        double d8 = this.A.get(n, n);
        double d9 = this.A.get(n + 1, n);
        double d10 = this.A.get(n, n + 1);
        double d11 = this.A.get(n + 1, n + 1);
        double d12 = this.A.get(n + 2, n + 1);
        if (this.normalize) {
            this.temp[0] = d8;
            this.temp[1] = d9;
            this.temp[2] = d10;
            this.temp[3] = d11;
            this.temp[4] = d12;
            this.temp[5] = d4;
            this.temp[6] = d7;
            this.temp[7] = d5;
            this.temp[8] = d6;
            d3 = Math.abs(this.temp[0]);
            for (int i = 1; i < this.temp.length; ++i) {
                if (!(Math.abs(this.temp[i]) > d3)) continue;
                d3 = Math.abs(this.temp[i]);
            }
            d8 /= d3;
            d9 /= d3;
            d10 /= d3;
            d11 /= d3;
            d12 /= d3;
            d4 /= d3;
            d7 /= d3;
            d5 /= d3;
            d6 /= d3;
        }
        if (this.useStandardEq) {
            d3 = ((d8 - d4) * (d8 - d7) - d6 * d5) / d9 + d10;
            d2 = d8 + d11 - d4 - d7;
            d = d12;
        } else {
            d3 = (d8 - d4) * (d8 - d7) - d6 * d5 + d10 * d9;
            d2 = (d8 + d11 - d4 - d7) * d9;
            d = d12 * d9;
        }
        this.performImplicitDoubleStep(n, n2, d3, d2, d);
    }

    public void performImplicitDoubleStep(int n, int n2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6 = this.A.get(n, n);
        double d7 = this.A.get(n + 1, n);
        double d8 = this.A.get(n, n + 1);
        double d9 = this.A.get(n + 1, n + 1);
        double d10 = this.A.get(n + 2, n + 1);
        double d11 = 2.0 * d;
        double d12 = d * d + d2 * d2;
        if (this.useStandardEq) {
            d5 = (d6 * d6 - d11 * d6 + d12) / d7 + d8;
            d4 = d6 + d9 - d11;
            d3 = d10;
        } else {
            d5 = d6 * d6 - d11 * d6 + d12 + d8 * d7;
            d4 = (d6 + d9 - d11) * d7;
            d3 = d10 * d7;
        }
        this.performImplicitDoubleStep(n, n2, d5, d4, d3);
    }

    private void performImplicitDoubleStep(int n, int n2, double d, double d2, double d3) {
        if (!this.bulgeDoubleStepQn(n, d, d2, d3, 0.0, false)) {
            return;
        }
        if (this.Q != null) {
            QrHelperFunctions.rank1UpdateMultR(this.Q, this.u.data, this.gamma, 0, n, n + 3, this._temp.data);
            if (this.checkOrthogonal && !MatrixFeatures.isOrthogonal(this.Q, 1.0E-8)) {
                this.u.print();
                this.Q.print();
                throw new RuntimeException("Bad");
            }
        }
        if (this.printHumps) {
            System.out.println("Applied first Q matrix, it should be humped now. A = ");
            this.A.print("%12.3e");
            System.out.println("Pushing the hump off the matrix.");
        }
        for (int i = n; i < n2 - 2; ++i) {
            if (this.bulgeDoubleStepQn(i) && this.Q != null) {
                QrHelperFunctions.rank1UpdateMultR(this.Q, this.u.data, this.gamma, 0, i + 1, i + 4, this._temp.data);
                if (this.checkOrthogonal && !MatrixFeatures.isOrthogonal(this.Q, 1.0E-8)) {
                    throw new RuntimeException("Bad");
                }
            }
            if (!this.printHumps) continue;
            System.out.println("i = " + i + " A = ");
            this.A.print("%12.3e");
        }
        if (this.printHumps) {
            System.out.println("removing last bump");
        }
        if (n2 - 2 >= 0 && this.bulgeSingleStepQn(n2 - 2) && this.Q != null) {
            QrHelperFunctions.rank1UpdateMultR(this.Q, this.u.data, this.gamma, 0, n2 - 1, n2 + 1, this._temp.data);
            if (this.checkOrthogonal && !MatrixFeatures.isOrthogonal(this.Q, 1.0E-8)) {
                throw new RuntimeException("Bad");
            }
        }
        if (this.printHumps) {
            System.out.println(" A = ");
            this.A.print("%12.3e");
        }
        if (this.checkHessenberg && !MatrixFeatures.isUpperTriangle(this.A, 1, 1.0E-12)) {
            this.A.print("%12.3e");
            throw new RuntimeException("Bad matrix");
        }
    }

    public void performImplicitSingleStep(int n, int n2, double d) {
        if (!this.createBulgeSingleStep(n, d)) {
            return;
        }
        if (this.Q != null) {
            QrHelperFunctions.rank1UpdateMultR(this.Q, this.u.data, this.gamma, 0, n, n + 2, this._temp.data);
            if (this.checkOrthogonal && !MatrixFeatures.isOrthogonal(this.Q, 1.0E-8)) {
                throw new RuntimeException("Bad");
            }
        }
        if (this.printHumps) {
            System.out.println("Applied first Q matrix, it should be humped now. A = ");
            this.A.print("%12.3e");
            System.out.println("Pushing the hump off the matrix.");
        }
        for (int i = n; i < n2 - 1; ++i) {
            if (this.bulgeSingleStepQn(i) && this.Q != null) {
                QrHelperFunctions.rank1UpdateMultR(this.Q, this.u.data, this.gamma, 0, i + 1, i + 3, this._temp.data);
                if (this.checkOrthogonal && !MatrixFeatures.isOrthogonal(this.Q, 1.0E-8)) {
                    throw new RuntimeException("Bad");
                }
            }
            if (!this.printHumps) continue;
            System.out.println("i = " + i + " A = ");
            this.A.print("%12.3e");
        }
        if (this.checkHessenberg && !MatrixFeatures.isUpperTriangle(this.A, 1, 1.0E-12)) {
            this.A.print("%12.3e");
            throw new RuntimeException("Bad matrix");
        }
    }

    public boolean createBulgeSingleStep(int n, double d) {
        double d2 = this.A.get(n, n) - d;
        double d3 = this.A.get(n + 1, n);
        double d4 = Math.abs(this.A.get(n, n)) * UtilEjml.EPS;
        return this.bulgeSingleStepQn(n, d2, d3, d4, false);
    }

    public boolean bulgeDoubleStepQn(int n) {
        double d = this.A.get(n + 1, n);
        double d2 = this.A.get(n + 2, n);
        double d3 = this.A.get(n + 3, n);
        double d4 = Math.abs(this.A.get(n, n)) * UtilEjml.EPS;
        return this.bulgeDoubleStepQn(n + 1, d, d2, d3, d4, true);
    }

    public boolean bulgeDoubleStepQn(int n, double d, double d2, double d3, double d4, boolean bl) {
        double d5;
        double d6;
        double d7;
        if (this.normalize) {
            d7 = Math.abs(d);
            d6 = Math.abs(d2);
            double d8 = Math.abs(d3);
            double d9 = d5 = d7 > d6 ? d7 : d6;
            if (d8 > d5) {
                d5 = d8;
            }
            if (d5 <= d4) {
                if (bl) {
                    this.A.set(n, n - 1, 0.0);
                    this.A.set(n + 1, n - 1, 0.0);
                    this.A.set(n + 2, n - 1, 0.0);
                }
                return false;
            }
            d /= d5;
            d2 /= d5;
            d3 /= d5;
        } else {
            d5 = 1.0;
        }
        d7 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d < 0.0) {
            d7 = -d7;
        }
        d6 = d + d7;
        this.u.set(n, 0, 1.0);
        this.u.set(n + 1, 0, d2 / d6);
        this.u.set(n + 2, 0, d3 / d6);
        this.gamma = d6 / d7;
        QrHelperFunctions.rank1UpdateMultR(this.A, this.u.data, this.gamma, 0, n, n + 3, this._temp.data);
        if (bl) {
            this.A.set(n, n - 1, -d5 * d7);
            this.A.set(n + 1, n - 1, 0.0);
            this.A.set(n + 2, n - 1, 0.0);
        }
        if (this.printHumps) {
            System.out.println("  After Q.   A =");
            this.A.print();
        }
        QrHelperFunctions.rank1UpdateMultL(this.A, this.u.data, this.gamma, 0, n, n + 3);
        if (this.checkUncountable && MatrixFeatures.hasUncountable(this.A)) {
            throw new RuntimeException("bad matrix");
        }
        return true;
    }

    public boolean bulgeSingleStepQn(int n) {
        double d = this.A.get(n + 1, n);
        double d2 = this.A.get(n + 2, n);
        double d3 = Math.abs(this.A.get(n, n)) * UtilEjml.EPS;
        return this.bulgeSingleStepQn(n + 1, d, d2, d3, true);
    }

    public boolean bulgeSingleStepQn(int n, double d, double d2, double d3, boolean bl) {
        double d4;
        if (this.normalize) {
            d4 = Math.abs(d);
            if (d4 < Math.abs(d2)) {
                d4 = Math.abs(d2);
            }
            if (d4 <= d3) {
                if (bl) {
                    this.A.set(n, n - 1, 0.0);
                    this.A.set(n + 1, n - 1, 0.0);
                }
                return false;
            }
            d /= d4;
            d2 /= d4;
        } else {
            d4 = 1.0;
        }
        double d5 = Math.sqrt(d * d + d2 * d2);
        if (d < 0.0) {
            d5 = -d5;
        }
        double d6 = d + d5;
        this.u.set(n, 0, 1.0);
        this.u.set(n + 1, 0, d2 / d6);
        this.gamma = d6 / d5;
        QrHelperFunctions.rank1UpdateMultR(this.A, this.u.data, this.gamma, 0, n, n + 2, this._temp.data);
        if (bl) {
            this.A.set(n, n - 1, -d4 * d5);
            this.A.set(n + 1, n - 1, 0.0);
        }
        QrHelperFunctions.rank1UpdateMultL(this.A, this.u.data, this.gamma, 0, n, n + 2);
        if (this.checkUncountable && MatrixFeatures.hasUncountable(this.A)) {
            throw new RuntimeException("bad matrix");
        }
        return true;
    }

    public void eigen2by2_scale(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = Math.abs(d);
        double d7 = Math.abs(d4);
        double d8 = Math.abs(d2);
        double d9 = Math.abs(d3);
        double d10 = d5 = d6 > d7 ? d6 : d7;
        if (d5 < d8) {
            d5 = d8;
        }
        if (d5 < d9) {
            d5 = d9;
        }
        if (d5 == 0.0) {
            this.valueSmall.value0.real = 0.0;
            this.valueSmall.value0.imaginary = 0.0;
            this.valueSmall.value1.real = 0.0;
            this.valueSmall.value1.imaginary = 0.0;
        } else {
            d2 /= d5;
            d3 /= d5;
            d /= d5;
            d4 /= d5;
            if (this.useCareful2x2) {
                this.valueSmall.value2x2(d, d2, d3, d4);
            } else {
                this.valueSmall.value2x2_fast(d, d2, d3, d4);
            }
            this.valueSmall.value0.real *= d5;
            this.valueSmall.value0.imaginary *= d5;
            this.valueSmall.value1.real *= d5;
            this.valueSmall.value1.imaginary *= d5;
        }
    }

    public int getNumberOfEigenvalues() {
        return this.numEigen;
    }

    public Complex64F[] getEigenvalues() {
        return this.eigenvalues;
    }

    public void addComputedEigen2x2(int n, int n2) {
        this.eigen2by2_scale(this.A.get(n, n), this.A.get(n, n2), this.A.get(n2, n), this.A.get(n2, n2));
        if (this.checkUncountable && (Double.isNaN(this.valueSmall.value0.real) || Double.isNaN(this.valueSmall.value1.real))) {
            throw new RuntimeException("Uncountable");
        }
        this.addEigenvalue(this.valueSmall.value0.real, this.valueSmall.value0.imaginary);
        this.addEigenvalue(this.valueSmall.value1.real, this.valueSmall.value1.imaginary);
    }

    public boolean isReal2x2(int n, int n2) {
        this.eigen2by2_scale(this.A.get(n, n), this.A.get(n, n2), this.A.get(n2, n), this.A.get(n2, n2));
        return this.valueSmall.value0.isReal();
    }

    public void addEigenAt(int n) {
        this.addEigenvalue(this.A.get(n, n));
    }

    public void printSteps() {
        for (int i = 0; i < this.N; ++i) {
            System.out.println("Step[" + i + "] = " + this.numStepsFind[i]);
        }
    }
}

