/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.util.LittleEndian;

public class ExpPtg
extends Ptg {
    private static final int SIZE = 5;
    public static final short sid = 1;
    private short field_1_first_row;
    private short field_2_first_col;

    public ExpPtg() {
    }

    public ExpPtg(RecordInputStream in) {
        this.field_1_first_row = in.readShort();
        this.field_2_first_col = in.readShort();
    }

    @Override
    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 1;
        LittleEndian.putShort(array, offset + 1, this.field_1_first_row);
        LittleEndian.putShort(array, offset + 3, this.field_2_first_col);
    }

    @Override
    public int getSize() {
        return 5;
    }

    public short getRow() {
        return this.field_1_first_row;
    }

    public short getColumn() {
        return this.field_2_first_col;
    }

    @Override
    public String toFormulaString(Workbook book) {
        throw new RecordFormatException("Coding Error: Expected ExpPtg to be converted from Shared to Non-Shared Formula");
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("[Array Formula or Shared Formula]\n");
        buffer.append("row = ").append(this.getRow()).append("\n");
        buffer.append("col = ").append(this.getColumn()).append("\n");
        return buffer.toString();
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public Object clone() {
        ExpPtg result = new ExpPtg();
        result.field_1_first_row = this.field_1_first_row;
        result.field_2_first_col = this.field_2_first_col;
        return result;
    }
}

