/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.CompileState;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;

class ViewPlatformRetained
extends LeafRetained {
    static final int VP_IN_BS_LIST = 0;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 1;
    int viewAttachPolicy = 0;
    private ArrayList viewList = new ArrayList();
    private View[] views = null;
    Locale locale = null;
    boolean viewListDirty = true;
    Transform3D vworldToVpc = null;
    Transform3D vpcToVworld = new Transform3D();
    BoundingSphere sphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 62.0);
    BoundingSphere schedSphere;
    Point3d center = new Point3d();
    static final Point3d zeroPoint = new Point3d();
    int vprDirtyMask = 196608;
    static final Object[] emptyObj = new Object[0];
    static final Transform3D identity = new Transform3D();

    ViewPlatformRetained() {
        this.nodeType = 16;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        IndexedUnorderSet.init(this, 1);
        this.schedSphere = (BoundingSphere)this.sphere.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewAttachPolicy(int n) {
        ViewPlatformRetained viewPlatformRetained = this;
        synchronized (viewPlatformRetained) {
            this.viewAttachPolicy = n;
            this.vprDirtyMask |= 0x10000;
        }
        if (this.source != null && this.source.isLive()) {
            this.repaint();
        }
    }

    void repaint() {
        View[] viewArray = this.getViewList();
        for (int i = viewArray.length - 1; i >= 0; --i) {
            viewArray[i].repaint();
        }
    }

    int getViewAttachPolicy() {
        return this.viewAttachPolicy;
    }

    void setActivationRadius(float f) {
        this.sphere.setRadius(f);
        if (this.source != null && this.source.isLive()) {
            this.repaint();
        }
        if (this.source.isLive()) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 48;
            j3dMessage.threads = 384;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Float(f);
            VirtualUniverse.mc.processMessage(j3dMessage);
        } else {
            this.schedSphere.setRadius(f);
        }
    }

    float getActivationRadius() {
        return (float)this.sphere.getRadius();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setView(View view) {
        ArrayList arrayList = this.viewList;
        synchronized (arrayList) {
            if (!this.viewList.contains(view)) {
                this.viewList.add(view);
            }
            this.viewListDirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeView(View view) {
        ArrayList arrayList = this.viewList;
        synchronized (arrayList) {
            if (this.viewList.contains(view)) {
                this.viewList.remove(this.viewList.indexOf(view));
            }
            this.viewListDirty = true;
        }
    }

    Transform3D getVworldToVpc() {
        if (this.vworldToVpc == null) {
            this.vworldToVpc = new Transform3D();
        }
        this.vworldToVpc.set(this.getCurrentLocalToVworld(null));
        this.vworldToVpc.invert();
        return this.vworldToVpc;
    }

    Transform3D getVpcToVworld() {
        this.vpcToVworld.set(this.getCurrentLocalToVworld(null));
        return this.vpcToVworld;
    }

    void evaluateViewPlatformTransform() {
        this.vworldToVpc = null;
    }

    void evaluateInitViewPlatformTransform(NodeRetained nodeRetained, Transform3D transform3D) {
        Object object;
        if (nodeRetained instanceof TransformGroupRetained) {
            object = new Transform3D();
            TransformGroupRetained transformGroupRetained = (TransformGroupRetained)nodeRetained;
            transformGroupRetained.transform.getWithLock((Transform3D)object);
            transform3D.mul((Transform3D)object, transform3D);
        }
        if ((object = nodeRetained.getParent()) != null) {
            this.evaluateInitViewPlatformTransform((NodeRetained)object, transform3D);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateInitViewPlatformTransform() {
        ViewPlatformRetained viewPlatformRetained = this;
        synchronized (viewPlatformRetained) {
            Transform3D transform3D = this.getLastLocalToVworld();
            if (transform3D.equals(identity)) {
                this.evaluateInitViewPlatformTransform(this, transform3D);
            }
        }
    }

    void updateActivationRadius(float f) {
        this.schedSphere.setCenter(zeroPoint);
        this.schedSphere.setRadius(f);
        this.schedSphere.transform(this.getCurrentLocalToVworld(null));
    }

    void updateTransformRegion() {
        Transform3D transform3D = this.getCurrentLocalToVworld(null);
        this.schedSphere.setCenter(zeroPoint);
        this.schedSphere.transform(transform3D);
        transform3D.transform(zeroPoint, this.center);
    }

    void setLive(SetLiveState setLiveState) {
        int n;
        View[] viewArray = this.getViewList();
        for (n = viewArray.length - 1; n >= 0; --n) {
            viewArray[n].checkView();
        }
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ViewPlatformRetained1"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ViewPlatformRetained2"));
        }
        if (setLiveState.viewLists != null) {
            throw new IllegalSceneGraphException(J3dI18N.getString("ViewPlatformRetained3"));
        }
        this.locale = setLiveState.locale;
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 4);
            setLiveState.notifyThreads |= 0x2000;
        }
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 4);
        }
        this.switchState = (SwitchState)setLiveState.switchStates.get(0);
        setLiveState.nodeList.add(this);
        setLiveState.notifyThreads |= 0x100;
        super.markAsLive();
        for (n = viewArray.length - 1; n >= 0; --n) {
            viewArray[n].setUniverse(setLiveState.universe);
            viewArray[n].evaluateActive();
        }
        this.universe.addViewPlatform(this);
        setLiveState.traverseFlags |= 1;
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 4);
        }
        View[] viewArray = this.getViewList();
        for (int i = viewArray.length - 1; i >= 0; --i) {
            viewArray[i].evaluateActive();
        }
        setLiveState.nodeList.add(this);
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 4);
            setLiveState.notifyThreads |= 0x2000;
        }
        setLiveState.notifyThreads |= 0x102;
        this.universe.removeViewPlatform(this);
    }

    void reEvaluateView() {
        View[] viewArray = this.getViewList();
        for (int i = viewArray.length - 1; i >= 0; --i) {
            viewArray[i].evaluateActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    View[] getViewList() {
        ArrayList arrayList = this.viewList;
        synchronized (arrayList) {
            if (this.viewListDirty) {
                this.views = this.viewList.toArray(new View[this.viewList.size()]);
                this.viewListDirty = false;
            }
            return this.views;
        }
    }

    boolean isActiveViewPlatform() {
        View[] viewArray = this.getViewList();
        if (viewArray != null) {
            for (int i = 0; i < viewArray.length; ++i) {
                if (!viewArray[i].active) continue;
                return true;
            }
        }
        return false;
    }

    void processSwitchChanged() {
        this.reEvaluateView();
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        compileState.keepTG = true;
    }
}

