/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;

class PlugInExecuter
implements Runnable {
    private String plugin;
    private Thread thread;

    PlugInExecuter(String plugin) {
        this.plugin = plugin;
        this.thread = new Thread((Runnable)this, plugin);
        this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
        this.thread.start();
    }

    public void run() {
        IJ.resetEscape();
        IJ.runPlugIn("ij.plugin.ClassChecker", "");
        this.runCompiledPlugin(this.plugin);
    }

    void runCompiledPlugin(String className) {
        if (IJ.debugMode) {
            IJ.log("runCompiledPlugin: " + className);
        }
        IJ.resetClassLoader();
        ClassLoader loader = IJ.getClassLoader();
        Object thePlugIn = null;
        try {
            thePlugIn = loader.loadClass(className).newInstance();
            if (thePlugIn instanceof PlugIn) {
                ((PlugIn)thePlugIn).run("");
            } else if (thePlugIn instanceof PlugInFilter) {
                new PlugInFilterRunner(thePlugIn, className, "");
            }
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(95) != -1) {
                IJ.error("Plugin or class not found: \"" + className + "\"\n(" + e + ")");
            }
        }
        catch (NoClassDefFoundError e) {
            int index;
            String err = e.getMessage();
            int n = index = err != null ? err.indexOf("wrong name: ") : -1;
            if (index > -1 && !className.contains(".")) {
                String className2 = err.substring(index + 12, err.length() - 1);
                className2 = className2.replace("/", ".");
                this.runCompiledPlugin(className2);
                return;
            }
            if (className.indexOf(95) != -1) {
                IJ.error("Plugin or class not found: \"" + className + "\"\n(" + e + ")");
            }
        }
        catch (Exception e) {
            IJ.handleException(e);
        }
    }
}

