/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.function.tfloat.FloatFunction;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.FloatSorting;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FloatMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected FloatMatrix1D() {
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f) {
        if (this.size == 0) {
            return Float.NaN;
        }
        float a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix1D.this.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(FloatMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public float aggregate(final FloatFloatFunction aggr, final FloatFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            return Float.NaN;
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        float a = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix1D.this.getQuick(indexElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            float elem = FloatMatrix1D.this.getQuick(indexElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(indexElements[0]));
            int i = 1;
            while (i < size) {
                float elem = this.getQuick(indexElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public float aggregate(final FloatMatrix1D other, final FloatFloatFunction aggr, final FloatFloatFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            return Float.NaN;
        }
        float a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float a = f.apply(FloatMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(FloatMatrix1D.this.getQuick(i), other.getQuick(i)));
                            ++i;
                        }
                        return Float.valueOf(a);
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public FloatMatrix1D assign(final FloatFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FloatMatrix1D.this.setQuick(i, f.apply(FloatMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatProcedure cond, final FloatFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float elem = FloatMatrix1D.this.getQuick(i);
                            if (cond.apply(elem)) {
                                FloatMatrix1D.this.setQuick(i, f.apply(elem));
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, f.apply(elem));
                }
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatProcedure cond, final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float elem = FloatMatrix1D.this.getQuick(i);
                            if (cond.apply(elem)) {
                                FloatMatrix1D.this.setQuick(i, value);
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, value);
                }
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final float value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FloatMatrix1D.this.setQuick(i, value);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, value);
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final float[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FloatMatrix1D.this.setQuick(i, values[i]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, values[i]);
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(FloatMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final FloatMatrix1D source = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FloatMatrix1D.this.setQuick(i, source.getQuick(i));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, source.getQuick(i));
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(final FloatMatrix1D y, final FloatFloatFunction function) {
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            FloatMatrix1D.this.setQuick(i, function.apply(FloatMatrix1D.this.getQuick(i), y.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public FloatMatrix1D assign(FloatMatrix1D y, FloatFloatFunction function, IntArrayList nonZeroIndexes) {
        this.checkSize(y);
        int[] nonZeroElements = nonZeroIndexes.elements();
        if (function == FloatFunctions.mult) {
            int j = 0;
            int index = nonZeroIndexes.size();
            while (--index >= 0) {
                int i = nonZeroElements[index];
                while (j < i) {
                    this.setQuick(j, 0.0f);
                    ++j;
                }
                this.setQuick(i, this.getQuick(i) * y.getQuick(i));
                ++j;
            }
        } else if (function instanceof FloatPlusMultSecond) {
            float multiplicator = ((FloatPlusMultSecond)function).multiplicator;
            if (multiplicator == 0.0f) {
                return this;
            }
            if (multiplicator == 1.0f) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + y.getQuick(i));
                }
            } else if (multiplicator == -1.0f) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) - y.getQuick(i));
                }
            } else {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + multiplicator * y.getQuick(i));
                }
            }
        } else {
            return this.assign(y, function);
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (FloatMatrix1D.this.getQuick(i) != 0.0f) {
                                ++cardinality;
                            }
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.getQuick(i) != 0.0f) {
                    ++cardinality;
                }
                ++i;
            }
        }
        return cardinality;
    }

    public FloatMatrix1D copy() {
        FloatMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public abstract Object elements();

    public boolean equals(float value) {
        return FloatProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatMatrix1D)) {
            return false;
        }
        return FloatProperty.DEFAULT.equals(this, (FloatMatrix1D)obj);
    }

    public float get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    public float[] getMaxLocation() {
        int location = 0;
        float maxValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int location = firstIdx;
                        float maxValue = FloatMatrix1D.this.getQuick(location);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            float elem = FloatMatrix1D.this.getQuick(i);
                            if (maxValue < elem) {
                                maxValue = elem;
                                location = i;
                            }
                            ++i;
                        }
                        return new float[]{maxValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                float elem = this.getQuick(i);
                if (maxValue < elem) {
                    maxValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new float[]{maxValue, location};
    }

    public float[] getMinLocation() {
        int location = 0;
        float minValue = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int location = firstIdx;
                        float minValue = FloatMatrix1D.this.getQuick(location);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            float elem = FloatMatrix1D.this.getQuick(i);
                            if (minValue > elem) {
                                minValue = elem;
                                location = i;
                            }
                            ++i;
                        }
                        return new float[]{minValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                float elem = this.getQuick(i);
                if (minValue > elem) {
                    minValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new float[]{minValue, location};
    }

    public void getNegativeValues(IntArrayList indexList, FloatArrayList valueList) {
        float value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) < 0.0f) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        int i = rem;
        while (i < this.size) {
            float value2 = this.getQuick(i);
            if (value2 < 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) < 0.0f) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            i += 2;
        }
    }

    public void getNonZeros(IntArrayList indexList, FloatArrayList valueList) {
        float value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) != 0.0f) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        int i = rem;
        while (i < this.size) {
            float value2 = this.getQuick(i);
            if (value2 != 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) != 0.0f) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            i += 2;
        }
    }

    public void getNonZeros(IntArrayList indexList, FloatArrayList valueList, int maxCardinality) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        int currentSize = 0;
        int i = 0;
        while (i < s) {
            float value = this.getQuick(i);
            if (value != 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
                ++currentSize;
            }
            if (currentSize >= maxCardinality) break;
            ++i;
        }
    }

    public void getPositiveValues(IntArrayList indexList, FloatArrayList valueList) {
        float value;
        int rem;
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        if ((rem = this.size % 2) == 1 && (value = this.getQuick(0)) > 0.0f) {
            if (fillIndexList) {
                indexList.add(0);
            }
            if (fillValueList) {
                valueList.add(value);
            }
        }
        int i = rem;
        while (i < this.size) {
            float value2 = this.getQuick(i);
            if (value2 > 0.0f) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            if ((value2 = this.getQuick(i + 1)) > 0.0f) {
                if (fillIndexList) {
                    indexList.add(i + 1);
                }
                if (fillValueList) {
                    valueList.add(value2);
                }
            }
            i += 2;
        }
    }

    public abstract float getQuick(int var1);

    public FloatMatrix1D like() {
        return this.like(this.size);
    }

    public abstract FloatMatrix1D like(int var1);

    public abstract FloatMatrix2D like2D(int var1, int var2);

    public void normalize() {
        float min = this.getMinLocation()[0];
        if (min < 0.0f) {
            this.assign(FloatFunctions.minus(min));
        }
        if (this.getMaxLocation()[0] == 0.0f) {
            this.assign(1.0f / (float)this.size());
        } else {
            float sumScaleFactor = this.zSum();
            sumScaleFactor = 1.0f / sumScaleFactor;
            this.assign(FloatFunctions.mult(sumScaleFactor));
        }
    }

    public abstract FloatMatrix2D reshape(int var1, int var2);

    public abstract FloatMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, float value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, float var2);

    public void swap(final FloatMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            float tmp = FloatMatrix1D.this.getQuick(i);
                            FloatMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                float tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
                ++i;
            }
        }
    }

    public float[] toArray() {
        float[] values = new float[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(final float[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            values[i] = FloatMatrix1D.this.getQuick(i);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                values[i] = this.getQuick(i);
                ++i;
            }
        }
    }

    public String toString() {
        return new FloatFormatter().toString(this);
    }

    public FloatMatrix1D viewFlip() {
        return (FloatMatrix1D)this.view().vFlip();
    }

    public FloatMatrix1D viewPart(int index, int width) {
        return (FloatMatrix1D)this.view().vPart(index, width);
    }

    public FloatMatrix1D viewSelection(FloatProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.size) {
            if (condition.apply(this.getQuick(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public FloatMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = 0;
            while (i < this.size) {
                indexes[i] = i;
                ++i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            offsets[i] = (int)this.index(indexes[i]);
            ++i;
        }
        return this.viewSelectionLike(offsets);
    }

    public FloatMatrix1D viewSorted() {
        return FloatSorting.mergeSort.sort(this);
    }

    public FloatMatrix1D viewStrides(int stride) {
        return (FloatMatrix1D)this.view().vStrides(stride);
    }

    public float zDotProduct(FloatMatrix1D y) {
        return this.zDotProduct(y, 0, this.size);
    }

    public float zDotProduct(final FloatMatrix1D y, final int from, int length) {
        if (from < 0 || length <= 0) {
            return 0.0f;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        float sum = 0.0f;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Float[] results = new Float[nthreads];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Float>(){

                    @Override
                    public Float call() throws Exception {
                        float sum = 0.0f;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            int idx = k + from;
                            sum += FloatMatrix1D.this.getQuick(idx) * y.getQuick(idx);
                            ++k;
                        }
                        return Float.valueOf(sum);
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Float)futures[j].get();
                    ++j;
                }
                sum = results[0].floatValue();
                j = 1;
                while (j < nthreads) {
                    sum += results[j].floatValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = tail - 1;
            int k = length;
            while (--k >= 0) {
                sum += this.getQuick(i) * y.getQuick(i);
                --i;
            }
        }
        return sum;
    }

    public float zDotProduct(FloatMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        if (from < 0 || length <= 0) {
            return 0.0f;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return 0.0f;
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int index = 0;
        int s = indexesCopy.size();
        while (index < s && nonZeroIndexElements[index] < from) {
            ++index;
        }
        float sum = 0.0f;
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            sum += this.getQuick(i) * y.getQuick(i);
            ++index;
        }
        return sum;
    }

    public float zSum() {
        if (this.size() == 0L) {
            return 0.0f;
        }
        return this.aggregate(FloatFunctions.plus, FloatFunctions.identity);
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (this.getQuick(i) == 0.0f) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected FloatMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FloatMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FloatMatrix1D other) {
        return false;
    }

    protected FloatMatrix1D view() {
        return (FloatMatrix1D)this.clone();
    }

    protected abstract FloatMatrix1D viewSelectionLike(int[] var1);

    protected float zDotProduct(FloatMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, this.size, nonZeroIndexes);
    }
}

