package plugins.adufour.activemeshes.energy;

import java.util.concurrent.ExecutorService;

import plugins.adufour.activemeshes.mesh.Mesh;
import plugins.adufour.vars.lang.Var;

public abstract class EnergyTerm
{
	protected final ExecutorService	multiThreadService;
	
	protected final Var<Double>		weight;
	
	public abstract void registerMesh(Mesh mesh);
	
	public abstract void unregisterMesh(Mesh mesh);
	
	public abstract void unregisterMeshes();
	
	public EnergyTerm(ExecutorService service, Var<Double> weight)
	{
		this.multiThreadService = service;
		this.weight = weight;
	}
}
