package plugins.adufour.blocks.tools.ij;

import icy.plugin.abstract_.Plugin;
import icy.system.IcyHandledException;
import ij.IJ;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarImagePlus;
import plugins.adufour.vars.lang.VarString;

public class CallIJPlugin extends Plugin implements IJBlock
{
    VarImagePlus varIp        = new VarImagePlus("ImagePlus", null);
    
    VarString    pluginName   = new VarString("plug-in name", "");
    
    VarString    pluginParams = new VarString("parameters", "");
    
    @Override
    public void run()
    {
        try
        {
            IJ.run(varIp.getValue(), pluginName.getValue(), pluginParams.getValue());
        }
        catch (RuntimeException e)
        {
            throw new IcyHandledException(e.getLocalizedMessage());
        }
    }
    
    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("Input ImagePlus", varIp);
        inputMap.add("ImageJ plug-in name", pluginName);
        inputMap.add("ImageJ plug-in parameters", pluginParams);
    }
    
    @Override
    public void declareOutput(VarList outputMap)
    {
        
    }
}
