/*
 * Copyright 2010-2015 Institut Pasteur.
 * 
 * This file is part of Icy.
 * 
 * Icy is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Icy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Icy. If not, see <http://www.gnu.org/licenses/>.
 */
package icy.image.colorspace;

import icy.common.EventHierarchicalChecker;

/**
 * @author stephane
 */
public class IcyColorSpaceEvent implements EventHierarchicalChecker
{
    @Deprecated
    public enum IcyColorSpaceEventType
    {
        CHANGED
    }

    private final IcyColorSpace colorSpace;
    private final int component;

    public IcyColorSpaceEvent(IcyColorSpace colorSpace, int component)
    {
        super();

        this.colorSpace = colorSpace;
        this.component = component;
    }

    /**
     * @return the colorSpace
     */
    public IcyColorSpace getColorSpace()
    {
        return colorSpace;
    }

    /**
     * @return the type
     */
    public IcyColorSpaceEventType getType()
    {
        return IcyColorSpaceEventType.CHANGED;
    }

    /**
     * @return the component
     */
    public int getComponent()
    {
        return component;
    }

    @Override
    public boolean isEventRedundantWith(EventHierarchicalChecker event)
    {
        if (event instanceof IcyColorSpaceEvent)
        {
            final IcyColorSpaceEvent e = (IcyColorSpaceEvent) event;

            return (component == -1) || (component == e.getComponent());
        }

        return false;
    }

}