<?xml version = "1.0" encoding = "UTF-8"?>
<!--
  #%L
  BSD implementations of Bio-Formats readers and writers
  %%
  Copyright (C) 2005 - 2015 Open Microscopy Environment:
    - Board of Regents of the University of Wisconsin-Madison
    - Glencoe Software, Inc.
    - University of Dundee
  %%
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:
  
  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright notice,
     this list of conditions and the following disclaimer in the documentation
     and/or other materials provided with the distribution.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.
  #L%
  -->

<!--
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Written by:  Andrew Patterson: ajpatterson at lifesci.dundee.ac.uk
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:OME="http://www.openmicroscopy.org/Schemas/OME/2011-06"
	xmlns:Bin="http://www.openmicroscopy.org/Schemas/BinaryFile/2011-06"
	xmlns:SPW="http://www.openmicroscopy.org/Schemas/SPW/2011-06"
	xmlns:SA="http://www.openmicroscopy.org/Schemas/SA/2011-06"
	xmlns:ROI="http://www.openmicroscopy.org/Schemas/ROI/2011-06"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:xml="http://www.w3.org/XML/1998/namespace"
	exclude-result-prefixes="OME Bin SPW SA ROI"
	xmlns:exsl="http://exslt.org/common"
	extension-element-prefixes="exsl" version="1.0">

	<xsl:variable name="newOMENS">http://www.openmicroscopy.org/Schemas/OME/2012-06</xsl:variable>
	<xsl:variable name="newSPWNS">http://www.openmicroscopy.org/Schemas/SPW/2012-06</xsl:variable>
	<xsl:variable name="newBINNS"
		>http://www.openmicroscopy.org/Schemas/BinaryFile/2012-06</xsl:variable>
	<xsl:variable name="newROINS">http://www.openmicroscopy.org/Schemas/ROI/2012-06</xsl:variable>
	<xsl:variable name="newSANS">http://www.openmicroscopy.org/Schemas/SA/2012-06</xsl:variable>

	<xsl:output method="xml" indent="yes"/>
	<xsl:preserve-space elements="*"/>

	<!-- default value for non-numerical value when transforming the attribute of concrete shape -->
	<xsl:variable name="numberDefault" select="1"/>


	<!-- Actual schema changes -->

	<xsl:template match="OME:Dataset">
		<xsl:element name="OME:Dataset" namespace="{$newOMENS}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* [not (local-name(.) = 'ProjectRef' or local-name(.) = 'AnnotationRef')]"/>
			<xsl:comment>Insert ImageRef elements</xsl:comment>
			<!-- Insert ImageRef elements -->
			<xsl:variable name="datasetID" select="@ID"/>
			<xsl:for-each select="exsl:node-set(//OME:Image/OME:DatasetRef[@ID=$datasetID])">
				<xsl:element name="OME:ImageRef" namespace="{$newOMENS}">
					<xsl:attribute name="ID"><xsl:for-each select=" parent::node()">
						<xsl:value-of select="@ID"/>
					</xsl:for-each></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
			<xsl:apply-templates select="* [local-name(.) = 'AnnotationRef']"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="OME:Project">
		<xsl:element name="OME:Project" namespace="{$newOMENS}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* [not (local-name(.) = 'AnnotationRef')]"/>
			<xsl:comment>Insert DatasetRef elements</xsl:comment>
			<!-- Insert DatasetRef elements -->
			<xsl:variable name="projectID" select="@ID"/>
			<xsl:for-each select="exsl:node-set(//OME:Dataset/OME:ProjectRef[@ID=$projectID])">
				<xsl:element name="OME:DatasetRef" namespace="{$newOMENS}">
					<xsl:attribute name="ID"><xsl:for-each select=" parent::node()">
						<xsl:value-of select="@ID"/>
					</xsl:for-each></xsl:attribute>
				</xsl:element>
			</xsl:for-each>
			<xsl:apply-templates select="* [local-name(.) = 'AnnotationRef']"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="OME:Image">
		<xsl:element name="OME:Image" namespace="{$newOMENS}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* [not (local-name(.) = 'DatasetRef')]"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="OME:AcquiredDate">
		<xsl:element name="OME:AcquisitionDate" namespace="{$newOMENS}">
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="OME:Contact">
		<xsl:variable name = "ID" select = "@ID"/>
		<xsl:if test="not(../OME:Leader[@ID=$ID])">
			<xsl:element name="OME:Leader" namespace="{$newOMENS}">
				<xsl:apply-templates select="@*"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template match="OME:Experimenter">
		<xsl:element name="OME:Experimenter" namespace="{$newOMENS}">
			<!-- Strip DisplayName -->
			<xsl:for-each select="@* [not(name() = 'DisplayName')]">
				<xsl:attribute name="{local-name(.)}">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="OME:Group">
		<xsl:element name="OME:ExperimenterGroup" namespace="{$newOMENS}">
			<xsl:apply-templates select="@*[not(local-name(.)='ID')]"/>
			<xsl:for-each select="@* [name() = 'ID']">
				<xsl:attribute name="ID">ExperimenterGroup:<xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="* [(local-name(.) = 'Description')]"/>
			<xsl:comment>Insert reversed GroupRef nodes</xsl:comment>


			<xsl:variable name="groupID" select="@ID"/>
			<xsl:for-each select="exsl:node-set(//OME:OME/OME:Experimenter/OME:GroupRef[@ID=$groupID])">
				<xsl:variable name="matchingExperimenterID"><xsl:for-each select=" parent::node()">
					<xsl:value-of select="@ID"/>
				</xsl:for-each></xsl:variable>
				<xsl:if test="//OME:Group[@ID=$groupID]/OME:Contact[@ID=$matchingExperimenterID]">
					<xsl:comment>Already matching Contact - <xsl:value-of select="$matchingExperimenterID"/></xsl:comment>
				</xsl:if>
				<xsl:if test="//OME:Group[@ID=$groupID]/OME:Leader[@ID=$matchingExperimenterID]">
					<xsl:comment>Already matching Leader - <xsl:value-of select="$matchingExperimenterID"/></xsl:comment>
				</xsl:if>
				<xsl:if test="not(//OME:Group[@ID=$groupID]/OME:Leader[@ID=$matchingExperimenterID])">
					<xsl:if test="not(//OME:Group[@ID=$groupID]/OME:Contact[@ID=$matchingExperimenterID])">
						<xsl:comment>No existing match - <xsl:value-of select="$matchingExperimenterID"/></xsl:comment>
						<xsl:element name="OME:ExperimenterRef" namespace="{$newOMENS}">
							<xsl:attribute name="ID">
								<xsl:value-of select="$matchingExperimenterID"/>
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			<xsl:apply-templates select="* [(local-name(.) = 'Leader')]"/>
			<xsl:apply-templates select="* [(local-name(.) = 'Contact')]"/>
			<xsl:apply-templates select="* [(local-name(.) = 'AnnotationRef')]"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="OME:GroupRef">
		<xsl:comment>Remove and reverse GroupRef</xsl:comment>
	</xsl:template>

	<xsl:template match="SPW:ImageRef">
		<xsl:element name="OME:ImageRef" namespace="{$newOMENS}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="SPW:Well">
		<xsl:element name="SPW:Well" namespace="{$newSPWNS}">
			<xsl:for-each select="@* [not(name() = 'Status')]">
				<xsl:attribute name="{local-name(.)}">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="@* [name() = 'Status']">
				<xsl:attribute name="Type">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="SPW:Plate">
		<xsl:element name="SPW:Plate" namespace="{$newSPWNS}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* [(local-name(.) = 'Description')]"/>
			<xsl:comment>Remove ScreenRef elements and reverse </xsl:comment>
			<xsl:apply-templates select="* [(local-name(.) = 'Well')]"/>
			<xsl:apply-templates select="* [(local-name(.) = 'AnnotationRef')]"/>
			<xsl:apply-templates select="* [(local-name(.) = 'PlateAcquisition')]"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="SPW:Screen">
		<xsl:element name="SPW:Screen" namespace="{$newSPWNS}">
			<xsl:apply-templates select="@*"/>
			<xsl:apply-templates select="* [(local-name(.) = 'Description')]"/>
			<xsl:apply-templates select="* [(local-name(.) = 'Reagent')]"/>
			<xsl:apply-templates select="* [(local-name(.) = 'PlateRef')]"/>
			<xsl:comment>Insert reverses ScreenRef elements</xsl:comment>
			<!-- Insert reverses ScreenRef elements -->
			<xsl:variable name="screenID" select="@ID"/>
			<xsl:for-each select="exsl:node-set(//SPW:Plate/SPW:ScreenRef[@ID=$screenID])">
				<xsl:variable name="matchingPlateID"><xsl:for-each select=" parent::node()">
					<xsl:value-of select="@ID"/>
				</xsl:for-each></xsl:variable>
				<xsl:if test="not(//SPW:Screen[@ID=$screenID]/SPW:PlateRef[@ID=$matchingPlateID])">
					<xsl:comment>No existing PlateRef</xsl:comment>
				</xsl:if>
				<xsl:if test="//SPW:Screen[@ID=$screenID]/SPW:PlateRef[@ID=$matchingPlateID]">
					<xsl:comment>Already matching PlateRef</xsl:comment>
				</xsl:if>
				<xsl:if test="not(//SPW:Screen[@ID=$screenID]/SPW:PlateRef[@ID=$matchingPlateID])">
					<xsl:element name="SPW:PlateRef" namespace="{$newSPWNS}">
						<xsl:attribute name="ID">
							<xsl:value-of select="$matchingPlateID"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			<xsl:apply-templates select="* [local-name(.) = 'AnnotationRef']"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:ROI">
		<xsl:element name="ROI:ROI" namespace="{$newROINS}">
			<xsl:apply-templates select="@*"/>
			<xsl:if test="count(descendant::ROI:Path) != count(descendant::ROI:Shape)">
				<xsl:apply-templates select="* [local-name(.) = 'Union']" mode="stripPaths"/>
			</xsl:if>
			<xsl:if test="count(descendant::ROI:Path) = count(descendant::ROI:Shape)">
				<xsl:apply-templates select="* [local-name(.) = 'Union']" mode="replacePaths"/>
			</xsl:if>
			<xsl:apply-templates select="* [local-name(.) = 'Description']"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:Union" mode="replacePaths">
		<xsl:element name="ROI:Union" namespace="{$newROINS}">
			<xsl:apply-templates select="@*|node()" mode="replacePaths"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:Union" mode="stripPaths">
		<xsl:element name="ROI:Union" namespace="{$newROINS}">
			<xsl:apply-templates select="@*|node()" mode="stripPaths"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:Shape" mode="stripPaths">
		<xsl:if test="count(child::ROI:Path) = 0">
			<xsl:element name="ROI:Shape" namespace="{$newROINS}">
				<xsl:for-each
					select="@* [not(name() = 'Fill' or name() = 'Stroke' or name() = 'Name'  or name() = 'MarkerStart' or name() = 'MarkerEnd' or name() = 'Label' or name() = 'Transform')]">
					<xsl:attribute name="{local-name(.)}">
						<xsl:value-of select="."/>
					</xsl:attribute>
				</xsl:for-each>
				<xsl:for-each select="@* [name() = 'Fill']">
					<xsl:attribute name="FillColor">
						<xsl:value-of select="."/>
					</xsl:attribute>
				</xsl:for-each>
				<xsl:for-each select="@* [name() = 'Stroke']">
					<xsl:attribute name="StrokeColor">
						<xsl:value-of select="."/>
					</xsl:attribute>
				</xsl:for-each>
				<!-- Both these make a new Text attribute. It will contain
					the value of either attribute Label or element Text, if
					both are present element Text takes priority -->
				<xsl:if test="count(child::ROI:Text) = 1">
					<xsl:for-each select="* [local-name(.) = 'Text']">
						<xsl:for-each select="* [local-name(.) = 'Value']">
							<xsl:attribute name="Text">
								<xsl:value-of select="."/>
							</xsl:attribute>
						</xsl:for-each>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count(child::ROI:Text) = 0">
					<xsl:for-each select="@* [name() = 'Label']">
						<xsl:attribute name="Text">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</xsl:for-each>
				</xsl:if>
				<!-- end of new attributes -->
				<xsl:for-each
					select="* [not(local-name(.) = 'Description' or local-name(.) = 'Path')]">
					<xsl:apply-templates select="."/>
				</xsl:for-each>
				<xsl:for-each select="* [local-name(.) = 'Path']">
					<xsl:comment>Path elements cannot be converted to 2012-06 Schema, they are not
						supported.</xsl:comment>
				</xsl:for-each>
				<xsl:for-each select="@* [name() = 'Transform']">
					<xsl:element name="ROI:Transform" namespace="{$newROINS}">
						<xsl:variable name="fullString">
							<xsl:value-of select="."/>
						</xsl:variable>
						<xsl:variable name="valA">
							<xsl:value-of select="substring-before($fullString, ',')"/>
						</xsl:variable>
						<xsl:variable name="partBstarting">
							<xsl:value-of select="substring-after($fullString, ', ')"/>
						</xsl:variable>
						<xsl:variable name="valB">
							<xsl:value-of select="substring-before($partBstarting, ',')"/>
						</xsl:variable>
						<xsl:variable name="partCstarting">
							<xsl:value-of select="substring-after($partBstarting, ', ')"/>
						</xsl:variable>
						<xsl:variable name="valC">
							<xsl:value-of select="substring-before($partCstarting, ',')"/>
						</xsl:variable>
						<xsl:variable name="partDstarting">
							<xsl:value-of select="substring-after($partCstarting, ', ')"/>
						</xsl:variable>
						<xsl:variable name="valD">
							<xsl:value-of select="substring-before($partDstarting, ',')"/>
						</xsl:variable>
						<xsl:variable name="partEstarting">
							<xsl:value-of select="substring-after($partDstarting, ', ')"/>
						</xsl:variable>
						<xsl:variable name="valE">
							<xsl:value-of select="substring-before($partEstarting, ',')"/>
						</xsl:variable>
						<xsl:variable name="valF">
							<xsl:value-of select="substring-after($partEstarting, ', ')"/>
						</xsl:variable>
						<xsl:attribute name="A00">
							<xsl:value-of select="$valA"/>
						</xsl:attribute>
						<xsl:attribute name="A10">
							<xsl:value-of select="$valB"/>
						</xsl:attribute>
						<xsl:attribute name="A01">
							<xsl:value-of select="$valC"/>
						</xsl:attribute>
						<xsl:attribute name="A11">
							<xsl:value-of select="$valD"/>
						</xsl:attribute>
						<xsl:attribute name="A02">
							<xsl:value-of select="$valE"/>
						</xsl:attribute>
						<xsl:attribute name="A12">
							<xsl:value-of select="$valF"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template match="ROI:Shape" mode="replacePaths">
		<xsl:element name="ROI:Shape" namespace="{$newROINS}">
			<xsl:for-each select="@* [name() = 'ID']">
				<xsl:attribute name="{local-name(.)}">
					<xsl:value-of select="."/>
				</xsl:attribute>
			</xsl:for-each>
			<xsl:attribute name="Visible">false</xsl:attribute>
			<xsl:attribute name="Text">Removed Path</xsl:attribute>
			<xsl:comment>
				Path elements cannot be converted to 2012-06 Schema, they are not
				supported.</xsl:comment>
			<xsl:element name="ROI:Label" namespace="{$newROINS}">
				<xsl:attribute name="X">0</xsl:attribute>
				<xsl:attribute name="Y">0</xsl:attribute>
			</xsl:element>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:Text">
		<xsl:element name="ROI:Label" namespace="{$newROINS}">
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select="* [not(local-name(.) = 'Value')]">
				<xsl:element name="{local-name(.)}" namespace="{$newROINS}">
					<xsl:apply-templates select="@*"/>
					<xsl:value-of select="."/>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:Line">
		<xsl:element name="ROI:Line" namespace="{$newROINS}">
			<xsl:apply-templates select="@*"/>
			<!-- Fix markers -->
			<xsl:for-each select="../@MarkerStart">
				<xsl:attribute name="MarkerStart"><xsl:value-of select="../@MarkerStart"/></xsl:attribute>
			</xsl:for-each>
			<xsl:for-each select="../@MarkerEnd">
				<xsl:attribute name="MarkerEnd"><xsl:value-of select="../@MarkerEnd"/></xsl:attribute>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:Polyline">
		<!-- if closed -->
		<xsl:if test="@Closed = 'true'">
			<xsl:element name="ROI:Polygon" namespace="{$newROINS}">
				<xsl:apply-templates select="@* [ not(name() = 'Closed')]"/>
			</xsl:element>
		</xsl:if>
		<!-- if not closed -->
		<xsl:if test="@Closed = 'false'">
			<xsl:element name="ROI:Polyline" namespace="{$newROINS}">
				<xsl:apply-templates select="@* [ not(name() = 'Closed')]"/>
				<!-- Fix markers -->
				<xsl:for-each select="../@MarkerStart">
					<xsl:attribute name="MarkerStart"><xsl:value-of select="../@MarkerStart"/></xsl:attribute>
				</xsl:for-each>
				<xsl:for-each select="../@MarkerEnd">
					<xsl:attribute name="MarkerEnd"><xsl:value-of select="../@MarkerEnd"/></xsl:attribute>
				</xsl:for-each>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template match="OME:OTF">
		<xsl:comment>OTF elements cannot be converted to 2012-06 Schema, they are not supported.</xsl:comment>
	</xsl:template>

	<xsl:template match="OME:OTFRef">
		<xsl:comment>OTFRef elements cannot be converted to 2012-06 Schema, they are not supported.</xsl:comment>
	</xsl:template>


	<!-- Rewriting all namespaces -->

	<xsl:template match="OME:OME">
		<OME xmlns="http://www.openmicroscopy.org/Schemas/OME/2012-06"
			xmlns:OME="http://www.openmicroscopy.org/Schemas/OME/2012-06"
			xmlns:Bin="http://www.openmicroscopy.org/Schemas/BinaryFile/2012-06"
			xmlns:SPW="http://www.openmicroscopy.org/Schemas/SPW/2012-06"
			xmlns:SA="http://www.openmicroscopy.org/Schemas/SA/2012-06"
			xmlns:ROI="http://www.openmicroscopy.org/Schemas/ROI/2012-06"
			xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
			xsi:schemaLocation="http://www.openmicroscopy.org/Schemas/OME/2012-06
			http://www.openmicroscopy.org/Schemas/OME/2012-06/ome.xsd">
			<xsl:apply-templates/>
		</OME>
	</xsl:template>

	<xsl:template match="OME:*">
		<xsl:element name="{name()}" namespace="{$newOMENS}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="Bin:*">
		<xsl:element name="{name()}" namespace="{$newBINNS}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="SA:*">
		<xsl:element name="{name()}" namespace="{$newSANS}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="SPW:*">
		<xsl:element name="{name()}" namespace="{$newSPWNS}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="ROI:*">
		<xsl:element name="{name()}" namespace="{$newROINS}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>

	<!-- Default processing -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
