package plugins.adufour.activemeshes.energy;

import icy.sequence.Sequence;
import icy.type.DataType;

import java.util.concurrent.ExecutorService;

import javax.vecmath.Point3d;

import plugins.adufour.activemeshes.util.SequenceSampler;
import plugins.adufour.vars.lang.Var;

public abstract class DataAttachmentTerm extends EnergyTerm
{
    protected SequenceSampler sampler;
    protected Point3d         imResolution = new Point3d(1.0, 1.0, 1.0);
    
    public DataAttachmentTerm(ExecutorService service, Var<Double> weight)
    {
        super(service, weight);
    }
    
    /**
     * 
     * @param sequence
     * @param t
     * @param c
     * @param isNormalized
     *            set to true if the input data is already normalized with double values between 0
     *            and 1, false otherwise.
     */
    public void setImageData(Sequence sequence, int t, int c, boolean isNormalized, boolean smartRescale)
    {
        imResolution.set(sequence.getPixelSizeX(), sequence.getPixelSizeY(), sequence.getPixelSizeZ());
        
        // convert to double [0,1]
        if (sequence.getDataType_() == DataType.DOUBLE && isNormalized)
        {
            sampler = new SequenceSampler(sequence, t, c, false, false);
        }
        else
        {
            sampler = new SequenceSampler(sequence, t, c, false, smartRescale);
        }
    }
}
