/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class Exponential
extends AbstractContinousDoubleDistribution {
    private static final long serialVersionUID = 1L;
    protected double lambda;
    protected static Exponential shared = new Exponential(1.0, Exponential.makeDefaultGenerator());

    public Exponential(double lambda, DoubleRandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(lambda);
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x * this.lambda);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.lambda);
    }

    public double nextDouble(double lambda) {
        return -Math.log(this.randomGenerator.raw()) / lambda;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-x * this.lambda);
    }

    public void setState(double lambda) {
        this.lambda = lambda;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double lambda) {
        Exponential exponential = shared;
        synchronized (exponential) {
            return shared.nextDouble(lambda);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.lambda + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine randomGenerator) {
        Exponential exponential = shared;
        synchronized (exponential) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

