/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseIntMatrix2D
extends IntMatrix2D {
    static final long serialVersionUID = 1L;
    protected int[] elements;

    public DenseIntMatrix2D(int[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public DenseIntMatrix2D(int rows, int columns) {
        this.setUp(rows, columns);
        this.elements = new int[rows * columns];
    }

    public DenseIntMatrix2D(int rows, int columns, int[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseIntMatrix2D.this.elements[zero + firstRow * DenseIntMatrix2D.this.rowStride]);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseIntMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(DenseIntMatrix2D.this.elements[zero + r * DenseIntMatrix2D.this.rowStride + c * DenseIntMatrix2D.this.columnStride]));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride]));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, final IntProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int elem = DenseIntMatrix2D.this.elements[zero + firstRow * DenseIntMatrix2D.this.rowStride];
                        int a = 0;
                        if (cond.apply(elem)) {
                            a = f.apply(elem);
                        }
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseIntMatrix2D.this.columns) {
                                elem = DenseIntMatrix2D.this.elements[zero + r * DenseIntMatrix2D.this.rowStride + c * DenseIntMatrix2D.this.columnStride];
                                if (cond.apply(elem)) {
                                    a = aggr.apply(a, f.apply(elem));
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = f.apply(this.elements[zero]);
            }
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (cond.apply(elem)) {
                        a = aggr.apply(a, f.apply(elem));
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseIntMatrix2D.this.elements[zero + rowElements[firstIdx] * DenseIntMatrix2D.this.rowStride + columnElements[firstIdx] * DenseIntMatrix2D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            int elem = DenseIntMatrix2D.this.elements[zero + rowElements[i] * DenseIntMatrix2D.this.rowStride + columnElements[i] * DenseIntMatrix2D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                int elem = this.elements[zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public int aggregate(IntMatrix2D other, final IntIntFunction aggr, final IntIntFunction f) {
        if (!(other instanceof DenseIntMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int colStrideOther = other.columnStride();
        final int[] elemsOther = (int[])other.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(DenseIntMatrix2D.this.elements[zero + firstRow * DenseIntMatrix2D.this.rowStride], elemsOther[zeroOther + firstRow * rowStrideOther]);
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseIntMatrix2D.this.columns) {
                                a = aggr.apply(a, f.apply(DenseIntMatrix2D.this.elements[zero + r * DenseIntMatrix2D.this.rowStride + c * DenseIntMatrix2D.this.columnStride], elemsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int d = 1;
            a = f.apply(this.elements[zero], elemsOther[zeroOther]);
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    a = aggr.apply(a, f.apply(this.elements[zero + r * this.rowStride + c * this.columnStride], elemsOther[zeroOther + r * rowStrideOther + c * colStrideOther]));
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return a;
    }

    @Override
    public IntMatrix2D assign(final IntFunction function) {
        final int[] elems = this.elements;
        if (elems == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof IntMult) {
                int multiplicator = ((IntMult)function).multiplicator;
                if (multiplicator == 1) {
                    return this;
                }
                if (multiplicator == 0) {
                    return this.assign(0);
                }
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        if (function instanceof IntMult) {
                            int multiplicator = ((IntMult)function).multiplicator;
                            if (multiplicator == 1) {
                                return;
                            }
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    int n = i;
                                    elems[n] = elems[n] * multiplicator;
                                    i += DenseIntMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                ++r;
                            }
                        } else {
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    elems[i] = function.apply(elems[i]);
                                    i += DenseIntMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            if (function instanceof IntMult) {
                int multiplicator = ((IntMult)function).multiplicator;
                if (multiplicator == 1) {
                    return this;
                }
                if (multiplicator == 0) {
                    return this.assign(0);
                }
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        elems[n] = elems[n] * multiplicator;
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            } else {
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        elems[i] = function.apply(elems[i]);
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final IntProcedure cond, final IntFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                int elem = DenseIntMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseIntMatrix2D.this.elements[i] = function.apply(elem);
                                }
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    int elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = function.apply(elem);
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final IntProcedure cond, final int value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                int elem = DenseIntMatrix2D.this.elements[i];
                                if (cond.apply(elem)) {
                                    DenseIntMatrix2D.this.elements[i] = value;
                                }
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    int elem = this.elements[i];
                    if (cond.apply(elem)) {
                        this.elements[i] = value;
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final int value) {
        final int[] elems = this.elements;
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                elems[i] = value;
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    elems[i] = value;
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final int[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstRow * DenseIntMatrix2D.this.columns;
                            int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    DenseIntMatrix2D.this.elements[i] = values[idxOther++];
                                    i += DenseIntMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[i] = values[idxOther++];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(final int[][] values) {
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstRow * DenseIntMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                int[] currentRow = values[r];
                                if (currentRow.length != DenseIntMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseIntMatrix2D.this.columns());
                                }
                                System.arraycopy(currentRow, 0, DenseIntMatrix2D.this.elements, i, DenseIntMatrix2D.this.columns);
                                i += DenseIntMatrix2D.this.columns;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                int r = 0;
                while (r < this.rows) {
                    int[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                    i += this.columns;
                    ++r;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.rows);
                Future[] futures = new Future[nthreads];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                            int r = firstRow;
                            while (r < lastRow) {
                                int[] currentRow = values[r];
                                if (currentRow.length != DenseIntMatrix2D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseIntMatrix2D.this.columns());
                                }
                                int i = idx;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    DenseIntMatrix2D.this.elements[i] = currentRow[c];
                                    i += DenseIntMatrix2D.this.columnStride;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                ++r;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                int r = 0;
                while (r < this.rows) {
                    int[] currentRow = values[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int i = idx;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[i] = currentRow[c];
                        i += this.columnStride;
                        ++c;
                    }
                    idx += this.rowStride;
                    ++r;
                }
            }
            return this;
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D source) {
        if (!(source instanceof DenseIntMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseIntMatrix2D other_final = (DenseIntMatrix2D)source;
        if (other_final == this) {
            return this;
        }
        this.checkShape(other_final);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other_final.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        DenseIntMatrix2D other = (DenseIntMatrix2D)source;
        if (this.haveSharedCells(other)) {
            IntMatrix2D c = other.copy();
            if (!(c instanceof DenseIntMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseIntMatrix2D)c;
        }
        final int[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int idxOther = zeroOther + firstRow * rowStrideOther;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int j = idxOther;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                DenseIntMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseIntMatrix2D.this.columnStride;
                                j += columnStrideOther;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            idxOther += rowStrideOther;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D y, final IntIntFunction function) {
        if (!(y instanceof DenseIntMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        DenseIntMatrix2D other = (DenseIntMatrix2D)y;
        this.checkShape(y);
        final int[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int multiplicator;
            if (function instanceof IntPlusMultSecond && (multiplicator = ((IntPlusMultSecond)function).multiplicator) == 0) {
                return this;
            }
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (function == IntFunctions.mult) {
                            int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    int n = i;
                                    DenseIntMatrix2D.this.elements[n] = DenseIntMatrix2D.this.elements[n] * elemsOther[j];
                                    i += DenseIntMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else if (function == IntFunctions.div) {
                            int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    int n = i;
                                    DenseIntMatrix2D.this.elements[n] = DenseIntMatrix2D.this.elements[n] / elemsOther[j];
                                    i += DenseIntMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        } else if (function instanceof IntPlusMultSecond) {
                            int multiplicator = ((IntPlusMultSecond)function).multiplicator;
                            if (multiplicator == 1) {
                                int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                int r = firstRow;
                                while (r < lastRow) {
                                    int i = idx;
                                    int j = idxOther;
                                    int c = 0;
                                    while (c < DenseIntMatrix2D.this.columns) {
                                        int n = i;
                                        DenseIntMatrix2D.this.elements[n] = DenseIntMatrix2D.this.elements[n] + elemsOther[j];
                                        i += DenseIntMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                        ++c;
                                    }
                                    idx += DenseIntMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                    ++r;
                                }
                            } else if (multiplicator == -1) {
                                int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                int r = firstRow;
                                while (r < lastRow) {
                                    int i = idx;
                                    int j = idxOther;
                                    int c = 0;
                                    while (c < DenseIntMatrix2D.this.columns) {
                                        int n = i;
                                        DenseIntMatrix2D.this.elements[n] = DenseIntMatrix2D.this.elements[n] - elemsOther[j];
                                        i += DenseIntMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                        ++c;
                                    }
                                    idx += DenseIntMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                    ++r;
                                }
                            } else {
                                int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                                int idxOther = zeroOther + firstRow * rowStrideOther;
                                int r = firstRow;
                                while (r < lastRow) {
                                    int i = idx;
                                    int j = idxOther;
                                    int c = 0;
                                    while (c < DenseIntMatrix2D.this.columns) {
                                        int n = i;
                                        DenseIntMatrix2D.this.elements[n] = DenseIntMatrix2D.this.elements[n] + multiplicator * elemsOther[j];
                                        i += DenseIntMatrix2D.this.columnStride;
                                        j += columnStrideOther;
                                        ++c;
                                    }
                                    idx += DenseIntMatrix2D.this.rowStride;
                                    idxOther += rowStrideOther;
                                    ++r;
                                }
                            }
                        } else {
                            int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                            int idxOther = zeroOther + firstRow * rowStrideOther;
                            int r = firstRow;
                            while (r < lastRow) {
                                int i = idx;
                                int j = idxOther;
                                int c = 0;
                                while (c < DenseIntMatrix2D.this.columns) {
                                    DenseIntMatrix2D.this.elements[i] = function.apply(DenseIntMatrix2D.this.elements[i], elemsOther[j]);
                                    i += DenseIntMatrix2D.this.columnStride;
                                    j += columnStrideOther;
                                    ++c;
                                }
                                idx += DenseIntMatrix2D.this.rowStride;
                                idxOther += rowStrideOther;
                                ++r;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else if (function == IntFunctions.mult) {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    int n = i;
                    this.elements[n] = this.elements[n] * elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        } else if (function == IntFunctions.div) {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    int n = i;
                    this.elements[n] = this.elements[n] / elemsOther[j];
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        } else if (function instanceof IntPlusMultSecond) {
            int multiplicator = ((IntPlusMultSecond)function).multiplicator;
            if (multiplicator == 0) {
                return this;
            }
            if (multiplicator == 1) {
                int idx = zero;
                int idxOther = zeroOther;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        this.elements[n] = this.elements[n] + elemsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else if (multiplicator == -1) {
                int idx = zero;
                int idxOther = zeroOther;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        this.elements[n] = this.elements[n] - elemsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            } else {
                int idx = zero;
                int idxOther = zeroOther;
                int r = 0;
                while (r < this.rows) {
                    int i = idx;
                    int j = idxOther;
                    int c = 0;
                    while (c < this.columns) {
                        int n = i;
                        this.elements[n] = this.elements[n] + multiplicator * elemsOther[j];
                        i += this.columnStride;
                        j += columnStrideOther;
                        ++c;
                    }
                    idx += this.rowStride;
                    idxOther += rowStrideOther;
                    ++r;
                }
            }
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int j = idxOther;
                int c = 0;
                while (c < this.columns) {
                    this.elements[i] = function.apply(this.elements[i], elemsOther[j]);
                    i += this.columnStride;
                    j += columnStrideOther;
                    ++c;
                }
                idx += this.rowStride;
                idxOther += rowStrideOther;
                ++r;
            }
        }
        return this;
    }

    @Override
    public IntMatrix2D assign(IntMatrix2D y, final IntIntFunction function, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = rowList.size();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int[] elemsOther = (int[])y.elements();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + rowElements[i] * DenseIntMatrix2D.this.rowStride + columnElements[i] * DenseIntMatrix2D.this.columnStride;
                            int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseIntMatrix2D.this.elements[idx] = function.apply(DenseIntMatrix2D.this.elements[idx], elemsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elemsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                if (DenseIntMatrix2D.this.elements[i] != 0) {
                                    ++cardinality;
                                }
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    if (this.elements[i] != 0) {
                        ++cardinality;
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return cardinality;
    }

    public int[] elements() {
        return this.elements;
    }

    @Override
    public IntMatrix2D forEachNonZero(final IntIntIntFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                int value = DenseIntMatrix2D.this.elements[i];
                                if (value != 0) {
                                    DenseIntMatrix2D.this.elements[i] = function.apply(r, c, value);
                                }
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    int value = this.elements[i];
                    if (value != 0) {
                        this.elements[i] = function.apply(r, c, value);
                    }
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return this;
    }

    @Override
    public void getNegativeValues(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                int value = this.elements[i];
                if (value < 0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                int value = this.elements[i];
                if (value != 0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int r = 0;
        while (r < this.rows) {
            int i = idx;
            int c = 0;
            while (c < this.columns) {
                int value = this.elements[i];
                if (value > 0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.columnStride;
                ++c;
            }
            idx += this.rowStride;
            ++r;
        }
    }

    @Override
    public int getQuick(int row, int column) {
        return this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return new DenseIntMatrix2D(rows, columns);
    }

    @Override
    public IntMatrix1D like1D(int size) {
        return new DenseIntMatrix1D(size);
    }

    @Override
    public int[] getMaxLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int maxValue = DenseIntMatrix2D.this.elements[zero + firstRow * DenseIntMatrix2D.this.rowStride];
                        int rowLocation = firstRow;
                        int colLocation = 0;
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseIntMatrix2D.this.columns) {
                                int elem = DenseIntMatrix2D.this.elements[zero + r * DenseIntMatrix2D.this.rowStride + c * DenseIntMatrix2D.this.columnStride];
                                if (maxValue < elem) {
                                    maxValue = elem;
                                    rowLocation = r;
                                    colLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new int[]{maxValue, rowLocation, colLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                rowLocation = results[0][1];
                columnLocation = results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        rowLocation = results[j][1];
                        columnLocation = results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    int elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (maxValue < elem) {
                        maxValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new int[]{maxValue, rowLocation, columnLocation};
    }

    @Override
    public int[] getMinLocation() {
        int rowLocation = 0;
        int columnLocation = 0;
        final int zero = (int)this.index(0, 0);
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int rowLocation = firstRow;
                        int columnLocation = 0;
                        int minValue = DenseIntMatrix2D.this.elements[zero + firstRow * DenseIntMatrix2D.this.rowStride];
                        int d = 1;
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = d;
                            while (c < DenseIntMatrix2D.this.columns) {
                                int elem = DenseIntMatrix2D.this.elements[zero + r * DenseIntMatrix2D.this.rowStride + c * DenseIntMatrix2D.this.columnStride];
                                if (minValue > elem) {
                                    minValue = elem;
                                    rowLocation = r;
                                    columnLocation = c;
                                }
                                ++c;
                            }
                            d = 0;
                            ++r;
                        }
                        return new int[]{minValue, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                rowLocation = results[0][1];
                columnLocation = results[0][2];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        rowLocation = results[j][1];
                        columnLocation = results[j][2];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            int r = 0;
            while (r < this.rows) {
                int c = d;
                while (c < this.columns) {
                    int elem = this.elements[zero + r * this.rowStride + c * this.columnStride];
                    if (minValue > elem) {
                        minValue = elem;
                        rowLocation = r;
                        columnLocation = c;
                    }
                    ++c;
                }
                d = 0;
                ++r;
            }
        }
        return new int[]{minValue, rowLocation, columnLocation};
    }

    @Override
    public void setQuick(int row, int column, int value) {
        this.elements[this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public int[][] toArray() {
        final int[][] values = new int[this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int[] currentRow = values[r];
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                currentRow[c] = DenseIntMatrix2D.this.elements[i];
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int[] currentRow = values[r];
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    currentRow[c] = this.elements[i];
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return values;
    }

    @Override
    public IntMatrix1D vectorize() {
        DenseIntMatrix1D v = new DenseIntMatrix1D((int)this.size());
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)v.index(0);
        final int strideOther = v.stride();
        final int[] elemsOther = v.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                final int startidx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = 0;
                        int idxOther = zeroOther + startidx * strideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            idx = zero + c * DenseIntMatrix2D.this.columnStride;
                            int r = 0;
                            while (r < DenseIntMatrix2D.this.rows) {
                                elemsOther[idxOther] = DenseIntMatrix2D.this.elements[idx];
                                idx += DenseIntMatrix2D.this.rowStride;
                                idxOther += strideOther;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                idx = zero + c * this.columnStride;
                int r = 0;
                while (r < this.rows) {
                    elemsOther[idxOther] = this.elements[idx];
                    idx += this.rowStride;
                    idxOther += strideOther;
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public IntMatrix1D zMult(IntMatrix1D y, IntMatrix1D z, final int alpha, final int beta, boolean transposeA) {
        if (transposeA) {
            return this.viewDice().zMult(y, z, alpha, beta, false);
        }
        if (z == null) {
            z = new DenseIntMatrix1D(this.rows);
        }
        if (!(y instanceof DenseIntMatrix1D) || !(z instanceof DenseIntMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)this.columns != y.size() || (long)this.rows > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        final int[] elemsY = (int[])y.elements();
        final int[] elemsZ = (int[])z.elements();
        if (this.elements == null || elemsY == null || elemsZ == null) {
            throw new InternalError();
        }
        final int strideY = y.stride();
        final int strideZ = z.stride();
        final int zero = (int)this.index(0, 0);
        final int zeroY = (int)y.index(0);
        final int zeroZ = (int)z.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxZero = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int idxZeroZ = zeroZ + firstRow * strideZ;
                        int r = firstRow;
                        while (r < lastRow) {
                            int sum = 0;
                            int idx = idxZero;
                            int idxY = zeroY;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                sum += DenseIntMatrix2D.this.elements[idx] * elemsY[idxY];
                                idx += DenseIntMatrix2D.this.columnStride;
                                idxY += strideY;
                                ++c;
                            }
                            elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                            idxZero += DenseIntMatrix2D.this.rowStride;
                            idxZeroZ += strideZ;
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxZero = zero;
            int idxZeroZ = zeroZ;
            int r = 0;
            while (r < this.rows) {
                int sum = 0;
                int idx = idxZero;
                int idxY = zeroY;
                int c = 0;
                while (c < this.columns) {
                    sum += this.elements[idx] * elemsY[idxY];
                    idx += this.columnStride;
                    idxY += strideY;
                    ++c;
                }
                elemsZ[idxZeroZ] = alpha * sum + beta * elemsZ[idxZeroZ];
                idxZero += this.rowStride;
                idxZeroZ += strideZ;
                ++r;
            }
        }
        return z;
    }

    @Override
    public IntMatrix2D zMult(IntMatrix2D B, IntMatrix2D C, final int alpha, final int beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseIntMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseIntMatrix2D || B instanceof SparseRCIntMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        if (!(C instanceof DenseIntMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int flops = 2 * rowsA * columnsA * columnsB;
        int noOfTasks = Math.min(flops / 30000, ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSequential(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        int i = 0;
        while (i < noOfTasks) {
            IntMatrix2D CC;
            IntMatrix2D BB;
            IntMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    ((DenseIntMatrix2D)AA).zMultSequential(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    @Override
    public int zSum() {
        int sum = 0;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int sum = 0;
                        int idx = zero + firstRow * DenseIntMatrix2D.this.rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            int i = idx;
                            int c = 0;
                            while (c < DenseIntMatrix2D.this.columns) {
                                sum += DenseIntMatrix2D.this.elements[i];
                                i += DenseIntMatrix2D.this.columnStride;
                                ++c;
                            }
                            idx += DenseIntMatrix2D.this.rowStride;
                            ++r;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Integer)futures[j].get()).intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int r = 0;
            while (r < this.rows) {
                int i = idx;
                int c = 0;
                while (c < this.columns) {
                    sum += this.elements[i];
                    i += this.columnStride;
                    ++c;
                }
                idx += this.rowStride;
                ++r;
            }
        }
        return sum;
    }

    private IntMatrix2D zMultSequential(IntMatrix2D B, IntMatrix2D C, int alpha, int beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.viewDice().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (B instanceof SparseIntMatrix2D || B instanceof SparseRCIntMatrix2D || B instanceof SparseCCIntMatrix2D) {
            if (C == null) {
                return B.zMult(this, null, alpha, beta, !transposeB, true).viewDice();
            }
            B.zMult(this, C.viewDice(), alpha, beta, !transposeB, true);
            return C;
        }
        if (transposeB) {
            return this.zMult(B.viewDice(), C, alpha, beta, transposeA, false);
        }
        int rowsA = this.rows;
        int columnsA = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseIntMatrix2D(rowsA, p);
        }
        if (!(B instanceof DenseIntMatrix2D) || !(C instanceof DenseIntMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseIntMatrix2D BB = (DenseIntMatrix2D)B;
        DenseIntMatrix2D CC = (DenseIntMatrix2D)C;
        int[] AElems = this.elements;
        int[] BElems = BB.elements;
        int[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - columnsA) / (columnsA + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = rowsA / m_optimal;
        int rr = 0;
        if (rowsA % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += rowsA - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    int kA = iA;
                    int kB = jB;
                    int s = 0;
                    kA -= cA;
                    kB -= rB;
                    int k = columnsA % 4;
                    while (--k >= 0) {
                        s += AElems[kA += cA] * BElems[kB += rB];
                    }
                    k = columnsA / 4;
                    while (--k >= 0) {
                        int n = kA + cA;
                        kA = n;
                        int n2 = kB + rB;
                        kB = n2;
                        int n3 = kA + cA;
                        kA = n3;
                        int n4 = kB + rB;
                        kB = n4;
                        kA = kA + cA;
                        kB = kB + rB;
                        s += AElems[n] * BElems[n2] + AElems[n3] * BElems[n4] + AElems[kA] * BElems[kB] + AElems[kA += cA] * BElems[kB += rB];
                    }
                    CElems[iC] = alpha * s + beta * CElems[iC];
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    protected boolean haveSharedCellsRaw(IntMatrix2D other) {
        if (other instanceof SelectedDenseIntMatrix2D) {
            SelectedDenseIntMatrix2D otherMatrix = (SelectedDenseIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseIntMatrix2D) {
            DenseIntMatrix2D otherMatrix = (DenseIntMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected IntMatrix1D like1D(int size, int zero, int stride) {
        return new DenseIntMatrix1D(size, this.elements, zero, stride, true);
    }

    @Override
    protected IntMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseIntMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

