/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Frequency;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsFrequencyEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsFrequency implements Enumeration
{
    YOTTAHZ("YHz"),
    ZETTAHZ("ZHz"),
    EXAHZ("EHz"),
    PETAHZ("PHz"),
    TERAHZ("THz"),
    GIGAHZ("GHz"),
    MEGAHZ("MHz"),
    KHZ("kHz"),
    HHZ("hHz"),
    DAHZ("daHz"),
    HZ("Hz"),
    DHZ("dHz"),
    CHZ("cHz"),
    MHZ("mHz"),
    MICROHZ("\u00b5Hz"),
    NHZ("nHz"),
    PHZ("pHz"),
    FHZ("fHz"),
    AHZ("aHz"),
    ZHZ("zHz"),
    YHZ("yHz");

    private final String value;

    private UnitsFrequency(String value) {
        this.value = value;
    }

    public static UnitsFrequency fromString(String value) throws EnumerationException {
        if ("YHz".equals(value)) {
            return YOTTAHZ;
        }
        if ("ZHz".equals(value)) {
            return ZETTAHZ;
        }
        if ("EHz".equals(value)) {
            return EXAHZ;
        }
        if ("PHz".equals(value)) {
            return PETAHZ;
        }
        if ("THz".equals(value)) {
            return TERAHZ;
        }
        if ("GHz".equals(value)) {
            return GIGAHZ;
        }
        if ("MHz".equals(value)) {
            return MEGAHZ;
        }
        if ("kHz".equals(value)) {
            return KHZ;
        }
        if ("hHz".equals(value)) {
            return HHZ;
        }
        if ("daHz".equals(value)) {
            return DAHZ;
        }
        if ("Hz".equals(value)) {
            return HZ;
        }
        if ("dHz".equals(value)) {
            return DHZ;
        }
        if ("cHz".equals(value)) {
            return CHZ;
        }
        if ("mHz".equals(value)) {
            return MHZ;
        }
        if ("\u00b5Hz".equals(value)) {
            return MICROHZ;
        }
        if ("nHz".equals(value)) {
            return NHZ;
        }
        if ("pHz".equals(value)) {
            return PHZ;
        }
        if ("fHz".equals(value)) {
            return FHZ;
        }
        if ("aHz".equals(value)) {
            return AHZ;
        }
        if ("zHz".equals(value)) {
            return ZHZ;
        }
        if ("yHz".equals(value)) {
            return YHZ;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsFrequency.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PrimitiveNumber> Frequency create(T newValue, UnitsFrequency newUnit) {
        Frequency theQuantity = null;
        try {
            theQuantity = UnitsFrequencyEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Number> Frequency create(T newValue, UnitsFrequency newUnit) {
        Frequency theQuantity = null;
        try {
            theQuantity = UnitsFrequencyEnumHandler.getQuantity(newValue, newUnit);
            return theQuantity;
        }
        finally {
            return theQuantity;
        }
    }
}

